/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel.editor.container;

import java.awt.Component;

import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.tree.DefaultMutableTreeNode;

import de.renier.vdr.channel.Channel;
import de.renier.vdr.channel.ChannelElement;
import de.renier.vdr.channel.editor.util.LocalProperties;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * ChannelListRenderer
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelListRenderer extends DefaultListCellRenderer {

  private static final long serialVersionUID = 6389052307232425093L;

  /**
   * Overidden method to set icon
   */
  public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected,
      boolean cellHasFocus) {
    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    // get ChannelElement
    if (value instanceof DefaultMutableTreeNode) {
      DefaultMutableTreeNode node = (DefaultMutableTreeNode) value;
      if (node.getUserObject() instanceof ChannelElement) {
        ChannelElement channelElement = (ChannelElement) node.getUserObject();
        // set special icons
        if (channelElement.isCategory()) {
          this.setIcon(Utils.iconCategory);
        } else if (channelElement.isTelevision()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconTelevision);
          } else {
            this.setIcon(Utils.iconTelevisionCrypt);
          }
        } else if (channelElement.isRadio()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconRadio);
          } else {
            this.setIcon(Utils.iconRadioCrypt);
          }
        } else if (channelElement.isService()) {
          Channel channel = (Channel) channelElement;
          if ("0".equals(channel.getCaId())) {
            this.setIcon(Utils.iconService);
          } else {
            this.setIcon(Utils.iconServiceCrypt);
          }
        } else if (node.isRoot()) {
          this.setIcon(Utils.iconRoot);
        }
        // get font size
        int fontSize = Integer.parseInt(LocalProperties.getInstance().getProperty(LocalProperties.PROP_FONTSIZE));
        if (fontSize > 0) {
          this.setFont(this.getFont().deriveFont((float) fontSize));
        }
      }
    }

    return this;
  }

}
