/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel;

import java.io.Serializable;

/**
 * ChannelElement
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelElement implements Serializable {

  private static final long serialVersionUID = -3882175477185965068L;
  protected String name;

  /**
   * Constructor
   * 
   * @param name
   */
  public ChannelElement(String name) {
    this.name = name;
  }

  /**
   * @return Returns the name.
   */
  public String getName() {
    return name;
  }

  /**
   * @param name The name to set.
   */
  public void setName(String name) {
    this.name = name;
  }

  public boolean isTelevision() {
    return false;
  }

  public boolean isRadio() {
    return false;
  }

  public boolean isService() {
    return false;
  }

  public boolean isCategory() {
    return false;
  }

  public boolean isRadioOrTelevisionOrService() {
    if (isRadio() || isTelevision() || isService()) { return true; }
    return false;
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return this.name;
  }

  public String outputString() {
    return "";
  }
}
