/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel;

/**
 * ChannelCategory
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class ChannelCategory extends ChannelElement {

  private static final long serialVersionUID = -672846214455684762L;
  private int numberAt = 0;

  public ChannelCategory(String name) {
    super(name);
    // remove @<numbers>
    if (name.startsWith("@")) {
      int posNumberend = name.indexOf(" ");
      if (posNumberend > 0) {
        try {
          this.numberAt = Integer.parseInt(name.substring(1, posNumberend));
          this.name = name.substring(posNumberend + 1);
        } catch (NumberFormatException e) {
          System.out.println("ChannelCategory: Failed to convert number from: " + name);
        }
      } else {
        try {
          this.numberAt = Integer.parseInt(name.substring(1));
          this.name = "";
        } catch (NumberFormatException e) {
          System.out.println("ChannelCategory: Failed to convert number from: " + name);
        }
      }
    }
  }

  /**
   * overriden to mark as category
   */
  public boolean isCategory() {
    return true;
  }

  public String outputString() {
    return ":" + ((this.numberAt > 0) ? "@" + String.valueOf(this.numberAt) + " " : "") + this.name + (char) 10;
  }

  public int getNumberAt() {
    return numberAt;
  }

  public void setNumberAt(int numberAt) {
    this.numberAt = numberAt;
  }
}
