/*
 *  Copyright (C) 2005-2007 Renier Roth
 *  www.renier.de
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2
 *  of the License, or any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package de.renier.vdr.channel;

import de.renier.vdr.channel.editor.util.ChannelConstants;
import de.renier.vdr.channel.editor.util.Utils;

/**
 * Channel
 * 
 * @author <a href="mailto:editor@renier.de">Renier Roth</a>
 */
public class Channel extends ChannelElement {

  private static final long serialVersionUID = -5956711669128709225L;
  private String frequenz;
  private String parameter;
  private String source;
  private String symbolrate;
  private String vPid;
  private String aPid;
  private String tPid;
  private String caId;
  private String sid;
  private String nid;
  private String tid;
  private String rid;
  private int number;
  private String nameOnly;
  private String bouqet;
  private String alias;

  public Channel(String name) {
    super(name);
    // split name/bouqet
    int pos = name.indexOf(";");
    if (pos > -1) {
      this.nameOnly = name.substring(0, pos);
      this.bouqet = name.substring(pos + 1);
    } else {
      this.nameOnly = name;
      this.bouqet = "";
    }
  }

  /**
   * @return Returns the aPid.
   */
  public String getAPid() {
    return aPid;
  }

  /**
   * @param pid The aPid to set.
   */
  public void setAPid(String pid) {
    if (Utils.isEmpty(pid)) {
      pid = "0";
    }
    aPid = pid;
  }

  /**
   * @return Returns the caId.
   */
  public String getCaId() {
    return caId;
  }

  /**
   * @param caId The caId to set.
   */
  public void setCaId(String caId) {
    if (Utils.isEmpty(caId)) {
      caId = "0";
    }
    this.caId = caId;
  }

  /**
   * @return Returns the frequenz.
   */
  public String getFrequenz() {
    return frequenz;
  }

  /**
   * @param frequenz The frequenz to set.
   */
  public void setFrequenz(String frequenz) {
    if (Utils.isEmpty(frequenz)) {
      frequenz = "0";
    }
    this.frequenz = frequenz;
  }

  /**
   * @return Returns the nid.
   */
  public String getNid() {
    return nid;
  }

  /**
   * @param nid The nid to set.
   */
  public void setNid(String nid) {
    if (Utils.isEmpty(nid)) {
      nid = "0";
    }
    this.nid = nid;
  }

  /**
   * @return Returns the rid.
   */
  public String getRid() {
    return rid;
  }

  /**
   * @param rid The rid to set.
   */
  public void setRid(String rid) {
    if (Utils.isEmpty(rid)) {
      rid = "0";
    }
    this.rid = rid;
  }

  /**
   * @return Returns the sid.
   */
  public String getSid() {
    return sid;
  }

  /**
   * @param sid The sid to set.
   */
  public void setSid(String sid) {
    if (Utils.isEmpty(sid)) {
      sid = "0";
    }
    this.sid = sid;
  }

  /**
   * @return Returns the source.
   */
  public String getSource() {
    return source;
  }

  /**
   * @param source The source to set.
   */
  public void setSource(String source) {
    this.source = source;
  }

  /**
   * @return Returns the symbolrate.
   */
  public String getSymbolrate() {
    return symbolrate;
  }

  /**
   * @param symbolrate The symbolrate to set.
   */
  public void setSymbolrate(String symbolrate) {
    if (Utils.isEmpty(symbolrate)) {
      symbolrate = "0";
    }
    this.symbolrate = symbolrate;
  }

  /**
   * @return Returns the tid.
   */
  public String getTid() {
    return tid;
  }

  /**
   * @param tid The tid to set.
   */
  public void setTid(String tid) {
    if (Utils.isEmpty(tid)) {
      tid = "0";
    }
    this.tid = tid;
  }

  /**
   * @return Returns the tPid.
   */
  public String getTPid() {
    return tPid;
  }

  /**
   * @param pid The tPid to set.
   */
  public void setTPid(String pid) {
    if (Utils.isEmpty(pid)) {
      pid = "0";
    }
    tPid = pid;
  }

  /**
   * @return Returns the vPid.
   */
  public String getVPid() {
    return vPid;
  }

  /**
   * @param pid The vPid to set.
   */
  public void setVPid(String pid) {
    if (Utils.isEmpty(pid)) {
      pid = "0";
    }
    vPid = pid;
  }

  /**
   * @return Returns the parameter.
   */
  public String getParameter() {
    return parameter;
  }

  /**
   * @param parameter The parameter to set.
   */
  public void setParameter(String parameter) {
    this.parameter = parameter;
  }

  public boolean isTelevision() {
    if (!ChannelConstants.TYPE_RADIO.equals(vPid) && !ChannelConstants.TYPE_RADIO_CRYPTED.equals(vPid)) { return true; }
    return false;
  }

  public boolean isRadio() {
    if ((ChannelConstants.TYPE_RADIO.equals(vPid) || ChannelConstants.TYPE_RADIO_CRYPTED.equals(vPid))
        && !ChannelConstants.TYPE_RADIO.equals(aPid)) { return true; }
    return false;
  }

  public boolean isService() {
    if (ChannelConstants.TYPE_RADIO.equals(vPid) && ChannelConstants.TYPE_RADIO.equals(aPid)) { return true; }
    return false;
  }

  public String outputString() {
    return this.name + ":" + frequenz + ":" + parameter + ":" + source + ":" + symbolrate + ":" + vPid + ":" + aPid
        + ":" + tPid + ":" + caId + ":" + sid + ":" + nid + ":" + tid + ":" + rid + (char) 10;
  }

  public int getNumber() {
    return number;
  }

  public void setNumber(int number) {
    this.number = number;
  }

  public String getId() {
    return nid + "-" + tid + "-" + sid;
  }

  public String getBouqet() {
    return bouqet;
  }

  public String getNameOnly() {
    return nameOnly;
  }

  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }
}
