"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSurface = exports.SurfaceContext = void 0;
var _react = require("react");
/**
 * __Surface context__
 *
 * A surface context provides context information on the current background (if set).
 */
var SurfaceContext = exports.SurfaceContext = /*#__PURE__*/(0, _react.createContext)('elevation.surface');

/**
 * __useSurface__
 *
 * Return the current surface. If no parent sets a surface color it falls back to the default surface.
 *
 * @see SurfaceContext
 */
var useSurface = exports.useSurface = function useSurface() {
  return (0, _react.useContext)(SurfaceContext);
};
SurfaceContext.displayName = 'SurfaceProvider';