"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EvaluationReason = void 0;
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/StatsigStore.ts
var EvaluationReason = exports.EvaluationReason = /*#__PURE__*/function (EvaluationReason) {
  // Order is important since the logic for migrating from a new client reason to an old one
  // returns the first which is a substring of the new client reason
  EvaluationReason["Error"] = "Error";
  EvaluationReason["LocalOverride"] = "LocalOverride";
  EvaluationReason["Unrecognized"] = "Unrecognized";
  EvaluationReason["Uninitialized"] = "Uninitialized";
  EvaluationReason["NetworkNotModified"] = "NetworkNotModified";
  EvaluationReason["Network"] = "Network";
  EvaluationReason["InvalidBootstrap"] = "InvalidBootstrap";
  EvaluationReason["Bootstrap"] = "Bootstrap";
  EvaluationReason["Cache"] = "Cache";
  // For when we could not migrate the reason from the new client
  EvaluationReason["Unknown"] = "Unknown";
  return EvaluationReason;
}({}); // Reference: https://github.com/statsig-io/js-lite/blob/main/src/StatsigSDKOptions.ts