import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _inherits from "@babel/runtime/helpers/inherits";
function _callSuper(t, o, e) { return o = _getPrototypeOf(o), _possibleConstructorReturn(t, _isNativeReflectConstruct() ? Reflect.construct(o, e || [], _getPrototypeOf(t).constructor) : o.apply(t, e)); }
function _isNativeReflectConstruct() { try { var t = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); } catch (t) {} return (_isNativeReflectConstruct = function _isNativeReflectConstruct() { return !!t; })(); }
import React, { Component } from 'react';
import { fg } from '@atlaskit/platform-feature-flags';
import isModernContextEnabledEnv from '../utils/isModernContextEnabledEnv';
import LegacyAnalyticsContext from './AnalyticsContext/LegacyAnalyticsContext';
import ModernAnalyticsContext from './AnalyticsContext/ModernAnalyticsContext';
/**
 *  @private https://product-fabric.atlassian.net/browse/AFO-815
 *  @deprecated
 */
// eslint-disable-next-line @repo/internal/react/no-class-components
var AnalyticsErrorBoundary = /*#__PURE__*/function (_Component) {
  function AnalyticsErrorBoundary(props) {
    var _this;
    _classCallCheck(this, AnalyticsErrorBoundary);
    _this = _callSuper(this, AnalyticsErrorBoundary, [props]);
    _this.state = {
      hasError: false
    };
    return _this;
  }
  _inherits(AnalyticsErrorBoundary, _Component);
  return _createClass(AnalyticsErrorBoundary, [{
    key: "componentDidCatch",
    value: function componentDidCatch(error, info) {
      var onError = this.props.onError;
      onError && onError(error, info);
      this.setState({
        hasError: true
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
        data = _this$props.data,
        children = _this$props.children,
        ErrorComponent = _this$props.ErrorComponent;
      var hasError = this.state.hasError;
      var isModernContext = isModernContextEnabledEnv || fg('analytics-next-use-modern-context_jira');
      if (hasError) {
        if (ErrorComponent) {
          if (isModernContext) {
            return /*#__PURE__*/React.createElement(ModernAnalyticsContext, {
              data: data
            }, /*#__PURE__*/React.createElement(ErrorComponent, null));
          }
          return /*#__PURE__*/React.createElement(LegacyAnalyticsContext, {
            data: data
          }, /*#__PURE__*/React.createElement(ErrorComponent, null));
        }
        return null;
      }
      if (isModernContext) {
        return /*#__PURE__*/React.createElement(ModernAnalyticsContext, {
          data: data
        }, children);
      }
      return /*#__PURE__*/React.createElement(LegacyAnalyticsContext, {
        data: data
      }, children);
    }
  }]);
}(Component);
export { AnalyticsErrorBoundary as default };