// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package deadline

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateMemberToFarm = "AssociateMemberToFarm"

// AssociateMemberToFarmRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToFarm for more information on using the AssociateMemberToFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberToFarmRequest method.
//	req, resp := client.AssociateMemberToFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm
func (c *Deadline) AssociateMemberToFarmRequest(input *AssociateMemberToFarmInput) (req *request.Request, output *AssociateMemberToFarmOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToFarm,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/farms/{farmId}/members/{principalId}",
	}

	if input == nil {
		input = &AssociateMemberToFarmInput{}
	}

	output = &AssociateMemberToFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateMemberToFarm API operation for AWSDeadlineCloud.
//
// Assigns a farm membership level to a member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssociateMemberToFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFarm
func (c *Deadline) AssociateMemberToFarm(input *AssociateMemberToFarmInput) (*AssociateMemberToFarmOutput, error) {
	req, out := c.AssociateMemberToFarmRequest(input)
	return out, req.Send()
}

// AssociateMemberToFarmWithContext is the same as AssociateMemberToFarm with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssociateMemberToFarmWithContext(ctx aws.Context, input *AssociateMemberToFarmInput, opts ...request.Option) (*AssociateMemberToFarmOutput, error) {
	req, out := c.AssociateMemberToFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateMemberToFleet = "AssociateMemberToFleet"

// AssociateMemberToFleetRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToFleet for more information on using the AssociateMemberToFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberToFleetRequest method.
//	req, resp := client.AssociateMemberToFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet
func (c *Deadline) AssociateMemberToFleetRequest(input *AssociateMemberToFleetInput) (req *request.Request, output *AssociateMemberToFleetOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToFleet,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/members/{principalId}",
	}

	if input == nil {
		input = &AssociateMemberToFleetInput{}
	}

	output = &AssociateMemberToFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateMemberToFleet API operation for AWSDeadlineCloud.
//
// Assigns a fleet membership level to a member.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssociateMemberToFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToFleet
func (c *Deadline) AssociateMemberToFleet(input *AssociateMemberToFleetInput) (*AssociateMemberToFleetOutput, error) {
	req, out := c.AssociateMemberToFleetRequest(input)
	return out, req.Send()
}

// AssociateMemberToFleetWithContext is the same as AssociateMemberToFleet with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssociateMemberToFleetWithContext(ctx aws.Context, input *AssociateMemberToFleetInput, opts ...request.Option) (*AssociateMemberToFleetOutput, error) {
	req, out := c.AssociateMemberToFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateMemberToJob = "AssociateMemberToJob"

// AssociateMemberToJobRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToJob for more information on using the AssociateMemberToJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberToJobRequest method.
//	req, resp := client.AssociateMemberToJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob
func (c *Deadline) AssociateMemberToJobRequest(input *AssociateMemberToJobInput) (req *request.Request, output *AssociateMemberToJobOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members/{principalId}",
	}

	if input == nil {
		input = &AssociateMemberToJobInput{}
	}

	output = &AssociateMemberToJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateMemberToJob API operation for AWSDeadlineCloud.
//
// # Assigns a job membership level to a member
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssociateMemberToJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToJob
func (c *Deadline) AssociateMemberToJob(input *AssociateMemberToJobInput) (*AssociateMemberToJobOutput, error) {
	req, out := c.AssociateMemberToJobRequest(input)
	return out, req.Send()
}

// AssociateMemberToJobWithContext is the same as AssociateMemberToJob with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssociateMemberToJobWithContext(ctx aws.Context, input *AssociateMemberToJobInput, opts ...request.Option) (*AssociateMemberToJobOutput, error) {
	req, out := c.AssociateMemberToJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateMemberToQueue = "AssociateMemberToQueue"

// AssociateMemberToQueueRequest generates a "aws/request.Request" representing the
// client's request for the AssociateMemberToQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateMemberToQueue for more information on using the AssociateMemberToQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateMemberToQueueRequest method.
//	req, resp := client.AssociateMemberToQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue
func (c *Deadline) AssociateMemberToQueueRequest(input *AssociateMemberToQueueInput) (req *request.Request, output *AssociateMemberToQueueOutput) {
	op := &request.Operation{
		Name:       opAssociateMemberToQueue,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/members/{principalId}",
	}

	if input == nil {
		input = &AssociateMemberToQueueInput{}
	}

	output = &AssociateMemberToQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssociateMemberToQueue API operation for AWSDeadlineCloud.
//
// # Assigns a queue membership level to a member
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssociateMemberToQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssociateMemberToQueue
func (c *Deadline) AssociateMemberToQueue(input *AssociateMemberToQueueInput) (*AssociateMemberToQueueOutput, error) {
	req, out := c.AssociateMemberToQueueRequest(input)
	return out, req.Send()
}

// AssociateMemberToQueueWithContext is the same as AssociateMemberToQueue with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateMemberToQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssociateMemberToQueueWithContext(ctx aws.Context, input *AssociateMemberToQueueInput, opts ...request.Option) (*AssociateMemberToQueueOutput, error) {
	req, out := c.AssociateMemberToQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeFleetRoleForRead = "AssumeFleetRoleForRead"

// AssumeFleetRoleForReadRequest generates a "aws/request.Request" representing the
// client's request for the AssumeFleetRoleForRead operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeFleetRoleForRead for more information on using the AssumeFleetRoleForRead
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeFleetRoleForReadRequest method.
//	req, resp := client.AssumeFleetRoleForReadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead
func (c *Deadline) AssumeFleetRoleForReadRequest(input *AssumeFleetRoleForReadInput) (req *request.Request, output *AssumeFleetRoleForReadOutput) {
	op := &request.Operation{
		Name:       opAssumeFleetRoleForRead,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/read-roles",
	}

	if input == nil {
		input = &AssumeFleetRoleForReadInput{}
	}

	output = &AssumeFleetRoleForReadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssumeFleetRoleForRead API operation for AWSDeadlineCloud.
//
// Get Amazon Web Services credentials from the fleet role. The IAM permissions
// of the credentials are scoped down to have read-only access.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssumeFleetRoleForRead for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForRead
func (c *Deadline) AssumeFleetRoleForRead(input *AssumeFleetRoleForReadInput) (*AssumeFleetRoleForReadOutput, error) {
	req, out := c.AssumeFleetRoleForReadRequest(input)
	return out, req.Send()
}

// AssumeFleetRoleForReadWithContext is the same as AssumeFleetRoleForRead with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeFleetRoleForRead for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssumeFleetRoleForReadWithContext(ctx aws.Context, input *AssumeFleetRoleForReadInput, opts ...request.Option) (*AssumeFleetRoleForReadOutput, error) {
	req, out := c.AssumeFleetRoleForReadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeFleetRoleForWorker = "AssumeFleetRoleForWorker"

// AssumeFleetRoleForWorkerRequest generates a "aws/request.Request" representing the
// client's request for the AssumeFleetRoleForWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeFleetRoleForWorker for more information on using the AssumeFleetRoleForWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeFleetRoleForWorkerRequest method.
//	req, resp := client.AssumeFleetRoleForWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker
func (c *Deadline) AssumeFleetRoleForWorkerRequest(input *AssumeFleetRoleForWorkerInput) (req *request.Request, output *AssumeFleetRoleForWorkerOutput) {
	op := &request.Operation{
		Name:       opAssumeFleetRoleForWorker,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/fleet-roles",
	}

	if input == nil {
		input = &AssumeFleetRoleForWorkerInput{}
	}

	output = &AssumeFleetRoleForWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssumeFleetRoleForWorker API operation for AWSDeadlineCloud.
//
// Get credentials from the fleet role for a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssumeFleetRoleForWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeFleetRoleForWorker
func (c *Deadline) AssumeFleetRoleForWorker(input *AssumeFleetRoleForWorkerInput) (*AssumeFleetRoleForWorkerOutput, error) {
	req, out := c.AssumeFleetRoleForWorkerRequest(input)
	return out, req.Send()
}

// AssumeFleetRoleForWorkerWithContext is the same as AssumeFleetRoleForWorker with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeFleetRoleForWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssumeFleetRoleForWorkerWithContext(ctx aws.Context, input *AssumeFleetRoleForWorkerInput, opts ...request.Option) (*AssumeFleetRoleForWorkerOutput, error) {
	req, out := c.AssumeFleetRoleForWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeQueueRoleForRead = "AssumeQueueRoleForRead"

// AssumeQueueRoleForReadRequest generates a "aws/request.Request" representing the
// client's request for the AssumeQueueRoleForRead operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeQueueRoleForRead for more information on using the AssumeQueueRoleForRead
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeQueueRoleForReadRequest method.
//	req, resp := client.AssumeQueueRoleForReadRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead
func (c *Deadline) AssumeQueueRoleForReadRequest(input *AssumeQueueRoleForReadInput) (req *request.Request, output *AssumeQueueRoleForReadOutput) {
	op := &request.Operation{
		Name:       opAssumeQueueRoleForRead,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/read-roles",
	}

	if input == nil {
		input = &AssumeQueueRoleForReadInput{}
	}

	output = &AssumeQueueRoleForReadOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssumeQueueRoleForRead API operation for AWSDeadlineCloud.
//
// Gets Amazon Web Services credentials from the queue role. The IAM permissions
// of the credentials are scoped down to have read-only access.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssumeQueueRoleForRead for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForRead
func (c *Deadline) AssumeQueueRoleForRead(input *AssumeQueueRoleForReadInput) (*AssumeQueueRoleForReadOutput, error) {
	req, out := c.AssumeQueueRoleForReadRequest(input)
	return out, req.Send()
}

// AssumeQueueRoleForReadWithContext is the same as AssumeQueueRoleForRead with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeQueueRoleForRead for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssumeQueueRoleForReadWithContext(ctx aws.Context, input *AssumeQueueRoleForReadInput, opts ...request.Option) (*AssumeQueueRoleForReadOutput, error) {
	req, out := c.AssumeQueueRoleForReadRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeQueueRoleForUser = "AssumeQueueRoleForUser"

// AssumeQueueRoleForUserRequest generates a "aws/request.Request" representing the
// client's request for the AssumeQueueRoleForUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeQueueRoleForUser for more information on using the AssumeQueueRoleForUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeQueueRoleForUserRequest method.
//	req, resp := client.AssumeQueueRoleForUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser
func (c *Deadline) AssumeQueueRoleForUserRequest(input *AssumeQueueRoleForUserInput) (req *request.Request, output *AssumeQueueRoleForUserOutput) {
	op := &request.Operation{
		Name:       opAssumeQueueRoleForUser,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/user-roles",
	}

	if input == nil {
		input = &AssumeQueueRoleForUserInput{}
	}

	output = &AssumeQueueRoleForUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssumeQueueRoleForUser API operation for AWSDeadlineCloud.
//
// Allows a user to assume a role for a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssumeQueueRoleForUser for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForUser
func (c *Deadline) AssumeQueueRoleForUser(input *AssumeQueueRoleForUserInput) (*AssumeQueueRoleForUserOutput, error) {
	req, out := c.AssumeQueueRoleForUserRequest(input)
	return out, req.Send()
}

// AssumeQueueRoleForUserWithContext is the same as AssumeQueueRoleForUser with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeQueueRoleForUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssumeQueueRoleForUserWithContext(ctx aws.Context, input *AssumeQueueRoleForUserInput, opts ...request.Option) (*AssumeQueueRoleForUserOutput, error) {
	req, out := c.AssumeQueueRoleForUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssumeQueueRoleForWorker = "AssumeQueueRoleForWorker"

// AssumeQueueRoleForWorkerRequest generates a "aws/request.Request" representing the
// client's request for the AssumeQueueRoleForWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssumeQueueRoleForWorker for more information on using the AssumeQueueRoleForWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssumeQueueRoleForWorkerRequest method.
//	req, resp := client.AssumeQueueRoleForWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker
func (c *Deadline) AssumeQueueRoleForWorkerRequest(input *AssumeQueueRoleForWorkerInput) (req *request.Request, output *AssumeQueueRoleForWorkerOutput) {
	op := &request.Operation{
		Name:       opAssumeQueueRoleForWorker,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/queue-roles",
	}

	if input == nil {
		input = &AssumeQueueRoleForWorkerInput{}
	}

	output = &AssumeQueueRoleForWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// AssumeQueueRoleForWorker API operation for AWSDeadlineCloud.
//
// Allows a worker to assume a queue role.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation AssumeQueueRoleForWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/AssumeQueueRoleForWorker
func (c *Deadline) AssumeQueueRoleForWorker(input *AssumeQueueRoleForWorkerInput) (*AssumeQueueRoleForWorkerOutput, error) {
	req, out := c.AssumeQueueRoleForWorkerRequest(input)
	return out, req.Send()
}

// AssumeQueueRoleForWorkerWithContext is the same as AssumeQueueRoleForWorker with the addition of
// the ability to pass a context and additional request options.
//
// See AssumeQueueRoleForWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) AssumeQueueRoleForWorkerWithContext(ctx aws.Context, input *AssumeQueueRoleForWorkerInput, opts ...request.Option) (*AssumeQueueRoleForWorkerOutput, error) {
	req, out := c.AssumeQueueRoleForWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchGetJobEntity = "BatchGetJobEntity"

// BatchGetJobEntityRequest generates a "aws/request.Request" representing the
// client's request for the BatchGetJobEntity operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchGetJobEntity for more information on using the BatchGetJobEntity
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the BatchGetJobEntityRequest method.
//	req, resp := client.BatchGetJobEntityRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity
func (c *Deadline) BatchGetJobEntityRequest(input *BatchGetJobEntityInput) (req *request.Request, output *BatchGetJobEntityOutput) {
	op := &request.Operation{
		Name:       opBatchGetJobEntity,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/batchGetJobEntity",
	}

	if input == nil {
		input = &BatchGetJobEntityInput{}
	}

	output = &BatchGetJobEntityOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// BatchGetJobEntity API operation for AWSDeadlineCloud.
//
// Get batched job details for a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation BatchGetJobEntity for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/BatchGetJobEntity
func (c *Deadline) BatchGetJobEntity(input *BatchGetJobEntityInput) (*BatchGetJobEntityOutput, error) {
	req, out := c.BatchGetJobEntityRequest(input)
	return out, req.Send()
}

// BatchGetJobEntityWithContext is the same as BatchGetJobEntity with the addition of
// the ability to pass a context and additional request options.
//
// See BatchGetJobEntity for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) BatchGetJobEntityWithContext(ctx aws.Context, input *BatchGetJobEntityInput, opts ...request.Option) (*BatchGetJobEntityOutput, error) {
	req, out := c.BatchGetJobEntityRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyJobTemplate = "CopyJobTemplate"

// CopyJobTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CopyJobTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyJobTemplate for more information on using the CopyJobTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CopyJobTemplateRequest method.
//	req, resp := client.CopyJobTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate
func (c *Deadline) CopyJobTemplateRequest(input *CopyJobTemplateInput) (req *request.Request, output *CopyJobTemplateOutput) {
	op := &request.Operation{
		Name:       opCopyJobTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/template",
	}

	if input == nil {
		input = &CopyJobTemplateInput{}
	}

	output = &CopyJobTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CopyJobTemplate API operation for AWSDeadlineCloud.
//
// Copies a job template to an Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CopyJobTemplate for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CopyJobTemplate
func (c *Deadline) CopyJobTemplate(input *CopyJobTemplateInput) (*CopyJobTemplateOutput, error) {
	req, out := c.CopyJobTemplateRequest(input)
	return out, req.Send()
}

// CopyJobTemplateWithContext is the same as CopyJobTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CopyJobTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CopyJobTemplateWithContext(ctx aws.Context, input *CopyJobTemplateInput, opts ...request.Option) (*CopyJobTemplateOutput, error) {
	req, out := c.CopyJobTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBudget = "CreateBudget"

// CreateBudgetRequest generates a "aws/request.Request" representing the
// client's request for the CreateBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBudget for more information on using the CreateBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBudgetRequest method.
//	req, resp := client.CreateBudgetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget
func (c *Deadline) CreateBudgetRequest(input *CreateBudgetInput) (req *request.Request, output *CreateBudgetOutput) {
	op := &request.Operation{
		Name:       opCreateBudget,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/budgets",
	}

	if input == nil {
		input = &CreateBudgetInput{}
	}

	output = &CreateBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateBudget API operation for AWSDeadlineCloud.
//
// Creates a budget to set spending thresholds for your rendering activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateBudget for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateBudget
func (c *Deadline) CreateBudget(input *CreateBudgetInput) (*CreateBudgetOutput, error) {
	req, out := c.CreateBudgetRequest(input)
	return out, req.Send()
}

// CreateBudgetWithContext is the same as CreateBudget with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateBudgetWithContext(ctx aws.Context, input *CreateBudgetInput, opts ...request.Option) (*CreateBudgetOutput, error) {
	req, out := c.CreateBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFarm = "CreateFarm"

// CreateFarmRequest generates a "aws/request.Request" representing the
// client's request for the CreateFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFarm for more information on using the CreateFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFarmRequest method.
//	req, resp := client.CreateFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm
func (c *Deadline) CreateFarmRequest(input *CreateFarmInput) (req *request.Request, output *CreateFarmOutput) {
	op := &request.Operation{
		Name:       opCreateFarm,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms",
	}

	if input == nil {
		input = &CreateFarmInput{}
	}

	output = &CreateFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateFarm API operation for AWSDeadlineCloud.
//
// Creates a farm to allow space for queues and fleets. Farms are the space
// where the components of your renders gather and are pieced together in the
// cloud. Farms contain budgets and allow you to enforce permissions. Deadline
// Cloud farms are a useful container for large projects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFarm
func (c *Deadline) CreateFarm(input *CreateFarmInput) (*CreateFarmOutput, error) {
	req, out := c.CreateFarmRequest(input)
	return out, req.Send()
}

// CreateFarmWithContext is the same as CreateFarm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateFarmWithContext(ctx aws.Context, input *CreateFarmInput, opts ...request.Option) (*CreateFarmOutput, error) {
	req, out := c.CreateFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFleetRequest method.
//	req, resp := client.CreateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet
func (c *Deadline) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateFleet API operation for AWSDeadlineCloud.
//
// Creates a fleet. Fleets gather information relating to compute, or capacity,
// for renders within your farms. You can choose to manage your own capacity
// or opt to have fleets fully managed by Deadline Cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateFleet
func (c *Deadline) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateJob = "CreateJob"

// CreateJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateJob for more information on using the CreateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateJobRequest method.
//	req, resp := client.CreateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob
func (c *Deadline) CreateJobRequest(input *CreateJobInput) (req *request.Request, output *CreateJobOutput) {
	op := &request.Operation{
		Name:       opCreateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs",
	}

	if input == nil {
		input = &CreateJobInput{}
	}

	output = &CreateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateJob API operation for AWSDeadlineCloud.
//
// Creates a job. A job is a render submission submitted by a user. It contains
// specific job properties outlined as steps and tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateJob
func (c *Deadline) CreateJob(input *CreateJobInput) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	return out, req.Send()
}

// CreateJobWithContext is the same as CreateJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateJobWithContext(ctx aws.Context, input *CreateJobInput, opts ...request.Option) (*CreateJobOutput, error) {
	req, out := c.CreateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLicenseEndpoint = "CreateLicenseEndpoint"

// CreateLicenseEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateLicenseEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLicenseEndpoint for more information on using the CreateLicenseEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLicenseEndpointRequest method.
//	req, resp := client.CreateLicenseEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint
func (c *Deadline) CreateLicenseEndpointRequest(input *CreateLicenseEndpointInput) (req *request.Request, output *CreateLicenseEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateLicenseEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/license-endpoints",
	}

	if input == nil {
		input = &CreateLicenseEndpointInput{}
	}

	output = &CreateLicenseEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateLicenseEndpoint API operation for AWSDeadlineCloud.
//
// Creates a license endpoint to integrate your various licensed software used
// for rendering on Deadline Cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateLicenseEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateLicenseEndpoint
func (c *Deadline) CreateLicenseEndpoint(input *CreateLicenseEndpointInput) (*CreateLicenseEndpointOutput, error) {
	req, out := c.CreateLicenseEndpointRequest(input)
	return out, req.Send()
}

// CreateLicenseEndpointWithContext is the same as CreateLicenseEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLicenseEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateLicenseEndpointWithContext(ctx aws.Context, input *CreateLicenseEndpointInput, opts ...request.Option) (*CreateLicenseEndpointOutput, error) {
	req, out := c.CreateLicenseEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateMonitor = "CreateMonitor"

// CreateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the CreateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateMonitor for more information on using the CreateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateMonitorRequest method.
//	req, resp := client.CreateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor
func (c *Deadline) CreateMonitorRequest(input *CreateMonitorInput) (req *request.Request, output *CreateMonitorOutput) {
	op := &request.Operation{
		Name:       opCreateMonitor,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/monitors",
	}

	if input == nil {
		input = &CreateMonitorInput{}
	}

	output = &CreateMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateMonitor API operation for AWSDeadlineCloud.
//
// Creates an Amazon Web Services Deadline Cloud monitor that you can use to
// view your farms, queues, and fleets. After you submit a job, you can track
// the progress of the tasks and steps that make up the job, and then download
// the job's results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateMonitor
func (c *Deadline) CreateMonitor(input *CreateMonitorInput) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	return out, req.Send()
}

// CreateMonitorWithContext is the same as CreateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See CreateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateMonitorWithContext(ctx aws.Context, input *CreateMonitorInput, opts ...request.Option) (*CreateMonitorOutput, error) {
	req, out := c.CreateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueue = "CreateQueue"

// CreateQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueue for more information on using the CreateQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQueueRequest method.
//	req, resp := client.CreateQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue
func (c *Deadline) CreateQueueRequest(input *CreateQueueInput) (req *request.Request, output *CreateQueueOutput) {
	op := &request.Operation{
		Name:       opCreateQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues",
	}

	if input == nil {
		input = &CreateQueueInput{}
	}

	output = &CreateQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateQueue API operation for AWSDeadlineCloud.
//
// Creates a queue to coordinate the order in which jobs run on a farm. A queue
// can also specify where to pull resources and indicate where to output completed
// jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueue
func (c *Deadline) CreateQueue(input *CreateQueueInput) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	return out, req.Send()
}

// CreateQueueWithContext is the same as CreateQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateQueueWithContext(ctx aws.Context, input *CreateQueueInput, opts ...request.Option) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueueEnvironment = "CreateQueueEnvironment"

// CreateQueueEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueueEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueueEnvironment for more information on using the CreateQueueEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQueueEnvironmentRequest method.
//	req, resp := client.CreateQueueEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment
func (c *Deadline) CreateQueueEnvironmentRequest(input *CreateQueueEnvironmentInput) (req *request.Request, output *CreateQueueEnvironmentOutput) {
	op := &request.Operation{
		Name:       opCreateQueueEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/environments",
	}

	if input == nil {
		input = &CreateQueueEnvironmentInput{}
	}

	output = &CreateQueueEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateQueueEnvironment API operation for AWSDeadlineCloud.
//
// Creates an environment for a queue that defines how jobs in the queue run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateQueueEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueEnvironment
func (c *Deadline) CreateQueueEnvironment(input *CreateQueueEnvironmentInput) (*CreateQueueEnvironmentOutput, error) {
	req, out := c.CreateQueueEnvironmentRequest(input)
	return out, req.Send()
}

// CreateQueueEnvironmentWithContext is the same as CreateQueueEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueueEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateQueueEnvironmentWithContext(ctx aws.Context, input *CreateQueueEnvironmentInput, opts ...request.Option) (*CreateQueueEnvironmentOutput, error) {
	req, out := c.CreateQueueEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueueFleetAssociation = "CreateQueueFleetAssociation"

// CreateQueueFleetAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueueFleetAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueueFleetAssociation for more information on using the CreateQueueFleetAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQueueFleetAssociationRequest method.
//	req, resp := client.CreateQueueFleetAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation
func (c *Deadline) CreateQueueFleetAssociationRequest(input *CreateQueueFleetAssociationInput) (req *request.Request, output *CreateQueueFleetAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateQueueFleetAssociation,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queue-fleet-associations",
	}

	if input == nil {
		input = &CreateQueueFleetAssociationInput{}
	}

	output = &CreateQueueFleetAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateQueueFleetAssociation API operation for AWSDeadlineCloud.
//
// Creates an association between a queue and a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateQueueFleetAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateQueueFleetAssociation
func (c *Deadline) CreateQueueFleetAssociation(input *CreateQueueFleetAssociationInput) (*CreateQueueFleetAssociationOutput, error) {
	req, out := c.CreateQueueFleetAssociationRequest(input)
	return out, req.Send()
}

// CreateQueueFleetAssociationWithContext is the same as CreateQueueFleetAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueueFleetAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateQueueFleetAssociationWithContext(ctx aws.Context, input *CreateQueueFleetAssociationInput, opts ...request.Option) (*CreateQueueFleetAssociationOutput, error) {
	req, out := c.CreateQueueFleetAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStorageProfile = "CreateStorageProfile"

// CreateStorageProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateStorageProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStorageProfile for more information on using the CreateStorageProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateStorageProfileRequest method.
//	req, resp := client.CreateStorageProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile
func (c *Deadline) CreateStorageProfileRequest(input *CreateStorageProfileInput) (req *request.Request, output *CreateStorageProfileOutput) {
	op := &request.Operation{
		Name:       opCreateStorageProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/storage-profiles",
	}

	if input == nil {
		input = &CreateStorageProfileInput{}
	}

	output = &CreateStorageProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateStorageProfile API operation for AWSDeadlineCloud.
//
// Creates a storage profile that specifies the operating system, file type,
// and file location of resources used on a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateStorageProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateStorageProfile
func (c *Deadline) CreateStorageProfile(input *CreateStorageProfileInput) (*CreateStorageProfileOutput, error) {
	req, out := c.CreateStorageProfileRequest(input)
	return out, req.Send()
}

// CreateStorageProfileWithContext is the same as CreateStorageProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStorageProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateStorageProfileWithContext(ctx aws.Context, input *CreateStorageProfileInput, opts ...request.Option) (*CreateStorageProfileOutput, error) {
	req, out := c.CreateStorageProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorker = "CreateWorker"

// CreateWorkerRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorker for more information on using the CreateWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkerRequest method.
//	req, resp := client.CreateWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker
func (c *Deadline) CreateWorkerRequest(input *CreateWorkerInput) (req *request.Request, output *CreateWorkerOutput) {
	op := &request.Operation{
		Name:       opCreateWorker,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers",
	}

	if input == nil {
		input = &CreateWorkerInput{}
	}

	output = &CreateWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// CreateWorker API operation for AWSDeadlineCloud.
//
// Creates a worker. A worker tells your instance how much processing power
// (vCPU), and memory (GiB) you’ll need to assemble the digital assets held
// within a particular instance. You can specify certain instance types to use,
// or let the worker know which instances types to exclude.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation CreateWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/CreateWorker
func (c *Deadline) CreateWorker(input *CreateWorkerInput) (*CreateWorkerOutput, error) {
	req, out := c.CreateWorkerRequest(input)
	return out, req.Send()
}

// CreateWorkerWithContext is the same as CreateWorker with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) CreateWorkerWithContext(ctx aws.Context, input *CreateWorkerInput, opts ...request.Option) (*CreateWorkerOutput, error) {
	req, out := c.CreateWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBudget = "DeleteBudget"

// DeleteBudgetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBudget for more information on using the DeleteBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBudgetRequest method.
//	req, resp := client.DeleteBudgetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget
func (c *Deadline) DeleteBudgetRequest(input *DeleteBudgetInput) (req *request.Request, output *DeleteBudgetOutput) {
	op := &request.Operation{
		Name:       opDeleteBudget,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/budgets/{budgetId}",
	}

	if input == nil {
		input = &DeleteBudgetInput{}
	}

	output = &DeleteBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteBudget API operation for AWSDeadlineCloud.
//
// Deletes a budget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteBudget for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteBudget
func (c *Deadline) DeleteBudget(input *DeleteBudgetInput) (*DeleteBudgetOutput, error) {
	req, out := c.DeleteBudgetRequest(input)
	return out, req.Send()
}

// DeleteBudgetWithContext is the same as DeleteBudget with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteBudgetWithContext(ctx aws.Context, input *DeleteBudgetInput, opts ...request.Option) (*DeleteBudgetOutput, error) {
	req, out := c.DeleteBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFarm = "DeleteFarm"

// DeleteFarmRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFarm for more information on using the DeleteFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFarmRequest method.
//	req, resp := client.DeleteFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm
func (c *Deadline) DeleteFarmRequest(input *DeleteFarmInput) (req *request.Request, output *DeleteFarmOutput) {
	op := &request.Operation{
		Name:       opDeleteFarm,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}",
	}

	if input == nil {
		input = &DeleteFarmInput{}
	}

	output = &DeleteFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteFarm API operation for AWSDeadlineCloud.
//
// Deletes a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFarm
func (c *Deadline) DeleteFarm(input *DeleteFarmInput) (*DeleteFarmOutput, error) {
	req, out := c.DeleteFarmRequest(input)
	return out, req.Send()
}

// DeleteFarmWithContext is the same as DeleteFarm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteFarmWithContext(ctx aws.Context, input *DeleteFarmInput, opts ...request.Option) (*DeleteFarmOutput, error) {
	req, out := c.DeleteFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFleetRequest method.
//	req, resp := client.DeleteFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet
func (c *Deadline) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteFleet API operation for AWSDeadlineCloud.
//
// Deletes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteFleet
func (c *Deadline) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLicenseEndpoint = "DeleteLicenseEndpoint"

// DeleteLicenseEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLicenseEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLicenseEndpoint for more information on using the DeleteLicenseEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteLicenseEndpointRequest method.
//	req, resp := client.DeleteLicenseEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint
func (c *Deadline) DeleteLicenseEndpointRequest(input *DeleteLicenseEndpointInput) (req *request.Request, output *DeleteLicenseEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteLicenseEndpoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/license-endpoints/{licenseEndpointId}",
	}

	if input == nil {
		input = &DeleteLicenseEndpointInput{}
	}

	output = &DeleteLicenseEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteLicenseEndpoint API operation for AWSDeadlineCloud.
//
// Deletes a license endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteLicenseEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteLicenseEndpoint
func (c *Deadline) DeleteLicenseEndpoint(input *DeleteLicenseEndpointInput) (*DeleteLicenseEndpointOutput, error) {
	req, out := c.DeleteLicenseEndpointRequest(input)
	return out, req.Send()
}

// DeleteLicenseEndpointWithContext is the same as DeleteLicenseEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLicenseEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteLicenseEndpointWithContext(ctx aws.Context, input *DeleteLicenseEndpointInput, opts ...request.Option) (*DeleteLicenseEndpointOutput, error) {
	req, out := c.DeleteLicenseEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMeteredProduct = "DeleteMeteredProduct"

// DeleteMeteredProductRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMeteredProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMeteredProduct for more information on using the DeleteMeteredProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMeteredProductRequest method.
//	req, resp := client.DeleteMeteredProductRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct
func (c *Deadline) DeleteMeteredProductRequest(input *DeleteMeteredProductInput) (req *request.Request, output *DeleteMeteredProductOutput) {
	op := &request.Operation{
		Name:       opDeleteMeteredProduct,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products/{productId}",
	}

	if input == nil {
		input = &DeleteMeteredProductInput{}
	}

	output = &DeleteMeteredProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteMeteredProduct API operation for AWSDeadlineCloud.
//
// Deletes a metered product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteMeteredProduct for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMeteredProduct
func (c *Deadline) DeleteMeteredProduct(input *DeleteMeteredProductInput) (*DeleteMeteredProductOutput, error) {
	req, out := c.DeleteMeteredProductRequest(input)
	return out, req.Send()
}

// DeleteMeteredProductWithContext is the same as DeleteMeteredProduct with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMeteredProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteMeteredProductWithContext(ctx aws.Context, input *DeleteMeteredProductInput, opts ...request.Option) (*DeleteMeteredProductOutput, error) {
	req, out := c.DeleteMeteredProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMonitor = "DeleteMonitor"

// DeleteMonitorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMonitor for more information on using the DeleteMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteMonitorRequest method.
//	req, resp := client.DeleteMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor
func (c *Deadline) DeleteMonitorRequest(input *DeleteMonitorInput) (req *request.Request, output *DeleteMonitorOutput) {
	op := &request.Operation{
		Name:       opDeleteMonitor,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/monitors/{monitorId}",
	}

	if input == nil {
		input = &DeleteMonitorInput{}
	}

	output = &DeleteMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteMonitor API operation for AWSDeadlineCloud.
//
// Removes a Deadline Cloud monitor. After you delete a monitor, you can create
// a new one and attach farms to the monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteMonitor
func (c *Deadline) DeleteMonitor(input *DeleteMonitorInput) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	return out, req.Send()
}

// DeleteMonitorWithContext is the same as DeleteMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteMonitorWithContext(ctx aws.Context, input *DeleteMonitorInput, opts ...request.Option) (*DeleteMonitorOutput, error) {
	req, out := c.DeleteMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueue = "DeleteQueue"

// DeleteQueueRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueue for more information on using the DeleteQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQueueRequest method.
//	req, resp := client.DeleteQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue
func (c *Deadline) DeleteQueueRequest(input *DeleteQueueInput) (req *request.Request, output *DeleteQueueOutput) {
	op := &request.Operation{
		Name:       opDeleteQueue,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}",
	}

	if input == nil {
		input = &DeleteQueueInput{}
	}

	output = &DeleteQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteQueue API operation for AWSDeadlineCloud.
//
// Deletes a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueue
func (c *Deadline) DeleteQueue(input *DeleteQueueInput) (*DeleteQueueOutput, error) {
	req, out := c.DeleteQueueRequest(input)
	return out, req.Send()
}

// DeleteQueueWithContext is the same as DeleteQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteQueueWithContext(ctx aws.Context, input *DeleteQueueInput, opts ...request.Option) (*DeleteQueueOutput, error) {
	req, out := c.DeleteQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueueEnvironment = "DeleteQueueEnvironment"

// DeleteQueueEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueueEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueueEnvironment for more information on using the DeleteQueueEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQueueEnvironmentRequest method.
//	req, resp := client.DeleteQueueEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment
func (c *Deadline) DeleteQueueEnvironmentRequest(input *DeleteQueueEnvironmentInput) (req *request.Request, output *DeleteQueueEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteQueueEnvironment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}",
	}

	if input == nil {
		input = &DeleteQueueEnvironmentInput{}
	}

	output = &DeleteQueueEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteQueueEnvironment API operation for AWSDeadlineCloud.
//
// Deletes a queue environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteQueueEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueEnvironment
func (c *Deadline) DeleteQueueEnvironment(input *DeleteQueueEnvironmentInput) (*DeleteQueueEnvironmentOutput, error) {
	req, out := c.DeleteQueueEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteQueueEnvironmentWithContext is the same as DeleteQueueEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueueEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteQueueEnvironmentWithContext(ctx aws.Context, input *DeleteQueueEnvironmentInput, opts ...request.Option) (*DeleteQueueEnvironmentOutput, error) {
	req, out := c.DeleteQueueEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQueueFleetAssociation = "DeleteQueueFleetAssociation"

// DeleteQueueFleetAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQueueFleetAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQueueFleetAssociation for more information on using the DeleteQueueFleetAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQueueFleetAssociationRequest method.
//	req, resp := client.DeleteQueueFleetAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation
func (c *Deadline) DeleteQueueFleetAssociationRequest(input *DeleteQueueFleetAssociationInput) (req *request.Request, output *DeleteQueueFleetAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteQueueFleetAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}",
	}

	if input == nil {
		input = &DeleteQueueFleetAssociationInput{}
	}

	output = &DeleteQueueFleetAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteQueueFleetAssociation API operation for AWSDeadlineCloud.
//
// Deletes a queue-fleet association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteQueueFleetAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteQueueFleetAssociation
func (c *Deadline) DeleteQueueFleetAssociation(input *DeleteQueueFleetAssociationInput) (*DeleteQueueFleetAssociationOutput, error) {
	req, out := c.DeleteQueueFleetAssociationRequest(input)
	return out, req.Send()
}

// DeleteQueueFleetAssociationWithContext is the same as DeleteQueueFleetAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQueueFleetAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteQueueFleetAssociationWithContext(ctx aws.Context, input *DeleteQueueFleetAssociationInput, opts ...request.Option) (*DeleteQueueFleetAssociationOutput, error) {
	req, out := c.DeleteQueueFleetAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStorageProfile = "DeleteStorageProfile"

// DeleteStorageProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStorageProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStorageProfile for more information on using the DeleteStorageProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteStorageProfileRequest method.
//	req, resp := client.DeleteStorageProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile
func (c *Deadline) DeleteStorageProfileRequest(input *DeleteStorageProfileInput) (req *request.Request, output *DeleteStorageProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteStorageProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}",
	}

	if input == nil {
		input = &DeleteStorageProfileInput{}
	}

	output = &DeleteStorageProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteStorageProfile API operation for AWSDeadlineCloud.
//
// Deletes a storage profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteStorageProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteStorageProfile
func (c *Deadline) DeleteStorageProfile(input *DeleteStorageProfileInput) (*DeleteStorageProfileOutput, error) {
	req, out := c.DeleteStorageProfileRequest(input)
	return out, req.Send()
}

// DeleteStorageProfileWithContext is the same as DeleteStorageProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStorageProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteStorageProfileWithContext(ctx aws.Context, input *DeleteStorageProfileInput, opts ...request.Option) (*DeleteStorageProfileOutput, error) {
	req, out := c.DeleteStorageProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorker = "DeleteWorker"

// DeleteWorkerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorker for more information on using the DeleteWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkerRequest method.
//	req, resp := client.DeleteWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker
func (c *Deadline) DeleteWorkerRequest(input *DeleteWorkerInput) (req *request.Request, output *DeleteWorkerOutput) {
	op := &request.Operation{
		Name:       opDeleteWorker,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}",
	}

	if input == nil {
		input = &DeleteWorkerInput{}
	}

	output = &DeleteWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DeleteWorker API operation for AWSDeadlineCloud.
//
// Deletes a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DeleteWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DeleteWorker
func (c *Deadline) DeleteWorker(input *DeleteWorkerInput) (*DeleteWorkerOutput, error) {
	req, out := c.DeleteWorkerRequest(input)
	return out, req.Send()
}

// DeleteWorkerWithContext is the same as DeleteWorker with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DeleteWorkerWithContext(ctx aws.Context, input *DeleteWorkerInput, opts ...request.Option) (*DeleteWorkerOutput, error) {
	req, out := c.DeleteWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromFarm = "DisassociateMemberFromFarm"

// DisassociateMemberFromFarmRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromFarm for more information on using the DisassociateMemberFromFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberFromFarmRequest method.
//	req, resp := client.DisassociateMemberFromFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm
func (c *Deadline) DisassociateMemberFromFarmRequest(input *DisassociateMemberFromFarmInput) (req *request.Request, output *DisassociateMemberFromFarmOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromFarm,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/members/{principalId}",
	}

	if input == nil {
		input = &DisassociateMemberFromFarmInput{}
	}

	output = &DisassociateMemberFromFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateMemberFromFarm API operation for AWSDeadlineCloud.
//
// Disassociates a member from a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DisassociateMemberFromFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFarm
func (c *Deadline) DisassociateMemberFromFarm(input *DisassociateMemberFromFarmInput) (*DisassociateMemberFromFarmOutput, error) {
	req, out := c.DisassociateMemberFromFarmRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromFarmWithContext is the same as DisassociateMemberFromFarm with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DisassociateMemberFromFarmWithContext(ctx aws.Context, input *DisassociateMemberFromFarmInput, opts ...request.Option) (*DisassociateMemberFromFarmOutput, error) {
	req, out := c.DisassociateMemberFromFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromFleet = "DisassociateMemberFromFleet"

// DisassociateMemberFromFleetRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromFleet for more information on using the DisassociateMemberFromFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberFromFleetRequest method.
//	req, resp := client.DisassociateMemberFromFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet
func (c *Deadline) DisassociateMemberFromFleetRequest(input *DisassociateMemberFromFleetInput) (req *request.Request, output *DisassociateMemberFromFleetOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromFleet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/members/{principalId}",
	}

	if input == nil {
		input = &DisassociateMemberFromFleetInput{}
	}

	output = &DisassociateMemberFromFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateMemberFromFleet API operation for AWSDeadlineCloud.
//
// Disassociates a member from a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DisassociateMemberFromFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromFleet
func (c *Deadline) DisassociateMemberFromFleet(input *DisassociateMemberFromFleetInput) (*DisassociateMemberFromFleetOutput, error) {
	req, out := c.DisassociateMemberFromFleetRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromFleetWithContext is the same as DisassociateMemberFromFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DisassociateMemberFromFleetWithContext(ctx aws.Context, input *DisassociateMemberFromFleetInput, opts ...request.Option) (*DisassociateMemberFromFleetOutput, error) {
	req, out := c.DisassociateMemberFromFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromJob = "DisassociateMemberFromJob"

// DisassociateMemberFromJobRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromJob for more information on using the DisassociateMemberFromJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberFromJobRequest method.
//	req, resp := client.DisassociateMemberFromJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob
func (c *Deadline) DisassociateMemberFromJobRequest(input *DisassociateMemberFromJobInput) (req *request.Request, output *DisassociateMemberFromJobOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromJob,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members/{principalId}",
	}

	if input == nil {
		input = &DisassociateMemberFromJobInput{}
	}

	output = &DisassociateMemberFromJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateMemberFromJob API operation for AWSDeadlineCloud.
//
// Disassociates a member from a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DisassociateMemberFromJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromJob
func (c *Deadline) DisassociateMemberFromJob(input *DisassociateMemberFromJobInput) (*DisassociateMemberFromJobOutput, error) {
	req, out := c.DisassociateMemberFromJobRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromJobWithContext is the same as DisassociateMemberFromJob with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DisassociateMemberFromJobWithContext(ctx aws.Context, input *DisassociateMemberFromJobInput, opts ...request.Option) (*DisassociateMemberFromJobOutput, error) {
	req, out := c.DisassociateMemberFromJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateMemberFromQueue = "DisassociateMemberFromQueue"

// DisassociateMemberFromQueueRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateMemberFromQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateMemberFromQueue for more information on using the DisassociateMemberFromQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateMemberFromQueueRequest method.
//	req, resp := client.DisassociateMemberFromQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue
func (c *Deadline) DisassociateMemberFromQueueRequest(input *DisassociateMemberFromQueueInput) (req *request.Request, output *DisassociateMemberFromQueueOutput) {
	op := &request.Operation{
		Name:       opDisassociateMemberFromQueue,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/members/{principalId}",
	}

	if input == nil {
		input = &DisassociateMemberFromQueueInput{}
	}

	output = &DisassociateMemberFromQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DisassociateMemberFromQueue API operation for AWSDeadlineCloud.
//
// Disassociates a member from a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation DisassociateMemberFromQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/DisassociateMemberFromQueue
func (c *Deadline) DisassociateMemberFromQueue(input *DisassociateMemberFromQueueInput) (*DisassociateMemberFromQueueOutput, error) {
	req, out := c.DisassociateMemberFromQueueRequest(input)
	return out, req.Send()
}

// DisassociateMemberFromQueueWithContext is the same as DisassociateMemberFromQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateMemberFromQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) DisassociateMemberFromQueueWithContext(ctx aws.Context, input *DisassociateMemberFromQueueInput, opts ...request.Option) (*DisassociateMemberFromQueueOutput, error) {
	req, out := c.DisassociateMemberFromQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBudget = "GetBudget"

// GetBudgetRequest generates a "aws/request.Request" representing the
// client's request for the GetBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBudget for more information on using the GetBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBudgetRequest method.
//	req, resp := client.GetBudgetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget
func (c *Deadline) GetBudgetRequest(input *GetBudgetInput) (req *request.Request, output *GetBudgetOutput) {
	op := &request.Operation{
		Name:       opGetBudget,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/budgets/{budgetId}",
	}

	if input == nil {
		input = &GetBudgetInput{}
	}

	output = &GetBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetBudget API operation for AWSDeadlineCloud.
//
// Get a budget.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetBudget for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetBudget
func (c *Deadline) GetBudget(input *GetBudgetInput) (*GetBudgetOutput, error) {
	req, out := c.GetBudgetRequest(input)
	return out, req.Send()
}

// GetBudgetWithContext is the same as GetBudget with the addition of
// the ability to pass a context and additional request options.
//
// See GetBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetBudgetWithContext(ctx aws.Context, input *GetBudgetInput, opts ...request.Option) (*GetBudgetOutput, error) {
	req, out := c.GetBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFarm = "GetFarm"

// GetFarmRequest generates a "aws/request.Request" representing the
// client's request for the GetFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFarm for more information on using the GetFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFarmRequest method.
//	req, resp := client.GetFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm
func (c *Deadline) GetFarmRequest(input *GetFarmInput) (req *request.Request, output *GetFarmOutput) {
	op := &request.Operation{
		Name:       opGetFarm,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}",
	}

	if input == nil {
		input = &GetFarmInput{}
	}

	output = &GetFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetFarm API operation for AWSDeadlineCloud.
//
// Get a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFarm
func (c *Deadline) GetFarm(input *GetFarmInput) (*GetFarmOutput, error) {
	req, out := c.GetFarmRequest(input)
	return out, req.Send()
}

// GetFarmWithContext is the same as GetFarm with the addition of
// the ability to pass a context and additional request options.
//
// See GetFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetFarmWithContext(ctx aws.Context, input *GetFarmInput, opts ...request.Option) (*GetFarmOutput, error) {
	req, out := c.GetFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetFleet = "GetFleet"

// GetFleetRequest generates a "aws/request.Request" representing the
// client's request for the GetFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFleet for more information on using the GetFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFleetRequest method.
//	req, resp := client.GetFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet
func (c *Deadline) GetFleetRequest(input *GetFleetInput) (req *request.Request, output *GetFleetOutput) {
	op := &request.Operation{
		Name:       opGetFleet,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}",
	}

	if input == nil {
		input = &GetFleetInput{}
	}

	output = &GetFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetFleet API operation for AWSDeadlineCloud.
//
// Get a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetFleet
func (c *Deadline) GetFleet(input *GetFleetInput) (*GetFleetOutput, error) {
	req, out := c.GetFleetRequest(input)
	return out, req.Send()
}

// GetFleetWithContext is the same as GetFleet with the addition of
// the ability to pass a context and additional request options.
//
// See GetFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetFleetWithContext(ctx aws.Context, input *GetFleetInput, opts ...request.Option) (*GetFleetOutput, error) {
	req, out := c.GetFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "aws/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetJobRequest method.
//	req, resp := client.GetJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob
func (c *Deadline) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetJob API operation for AWSDeadlineCloud.
//
// Gets a Deadline Cloud job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetJob
func (c *Deadline) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetJobWithContext(ctx aws.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLicenseEndpoint = "GetLicenseEndpoint"

// GetLicenseEndpointRequest generates a "aws/request.Request" representing the
// client's request for the GetLicenseEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLicenseEndpoint for more information on using the GetLicenseEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLicenseEndpointRequest method.
//	req, resp := client.GetLicenseEndpointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint
func (c *Deadline) GetLicenseEndpointRequest(input *GetLicenseEndpointInput) (req *request.Request, output *GetLicenseEndpointOutput) {
	op := &request.Operation{
		Name:       opGetLicenseEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/license-endpoints/{licenseEndpointId}",
	}

	if input == nil {
		input = &GetLicenseEndpointInput{}
	}

	output = &GetLicenseEndpointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetLicenseEndpoint API operation for AWSDeadlineCloud.
//
// Gets a licence endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetLicenseEndpoint for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetLicenseEndpoint
func (c *Deadline) GetLicenseEndpoint(input *GetLicenseEndpointInput) (*GetLicenseEndpointOutput, error) {
	req, out := c.GetLicenseEndpointRequest(input)
	return out, req.Send()
}

// GetLicenseEndpointWithContext is the same as GetLicenseEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetLicenseEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetLicenseEndpointWithContext(ctx aws.Context, input *GetLicenseEndpointInput, opts ...request.Option) (*GetLicenseEndpointOutput, error) {
	req, out := c.GetLicenseEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMonitor = "GetMonitor"

// GetMonitorRequest generates a "aws/request.Request" representing the
// client's request for the GetMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMonitor for more information on using the GetMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMonitorRequest method.
//	req, resp := client.GetMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor
func (c *Deadline) GetMonitorRequest(input *GetMonitorInput) (req *request.Request, output *GetMonitorOutput) {
	op := &request.Operation{
		Name:       opGetMonitor,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/monitors/{monitorId}",
	}

	if input == nil {
		input = &GetMonitorInput{}
	}

	output = &GetMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetMonitor API operation for AWSDeadlineCloud.
//
// Gets information about the specified monitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetMonitor
func (c *Deadline) GetMonitor(input *GetMonitorInput) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	return out, req.Send()
}

// GetMonitorWithContext is the same as GetMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See GetMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetMonitorWithContext(ctx aws.Context, input *GetMonitorInput, opts ...request.Option) (*GetMonitorOutput, error) {
	req, out := c.GetMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueue = "GetQueue"

// GetQueueRequest generates a "aws/request.Request" representing the
// client's request for the GetQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueue for more information on using the GetQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQueueRequest method.
//	req, resp := client.GetQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue
func (c *Deadline) GetQueueRequest(input *GetQueueInput) (req *request.Request, output *GetQueueOutput) {
	op := &request.Operation{
		Name:       opGetQueue,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}",
	}

	if input == nil {
		input = &GetQueueInput{}
	}

	output = &GetQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetQueue API operation for AWSDeadlineCloud.
//
// Gets a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueue
func (c *Deadline) GetQueue(input *GetQueueInput) (*GetQueueOutput, error) {
	req, out := c.GetQueueRequest(input)
	return out, req.Send()
}

// GetQueueWithContext is the same as GetQueue with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetQueueWithContext(ctx aws.Context, input *GetQueueInput, opts ...request.Option) (*GetQueueOutput, error) {
	req, out := c.GetQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueueEnvironment = "GetQueueEnvironment"

// GetQueueEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the GetQueueEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueueEnvironment for more information on using the GetQueueEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQueueEnvironmentRequest method.
//	req, resp := client.GetQueueEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment
func (c *Deadline) GetQueueEnvironmentRequest(input *GetQueueEnvironmentInput) (req *request.Request, output *GetQueueEnvironmentOutput) {
	op := &request.Operation{
		Name:       opGetQueueEnvironment,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}",
	}

	if input == nil {
		input = &GetQueueEnvironmentInput{}
	}

	output = &GetQueueEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetQueueEnvironment API operation for AWSDeadlineCloud.
//
// Gets a queue environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetQueueEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueEnvironment
func (c *Deadline) GetQueueEnvironment(input *GetQueueEnvironmentInput) (*GetQueueEnvironmentOutput, error) {
	req, out := c.GetQueueEnvironmentRequest(input)
	return out, req.Send()
}

// GetQueueEnvironmentWithContext is the same as GetQueueEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueueEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetQueueEnvironmentWithContext(ctx aws.Context, input *GetQueueEnvironmentInput, opts ...request.Option) (*GetQueueEnvironmentOutput, error) {
	req, out := c.GetQueueEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetQueueFleetAssociation = "GetQueueFleetAssociation"

// GetQueueFleetAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetQueueFleetAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetQueueFleetAssociation for more information on using the GetQueueFleetAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetQueueFleetAssociationRequest method.
//	req, resp := client.GetQueueFleetAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation
func (c *Deadline) GetQueueFleetAssociationRequest(input *GetQueueFleetAssociationInput) (req *request.Request, output *GetQueueFleetAssociationOutput) {
	op := &request.Operation{
		Name:       opGetQueueFleetAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}",
	}

	if input == nil {
		input = &GetQueueFleetAssociationInput{}
	}

	output = &GetQueueFleetAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetQueueFleetAssociation API operation for AWSDeadlineCloud.
//
// Gets a queue-fleet association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetQueueFleetAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetQueueFleetAssociation
func (c *Deadline) GetQueueFleetAssociation(input *GetQueueFleetAssociationInput) (*GetQueueFleetAssociationOutput, error) {
	req, out := c.GetQueueFleetAssociationRequest(input)
	return out, req.Send()
}

// GetQueueFleetAssociationWithContext is the same as GetQueueFleetAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetQueueFleetAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetQueueFleetAssociationWithContext(ctx aws.Context, input *GetQueueFleetAssociationInput, opts ...request.Option) (*GetQueueFleetAssociationOutput, error) {
	req, out := c.GetQueueFleetAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSession = "GetSession"

// GetSessionRequest generates a "aws/request.Request" representing the
// client's request for the GetSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSession for more information on using the GetSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSessionRequest method.
//	req, resp := client.GetSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession
func (c *Deadline) GetSessionRequest(input *GetSessionInput) (req *request.Request, output *GetSessionOutput) {
	op := &request.Operation{
		Name:       opGetSession,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &GetSessionInput{}
	}

	output = &GetSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSession API operation for AWSDeadlineCloud.
//
// Gets a session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetSession for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSession
func (c *Deadline) GetSession(input *GetSessionInput) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	return out, req.Send()
}

// GetSessionWithContext is the same as GetSession with the addition of
// the ability to pass a context and additional request options.
//
// See GetSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetSessionWithContext(ctx aws.Context, input *GetSessionInput, opts ...request.Option) (*GetSessionOutput, error) {
	req, out := c.GetSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSessionAction = "GetSessionAction"

// GetSessionActionRequest generates a "aws/request.Request" representing the
// client's request for the GetSessionAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSessionAction for more information on using the GetSessionAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSessionActionRequest method.
//	req, resp := client.GetSessionActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction
func (c *Deadline) GetSessionActionRequest(input *GetSessionActionInput) (req *request.Request, output *GetSessionActionOutput) {
	op := &request.Operation{
		Name:       opGetSessionAction,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/session-actions/{sessionActionId}",
	}

	if input == nil {
		input = &GetSessionActionInput{}
	}

	output = &GetSessionActionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSessionAction API operation for AWSDeadlineCloud.
//
// Gets a session action for the job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetSessionAction for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionAction
func (c *Deadline) GetSessionAction(input *GetSessionActionInput) (*GetSessionActionOutput, error) {
	req, out := c.GetSessionActionRequest(input)
	return out, req.Send()
}

// GetSessionActionWithContext is the same as GetSessionAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetSessionAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetSessionActionWithContext(ctx aws.Context, input *GetSessionActionInput, opts ...request.Option) (*GetSessionActionOutput, error) {
	req, out := c.GetSessionActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSessionsStatisticsAggregation = "GetSessionsStatisticsAggregation"

// GetSessionsStatisticsAggregationRequest generates a "aws/request.Request" representing the
// client's request for the GetSessionsStatisticsAggregation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSessionsStatisticsAggregation for more information on using the GetSessionsStatisticsAggregation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSessionsStatisticsAggregationRequest method.
//	req, resp := client.GetSessionsStatisticsAggregationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation
func (c *Deadline) GetSessionsStatisticsAggregationRequest(input *GetSessionsStatisticsAggregationInput) (req *request.Request, output *GetSessionsStatisticsAggregationOutput) {
	op := &request.Operation{
		Name:       opGetSessionsStatisticsAggregation,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/sessions-statistics-aggregation",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetSessionsStatisticsAggregationInput{}
	}

	output = &GetSessionsStatisticsAggregationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetSessionsStatisticsAggregation API operation for AWSDeadlineCloud.
//
// Gets a set of statistics for queues or farms. Before you can call the GetSessionStatisticsAggregation
// operation, you must first call the StartSessionsStatisticsAggregation operation.
// Statistics are available for 1 hour after you call the StartSessionsStatisticsAggregation
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetSessionsStatisticsAggregation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetSessionsStatisticsAggregation
func (c *Deadline) GetSessionsStatisticsAggregation(input *GetSessionsStatisticsAggregationInput) (*GetSessionsStatisticsAggregationOutput, error) {
	req, out := c.GetSessionsStatisticsAggregationRequest(input)
	return out, req.Send()
}

// GetSessionsStatisticsAggregationWithContext is the same as GetSessionsStatisticsAggregation with the addition of
// the ability to pass a context and additional request options.
//
// See GetSessionsStatisticsAggregation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetSessionsStatisticsAggregationWithContext(ctx aws.Context, input *GetSessionsStatisticsAggregationInput, opts ...request.Option) (*GetSessionsStatisticsAggregationOutput, error) {
	req, out := c.GetSessionsStatisticsAggregationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetSessionsStatisticsAggregationPages iterates over the pages of a GetSessionsStatisticsAggregation operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetSessionsStatisticsAggregation method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetSessionsStatisticsAggregation operation.
//	pageNum := 0
//	err := client.GetSessionsStatisticsAggregationPages(params,
//	    func(page *deadline.GetSessionsStatisticsAggregationOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) GetSessionsStatisticsAggregationPages(input *GetSessionsStatisticsAggregationInput, fn func(*GetSessionsStatisticsAggregationOutput, bool) bool) error {
	return c.GetSessionsStatisticsAggregationPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetSessionsStatisticsAggregationPagesWithContext same as GetSessionsStatisticsAggregationPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetSessionsStatisticsAggregationPagesWithContext(ctx aws.Context, input *GetSessionsStatisticsAggregationInput, fn func(*GetSessionsStatisticsAggregationOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetSessionsStatisticsAggregationInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetSessionsStatisticsAggregationRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetSessionsStatisticsAggregationOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetStep = "GetStep"

// GetStepRequest generates a "aws/request.Request" representing the
// client's request for the GetStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStep for more information on using the GetStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStepRequest method.
//	req, resp := client.GetStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep
func (c *Deadline) GetStepRequest(input *GetStepInput) (req *request.Request, output *GetStepOutput) {
	op := &request.Operation{
		Name:       opGetStep,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}",
	}

	if input == nil {
		input = &GetStepInput{}
	}

	output = &GetStepOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStep API operation for AWSDeadlineCloud.
//
// Gets a step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetStep for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStep
func (c *Deadline) GetStep(input *GetStepInput) (*GetStepOutput, error) {
	req, out := c.GetStepRequest(input)
	return out, req.Send()
}

// GetStepWithContext is the same as GetStep with the addition of
// the ability to pass a context and additional request options.
//
// See GetStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetStepWithContext(ctx aws.Context, input *GetStepInput, opts ...request.Option) (*GetStepOutput, error) {
	req, out := c.GetStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageProfile = "GetStorageProfile"

// GetStorageProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageProfile for more information on using the GetStorageProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageProfileRequest method.
//	req, resp := client.GetStorageProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile
func (c *Deadline) GetStorageProfileRequest(input *GetStorageProfileInput) (req *request.Request, output *GetStorageProfileOutput) {
	op := &request.Operation{
		Name:       opGetStorageProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}",
	}

	if input == nil {
		input = &GetStorageProfileInput{}
	}

	output = &GetStorageProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageProfile API operation for AWSDeadlineCloud.
//
// Gets a storage profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetStorageProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfile
func (c *Deadline) GetStorageProfile(input *GetStorageProfileInput) (*GetStorageProfileOutput, error) {
	req, out := c.GetStorageProfileRequest(input)
	return out, req.Send()
}

// GetStorageProfileWithContext is the same as GetStorageProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetStorageProfileWithContext(ctx aws.Context, input *GetStorageProfileInput, opts ...request.Option) (*GetStorageProfileOutput, error) {
	req, out := c.GetStorageProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStorageProfileForQueue = "GetStorageProfileForQueue"

// GetStorageProfileForQueueRequest generates a "aws/request.Request" representing the
// client's request for the GetStorageProfileForQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStorageProfileForQueue for more information on using the GetStorageProfileForQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetStorageProfileForQueueRequest method.
//	req, resp := client.GetStorageProfileForQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue
func (c *Deadline) GetStorageProfileForQueueRequest(input *GetStorageProfileForQueueInput) (req *request.Request, output *GetStorageProfileForQueueOutput) {
	op := &request.Operation{
		Name:       opGetStorageProfileForQueue,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/storage-profiles/{storageProfileId}",
	}

	if input == nil {
		input = &GetStorageProfileForQueueInput{}
	}

	output = &GetStorageProfileForQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetStorageProfileForQueue API operation for AWSDeadlineCloud.
//
// Gets a storage profile for a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetStorageProfileForQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetStorageProfileForQueue
func (c *Deadline) GetStorageProfileForQueue(input *GetStorageProfileForQueueInput) (*GetStorageProfileForQueueOutput, error) {
	req, out := c.GetStorageProfileForQueueRequest(input)
	return out, req.Send()
}

// GetStorageProfileForQueueWithContext is the same as GetStorageProfileForQueue with the addition of
// the ability to pass a context and additional request options.
//
// See GetStorageProfileForQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetStorageProfileForQueueWithContext(ctx aws.Context, input *GetStorageProfileForQueueInput, opts ...request.Option) (*GetStorageProfileForQueueOutput, error) {
	req, out := c.GetStorageProfileForQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTask = "GetTask"

// GetTaskRequest generates a "aws/request.Request" representing the
// client's request for the GetTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTask for more information on using the GetTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTaskRequest method.
//	req, resp := client.GetTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask
func (c *Deadline) GetTaskRequest(input *GetTaskInput) (req *request.Request, output *GetTaskOutput) {
	op := &request.Operation{
		Name:       opGetTask,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks/{taskId}",
	}

	if input == nil {
		input = &GetTaskInput{}
	}

	output = &GetTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetTask API operation for AWSDeadlineCloud.
//
// Gets a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetTask
func (c *Deadline) GetTask(input *GetTaskInput) (*GetTaskOutput, error) {
	req, out := c.GetTaskRequest(input)
	return out, req.Send()
}

// GetTaskWithContext is the same as GetTask with the addition of
// the ability to pass a context and additional request options.
//
// See GetTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetTaskWithContext(ctx aws.Context, input *GetTaskInput, opts ...request.Option) (*GetTaskOutput, error) {
	req, out := c.GetTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorker = "GetWorker"

// GetWorkerRequest generates a "aws/request.Request" representing the
// client's request for the GetWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorker for more information on using the GetWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkerRequest method.
//	req, resp := client.GetWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker
func (c *Deadline) GetWorkerRequest(input *GetWorkerInput) (req *request.Request, output *GetWorkerOutput) {
	op := &request.Operation{
		Name:       opGetWorker,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}",
	}

	if input == nil {
		input = &GetWorkerInput{}
	}

	output = &GetWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// GetWorker API operation for AWSDeadlineCloud.
//
// Gets a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation GetWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/GetWorker
func (c *Deadline) GetWorker(input *GetWorkerInput) (*GetWorkerOutput, error) {
	req, out := c.GetWorkerRequest(input)
	return out, req.Send()
}

// GetWorkerWithContext is the same as GetWorker with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) GetWorkerWithContext(ctx aws.Context, input *GetWorkerInput, opts ...request.Option) (*GetWorkerOutput, error) {
	req, out := c.GetWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableMeteredProducts = "ListAvailableMeteredProducts"

// ListAvailableMeteredProductsRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableMeteredProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableMeteredProducts for more information on using the ListAvailableMeteredProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAvailableMeteredProductsRequest method.
//	req, resp := client.ListAvailableMeteredProductsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts
func (c *Deadline) ListAvailableMeteredProductsRequest(input *ListAvailableMeteredProductsInput) (req *request.Request, output *ListAvailableMeteredProductsOutput) {
	op := &request.Operation{
		Name:       opListAvailableMeteredProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/metered-products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAvailableMeteredProductsInput{}
	}

	output = &ListAvailableMeteredProductsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListAvailableMeteredProducts API operation for AWSDeadlineCloud.
//
// A list of the available metered products.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListAvailableMeteredProducts for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListAvailableMeteredProducts
func (c *Deadline) ListAvailableMeteredProducts(input *ListAvailableMeteredProductsInput) (*ListAvailableMeteredProductsOutput, error) {
	req, out := c.ListAvailableMeteredProductsRequest(input)
	return out, req.Send()
}

// ListAvailableMeteredProductsWithContext is the same as ListAvailableMeteredProducts with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableMeteredProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListAvailableMeteredProductsWithContext(ctx aws.Context, input *ListAvailableMeteredProductsInput, opts ...request.Option) (*ListAvailableMeteredProductsOutput, error) {
	req, out := c.ListAvailableMeteredProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAvailableMeteredProductsPages iterates over the pages of a ListAvailableMeteredProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAvailableMeteredProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAvailableMeteredProducts operation.
//	pageNum := 0
//	err := client.ListAvailableMeteredProductsPages(params,
//	    func(page *deadline.ListAvailableMeteredProductsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListAvailableMeteredProductsPages(input *ListAvailableMeteredProductsInput, fn func(*ListAvailableMeteredProductsOutput, bool) bool) error {
	return c.ListAvailableMeteredProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAvailableMeteredProductsPagesWithContext same as ListAvailableMeteredProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListAvailableMeteredProductsPagesWithContext(ctx aws.Context, input *ListAvailableMeteredProductsInput, fn func(*ListAvailableMeteredProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAvailableMeteredProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAvailableMeteredProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAvailableMeteredProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBudgets = "ListBudgets"

// ListBudgetsRequest generates a "aws/request.Request" representing the
// client's request for the ListBudgets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBudgets for more information on using the ListBudgets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBudgetsRequest method.
//	req, resp := client.ListBudgetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets
func (c *Deadline) ListBudgetsRequest(input *ListBudgetsInput) (req *request.Request, output *ListBudgetsOutput) {
	op := &request.Operation{
		Name:       opListBudgets,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/budgets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBudgetsInput{}
	}

	output = &ListBudgetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListBudgets API operation for AWSDeadlineCloud.
//
// A list of budgets in a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListBudgets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListBudgets
func (c *Deadline) ListBudgets(input *ListBudgetsInput) (*ListBudgetsOutput, error) {
	req, out := c.ListBudgetsRequest(input)
	return out, req.Send()
}

// ListBudgetsWithContext is the same as ListBudgets with the addition of
// the ability to pass a context and additional request options.
//
// See ListBudgets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListBudgetsWithContext(ctx aws.Context, input *ListBudgetsInput, opts ...request.Option) (*ListBudgetsOutput, error) {
	req, out := c.ListBudgetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBudgetsPages iterates over the pages of a ListBudgets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBudgets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBudgets operation.
//	pageNum := 0
//	err := client.ListBudgetsPages(params,
//	    func(page *deadline.ListBudgetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListBudgetsPages(input *ListBudgetsInput, fn func(*ListBudgetsOutput, bool) bool) error {
	return c.ListBudgetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBudgetsPagesWithContext same as ListBudgetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListBudgetsPagesWithContext(ctx aws.Context, input *ListBudgetsInput, fn func(*ListBudgetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBudgetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBudgetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBudgetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFarmMembers = "ListFarmMembers"

// ListFarmMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListFarmMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFarmMembers for more information on using the ListFarmMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFarmMembersRequest method.
//	req, resp := client.ListFarmMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers
func (c *Deadline) ListFarmMembersRequest(input *ListFarmMembersInput) (req *request.Request, output *ListFarmMembersOutput) {
	op := &request.Operation{
		Name:       opListFarmMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFarmMembersInput{}
	}

	output = &ListFarmMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListFarmMembers API operation for AWSDeadlineCloud.
//
// Lists the members of a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListFarmMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarmMembers
func (c *Deadline) ListFarmMembers(input *ListFarmMembersInput) (*ListFarmMembersOutput, error) {
	req, out := c.ListFarmMembersRequest(input)
	return out, req.Send()
}

// ListFarmMembersWithContext is the same as ListFarmMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListFarmMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFarmMembersWithContext(ctx aws.Context, input *ListFarmMembersInput, opts ...request.Option) (*ListFarmMembersOutput, error) {
	req, out := c.ListFarmMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFarmMembersPages iterates over the pages of a ListFarmMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFarmMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFarmMembers operation.
//	pageNum := 0
//	err := client.ListFarmMembersPages(params,
//	    func(page *deadline.ListFarmMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListFarmMembersPages(input *ListFarmMembersInput, fn func(*ListFarmMembersOutput, bool) bool) error {
	return c.ListFarmMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFarmMembersPagesWithContext same as ListFarmMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFarmMembersPagesWithContext(ctx aws.Context, input *ListFarmMembersInput, fn func(*ListFarmMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFarmMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFarmMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFarmMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFarms = "ListFarms"

// ListFarmsRequest generates a "aws/request.Request" representing the
// client's request for the ListFarms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFarms for more information on using the ListFarms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFarmsRequest method.
//	req, resp := client.ListFarmsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms
func (c *Deadline) ListFarmsRequest(input *ListFarmsInput) (req *request.Request, output *ListFarmsOutput) {
	op := &request.Operation{
		Name:       opListFarms,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFarmsInput{}
	}

	output = &ListFarmsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListFarms API operation for AWSDeadlineCloud.
//
// Lists farms.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListFarms for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFarms
func (c *Deadline) ListFarms(input *ListFarmsInput) (*ListFarmsOutput, error) {
	req, out := c.ListFarmsRequest(input)
	return out, req.Send()
}

// ListFarmsWithContext is the same as ListFarms with the addition of
// the ability to pass a context and additional request options.
//
// See ListFarms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFarmsWithContext(ctx aws.Context, input *ListFarmsInput, opts ...request.Option) (*ListFarmsOutput, error) {
	req, out := c.ListFarmsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFarmsPages iterates over the pages of a ListFarms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFarms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFarms operation.
//	pageNum := 0
//	err := client.ListFarmsPages(params,
//	    func(page *deadline.ListFarmsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListFarmsPages(input *ListFarmsInput, fn func(*ListFarmsOutput, bool) bool) error {
	return c.ListFarmsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFarmsPagesWithContext same as ListFarmsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFarmsPagesWithContext(ctx aws.Context, input *ListFarmsInput, fn func(*ListFarmsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFarmsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFarmsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFarmsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleetMembers = "ListFleetMembers"

// ListFleetMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListFleetMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleetMembers for more information on using the ListFleetMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFleetMembersRequest method.
//	req, resp := client.ListFleetMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers
func (c *Deadline) ListFleetMembersRequest(input *ListFleetMembersInput) (req *request.Request, output *ListFleetMembersOutput) {
	op := &request.Operation{
		Name:       opListFleetMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetMembersInput{}
	}

	output = &ListFleetMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListFleetMembers API operation for AWSDeadlineCloud.
//
// Lists fleet members.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListFleetMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleetMembers
func (c *Deadline) ListFleetMembers(input *ListFleetMembersInput) (*ListFleetMembersOutput, error) {
	req, out := c.ListFleetMembersRequest(input)
	return out, req.Send()
}

// ListFleetMembersWithContext is the same as ListFleetMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleetMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFleetMembersWithContext(ctx aws.Context, input *ListFleetMembersInput, opts ...request.Option) (*ListFleetMembersOutput, error) {
	req, out := c.ListFleetMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetMembersPages iterates over the pages of a ListFleetMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleetMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFleetMembers operation.
//	pageNum := 0
//	err := client.ListFleetMembersPages(params,
//	    func(page *deadline.ListFleetMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListFleetMembersPages(input *ListFleetMembersInput, fn func(*ListFleetMembersOutput, bool) bool) error {
	return c.ListFleetMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetMembersPagesWithContext same as ListFleetMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFleetMembersPagesWithContext(ctx aws.Context, input *ListFleetMembersInput, fn func(*ListFleetMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFleetsRequest method.
//	req, resp := client.ListFleetsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets
func (c *Deadline) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListFleets API operation for AWSDeadlineCloud.
//
// Lists fleets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListFleets for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListFleets
func (c *Deadline) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsPages iterates over the pages of a ListFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFleets operation.
//	pageNum := 0
//	err := client.ListFleetsPages(params,
//	    func(page *deadline.ListFleetsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListFleetsPages(input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool) error {
	return c.ListFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsPagesWithContext same as ListFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListFleetsPagesWithContext(ctx aws.Context, input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobMembers = "ListJobMembers"

// ListJobMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListJobMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobMembers for more information on using the ListJobMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobMembersRequest method.
//	req, resp := client.ListJobMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers
func (c *Deadline) ListJobMembersRequest(input *ListJobMembersInput) (req *request.Request, output *ListJobMembersOutput) {
	op := &request.Operation{
		Name:       opListJobMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobMembersInput{}
	}

	output = &ListJobMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListJobMembers API operation for AWSDeadlineCloud.
//
// Lists members on a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListJobMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobMembers
func (c *Deadline) ListJobMembers(input *ListJobMembersInput) (*ListJobMembersOutput, error) {
	req, out := c.ListJobMembersRequest(input)
	return out, req.Send()
}

// ListJobMembersWithContext is the same as ListJobMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListJobMembersWithContext(ctx aws.Context, input *ListJobMembersInput, opts ...request.Option) (*ListJobMembersOutput, error) {
	req, out := c.ListJobMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobMembersPages iterates over the pages of a ListJobMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobMembers operation.
//	pageNum := 0
//	err := client.ListJobMembersPages(params,
//	    func(page *deadline.ListJobMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListJobMembersPages(input *ListJobMembersInput, fn func(*ListJobMembersOutput, bool) bool) error {
	return c.ListJobMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobMembersPagesWithContext same as ListJobMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListJobMembersPagesWithContext(ctx aws.Context, input *ListJobMembersInput, fn func(*ListJobMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListJobs for more information on using the ListJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListJobsRequest method.
//	req, resp := client.ListJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs
func (c *Deadline) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	output = &ListJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListJobs API operation for AWSDeadlineCloud.
//
// Lists jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListJobs
func (c *Deadline) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	return out, req.Send()
}

// ListJobsWithContext is the same as ListJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListJobsWithContext(ctx aws.Context, input *ListJobsInput, opts ...request.Option) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListJobsPages iterates over the pages of a ListJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListJobs operation.
//	pageNum := 0
//	err := client.ListJobsPages(params,
//	    func(page *deadline.ListJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListJobsPages(input *ListJobsInput, fn func(*ListJobsOutput, bool) bool) error {
	return c.ListJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListJobsPagesWithContext same as ListJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListJobsPagesWithContext(ctx aws.Context, input *ListJobsInput, fn func(*ListJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLicenseEndpoints = "ListLicenseEndpoints"

// ListLicenseEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the ListLicenseEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLicenseEndpoints for more information on using the ListLicenseEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLicenseEndpointsRequest method.
//	req, resp := client.ListLicenseEndpointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints
func (c *Deadline) ListLicenseEndpointsRequest(input *ListLicenseEndpointsInput) (req *request.Request, output *ListLicenseEndpointsOutput) {
	op := &request.Operation{
		Name:       opListLicenseEndpoints,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/license-endpoints",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLicenseEndpointsInput{}
	}

	output = &ListLicenseEndpointsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListLicenseEndpoints API operation for AWSDeadlineCloud.
//
// Lists license endpoints.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListLicenseEndpoints for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListLicenseEndpoints
func (c *Deadline) ListLicenseEndpoints(input *ListLicenseEndpointsInput) (*ListLicenseEndpointsOutput, error) {
	req, out := c.ListLicenseEndpointsRequest(input)
	return out, req.Send()
}

// ListLicenseEndpointsWithContext is the same as ListLicenseEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListLicenseEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListLicenseEndpointsWithContext(ctx aws.Context, input *ListLicenseEndpointsInput, opts ...request.Option) (*ListLicenseEndpointsOutput, error) {
	req, out := c.ListLicenseEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLicenseEndpointsPages iterates over the pages of a ListLicenseEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLicenseEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLicenseEndpoints operation.
//	pageNum := 0
//	err := client.ListLicenseEndpointsPages(params,
//	    func(page *deadline.ListLicenseEndpointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListLicenseEndpointsPages(input *ListLicenseEndpointsInput, fn func(*ListLicenseEndpointsOutput, bool) bool) error {
	return c.ListLicenseEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLicenseEndpointsPagesWithContext same as ListLicenseEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListLicenseEndpointsPagesWithContext(ctx aws.Context, input *ListLicenseEndpointsInput, fn func(*ListLicenseEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLicenseEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLicenseEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLicenseEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMeteredProducts = "ListMeteredProducts"

// ListMeteredProductsRequest generates a "aws/request.Request" representing the
// client's request for the ListMeteredProducts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMeteredProducts for more information on using the ListMeteredProducts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMeteredProductsRequest method.
//	req, resp := client.ListMeteredProductsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts
func (c *Deadline) ListMeteredProductsRequest(input *ListMeteredProductsInput) (req *request.Request, output *ListMeteredProductsOutput) {
	op := &request.Operation{
		Name:       opListMeteredProducts,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMeteredProductsInput{}
	}

	output = &ListMeteredProductsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListMeteredProducts API operation for AWSDeadlineCloud.
//
// Lists metered products.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListMeteredProducts for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMeteredProducts
func (c *Deadline) ListMeteredProducts(input *ListMeteredProductsInput) (*ListMeteredProductsOutput, error) {
	req, out := c.ListMeteredProductsRequest(input)
	return out, req.Send()
}

// ListMeteredProductsWithContext is the same as ListMeteredProducts with the addition of
// the ability to pass a context and additional request options.
//
// See ListMeteredProducts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListMeteredProductsWithContext(ctx aws.Context, input *ListMeteredProductsInput, opts ...request.Option) (*ListMeteredProductsOutput, error) {
	req, out := c.ListMeteredProductsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMeteredProductsPages iterates over the pages of a ListMeteredProducts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMeteredProducts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMeteredProducts operation.
//	pageNum := 0
//	err := client.ListMeteredProductsPages(params,
//	    func(page *deadline.ListMeteredProductsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListMeteredProductsPages(input *ListMeteredProductsInput, fn func(*ListMeteredProductsOutput, bool) bool) error {
	return c.ListMeteredProductsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMeteredProductsPagesWithContext same as ListMeteredProductsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListMeteredProductsPagesWithContext(ctx aws.Context, input *ListMeteredProductsInput, fn func(*ListMeteredProductsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMeteredProductsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMeteredProductsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMeteredProductsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListMonitors = "ListMonitors"

// ListMonitorsRequest generates a "aws/request.Request" representing the
// client's request for the ListMonitors operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListMonitors for more information on using the ListMonitors
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListMonitorsRequest method.
//	req, resp := client.ListMonitorsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors
func (c *Deadline) ListMonitorsRequest(input *ListMonitorsInput) (req *request.Request, output *ListMonitorsOutput) {
	op := &request.Operation{
		Name:       opListMonitors,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/monitors",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMonitorsInput{}
	}

	output = &ListMonitorsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListMonitors API operation for AWSDeadlineCloud.
//
// Gets a list of your monitors in Deadline Cloud.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListMonitors for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListMonitors
func (c *Deadline) ListMonitors(input *ListMonitorsInput) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	return out, req.Send()
}

// ListMonitorsWithContext is the same as ListMonitors with the addition of
// the ability to pass a context and additional request options.
//
// See ListMonitors for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListMonitorsWithContext(ctx aws.Context, input *ListMonitorsInput, opts ...request.Option) (*ListMonitorsOutput, error) {
	req, out := c.ListMonitorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListMonitorsPages iterates over the pages of a ListMonitors operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListMonitors method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListMonitors operation.
//	pageNum := 0
//	err := client.ListMonitorsPages(params,
//	    func(page *deadline.ListMonitorsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListMonitorsPages(input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool) error {
	return c.ListMonitorsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListMonitorsPagesWithContext same as ListMonitorsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListMonitorsPagesWithContext(ctx aws.Context, input *ListMonitorsInput, fn func(*ListMonitorsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListMonitorsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListMonitorsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListMonitorsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueueEnvironments = "ListQueueEnvironments"

// ListQueueEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueueEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueueEnvironments for more information on using the ListQueueEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueueEnvironmentsRequest method.
//	req, resp := client.ListQueueEnvironmentsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments
func (c *Deadline) ListQueueEnvironmentsRequest(input *ListQueueEnvironmentsInput) (req *request.Request, output *ListQueueEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListQueueEnvironments,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/environments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueueEnvironmentsInput{}
	}

	output = &ListQueueEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListQueueEnvironments API operation for AWSDeadlineCloud.
//
// Lists queue environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListQueueEnvironments for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueEnvironments
func (c *Deadline) ListQueueEnvironments(input *ListQueueEnvironmentsInput) (*ListQueueEnvironmentsOutput, error) {
	req, out := c.ListQueueEnvironmentsRequest(input)
	return out, req.Send()
}

// ListQueueEnvironmentsWithContext is the same as ListQueueEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueueEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueEnvironmentsWithContext(ctx aws.Context, input *ListQueueEnvironmentsInput, opts ...request.Option) (*ListQueueEnvironmentsOutput, error) {
	req, out := c.ListQueueEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueueEnvironmentsPages iterates over the pages of a ListQueueEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueueEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueueEnvironments operation.
//	pageNum := 0
//	err := client.ListQueueEnvironmentsPages(params,
//	    func(page *deadline.ListQueueEnvironmentsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListQueueEnvironmentsPages(input *ListQueueEnvironmentsInput, fn func(*ListQueueEnvironmentsOutput, bool) bool) error {
	return c.ListQueueEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueueEnvironmentsPagesWithContext same as ListQueueEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueEnvironmentsPagesWithContext(ctx aws.Context, input *ListQueueEnvironmentsInput, fn func(*ListQueueEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueueEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueueEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueueEnvironmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueueFleetAssociations = "ListQueueFleetAssociations"

// ListQueueFleetAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueueFleetAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueueFleetAssociations for more information on using the ListQueueFleetAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueueFleetAssociationsRequest method.
//	req, resp := client.ListQueueFleetAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations
func (c *Deadline) ListQueueFleetAssociationsRequest(input *ListQueueFleetAssociationsInput) (req *request.Request, output *ListQueueFleetAssociationsOutput) {
	op := &request.Operation{
		Name:       opListQueueFleetAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queue-fleet-associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueueFleetAssociationsInput{}
	}

	output = &ListQueueFleetAssociationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListQueueFleetAssociations API operation for AWSDeadlineCloud.
//
// Lists queue-fleet associations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListQueueFleetAssociations for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueFleetAssociations
func (c *Deadline) ListQueueFleetAssociations(input *ListQueueFleetAssociationsInput) (*ListQueueFleetAssociationsOutput, error) {
	req, out := c.ListQueueFleetAssociationsRequest(input)
	return out, req.Send()
}

// ListQueueFleetAssociationsWithContext is the same as ListQueueFleetAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueueFleetAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueFleetAssociationsWithContext(ctx aws.Context, input *ListQueueFleetAssociationsInput, opts ...request.Option) (*ListQueueFleetAssociationsOutput, error) {
	req, out := c.ListQueueFleetAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueueFleetAssociationsPages iterates over the pages of a ListQueueFleetAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueueFleetAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueueFleetAssociations operation.
//	pageNum := 0
//	err := client.ListQueueFleetAssociationsPages(params,
//	    func(page *deadline.ListQueueFleetAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListQueueFleetAssociationsPages(input *ListQueueFleetAssociationsInput, fn func(*ListQueueFleetAssociationsOutput, bool) bool) error {
	return c.ListQueueFleetAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueueFleetAssociationsPagesWithContext same as ListQueueFleetAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueFleetAssociationsPagesWithContext(ctx aws.Context, input *ListQueueFleetAssociationsInput, fn func(*ListQueueFleetAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueueFleetAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueueFleetAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueueFleetAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueueMembers = "ListQueueMembers"

// ListQueueMembersRequest generates a "aws/request.Request" representing the
// client's request for the ListQueueMembers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueueMembers for more information on using the ListQueueMembers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueueMembersRequest method.
//	req, resp := client.ListQueueMembersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers
func (c *Deadline) ListQueueMembersRequest(input *ListQueueMembersInput) (req *request.Request, output *ListQueueMembersOutput) {
	op := &request.Operation{
		Name:       opListQueueMembers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/members",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueueMembersInput{}
	}

	output = &ListQueueMembersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListQueueMembers API operation for AWSDeadlineCloud.
//
// Lists the members in a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListQueueMembers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueueMembers
func (c *Deadline) ListQueueMembers(input *ListQueueMembersInput) (*ListQueueMembersOutput, error) {
	req, out := c.ListQueueMembersRequest(input)
	return out, req.Send()
}

// ListQueueMembersWithContext is the same as ListQueueMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueueMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueMembersWithContext(ctx aws.Context, input *ListQueueMembersInput, opts ...request.Option) (*ListQueueMembersOutput, error) {
	req, out := c.ListQueueMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueueMembersPages iterates over the pages of a ListQueueMembers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueueMembers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueueMembers operation.
//	pageNum := 0
//	err := client.ListQueueMembersPages(params,
//	    func(page *deadline.ListQueueMembersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListQueueMembersPages(input *ListQueueMembersInput, fn func(*ListQueueMembersOutput, bool) bool) error {
	return c.ListQueueMembersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueueMembersPagesWithContext same as ListQueueMembersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueueMembersPagesWithContext(ctx aws.Context, input *ListQueueMembersInput, fn func(*ListQueueMembersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueueMembersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueueMembersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueueMembersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueues = "ListQueues"

// ListQueuesRequest generates a "aws/request.Request" representing the
// client's request for the ListQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueues for more information on using the ListQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueuesRequest method.
//	req, resp := client.ListQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues
func (c *Deadline) ListQueuesRequest(input *ListQueuesInput) (req *request.Request, output *ListQueuesOutput) {
	op := &request.Operation{
		Name:       opListQueues,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueuesInput{}
	}

	output = &ListQueuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListQueues API operation for AWSDeadlineCloud.
//
// Lists queues.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListQueues for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListQueues
func (c *Deadline) ListQueues(input *ListQueuesInput) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	return out, req.Send()
}

// ListQueuesWithContext is the same as ListQueues with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueuesWithContext(ctx aws.Context, input *ListQueuesInput, opts ...request.Option) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueuesPages iterates over the pages of a ListQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueues operation.
//	pageNum := 0
//	err := client.ListQueuesPages(params,
//	    func(page *deadline.ListQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListQueuesPages(input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool) error {
	return c.ListQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueuesPagesWithContext same as ListQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListQueuesPagesWithContext(ctx aws.Context, input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessionActions = "ListSessionActions"

// ListSessionActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSessionActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessionActions for more information on using the ListSessionActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSessionActionsRequest method.
//	req, resp := client.ListSessionActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions
func (c *Deadline) ListSessionActionsRequest(input *ListSessionActionsInput) (req *request.Request, output *ListSessionActionsOutput) {
	op := &request.Operation{
		Name:       opListSessionActions,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/session-actions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionActionsInput{}
	}

	output = &ListSessionActionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSessionActions API operation for AWSDeadlineCloud.
//
// Lists session actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListSessionActions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionActions
func (c *Deadline) ListSessionActions(input *ListSessionActionsInput) (*ListSessionActionsOutput, error) {
	req, out := c.ListSessionActionsRequest(input)
	return out, req.Send()
}

// ListSessionActionsWithContext is the same as ListSessionActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessionActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionActionsWithContext(ctx aws.Context, input *ListSessionActionsInput, opts ...request.Option) (*ListSessionActionsOutput, error) {
	req, out := c.ListSessionActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionActionsPages iterates over the pages of a ListSessionActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessionActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSessionActions operation.
//	pageNum := 0
//	err := client.ListSessionActionsPages(params,
//	    func(page *deadline.ListSessionActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListSessionActionsPages(input *ListSessionActionsInput, fn func(*ListSessionActionsOutput, bool) bool) error {
	return c.ListSessionActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionActionsPagesWithContext same as ListSessionActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionActionsPagesWithContext(ctx aws.Context, input *ListSessionActionsInput, fn func(*ListSessionActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessions = "ListSessions"

// ListSessionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSessions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessions for more information on using the ListSessions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSessionsRequest method.
//	req, resp := client.ListSessionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions
func (c *Deadline) ListSessionsRequest(input *ListSessionsInput) (req *request.Request, output *ListSessionsOutput) {
	op := &request.Operation{
		Name:       opListSessions,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionsInput{}
	}

	output = &ListSessionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSessions API operation for AWSDeadlineCloud.
//
// Lists sessions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListSessions for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessions
func (c *Deadline) ListSessions(input *ListSessionsInput) (*ListSessionsOutput, error) {
	req, out := c.ListSessionsRequest(input)
	return out, req.Send()
}

// ListSessionsWithContext is the same as ListSessions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionsWithContext(ctx aws.Context, input *ListSessionsInput, opts ...request.Option) (*ListSessionsOutput, error) {
	req, out := c.ListSessionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionsPages iterates over the pages of a ListSessions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSessions operation.
//	pageNum := 0
//	err := client.ListSessionsPages(params,
//	    func(page *deadline.ListSessionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListSessionsPages(input *ListSessionsInput, fn func(*ListSessionsOutput, bool) bool) error {
	return c.ListSessionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionsPagesWithContext same as ListSessionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionsPagesWithContext(ctx aws.Context, input *ListSessionsInput, fn func(*ListSessionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSessionsForWorker = "ListSessionsForWorker"

// ListSessionsForWorkerRequest generates a "aws/request.Request" representing the
// client's request for the ListSessionsForWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSessionsForWorker for more information on using the ListSessionsForWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSessionsForWorkerRequest method.
//	req, resp := client.ListSessionsForWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker
func (c *Deadline) ListSessionsForWorkerRequest(input *ListSessionsForWorkerInput) (req *request.Request, output *ListSessionsForWorkerOutput) {
	op := &request.Operation{
		Name:       opListSessionsForWorker,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/sessions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSessionsForWorkerInput{}
	}

	output = &ListSessionsForWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSessionsForWorker API operation for AWSDeadlineCloud.
//
// Lists sessions for a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListSessionsForWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSessionsForWorker
func (c *Deadline) ListSessionsForWorker(input *ListSessionsForWorkerInput) (*ListSessionsForWorkerOutput, error) {
	req, out := c.ListSessionsForWorkerRequest(input)
	return out, req.Send()
}

// ListSessionsForWorkerWithContext is the same as ListSessionsForWorker with the addition of
// the ability to pass a context and additional request options.
//
// See ListSessionsForWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionsForWorkerWithContext(ctx aws.Context, input *ListSessionsForWorkerInput, opts ...request.Option) (*ListSessionsForWorkerOutput, error) {
	req, out := c.ListSessionsForWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSessionsForWorkerPages iterates over the pages of a ListSessionsForWorker operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSessionsForWorker method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSessionsForWorker operation.
//	pageNum := 0
//	err := client.ListSessionsForWorkerPages(params,
//	    func(page *deadline.ListSessionsForWorkerOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListSessionsForWorkerPages(input *ListSessionsForWorkerInput, fn func(*ListSessionsForWorkerOutput, bool) bool) error {
	return c.ListSessionsForWorkerPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSessionsForWorkerPagesWithContext same as ListSessionsForWorkerPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListSessionsForWorkerPagesWithContext(ctx aws.Context, input *ListSessionsForWorkerInput, fn func(*ListSessionsForWorkerOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSessionsForWorkerInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSessionsForWorkerRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSessionsForWorkerOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStepConsumers = "ListStepConsumers"

// ListStepConsumersRequest generates a "aws/request.Request" representing the
// client's request for the ListStepConsumers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStepConsumers for more information on using the ListStepConsumers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStepConsumersRequest method.
//	req, resp := client.ListStepConsumersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers
func (c *Deadline) ListStepConsumersRequest(input *ListStepConsumersInput) (req *request.Request, output *ListStepConsumersOutput) {
	op := &request.Operation{
		Name:       opListStepConsumers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/consumers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepConsumersInput{}
	}

	output = &ListStepConsumersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStepConsumers API operation for AWSDeadlineCloud.
//
// Lists step consumers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListStepConsumers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepConsumers
func (c *Deadline) ListStepConsumers(input *ListStepConsumersInput) (*ListStepConsumersOutput, error) {
	req, out := c.ListStepConsumersRequest(input)
	return out, req.Send()
}

// ListStepConsumersWithContext is the same as ListStepConsumers with the addition of
// the ability to pass a context and additional request options.
//
// See ListStepConsumers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepConsumersWithContext(ctx aws.Context, input *ListStepConsumersInput, opts ...request.Option) (*ListStepConsumersOutput, error) {
	req, out := c.ListStepConsumersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStepConsumersPages iterates over the pages of a ListStepConsumers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStepConsumers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStepConsumers operation.
//	pageNum := 0
//	err := client.ListStepConsumersPages(params,
//	    func(page *deadline.ListStepConsumersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListStepConsumersPages(input *ListStepConsumersInput, fn func(*ListStepConsumersOutput, bool) bool) error {
	return c.ListStepConsumersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStepConsumersPagesWithContext same as ListStepConsumersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepConsumersPagesWithContext(ctx aws.Context, input *ListStepConsumersInput, fn func(*ListStepConsumersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStepConsumersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStepConsumersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStepConsumersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStepDependencies = "ListStepDependencies"

// ListStepDependenciesRequest generates a "aws/request.Request" representing the
// client's request for the ListStepDependencies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStepDependencies for more information on using the ListStepDependencies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStepDependenciesRequest method.
//	req, resp := client.ListStepDependenciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies
func (c *Deadline) ListStepDependenciesRequest(input *ListStepDependenciesInput) (req *request.Request, output *ListStepDependenciesOutput) {
	op := &request.Operation{
		Name:       opListStepDependencies,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/dependencies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepDependenciesInput{}
	}

	output = &ListStepDependenciesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStepDependencies API operation for AWSDeadlineCloud.
//
// Lists the dependencies for a step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListStepDependencies for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStepDependencies
func (c *Deadline) ListStepDependencies(input *ListStepDependenciesInput) (*ListStepDependenciesOutput, error) {
	req, out := c.ListStepDependenciesRequest(input)
	return out, req.Send()
}

// ListStepDependenciesWithContext is the same as ListStepDependencies with the addition of
// the ability to pass a context and additional request options.
//
// See ListStepDependencies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepDependenciesWithContext(ctx aws.Context, input *ListStepDependenciesInput, opts ...request.Option) (*ListStepDependenciesOutput, error) {
	req, out := c.ListStepDependenciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStepDependenciesPages iterates over the pages of a ListStepDependencies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStepDependencies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStepDependencies operation.
//	pageNum := 0
//	err := client.ListStepDependenciesPages(params,
//	    func(page *deadline.ListStepDependenciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListStepDependenciesPages(input *ListStepDependenciesInput, fn func(*ListStepDependenciesOutput, bool) bool) error {
	return c.ListStepDependenciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStepDependenciesPagesWithContext same as ListStepDependenciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepDependenciesPagesWithContext(ctx aws.Context, input *ListStepDependenciesInput, fn func(*ListStepDependenciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStepDependenciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStepDependenciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStepDependenciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSteps = "ListSteps"

// ListStepsRequest generates a "aws/request.Request" representing the
// client's request for the ListSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSteps for more information on using the ListSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStepsRequest method.
//	req, resp := client.ListStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps
func (c *Deadline) ListStepsRequest(input *ListStepsInput) (req *request.Request, output *ListStepsOutput) {
	op := &request.Operation{
		Name:       opListSteps,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepsInput{}
	}

	output = &ListStepsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListSteps API operation for AWSDeadlineCloud.
//
// Lists steps for a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListSteps for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListSteps
func (c *Deadline) ListSteps(input *ListStepsInput) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	return out, req.Send()
}

// ListStepsWithContext is the same as ListSteps with the addition of
// the ability to pass a context and additional request options.
//
// See ListSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepsWithContext(ctx aws.Context, input *ListStepsInput, opts ...request.Option) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStepsPages iterates over the pages of a ListSteps operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSteps method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSteps operation.
//	pageNum := 0
//	err := client.ListStepsPages(params,
//	    func(page *deadline.ListStepsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListStepsPages(input *ListStepsInput, fn func(*ListStepsOutput, bool) bool) error {
	return c.ListStepsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStepsPagesWithContext same as ListStepsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStepsPagesWithContext(ctx aws.Context, input *ListStepsInput, fn func(*ListStepsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStepsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStepsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStepsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageProfiles = "ListStorageProfiles"

// ListStorageProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageProfiles for more information on using the ListStorageProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageProfilesRequest method.
//	req, resp := client.ListStorageProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles
func (c *Deadline) ListStorageProfilesRequest(input *ListStorageProfilesInput) (req *request.Request, output *ListStorageProfilesOutput) {
	op := &request.Operation{
		Name:       opListStorageProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/storage-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageProfilesInput{}
	}

	output = &ListStorageProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageProfiles API operation for AWSDeadlineCloud.
//
// Lists storage profiles.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListStorageProfiles for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfiles
func (c *Deadline) ListStorageProfiles(input *ListStorageProfilesInput) (*ListStorageProfilesOutput, error) {
	req, out := c.ListStorageProfilesRequest(input)
	return out, req.Send()
}

// ListStorageProfilesWithContext is the same as ListStorageProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStorageProfilesWithContext(ctx aws.Context, input *ListStorageProfilesInput, opts ...request.Option) (*ListStorageProfilesOutput, error) {
	req, out := c.ListStorageProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageProfilesPages iterates over the pages of a ListStorageProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageProfiles operation.
//	pageNum := 0
//	err := client.ListStorageProfilesPages(params,
//	    func(page *deadline.ListStorageProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListStorageProfilesPages(input *ListStorageProfilesInput, fn func(*ListStorageProfilesOutput, bool) bool) error {
	return c.ListStorageProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageProfilesPagesWithContext same as ListStorageProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStorageProfilesPagesWithContext(ctx aws.Context, input *ListStorageProfilesInput, fn func(*ListStorageProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListStorageProfilesForQueue = "ListStorageProfilesForQueue"

// ListStorageProfilesForQueueRequest generates a "aws/request.Request" representing the
// client's request for the ListStorageProfilesForQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListStorageProfilesForQueue for more information on using the ListStorageProfilesForQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListStorageProfilesForQueueRequest method.
//	req, resp := client.ListStorageProfilesForQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue
func (c *Deadline) ListStorageProfilesForQueueRequest(input *ListStorageProfilesForQueueInput) (req *request.Request, output *ListStorageProfilesForQueueOutput) {
	op := &request.Operation{
		Name:       opListStorageProfilesForQueue,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/storage-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStorageProfilesForQueueInput{}
	}

	output = &ListStorageProfilesForQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListStorageProfilesForQueue API operation for AWSDeadlineCloud.
//
// Lists storage profiles for a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListStorageProfilesForQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListStorageProfilesForQueue
func (c *Deadline) ListStorageProfilesForQueue(input *ListStorageProfilesForQueueInput) (*ListStorageProfilesForQueueOutput, error) {
	req, out := c.ListStorageProfilesForQueueRequest(input)
	return out, req.Send()
}

// ListStorageProfilesForQueueWithContext is the same as ListStorageProfilesForQueue with the addition of
// the ability to pass a context and additional request options.
//
// See ListStorageProfilesForQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStorageProfilesForQueueWithContext(ctx aws.Context, input *ListStorageProfilesForQueueInput, opts ...request.Option) (*ListStorageProfilesForQueueOutput, error) {
	req, out := c.ListStorageProfilesForQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListStorageProfilesForQueuePages iterates over the pages of a ListStorageProfilesForQueue operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListStorageProfilesForQueue method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListStorageProfilesForQueue operation.
//	pageNum := 0
//	err := client.ListStorageProfilesForQueuePages(params,
//	    func(page *deadline.ListStorageProfilesForQueueOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListStorageProfilesForQueuePages(input *ListStorageProfilesForQueueInput, fn func(*ListStorageProfilesForQueueOutput, bool) bool) error {
	return c.ListStorageProfilesForQueuePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListStorageProfilesForQueuePagesWithContext same as ListStorageProfilesForQueuePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListStorageProfilesForQueuePagesWithContext(ctx aws.Context, input *ListStorageProfilesForQueueInput, fn func(*ListStorageProfilesForQueueOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListStorageProfilesForQueueInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListStorageProfilesForQueueRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListStorageProfilesForQueueOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource
func (c *Deadline) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTagsForResource API operation for AWSDeadlineCloud.
//
// Lists tags for a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTagsForResource
func (c *Deadline) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "aws/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTasksRequest method.
//	req, resp := client.ListTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks
func (c *Deadline) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListTasks API operation for AWSDeadlineCloud.
//
// Lists tasks for a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListTasks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListTasks
func (c *Deadline) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListTasksWithContext(ctx aws.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTasksPages iterates over the pages of a ListTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTasks operation.
//	pageNum := 0
//	err := client.ListTasksPages(params,
//	    func(page *deadline.ListTasksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListTasksPages(input *ListTasksInput, fn func(*ListTasksOutput, bool) bool) error {
	return c.ListTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTasksPagesWithContext same as ListTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListTasksPagesWithContext(ctx aws.Context, input *ListTasksInput, fn func(*ListTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkers = "ListWorkers"

// ListWorkersRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkers for more information on using the ListWorkers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkersRequest method.
//	req, resp := client.ListWorkersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers
func (c *Deadline) ListWorkersRequest(input *ListWorkersInput) (req *request.Request, output *ListWorkersOutput) {
	op := &request.Operation{
		Name:       opListWorkers,
		HTTPMethod: "GET",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkersInput{}
	}

	output = &ListWorkersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// ListWorkers API operation for AWSDeadlineCloud.
//
// Lists workers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation ListWorkers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/ListWorkers
func (c *Deadline) ListWorkers(input *ListWorkersInput) (*ListWorkersOutput, error) {
	req, out := c.ListWorkersRequest(input)
	return out, req.Send()
}

// ListWorkersWithContext is the same as ListWorkers with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListWorkersWithContext(ctx aws.Context, input *ListWorkersInput, opts ...request.Option) (*ListWorkersOutput, error) {
	req, out := c.ListWorkersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkersPages iterates over the pages of a ListWorkers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkers operation.
//	pageNum := 0
//	err := client.ListWorkersPages(params,
//	    func(page *deadline.ListWorkersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Deadline) ListWorkersPages(input *ListWorkersInput, fn func(*ListWorkersOutput, bool) bool) error {
	return c.ListWorkersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkersPagesWithContext same as ListWorkersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) ListWorkersPagesWithContext(ctx aws.Context, input *ListWorkersInput, fn func(*ListWorkersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutMeteredProduct = "PutMeteredProduct"

// PutMeteredProductRequest generates a "aws/request.Request" representing the
// client's request for the PutMeteredProduct operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMeteredProduct for more information on using the PutMeteredProduct
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutMeteredProductRequest method.
//	req, resp := client.PutMeteredProductRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct
func (c *Deadline) PutMeteredProductRequest(input *PutMeteredProductInput) (req *request.Request, output *PutMeteredProductOutput) {
	op := &request.Operation{
		Name:       opPutMeteredProduct,
		HTTPMethod: "PUT",
		HTTPPath:   "/2023-10-12/license-endpoints/{licenseEndpointId}/metered-products/{productId}",
	}

	if input == nil {
		input = &PutMeteredProductInput{}
	}

	output = &PutMeteredProductOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// PutMeteredProduct API operation for AWSDeadlineCloud.
//
// Adds a metered product.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation PutMeteredProduct for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/PutMeteredProduct
func (c *Deadline) PutMeteredProduct(input *PutMeteredProductInput) (*PutMeteredProductOutput, error) {
	req, out := c.PutMeteredProductRequest(input)
	return out, req.Send()
}

// PutMeteredProductWithContext is the same as PutMeteredProduct with the addition of
// the ability to pass a context and additional request options.
//
// See PutMeteredProduct for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) PutMeteredProductWithContext(ctx aws.Context, input *PutMeteredProductInput, opts ...request.Option) (*PutMeteredProductOutput, error) {
	req, out := c.PutMeteredProductRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchJobs = "SearchJobs"

// SearchJobsRequest generates a "aws/request.Request" representing the
// client's request for the SearchJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchJobs for more information on using the SearchJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchJobsRequest method.
//	req, resp := client.SearchJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs
func (c *Deadline) SearchJobsRequest(input *SearchJobsInput) (req *request.Request, output *SearchJobsOutput) {
	op := &request.Operation{
		Name:       opSearchJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/search/jobs",
	}

	if input == nil {
		input = &SearchJobsInput{}
	}

	output = &SearchJobsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchJobs API operation for AWSDeadlineCloud.
//
// Searches for jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation SearchJobs for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchJobs
func (c *Deadline) SearchJobs(input *SearchJobsInput) (*SearchJobsOutput, error) {
	req, out := c.SearchJobsRequest(input)
	return out, req.Send()
}

// SearchJobsWithContext is the same as SearchJobs with the addition of
// the ability to pass a context and additional request options.
//
// See SearchJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) SearchJobsWithContext(ctx aws.Context, input *SearchJobsInput, opts ...request.Option) (*SearchJobsOutput, error) {
	req, out := c.SearchJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchSteps = "SearchSteps"

// SearchStepsRequest generates a "aws/request.Request" representing the
// client's request for the SearchSteps operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSteps for more information on using the SearchSteps
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchStepsRequest method.
//	req, resp := client.SearchStepsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps
func (c *Deadline) SearchStepsRequest(input *SearchStepsInput) (req *request.Request, output *SearchStepsOutput) {
	op := &request.Operation{
		Name:       opSearchSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/search/steps",
	}

	if input == nil {
		input = &SearchStepsInput{}
	}

	output = &SearchStepsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchSteps API operation for AWSDeadlineCloud.
//
// Searches for steps.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation SearchSteps for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchSteps
func (c *Deadline) SearchSteps(input *SearchStepsInput) (*SearchStepsOutput, error) {
	req, out := c.SearchStepsRequest(input)
	return out, req.Send()
}

// SearchStepsWithContext is the same as SearchSteps with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSteps for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) SearchStepsWithContext(ctx aws.Context, input *SearchStepsInput, opts ...request.Option) (*SearchStepsOutput, error) {
	req, out := c.SearchStepsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchTasks = "SearchTasks"

// SearchTasksRequest generates a "aws/request.Request" representing the
// client's request for the SearchTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchTasks for more information on using the SearchTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchTasksRequest method.
//	req, resp := client.SearchTasksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks
func (c *Deadline) SearchTasksRequest(input *SearchTasksInput) (req *request.Request, output *SearchTasksOutput) {
	op := &request.Operation{
		Name:       opSearchTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/search/tasks",
	}

	if input == nil {
		input = &SearchTasksInput{}
	}

	output = &SearchTasksOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchTasks API operation for AWSDeadlineCloud.
//
// Searches for tasks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation SearchTasks for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchTasks
func (c *Deadline) SearchTasks(input *SearchTasksInput) (*SearchTasksOutput, error) {
	req, out := c.SearchTasksRequest(input)
	return out, req.Send()
}

// SearchTasksWithContext is the same as SearchTasks with the addition of
// the ability to pass a context and additional request options.
//
// See SearchTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) SearchTasksWithContext(ctx aws.Context, input *SearchTasksInput, opts ...request.Option) (*SearchTasksOutput, error) {
	req, out := c.SearchTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchWorkers = "SearchWorkers"

// SearchWorkersRequest generates a "aws/request.Request" representing the
// client's request for the SearchWorkers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchWorkers for more information on using the SearchWorkers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchWorkersRequest method.
//	req, resp := client.SearchWorkersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers
func (c *Deadline) SearchWorkersRequest(input *SearchWorkersInput) (req *request.Request, output *SearchWorkersOutput) {
	op := &request.Operation{
		Name:       opSearchWorkers,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/search/workers",
	}

	if input == nil {
		input = &SearchWorkersInput{}
	}

	output = &SearchWorkersOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// SearchWorkers API operation for AWSDeadlineCloud.
//
// Searches for workers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation SearchWorkers for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/SearchWorkers
func (c *Deadline) SearchWorkers(input *SearchWorkersInput) (*SearchWorkersOutput, error) {
	req, out := c.SearchWorkersRequest(input)
	return out, req.Send()
}

// SearchWorkersWithContext is the same as SearchWorkers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchWorkers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) SearchWorkersWithContext(ctx aws.Context, input *SearchWorkersInput, opts ...request.Option) (*SearchWorkersOutput, error) {
	req, out := c.SearchWorkersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSessionsStatisticsAggregation = "StartSessionsStatisticsAggregation"

// StartSessionsStatisticsAggregationRequest generates a "aws/request.Request" representing the
// client's request for the StartSessionsStatisticsAggregation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSessionsStatisticsAggregation for more information on using the StartSessionsStatisticsAggregation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartSessionsStatisticsAggregationRequest method.
//	req, resp := client.StartSessionsStatisticsAggregationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation
func (c *Deadline) StartSessionsStatisticsAggregationRequest(input *StartSessionsStatisticsAggregationInput) (req *request.Request, output *StartSessionsStatisticsAggregationOutput) {
	op := &request.Operation{
		Name:       opStartSessionsStatisticsAggregation,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/farms/{farmId}/sessions-statistics-aggregation",
	}

	if input == nil {
		input = &StartSessionsStatisticsAggregationInput{}
	}

	output = &StartSessionsStatisticsAggregationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// StartSessionsStatisticsAggregation API operation for AWSDeadlineCloud.
//
// Starts an asynchronous request for getting aggregated statistics about queues
// and farms. Get the statistics using the GetSessionsStatisticsAggregation
// operation. Statistics are available for 1 hour after you call the StartSessionsStatisticsAggregation
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation StartSessionsStatisticsAggregation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/StartSessionsStatisticsAggregation
func (c *Deadline) StartSessionsStatisticsAggregation(input *StartSessionsStatisticsAggregationInput) (*StartSessionsStatisticsAggregationOutput, error) {
	req, out := c.StartSessionsStatisticsAggregationRequest(input)
	return out, req.Send()
}

// StartSessionsStatisticsAggregationWithContext is the same as StartSessionsStatisticsAggregation with the addition of
// the ability to pass a context and additional request options.
//
// See StartSessionsStatisticsAggregation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) StartSessionsStatisticsAggregationWithContext(ctx aws.Context, input *StartSessionsStatisticsAggregationInput, opts ...request.Option) (*StartSessionsStatisticsAggregationOutput, error) {
	req, out := c.StartSessionsStatisticsAggregationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource
func (c *Deadline) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2023-10-12/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// TagResource API operation for AWSDeadlineCloud.
//
// Tags a resource using the resource's ARN and desired tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/TagResource
func (c *Deadline) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource
func (c *Deadline) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2023-10-12/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UntagResource API operation for AWSDeadlineCloud.
//
// Removes a tag from a resource using the resource's ARN and tag to remove.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UntagResource
func (c *Deadline) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBudget = "UpdateBudget"

// UpdateBudgetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBudget operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBudget for more information on using the UpdateBudget
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBudgetRequest method.
//	req, resp := client.UpdateBudgetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget
func (c *Deadline) UpdateBudgetRequest(input *UpdateBudgetInput) (req *request.Request, output *UpdateBudgetOutput) {
	op := &request.Operation{
		Name:       opUpdateBudget,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/budgets/{budgetId}",
	}

	if input == nil {
		input = &UpdateBudgetInput{}
	}

	output = &UpdateBudgetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateBudget API operation for AWSDeadlineCloud.
//
// Updates a budget that sets spending thresholds for rendering activity.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateBudget for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateBudget
func (c *Deadline) UpdateBudget(input *UpdateBudgetInput) (*UpdateBudgetOutput, error) {
	req, out := c.UpdateBudgetRequest(input)
	return out, req.Send()
}

// UpdateBudgetWithContext is the same as UpdateBudget with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBudget for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateBudgetWithContext(ctx aws.Context, input *UpdateBudgetInput, opts ...request.Option) (*UpdateBudgetOutput, error) {
	req, out := c.UpdateBudgetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFarm = "UpdateFarm"

// UpdateFarmRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFarm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFarm for more information on using the UpdateFarm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFarmRequest method.
//	req, resp := client.UpdateFarmRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm
func (c *Deadline) UpdateFarmRequest(input *UpdateFarmInput) (req *request.Request, output *UpdateFarmOutput) {
	op := &request.Operation{
		Name:       opUpdateFarm,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}",
	}

	if input == nil {
		input = &UpdateFarmInput{}
	}

	output = &UpdateFarmOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateFarm API operation for AWSDeadlineCloud.
//
// Updates a farm.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateFarm for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFarm
func (c *Deadline) UpdateFarm(input *UpdateFarmInput) (*UpdateFarmOutput, error) {
	req, out := c.UpdateFarmRequest(input)
	return out, req.Send()
}

// UpdateFarmWithContext is the same as UpdateFarm with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFarm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateFarmWithContext(ctx aws.Context, input *UpdateFarmInput, opts ...request.Option) (*UpdateFarmOutput, error) {
	req, out := c.UpdateFarmRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFleet for more information on using the UpdateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFleetRequest method.
//	req, resp := client.UpdateFleetRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet
func (c *Deadline) UpdateFleetRequest(input *UpdateFleetInput) (req *request.Request, output *UpdateFleetOutput) {
	op := &request.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	output = &UpdateFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateFleet API operation for AWSDeadlineCloud.
//
// Updates a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateFleet for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
//   - ServiceQuotaExceededException
//     You exceeded your service quota. Service quotas, also referred to as limits,
//     are the maximum number of service resources or operations for your Amazon
//     Web Services account.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateFleet
func (c *Deadline) UpdateFleet(input *UpdateFleetInput) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	return out, req.Send()
}

// UpdateFleetWithContext is the same as UpdateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateFleetWithContext(ctx aws.Context, input *UpdateFleetInput, opts ...request.Option) (*UpdateFleetOutput, error) {
	req, out := c.UpdateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateJob = "UpdateJob"

// UpdateJobRequest generates a "aws/request.Request" representing the
// client's request for the UpdateJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateJob for more information on using the UpdateJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateJobRequest method.
//	req, resp := client.UpdateJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob
func (c *Deadline) UpdateJobRequest(input *UpdateJobInput) (req *request.Request, output *UpdateJobOutput) {
	op := &request.Operation{
		Name:       opUpdateJob,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}",
	}

	if input == nil {
		input = &UpdateJobInput{}
	}

	output = &UpdateJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateJob API operation for AWSDeadlineCloud.
//
// Updates a job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateJob for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateJob
func (c *Deadline) UpdateJob(input *UpdateJobInput) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	return out, req.Send()
}

// UpdateJobWithContext is the same as UpdateJob with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateJobWithContext(ctx aws.Context, input *UpdateJobInput, opts ...request.Option) (*UpdateJobOutput, error) {
	req, out := c.UpdateJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMonitor = "UpdateMonitor"

// UpdateMonitorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMonitor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMonitor for more information on using the UpdateMonitor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateMonitorRequest method.
//	req, resp := client.UpdateMonitorRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor
func (c *Deadline) UpdateMonitorRequest(input *UpdateMonitorInput) (req *request.Request, output *UpdateMonitorOutput) {
	op := &request.Operation{
		Name:       opUpdateMonitor,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/monitors/{monitorId}",
	}

	if input == nil {
		input = &UpdateMonitorInput{}
	}

	output = &UpdateMonitorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateMonitor API operation for AWSDeadlineCloud.
//
// Modifies the settings for a Deadline Cloud monitor. You can modify one or
// all of the settings when you call UpdateMonitor.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateMonitor for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateMonitor
func (c *Deadline) UpdateMonitor(input *UpdateMonitorInput) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	return out, req.Send()
}

// UpdateMonitorWithContext is the same as UpdateMonitor with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMonitor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateMonitorWithContext(ctx aws.Context, input *UpdateMonitorInput, opts ...request.Option) (*UpdateMonitorOutput, error) {
	req, out := c.UpdateMonitorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueue = "UpdateQueue"

// UpdateQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueue for more information on using the UpdateQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueRequest method.
//	req, resp := client.UpdateQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue
func (c *Deadline) UpdateQueueRequest(input *UpdateQueueInput) (req *request.Request, output *UpdateQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateQueue,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}",
	}

	if input == nil {
		input = &UpdateQueueInput{}
	}

	output = &UpdateQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateQueue API operation for AWSDeadlineCloud.
//
// Updates a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateQueue for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueue
func (c *Deadline) UpdateQueue(input *UpdateQueueInput) (*UpdateQueueOutput, error) {
	req, out := c.UpdateQueueRequest(input)
	return out, req.Send()
}

// UpdateQueueWithContext is the same as UpdateQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateQueueWithContext(ctx aws.Context, input *UpdateQueueInput, opts ...request.Option) (*UpdateQueueOutput, error) {
	req, out := c.UpdateQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueEnvironment = "UpdateQueueEnvironment"

// UpdateQueueEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueEnvironment for more information on using the UpdateQueueEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueEnvironmentRequest method.
//	req, resp := client.UpdateQueueEnvironmentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment
func (c *Deadline) UpdateQueueEnvironmentRequest(input *UpdateQueueEnvironmentInput) (req *request.Request, output *UpdateQueueEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueEnvironment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/environments/{queueEnvironmentId}",
	}

	if input == nil {
		input = &UpdateQueueEnvironmentInput{}
	}

	output = &UpdateQueueEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateQueueEnvironment API operation for AWSDeadlineCloud.
//
// Updates the queue environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateQueueEnvironment for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueEnvironment
func (c *Deadline) UpdateQueueEnvironment(input *UpdateQueueEnvironmentInput) (*UpdateQueueEnvironmentOutput, error) {
	req, out := c.UpdateQueueEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateQueueEnvironmentWithContext is the same as UpdateQueueEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateQueueEnvironmentWithContext(ctx aws.Context, input *UpdateQueueEnvironmentInput, opts ...request.Option) (*UpdateQueueEnvironmentOutput, error) {
	req, out := c.UpdateQueueEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueFleetAssociation = "UpdateQueueFleetAssociation"

// UpdateQueueFleetAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueFleetAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueFleetAssociation for more information on using the UpdateQueueFleetAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueFleetAssociationRequest method.
//	req, resp := client.UpdateQueueFleetAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation
func (c *Deadline) UpdateQueueFleetAssociationRequest(input *UpdateQueueFleetAssociationInput) (req *request.Request, output *UpdateQueueFleetAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueFleetAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queue-fleet-associations/{queueId}/{fleetId}",
	}

	if input == nil {
		input = &UpdateQueueFleetAssociationInput{}
	}

	output = &UpdateQueueFleetAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateQueueFleetAssociation API operation for AWSDeadlineCloud.
//
// Updates a queue-fleet association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateQueueFleetAssociation for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateQueueFleetAssociation
func (c *Deadline) UpdateQueueFleetAssociation(input *UpdateQueueFleetAssociationInput) (*UpdateQueueFleetAssociationOutput, error) {
	req, out := c.UpdateQueueFleetAssociationRequest(input)
	return out, req.Send()
}

// UpdateQueueFleetAssociationWithContext is the same as UpdateQueueFleetAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueFleetAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateQueueFleetAssociationWithContext(ctx aws.Context, input *UpdateQueueFleetAssociationInput, opts ...request.Option) (*UpdateQueueFleetAssociationOutput, error) {
	req, out := c.UpdateQueueFleetAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSession = "UpdateSession"

// UpdateSessionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSession operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSession for more information on using the UpdateSession
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSessionRequest method.
//	req, resp := client.UpdateSessionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession
func (c *Deadline) UpdateSessionRequest(input *UpdateSessionInput) (req *request.Request, output *UpdateSessionOutput) {
	op := &request.Operation{
		Name:       opUpdateSession,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/sessions/{sessionId}",
	}

	if input == nil {
		input = &UpdateSessionInput{}
	}

	output = &UpdateSessionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateSession API operation for AWSDeadlineCloud.
//
// Updates a session.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateSession for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateSession
func (c *Deadline) UpdateSession(input *UpdateSessionInput) (*UpdateSessionOutput, error) {
	req, out := c.UpdateSessionRequest(input)
	return out, req.Send()
}

// UpdateSessionWithContext is the same as UpdateSession with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSession for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateSessionWithContext(ctx aws.Context, input *UpdateSessionInput, opts ...request.Option) (*UpdateSessionOutput, error) {
	req, out := c.UpdateSessionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStep = "UpdateStep"

// UpdateStepRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStep operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStep for more information on using the UpdateStep
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStepRequest method.
//	req, resp := client.UpdateStepRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep
func (c *Deadline) UpdateStepRequest(input *UpdateStepInput) (req *request.Request, output *UpdateStepOutput) {
	op := &request.Operation{
		Name:       opUpdateStep,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}",
	}

	if input == nil {
		input = &UpdateStepInput{}
	}

	output = &UpdateStepOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateStep API operation for AWSDeadlineCloud.
//
// Updates a step.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateStep for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStep
func (c *Deadline) UpdateStep(input *UpdateStepInput) (*UpdateStepOutput, error) {
	req, out := c.UpdateStepRequest(input)
	return out, req.Send()
}

// UpdateStepWithContext is the same as UpdateStep with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStep for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateStepWithContext(ctx aws.Context, input *UpdateStepInput, opts ...request.Option) (*UpdateStepOutput, error) {
	req, out := c.UpdateStepRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStorageProfile = "UpdateStorageProfile"

// UpdateStorageProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStorageProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStorageProfile for more information on using the UpdateStorageProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateStorageProfileRequest method.
//	req, resp := client.UpdateStorageProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile
func (c *Deadline) UpdateStorageProfileRequest(input *UpdateStorageProfileInput) (req *request.Request, output *UpdateStorageProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateStorageProfile,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/storage-profiles/{storageProfileId}",
	}

	if input == nil {
		input = &UpdateStorageProfileInput{}
	}

	output = &UpdateStorageProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateStorageProfile API operation for AWSDeadlineCloud.
//
// Updates a storage profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateStorageProfile for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateStorageProfile
func (c *Deadline) UpdateStorageProfile(input *UpdateStorageProfileInput) (*UpdateStorageProfileOutput, error) {
	req, out := c.UpdateStorageProfileRequest(input)
	return out, req.Send()
}

// UpdateStorageProfileWithContext is the same as UpdateStorageProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStorageProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateStorageProfileWithContext(ctx aws.Context, input *UpdateStorageProfileInput, opts ...request.Option) (*UpdateStorageProfileOutput, error) {
	req, out := c.UpdateStorageProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTask = "UpdateTask"

// UpdateTaskRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTask for more information on using the UpdateTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTaskRequest method.
//	req, resp := client.UpdateTaskRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask
func (c *Deadline) UpdateTaskRequest(input *UpdateTaskInput) (req *request.Request, output *UpdateTaskOutput) {
	op := &request.Operation{
		Name:       opUpdateTask,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/queues/{queueId}/jobs/{jobId}/steps/{stepId}/tasks/{taskId}",
	}

	if input == nil {
		input = &UpdateTaskInput{}
	}

	output = &UpdateTaskOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("management.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateTask API operation for AWSDeadlineCloud.
//
// Updates a task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateTask for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateTask
func (c *Deadline) UpdateTask(input *UpdateTaskInput) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	return out, req.Send()
}

// UpdateTaskWithContext is the same as UpdateTask with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateTaskWithContext(ctx aws.Context, input *UpdateTaskInput, opts ...request.Option) (*UpdateTaskOutput, error) {
	req, out := c.UpdateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorker = "UpdateWorker"

// UpdateWorkerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorker operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorker for more information on using the UpdateWorker
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkerRequest method.
//	req, resp := client.UpdateWorkerRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker
func (c *Deadline) UpdateWorkerRequest(input *UpdateWorkerInput) (req *request.Request, output *UpdateWorkerOutput) {
	op := &request.Operation{
		Name:       opUpdateWorker,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}",
	}

	if input == nil {
		input = &UpdateWorkerInput{}
	}

	output = &UpdateWorkerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateWorker API operation for AWSDeadlineCloud.
//
// Updates a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateWorker for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorker
func (c *Deadline) UpdateWorker(input *UpdateWorkerInput) (*UpdateWorkerOutput, error) {
	req, out := c.UpdateWorkerRequest(input)
	return out, req.Send()
}

// UpdateWorkerWithContext is the same as UpdateWorker with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateWorkerWithContext(ctx aws.Context, input *UpdateWorkerInput, opts ...request.Option) (*UpdateWorkerOutput, error) {
	req, out := c.UpdateWorkerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkerSchedule = "UpdateWorkerSchedule"

// UpdateWorkerScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkerSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkerSchedule for more information on using the UpdateWorkerSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkerScheduleRequest method.
//	req, resp := client.UpdateWorkerScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule
func (c *Deadline) UpdateWorkerScheduleRequest(input *UpdateWorkerScheduleInput) (req *request.Request, output *UpdateWorkerScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkerSchedule,
		HTTPMethod: "PATCH",
		HTTPPath:   "/2023-10-12/farms/{farmId}/fleets/{fleetId}/workers/{workerId}/schedule",
	}

	if input == nil {
		input = &UpdateWorkerScheduleInput{}
	}

	output = &UpdateWorkerScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("scheduling.", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// UpdateWorkerSchedule API operation for AWSDeadlineCloud.
//
// Updates the schedule for a worker.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWSDeadlineCloud's
// API operation UpdateWorkerSchedule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don't have permission to perform the action.
//
//   - InternalServerErrorException
//     Deadline Cloud can't process your request right now. Try again later.
//
//   - ResourceNotFoundException
//     The requested resource can't be found.
//
//   - ThrottlingException
//     Your request exceeded a request rate quota.
//
//   - ConflictException
//     Your request has conflicting operations. This can occur if you're trying
//     to perform more than one operation on the same resource at the same time.
//
//   - ValidationException
//     The request isn't valid. This can occur if your request contains malformed
//     JSON or unsupported characters.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/deadline-2023-10-12/UpdateWorkerSchedule
func (c *Deadline) UpdateWorkerSchedule(input *UpdateWorkerScheduleInput) (*UpdateWorkerScheduleOutput, error) {
	req, out := c.UpdateWorkerScheduleRequest(input)
	return out, req.Send()
}

// UpdateWorkerScheduleWithContext is the same as UpdateWorkerSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkerSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Deadline) UpdateWorkerScheduleWithContext(ctx aws.Context, input *UpdateWorkerScheduleInput, opts ...request.Option) (*UpdateWorkerScheduleOutput, error) {
	req, out := c.UpdateWorkerScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The range for the GPU fleet acceleration.
type AcceleratorCountRange struct {
	_ struct{} `type:"structure"`

	// The maximum GPU for the accelerator.
	Max *int64 `locationName:"max" type:"integer"`

	// The minimum GPU for the accelerator.
	//
	// Min is a required field
	Min *int64 `locationName:"min" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorCountRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorCountRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceleratorCountRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceleratorCountRange"}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *AcceleratorCountRange) SetMax(v int64) *AcceleratorCountRange {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AcceleratorCountRange) SetMin(v int64) *AcceleratorCountRange {
	s.Min = &v
	return s
}

// The range for memory, in MiB, to use for the accelerator.
type AcceleratorTotalMemoryMiBRange struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory to use for the accelerator, measured in MiB.
	Max *int64 `locationName:"max" type:"integer"`

	// The minimum amount of memory to use for the accelerator, measured in MiB.
	//
	// Min is a required field
	Min *int64 `locationName:"min" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorTotalMemoryMiBRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AcceleratorTotalMemoryMiBRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcceleratorTotalMemoryMiBRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AcceleratorTotalMemoryMiBRange"}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *AcceleratorTotalMemoryMiBRange) SetMax(v int64) *AcceleratorTotalMemoryMiBRange {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *AcceleratorTotalMemoryMiBRange) SetMin(v int64) *AcceleratorTotalMemoryMiBRange {
	s.Min = &v
	return s
}

// You don't have permission to perform the action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Information about the resources in use when the exception was thrown.
	Context map[string]*string `locationName:"context" type:"map"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The assigned starting environment for a worker during session.
type AssignedEnvironmentEnterSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The environment ID of the assigned environment at the start of a session.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedEnvironmentEnterSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedEnvironmentEnterSessionActionDefinition) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *AssignedEnvironmentEnterSessionActionDefinition) SetEnvironmentId(v string) *AssignedEnvironmentEnterSessionActionDefinition {
	s.EnvironmentId = &v
	return s
}

// The assigned environment when a worker exits a session.
type AssignedEnvironmentExitSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The environment ID of the assigned environment when exiting a session.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedEnvironmentExitSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedEnvironmentExitSessionActionDefinition) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *AssignedEnvironmentExitSessionActionDefinition) SetEnvironmentId(v string) *AssignedEnvironmentExitSessionActionDefinition {
	s.EnvironmentId = &v
	return s
}

// The assigned session for the worker.
type AssignedSession struct {
	_ struct{} `type:"structure"`

	// The job ID for the assigned session.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The log configuration for the worker's assigned session.
	//
	// LogConfiguration is a required field
	LogConfiguration *LogConfiguration `locationName:"logConfiguration" type:"structure" required:"true"`

	// The queue ID of the assigned session.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`

	// The session actions to apply to the assigned session.
	//
	// SessionActions is a required field
	SessionActions []*AssignedSessionAction `locationName:"sessionActions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSession) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSession) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *AssignedSession) SetJobId(v string) *AssignedSession {
	s.JobId = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *AssignedSession) SetLogConfiguration(v *LogConfiguration) *AssignedSession {
	s.LogConfiguration = v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssignedSession) SetQueueId(v string) *AssignedSession {
	s.QueueId = &v
	return s
}

// SetSessionActions sets the SessionActions field's value.
func (s *AssignedSession) SetSessionActions(v []*AssignedSessionAction) *AssignedSession {
	s.SessionActions = v
	return s
}

// The action for a session defined by the session action ID.
type AssignedSessionAction struct {
	_ struct{} `type:"structure"`

	// The definition of the assigned session action.
	//
	// Definition is a required field
	Definition *AssignedSessionActionDefinition `locationName:"definition" type:"structure" required:"true"`

	// The session action ID for the assigned session.
	//
	// SessionActionId is a required field
	SessionActionId *string `locationName:"sessionActionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSessionAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSessionAction) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *AssignedSessionAction) SetDefinition(v *AssignedSessionActionDefinition) *AssignedSessionAction {
	s.Definition = v
	return s
}

// SetSessionActionId sets the SessionActionId field's value.
func (s *AssignedSessionAction) SetSessionActionId(v string) *AssignedSessionAction {
	s.SessionActionId = &v
	return s
}

// The definition of the assigned session action.
type AssignedSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The environment a session starts on.
	EnvEnter *AssignedEnvironmentEnterSessionActionDefinition `locationName:"envEnter" type:"structure"`

	// The environment a session exits from.
	EnvExit *AssignedEnvironmentExitSessionActionDefinition `locationName:"envExit" type:"structure"`

	// The job attachment to sync with an assigned session action.
	SyncInputJobAttachments *AssignedSyncInputJobAttachmentsSessionActionDefinition `locationName:"syncInputJobAttachments" type:"structure"`

	// The task run.
	TaskRun *AssignedTaskRunSessionActionDefinition `locationName:"taskRun" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSessionActionDefinition) GoString() string {
	return s.String()
}

// SetEnvEnter sets the EnvEnter field's value.
func (s *AssignedSessionActionDefinition) SetEnvEnter(v *AssignedEnvironmentEnterSessionActionDefinition) *AssignedSessionActionDefinition {
	s.EnvEnter = v
	return s
}

// SetEnvExit sets the EnvExit field's value.
func (s *AssignedSessionActionDefinition) SetEnvExit(v *AssignedEnvironmentExitSessionActionDefinition) *AssignedSessionActionDefinition {
	s.EnvExit = v
	return s
}

// SetSyncInputJobAttachments sets the SyncInputJobAttachments field's value.
func (s *AssignedSessionActionDefinition) SetSyncInputJobAttachments(v *AssignedSyncInputJobAttachmentsSessionActionDefinition) *AssignedSessionActionDefinition {
	s.SyncInputJobAttachments = v
	return s
}

// SetTaskRun sets the TaskRun field's value.
func (s *AssignedSessionActionDefinition) SetTaskRun(v *AssignedTaskRunSessionActionDefinition) *AssignedSessionActionDefinition {
	s.TaskRun = v
	return s
}

// The details for an assigned session action as it relates to a job attachment.
type AssignedSyncInputJobAttachmentsSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The step ID.
	StepId *string `locationName:"stepId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSyncInputJobAttachmentsSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedSyncInputJobAttachmentsSessionActionDefinition) GoString() string {
	return s.String()
}

// SetStepId sets the StepId field's value.
func (s *AssignedSyncInputJobAttachmentsSessionActionDefinition) SetStepId(v string) *AssignedSyncInputJobAttachmentsSessionActionDefinition {
	s.StepId = &v
	return s
}

// The specific task, step, and parameters to include.
type AssignedTaskRunSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The parameters to include.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssignedTaskRunSessionActionDefinition's
	// String and GoString methods.
	//
	// Parameters is a required field
	Parameters map[string]*TaskParameterValue `locationName:"parameters" type:"map" required:"true" sensitive:"true"`

	// The step ID.
	//
	// StepId is a required field
	StepId *string `locationName:"stepId" type:"string" required:"true"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedTaskRunSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignedTaskRunSessionActionDefinition) GoString() string {
	return s.String()
}

// SetParameters sets the Parameters field's value.
func (s *AssignedTaskRunSessionActionDefinition) SetParameters(v map[string]*TaskParameterValue) *AssignedTaskRunSessionActionDefinition {
	s.Parameters = v
	return s
}

// SetStepId sets the StepId field's value.
func (s *AssignedTaskRunSessionActionDefinition) SetStepId(v string) *AssignedTaskRunSessionActionDefinition {
	s.StepId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *AssignedTaskRunSessionActionDefinition) SetTaskId(v string) *AssignedTaskRunSessionActionDefinition {
	s.TaskId = &v
	return s
}

type AssociateMemberToFarmInput struct {
	_ struct{} `type:"structure"`

	// The ID of the farm to associate with the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The identity store ID of the member to associate with the farm.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The principal's membership level for the associated farm.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The member's principal ID to associate with the farm.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The principal type of the member to associate with the farm.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToFarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToFarmInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MembershipLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipLevel"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssociateMemberToFarmInput) SetFarmId(v string) *AssociateMemberToFarmInput {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *AssociateMemberToFarmInput) SetIdentityStoreId(v string) *AssociateMemberToFarmInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *AssociateMemberToFarmInput) SetMembershipLevel(v string) *AssociateMemberToFarmInput {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AssociateMemberToFarmInput) SetPrincipalId(v string) *AssociateMemberToFarmInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AssociateMemberToFarmInput) SetPrincipalType(v string) *AssociateMemberToFarmInput {
	s.PrincipalType = &v
	return s
}

type AssociateMemberToFarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFarmOutput) GoString() string {
	return s.String()
}

type AssociateMemberToFleetInput struct {
	_ struct{} `type:"structure"`

	// The farm ID of the fleet to associate with the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The ID of the fleet to associate with a member.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The member's identity store ID to associate with the fleet.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The principal's membership level for the associated fleet.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The member's principal ID to associate with a fleet.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The member's principal type to associate with the fleet.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToFleetInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MembershipLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipLevel"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssociateMemberToFleetInput) SetFarmId(v string) *AssociateMemberToFleetInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *AssociateMemberToFleetInput) SetFleetId(v string) *AssociateMemberToFleetInput {
	s.FleetId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *AssociateMemberToFleetInput) SetIdentityStoreId(v string) *AssociateMemberToFleetInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *AssociateMemberToFleetInput) SetMembershipLevel(v string) *AssociateMemberToFleetInput {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AssociateMemberToFleetInput) SetPrincipalId(v string) *AssociateMemberToFleetInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AssociateMemberToFleetInput) SetPrincipalType(v string) *AssociateMemberToFleetInput {
	s.PrincipalType = &v
	return s
}

type AssociateMemberToFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToFleetOutput) GoString() string {
	return s.String()
}

type AssociateMemberToJobInput struct {
	_ struct{} `type:"structure"`

	// The farm ID of the job to associate with the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The member's identity store ID to associate with the job.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The job ID to associate with the member.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The principal's membership level for the associated job.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The member's principal ID to associate with the job.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The member's principal type to associate with the job.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`

	// The queue ID to associate to the member.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToJobInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MembershipLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipLevel"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssociateMemberToJobInput) SetFarmId(v string) *AssociateMemberToJobInput {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *AssociateMemberToJobInput) SetIdentityStoreId(v string) *AssociateMemberToJobInput {
	s.IdentityStoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *AssociateMemberToJobInput) SetJobId(v string) *AssociateMemberToJobInput {
	s.JobId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *AssociateMemberToJobInput) SetMembershipLevel(v string) *AssociateMemberToJobInput {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AssociateMemberToJobInput) SetPrincipalId(v string) *AssociateMemberToJobInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AssociateMemberToJobInput) SetPrincipalType(v string) *AssociateMemberToJobInput {
	s.PrincipalType = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssociateMemberToJobInput) SetQueueId(v string) *AssociateMemberToJobInput {
	s.QueueId = &v
	return s
}

type AssociateMemberToJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToJobOutput) GoString() string {
	return s.String()
}

type AssociateMemberToQueueInput struct {
	_ struct{} `type:"structure"`

	// The farm ID of the queue to associate with the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The member's identity store ID to associate with the queue.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The principal's membership level for the associated queue.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The member's principal ID to associate with the queue.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The member's principal type to associate with the queue.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`

	// The ID of the queue to associate to the member.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateMemberToQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateMemberToQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.IdentityStoreId == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityStoreId"))
	}
	if s.IdentityStoreId != nil && len(*s.IdentityStoreId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IdentityStoreId", 1))
	}
	if s.MembershipLevel == nil {
		invalidParams.Add(request.NewErrParamRequired("MembershipLevel"))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.PrincipalType == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalType"))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssociateMemberToQueueInput) SetFarmId(v string) *AssociateMemberToQueueInput {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *AssociateMemberToQueueInput) SetIdentityStoreId(v string) *AssociateMemberToQueueInput {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *AssociateMemberToQueueInput) SetMembershipLevel(v string) *AssociateMemberToQueueInput {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *AssociateMemberToQueueInput) SetPrincipalId(v string) *AssociateMemberToQueueInput {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *AssociateMemberToQueueInput) SetPrincipalType(v string) *AssociateMemberToQueueInput {
	s.PrincipalType = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssociateMemberToQueueInput) SetQueueId(v string) *AssociateMemberToQueueInput {
	s.QueueId = &v
	return s
}

type AssociateMemberToQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateMemberToQueueOutput) GoString() string {
	return s.String()
}

type AssumeFleetRoleForReadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the fleet's farm.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForReadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForReadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeFleetRoleForReadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeFleetRoleForReadInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssumeFleetRoleForReadInput) SetFarmId(v string) *AssumeFleetRoleForReadInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *AssumeFleetRoleForReadInput) SetFleetId(v string) *AssumeFleetRoleForReadInput {
	s.FleetId = &v
	return s
}

type AssumeFleetRoleForReadOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The credentials for the fleet role.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeFleetRoleForReadOutput's
	// String and GoString methods.
	//
	// Credentials is a required field
	Credentials *AwsCredentials `locationName:"credentials" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForReadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForReadOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeFleetRoleForReadOutput) SetCredentials(v *AwsCredentials) *AssumeFleetRoleForReadOutput {
	s.Credentials = v
	return s
}

type AssumeFleetRoleForWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the fleet's farm.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID that contains the worker.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The ID of the worker assuming the fleet role.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeFleetRoleForWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeFleetRoleForWorkerInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssumeFleetRoleForWorkerInput) SetFarmId(v string) *AssumeFleetRoleForWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *AssumeFleetRoleForWorkerInput) SetFleetId(v string) *AssumeFleetRoleForWorkerInput {
	s.FleetId = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *AssumeFleetRoleForWorkerInput) SetWorkerId(v string) *AssumeFleetRoleForWorkerInput {
	s.WorkerId = &v
	return s
}

type AssumeFleetRoleForWorkerOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The credentials for the worker.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeFleetRoleForWorkerOutput's
	// String and GoString methods.
	//
	// Credentials is a required field
	Credentials *AwsCredentials `locationName:"credentials" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeFleetRoleForWorkerOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeFleetRoleForWorkerOutput) SetCredentials(v *AwsCredentials) *AssumeFleetRoleForWorkerOutput {
	s.Credentials = v
	return s
}

type AssumeQueueRoleForReadInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm containing the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForReadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForReadInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeQueueRoleForReadInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeQueueRoleForReadInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssumeQueueRoleForReadInput) SetFarmId(v string) *AssumeQueueRoleForReadInput {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssumeQueueRoleForReadInput) SetQueueId(v string) *AssumeQueueRoleForReadInput {
	s.QueueId = &v
	return s
}

type AssumeQueueRoleForReadOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The credentials for the queue role.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeQueueRoleForReadOutput's
	// String and GoString methods.
	//
	// Credentials is a required field
	Credentials *AwsCredentials `locationName:"credentials" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForReadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForReadOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeQueueRoleForReadOutput) SetCredentials(v *AwsCredentials) *AssumeQueueRoleForReadOutput {
	s.Credentials = v
	return s
}

type AssumeQueueRoleForUserInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the queue that the user assumes the role for.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue ID of the queue that the user assumes the role for.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeQueueRoleForUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeQueueRoleForUserInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssumeQueueRoleForUserInput) SetFarmId(v string) *AssumeQueueRoleForUserInput {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssumeQueueRoleForUserInput) SetQueueId(v string) *AssumeQueueRoleForUserInput {
	s.QueueId = &v
	return s
}

type AssumeQueueRoleForUserOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The credentials for the queue role that a user has access to.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeQueueRoleForUserOutput's
	// String and GoString methods.
	//
	// Credentials is a required field
	Credentials *AwsCredentials `locationName:"credentials" type:"structure" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForUserOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeQueueRoleForUserOutput) SetCredentials(v *AwsCredentials) *AssumeQueueRoleForUserOutput {
	s.Credentials = v
	return s
}

type AssumeQueueRoleForWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the worker assuming the queue role.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the worker assuming the queue role.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The queue ID of the worker assuming the queue role.
	//
	// QueueId is a required field
	QueueId *string `location:"querystring" locationName:"queueId" type:"string" required:"true"`

	// The worker ID of the worker assuming the queue role.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssumeQueueRoleForWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssumeQueueRoleForWorkerInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *AssumeQueueRoleForWorkerInput) SetFarmId(v string) *AssumeQueueRoleForWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *AssumeQueueRoleForWorkerInput) SetFleetId(v string) *AssumeQueueRoleForWorkerInput {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssumeQueueRoleForWorkerInput) SetQueueId(v string) *AssumeQueueRoleForWorkerInput {
	s.QueueId = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *AssumeQueueRoleForWorkerInput) SetWorkerId(v string) *AssumeQueueRoleForWorkerInput {
	s.WorkerId = &v
	return s
}

type AssumeQueueRoleForWorkerOutput struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The Amazon Web Services credentials for the role that the worker is assuming.
	//
	// Credentials is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AssumeQueueRoleForWorkerOutput's
	// String and GoString methods.
	Credentials *AwsCredentials `locationName:"credentials" type:"structure" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssumeQueueRoleForWorkerOutput) GoString() string {
	return s.String()
}

// SetCredentials sets the Credentials field's value.
func (s *AssumeQueueRoleForWorkerOutput) SetCredentials(v *AwsCredentials) *AssumeQueueRoleForWorkerOutput {
	s.Credentials = v
	return s
}

// The attachments for jobs.
type Attachments struct {
	_ struct{} `type:"structure"`

	// The file system.
	FileSystem *string `locationName:"fileSystem" type:"string" enum:"JobAttachmentsFileSystem"`

	// A list of manifests which describe job attachment configurations.
	//
	// Manifests is a required field
	Manifests []*ManifestProperties `locationName:"manifests" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachments) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attachments) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Attachments) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Attachments"}
	if s.Manifests == nil {
		invalidParams.Add(request.NewErrParamRequired("Manifests"))
	}
	if s.Manifests != nil && len(s.Manifests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Manifests", 1))
	}
	if s.Manifests != nil {
		for i, v := range s.Manifests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Manifests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystem sets the FileSystem field's value.
func (s *Attachments) SetFileSystem(v string) *Attachments {
	s.FileSystem = &v
	return s
}

// SetManifests sets the Manifests field's value.
func (s *Attachments) SetManifests(v []*ManifestProperties) *Attachments {
	s.Manifests = v
	return s
}

// The Identity and Access Management credentials.
type AwsCredentials struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The IAM access key ID.
	//
	// AccessKeyId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AwsCredentials's
	// String and GoString methods.
	//
	// AccessKeyId is a required field
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true" sensitive:"true"`

	// The expiration date and time of the IAM credentials.
	//
	// Expiration is a required field
	Expiration *time.Time `locationName:"expiration" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The IAM secret access key.
	//
	// SecretAccessKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AwsCredentials's
	// String and GoString methods.
	//
	// SecretAccessKey is a required field
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true" sensitive:"true"`

	// The IAM session token
	//
	// SessionToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by AwsCredentials's
	// String and GoString methods.
	//
	// SessionToken is a required field
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsCredentials) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *AwsCredentials) SetAccessKeyId(v string) *AwsCredentials {
	s.AccessKeyId = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *AwsCredentials) SetExpiration(v time.Time) *AwsCredentials {
	s.Expiration = &v
	return s
}

// SetSecretAccessKey sets the SecretAccessKey field's value.
func (s *AwsCredentials) SetSecretAccessKey(v string) *AwsCredentials {
	s.SecretAccessKey = &v
	return s
}

// SetSessionToken sets the SessionToken field's value.
func (s *AwsCredentials) SetSessionToken(v string) *AwsCredentials {
	s.SessionToken = &v
	return s
}

type BatchGetJobEntityInput struct {
	_ struct{} `type:"structure"`

	// The farm ID of the worker that's fetching job details. The worker must have
	// an assignment on a job to fetch job details.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the worker that's fetching job details. The worker must have
	// an assignment on a job to fetch job details.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The job identifiers to include within the job entity batch details.
	//
	// Identifiers is a required field
	Identifiers []*JobEntityIdentifiersUnion `locationName:"identifiers" min:"1" type:"list" required:"true"`

	// The worker ID of the worker containing the job details to get.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobEntityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobEntityInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchGetJobEntityInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchGetJobEntityInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.Identifiers == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifiers"))
	}
	if s.Identifiers != nil && len(s.Identifiers) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifiers", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}
	if s.Identifiers != nil {
		for i, v := range s.Identifiers {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Identifiers", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *BatchGetJobEntityInput) SetFarmId(v string) *BatchGetJobEntityInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *BatchGetJobEntityInput) SetFleetId(v string) *BatchGetJobEntityInput {
	s.FleetId = &v
	return s
}

// SetIdentifiers sets the Identifiers field's value.
func (s *BatchGetJobEntityInput) SetIdentifiers(v []*JobEntityIdentifiersUnion) *BatchGetJobEntityInput {
	s.Identifiers = v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *BatchGetJobEntityInput) SetWorkerId(v string) *BatchGetJobEntityInput {
	s.WorkerId = &v
	return s
}

type BatchGetJobEntityOutput struct {
	_ struct{} `type:"structure"`

	// A list of the job entities, or details, in the batch.
	//
	// Entities is a required field
	Entities []*JobEntity `locationName:"entities" type:"list" required:"true"`

	// A list of errors from the job error logs for the batch.
	//
	// Errors is a required field
	Errors []*GetJobEntityError `locationName:"errors" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobEntityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchGetJobEntityOutput) GoString() string {
	return s.String()
}

// SetEntities sets the Entities field's value.
func (s *BatchGetJobEntityOutput) SetEntities(v []*JobEntity) *BatchGetJobEntityOutput {
	s.Entities = v
	return s
}

// SetErrors sets the Errors field's value.
func (s *BatchGetJobEntityOutput) SetErrors(v []*GetJobEntityError) *BatchGetJobEntityOutput {
	s.Errors = v
	return s
}

// The budget action to add.
type BudgetActionToAdd struct {
	_ struct{} `type:"structure"`

	// A description for the budget action to add.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BudgetActionToAdd's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The percentage threshold for the budget action to add.
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"float" required:"true"`

	// The type of budget action to add.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BudgetActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetActionToAdd) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetActionToAdd) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BudgetActionToAdd) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BudgetActionToAdd"}
	if s.ThresholdPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("ThresholdPercentage"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *BudgetActionToAdd) SetDescription(v string) *BudgetActionToAdd {
	s.Description = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *BudgetActionToAdd) SetThresholdPercentage(v float64) *BudgetActionToAdd {
	s.ThresholdPercentage = &v
	return s
}

// SetType sets the Type field's value.
func (s *BudgetActionToAdd) SetType(v string) *BudgetActionToAdd {
	s.Type = &v
	return s
}

// The budget action to remove.
type BudgetActionToRemove struct {
	_ struct{} `type:"structure"`

	// The percentage threshold for the budget action to remove.
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"float" required:"true"`

	// The type of budget action to remove.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BudgetActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetActionToRemove) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetActionToRemove) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BudgetActionToRemove) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BudgetActionToRemove"}
	if s.ThresholdPercentage == nil {
		invalidParams.Add(request.NewErrParamRequired("ThresholdPercentage"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *BudgetActionToRemove) SetThresholdPercentage(v float64) *BudgetActionToRemove {
	s.ThresholdPercentage = &v
	return s
}

// SetType sets the Type field's value.
func (s *BudgetActionToRemove) SetType(v string) *BudgetActionToRemove {
	s.Type = &v
	return s
}

// The start and end time of the budget.
type BudgetSchedule struct {
	_ struct{} `type:"structure"`

	// The fixed start and end time of the budget's schedule.
	Fixed *FixedBudgetSchedule `locationName:"fixed" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BudgetSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BudgetSchedule"}
	if s.Fixed != nil {
		if err := s.Fixed.Validate(); err != nil {
			invalidParams.AddNested("Fixed", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFixed sets the Fixed field's value.
func (s *BudgetSchedule) SetFixed(v *FixedBudgetSchedule) *BudgetSchedule {
	s.Fixed = v
	return s
}

// The budget summary.
type BudgetSummary struct {
	_ struct{} `type:"structure"`

	// The approximate dollar limit of the budget.
	//
	// ApproximateDollarLimit is a required field
	ApproximateDollarLimit *float64 `locationName:"approximateDollarLimit" min:"0.01" type:"float" required:"true"`

	// The budget ID.
	//
	// BudgetId is a required field
	BudgetId *string `locationName:"budgetId" type:"string" required:"true"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the budget summary.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by BudgetSummary's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the budget summary to update.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The status of the budget.
	//
	//    * ACTIVE–The budget is being evaluated.
	//
	//    * INACTIVE–The budget is inactive. This can include Expired, Canceled,
	//    or deleted Deleted statuses.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"BudgetStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The resource used to track expenditure in the budget.
	//
	// UsageTrackingResource is a required field
	UsageTrackingResource *UsageTrackingResource `locationName:"usageTrackingResource" type:"structure" required:"true"`

	// The consumed usage for the budget.
	//
	// Usages is a required field
	Usages *ConsumedUsages `locationName:"usages" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BudgetSummary) GoString() string {
	return s.String()
}

// SetApproximateDollarLimit sets the ApproximateDollarLimit field's value.
func (s *BudgetSummary) SetApproximateDollarLimit(v float64) *BudgetSummary {
	s.ApproximateDollarLimit = &v
	return s
}

// SetBudgetId sets the BudgetId field's value.
func (s *BudgetSummary) SetBudgetId(v string) *BudgetSummary {
	s.BudgetId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *BudgetSummary) SetCreatedAt(v time.Time) *BudgetSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *BudgetSummary) SetCreatedBy(v string) *BudgetSummary {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *BudgetSummary) SetDescription(v string) *BudgetSummary {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *BudgetSummary) SetDisplayName(v string) *BudgetSummary {
	s.DisplayName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BudgetSummary) SetStatus(v string) *BudgetSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *BudgetSummary) SetUpdatedAt(v time.Time) *BudgetSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *BudgetSummary) SetUpdatedBy(v string) *BudgetSummary {
	s.UpdatedBy = &v
	return s
}

// SetUsageTrackingResource sets the UsageTrackingResource field's value.
func (s *BudgetSummary) SetUsageTrackingResource(v *UsageTrackingResource) *BudgetSummary {
	s.UsageTrackingResource = v
	return s
}

// SetUsages sets the Usages field's value.
func (s *BudgetSummary) SetUsages(v *ConsumedUsages) *BudgetSummary {
	s.Usages = v
	return s
}

// Your request has conflicting operations. This can occur if you're trying
// to perform more than one operation on the same resource at the same time.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Information about the resources in use when the exception was thrown.
	Context map[string]*string `locationName:"context" type:"map"`

	Message_ *string `locationName:"message" type:"string"`

	// A description of the error.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ConflictExceptionReason"`

	// The identifier of the resource in use.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource in use.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The consumed usage for the resource.
type ConsumedUsages struct {
	_ struct{} `type:"structure"`

	// The amount of the budget consumed.
	//
	// ApproximateDollarUsage is a required field
	ApproximateDollarUsage *float64 `locationName:"approximateDollarUsage" type:"float" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsumedUsages) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConsumedUsages) GoString() string {
	return s.String()
}

// SetApproximateDollarUsage sets the ApproximateDollarUsage field's value.
func (s *ConsumedUsages) SetApproximateDollarUsage(v float64) *ConsumedUsages {
	s.ApproximateDollarUsage = &v
	return s
}

type CopyJobTemplateInput struct {
	_ struct{} `type:"structure"`

	// The farm ID to copy.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID to copy.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID to copy.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The Amazon S3 bucket name and key where you would like to add a copy of the
	// job template.
	//
	// TargetS3Location is a required field
	TargetS3Location *S3Location `locationName:"targetS3Location" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyJobTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyJobTemplateInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.TargetS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetS3Location"))
	}
	if s.TargetS3Location != nil {
		if err := s.TargetS3Location.Validate(); err != nil {
			invalidParams.AddNested("TargetS3Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *CopyJobTemplateInput) SetFarmId(v string) *CopyJobTemplateInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *CopyJobTemplateInput) SetJobId(v string) *CopyJobTemplateInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *CopyJobTemplateInput) SetQueueId(v string) *CopyJobTemplateInput {
	s.QueueId = &v
	return s
}

// SetTargetS3Location sets the TargetS3Location field's value.
func (s *CopyJobTemplateInput) SetTargetS3Location(v *S3Location) *CopyJobTemplateInput {
	s.TargetS3Location = v
	return s
}

type CopyJobTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The format of the job template, either JSON or YAML.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"JobTemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobTemplateOutput) GoString() string {
	return s.String()
}

// SetTemplateType sets the TemplateType field's value.
func (s *CopyJobTemplateOutput) SetTemplateType(v string) *CopyJobTemplateOutput {
	s.TemplateType = &v
	return s
}

type CreateBudgetInput struct {
	_ struct{} `type:"structure"`

	// The budget actions to specify what happens when the budget runs out.
	//
	// Actions is a required field
	Actions []*BudgetActionToAdd `locationName:"actions" type:"list" required:"true"`

	// The dollar limit based on consumed usage.
	//
	// ApproximateDollarLimit is a required field
	ApproximateDollarLimit *float64 `locationName:"approximateDollarLimit" min:"0.01" type:"float" required:"true"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the budget.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBudgetInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the budget.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID to include in this budget.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The schedule to associate with this budget.
	//
	// Schedule is a required field
	Schedule *BudgetSchedule `locationName:"schedule" type:"structure" required:"true"`

	// The queue ID provided to this budget to track usage.
	//
	// UsageTrackingResource is a required field
	UsageTrackingResource *UsageTrackingResource `locationName:"usageTrackingResource" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBudgetInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.ApproximateDollarLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("ApproximateDollarLimit"))
	}
	if s.ApproximateDollarLimit != nil && *s.ApproximateDollarLimit < 0.01 {
		invalidParams.Add(request.NewErrParamMinValue("ApproximateDollarLimit", 0.01))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.UsageTrackingResource == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageTrackingResource"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateBudgetInput) SetActions(v []*BudgetActionToAdd) *CreateBudgetInput {
	s.Actions = v
	return s
}

// SetApproximateDollarLimit sets the ApproximateDollarLimit field's value.
func (s *CreateBudgetInput) SetApproximateDollarLimit(v float64) *CreateBudgetInput {
	s.ApproximateDollarLimit = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateBudgetInput) SetClientToken(v string) *CreateBudgetInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBudgetInput) SetDescription(v string) *CreateBudgetInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateBudgetInput) SetDisplayName(v string) *CreateBudgetInput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateBudgetInput) SetFarmId(v string) *CreateBudgetInput {
	s.FarmId = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateBudgetInput) SetSchedule(v *BudgetSchedule) *CreateBudgetInput {
	s.Schedule = v
	return s
}

// SetUsageTrackingResource sets the UsageTrackingResource field's value.
func (s *CreateBudgetInput) SetUsageTrackingResource(v *UsageTrackingResource) *CreateBudgetInput {
	s.UsageTrackingResource = v
	return s
}

type CreateBudgetOutput struct {
	_ struct{} `type:"structure"`

	// The budget ID.
	//
	// BudgetId is a required field
	BudgetId *string `locationName:"budgetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBudgetOutput) GoString() string {
	return s.String()
}

// SetBudgetId sets the BudgetId field's value.
func (s *CreateBudgetOutput) SetBudgetId(v string) *CreateBudgetOutput {
	s.BudgetId = &v
	return s
}

type CreateFarmInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the farm.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFarmInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the farm.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The ARN of the KMS key to use on the farm.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The tags to add to your farm. Each tag consists of a tag key and a tag value.
	// Tag keys and values are both required, but tag values can be empty strings.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFarmInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFarmInput) SetClientToken(v string) *CreateFarmInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFarmInput) SetDescription(v string) *CreateFarmInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFarmInput) SetDisplayName(v string) *CreateFarmInput {
	s.DisplayName = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *CreateFarmInput) SetKmsKeyArn(v string) *CreateFarmInput {
	s.KmsKeyArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFarmInput) SetTags(v map[string]*string) *CreateFarmInput {
	s.Tags = v
	return s
}

type CreateFarmOutput struct {
	_ struct{} `type:"structure"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFarmOutput) GoString() string {
	return s.String()
}

// SetFarmId sets the FarmId field's value.
func (s *CreateFarmOutput) SetFarmId(v string) *CreateFarmOutput {
	s.FarmId = &v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The configuration settings for the fleet. Customer managed fleets are self-managed.
	// Service managed Amazon EC2 fleets are managed by Deadline Cloud.
	//
	// Configuration is a required field
	Configuration *FleetConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The description of the fleet.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateFleetInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the fleet.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID of the farm to connect to the fleet.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of workers for the fleet.
	//
	// MaxWorkerCount is a required field
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" type:"integer" required:"true"`

	// The minimum number of workers for the fleet.
	MinWorkerCount *int64 `locationName:"minWorkerCount" type:"integer"`

	// The IAM role ARN for the role that the fleet's workers will use.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Each tag consists of a tag key and a tag value. Tag keys and values are both
	// required, but tag values can be empty strings.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("Configuration"))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxWorkerCount == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxWorkerCount"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Configuration != nil {
		if err := s.Configuration.Validate(); err != nil {
			invalidParams.AddNested("Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateFleetInput) SetClientToken(v string) *CreateFleetInput {
	s.ClientToken = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *CreateFleetInput) SetConfiguration(v *FleetConfiguration) *CreateFleetInput {
	s.Configuration = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateFleetInput) SetDescription(v string) *CreateFleetInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateFleetInput) SetDisplayName(v string) *CreateFleetInput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateFleetInput) SetFarmId(v string) *CreateFleetInput {
	s.FarmId = &v
	return s
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *CreateFleetInput) SetMaxWorkerCount(v int64) *CreateFleetInput {
	s.MaxWorkerCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *CreateFleetInput) SetMinWorkerCount(v int64) *CreateFleetInput {
	s.MinWorkerCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateFleetInput) SetRoleArn(v string) *CreateFleetInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v map[string]*string) *CreateFleetInput {
	s.Tags = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetFleetId sets the FleetId field's value.
func (s *CreateFleetOutput) SetFleetId(v string) *CreateFleetOutput {
	s.FleetId = &v
	return s
}

type CreateJobInput struct {
	_ struct{} `type:"structure"`

	// The attachments for the job. Attach files required for the job to run to
	// a render job.
	Attachments *Attachments `locationName:"attachments" type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The farm ID of the farm to connect to the job.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The number of task failures before the job stops running and is marked as
	// FAILED.
	MaxFailedTasksCount *int64 `locationName:"maxFailedTasksCount" type:"integer"`

	// The maximum number of retries for a job.
	MaxRetriesPerTask *int64 `locationName:"maxRetriesPerTask" type:"integer"`

	// The parameters for the job.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateJobInput's
	// String and GoString methods.
	Parameters map[string]*JobParameter `locationName:"parameters" type:"map" sensitive:"true"`

	// The priority of the job on a scale of 1 to 100. The highest priority is 1.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The ID of the queue that the job is submitted to.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The storage profile ID for the storage profile to connect to the job.
	StorageProfileId *string `locationName:"storageProfileId" type:"string"`

	// The initial status of the job's tasks when they are created. Tasks that are
	// created with a SUSPENDED status will not run until you update their status.
	TargetTaskRunStatus *string `locationName:"targetTaskRunStatus" type:"string" enum:"CreateJobTargetTaskRunStatus"`

	// The job template to use for this job.
	//
	// Template is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateJobInput's
	// String and GoString methods.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true" sensitive:"true"`

	// The file type for the job template.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"JobTemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateJobInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}
	if s.Attachments != nil {
		if err := s.Attachments.Validate(); err != nil {
			invalidParams.AddNested("Attachments", err.(request.ErrInvalidParams))
		}
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttachments sets the Attachments field's value.
func (s *CreateJobInput) SetAttachments(v *Attachments) *CreateJobInput {
	s.Attachments = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateJobInput) SetClientToken(v string) *CreateJobInput {
	s.ClientToken = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateJobInput) SetFarmId(v string) *CreateJobInput {
	s.FarmId = &v
	return s
}

// SetMaxFailedTasksCount sets the MaxFailedTasksCount field's value.
func (s *CreateJobInput) SetMaxFailedTasksCount(v int64) *CreateJobInput {
	s.MaxFailedTasksCount = &v
	return s
}

// SetMaxRetriesPerTask sets the MaxRetriesPerTask field's value.
func (s *CreateJobInput) SetMaxRetriesPerTask(v int64) *CreateJobInput {
	s.MaxRetriesPerTask = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *CreateJobInput) SetParameters(v map[string]*JobParameter) *CreateJobInput {
	s.Parameters = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateJobInput) SetPriority(v int64) *CreateJobInput {
	s.Priority = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *CreateJobInput) SetQueueId(v string) *CreateJobInput {
	s.QueueId = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *CreateJobInput) SetStorageProfileId(v string) *CreateJobInput {
	s.StorageProfileId = &v
	return s
}

// SetTargetTaskRunStatus sets the TargetTaskRunStatus field's value.
func (s *CreateJobInput) SetTargetTaskRunStatus(v string) *CreateJobInput {
	s.TargetTaskRunStatus = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *CreateJobInput) SetTemplate(v string) *CreateJobInput {
	s.Template = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *CreateJobInput) SetTemplateType(v string) *CreateJobInput {
	s.TemplateType = &v
	return s
}

type CreateJobOutput struct {
	_ struct{} `type:"structure"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateJobOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *CreateJobOutput) SetJobId(v string) *CreateJobOutput {
	s.JobId = &v
	return s
}

type CreateLicenseEndpointInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The security group IDs.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list" required:"true"`

	// The subnet IDs.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list" required:"true"`

	// Each tag consists of a tag key and a tag value. Tag keys and values are both
	// required, but tag values can be empty strings.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The VPC (virtual private cloud) ID to use with the license endpoint.
	//
	// VpcId is a required field
	VpcId *string `locationName:"vpcId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLicenseEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLicenseEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLicenseEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLicenseEndpointInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}
	if s.VpcId != nil && len(*s.VpcId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateLicenseEndpointInput) SetClientToken(v string) *CreateLicenseEndpointInput {
	s.ClientToken = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateLicenseEndpointInput) SetSecurityGroupIds(v []*string) *CreateLicenseEndpointInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateLicenseEndpointInput) SetSubnetIds(v []*string) *CreateLicenseEndpointInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLicenseEndpointInput) SetTags(v map[string]*string) *CreateLicenseEndpointInput {
	s.Tags = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateLicenseEndpointInput) SetVpcId(v string) *CreateLicenseEndpointInput {
	s.VpcId = &v
	return s
}

type CreateLicenseEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The license endpoint ID.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `locationName:"licenseEndpointId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLicenseEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLicenseEndpointOutput) GoString() string {
	return s.String()
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *CreateLicenseEndpointOutput) SetLicenseEndpointId(v string) *CreateLicenseEndpointOutput {
	s.LicenseEndpointId = &v
	return s
}

type CreateMonitorInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The name that you give the monitor that is displayed in the Deadline Cloud
	// console.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance that authenticates
	// monitor users.
	//
	// IdentityCenterInstanceArn is a required field
	IdentityCenterInstanceArn *string `locationName:"identityCenterInstanceArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that the monitor uses to connect
	// to Deadline Cloud. Every user that signs in to the monitor using IAM Identity
	// Center uses this role to access Deadline Cloud resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The subdomain to use when creating the monitor URL. The full URL of the monitor
	// is subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// Subdomain is a required field
	Subdomain *string `locationName:"subdomain" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateMonitorInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.IdentityCenterInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityCenterInstanceArn"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Subdomain == nil {
		invalidParams.Add(request.NewErrParamRequired("Subdomain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateMonitorInput) SetClientToken(v string) *CreateMonitorInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateMonitorInput) SetDisplayName(v string) *CreateMonitorInput {
	s.DisplayName = &v
	return s
}

// SetIdentityCenterInstanceArn sets the IdentityCenterInstanceArn field's value.
func (s *CreateMonitorInput) SetIdentityCenterInstanceArn(v string) *CreateMonitorInput {
	s.IdentityCenterInstanceArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateMonitorInput) SetRoleArn(v string) *CreateMonitorInput {
	s.RoleArn = &v
	return s
}

// SetSubdomain sets the Subdomain field's value.
func (s *CreateMonitorInput) SetSubdomain(v string) *CreateMonitorInput {
	s.Subdomain = &v
	return s
}

type CreateMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that IAM Identity Center assigns to the monitor.
	//
	// IdentityCenterApplicationArn is a required field
	IdentityCenterApplicationArn *string `locationName:"identityCenterApplicationArn" type:"string" required:"true"`

	// The unique identifier of the monitor.
	//
	// MonitorId is a required field
	MonitorId *string `locationName:"monitorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateMonitorOutput) GoString() string {
	return s.String()
}

// SetIdentityCenterApplicationArn sets the IdentityCenterApplicationArn field's value.
func (s *CreateMonitorOutput) SetIdentityCenterApplicationArn(v string) *CreateMonitorOutput {
	s.IdentityCenterApplicationArn = &v
	return s
}

// SetMonitorId sets the MonitorId field's value.
func (s *CreateMonitorOutput) SetMonitorId(v string) *CreateMonitorOutput {
	s.MonitorId = &v
	return s
}

type CreateQueueEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The farm ID of the farm to connect to the environment.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// Sets the priority of the environments in the queue from 0 to 10,000, where
	// 0 is the highest priority. If two environments share the same priority value,
	// the environment created first takes higher priority.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The queue ID to connect the queue and environment.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The environment template to use in the queue.
	//
	// Template is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateQueueEnvironmentInput's
	// String and GoString methods.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true" sensitive:"true"`

	// The template's file type, JSON or YAML.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"EnvironmentTemplateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueEnvironmentInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}
	if s.TemplateType == nil {
		invalidParams.Add(request.NewErrParamRequired("TemplateType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateQueueEnvironmentInput) SetClientToken(v string) *CreateQueueEnvironmentInput {
	s.ClientToken = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateQueueEnvironmentInput) SetFarmId(v string) *CreateQueueEnvironmentInput {
	s.FarmId = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *CreateQueueEnvironmentInput) SetPriority(v int64) *CreateQueueEnvironmentInput {
	s.Priority = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *CreateQueueEnvironmentInput) SetQueueId(v string) *CreateQueueEnvironmentInput {
	s.QueueId = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *CreateQueueEnvironmentInput) SetTemplate(v string) *CreateQueueEnvironmentInput {
	s.Template = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *CreateQueueEnvironmentInput) SetTemplateType(v string) *CreateQueueEnvironmentInput {
	s.TemplateType = &v
	return s
}

type CreateQueueEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The queue environment ID.
	//
	// QueueEnvironmentId is a required field
	QueueEnvironmentId *string `locationName:"queueEnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueEnvironmentOutput) GoString() string {
	return s.String()
}

// SetQueueEnvironmentId sets the QueueEnvironmentId field's value.
func (s *CreateQueueEnvironmentOutput) SetQueueEnvironmentId(v string) *CreateQueueEnvironmentOutput {
	s.QueueEnvironmentId = &v
	return s
}

type CreateQueueFleetAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the farm that the queue and fleet belong to.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueFleetAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueFleetAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueFleetAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueFleetAssociationInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *CreateQueueFleetAssociationInput) SetFarmId(v string) *CreateQueueFleetAssociationInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateQueueFleetAssociationInput) SetFleetId(v string) *CreateQueueFleetAssociationInput {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *CreateQueueFleetAssociationInput) SetQueueId(v string) *CreateQueueFleetAssociationInput {
	s.QueueId = &v
	return s
}

type CreateQueueFleetAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueFleetAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueFleetAssociationOutput) GoString() string {
	return s.String()
}

type CreateQueueInput struct {
	_ struct{} `type:"structure"`

	// The storage profile IDs to include in the queue.
	AllowedStorageProfileIds []*string `locationName:"allowedStorageProfileIds" type:"list"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The default action to take on a queue if a budget isn't configured.
	DefaultBudgetAction *string `locationName:"defaultBudgetAction" type:"string" enum:"DefaultQueueBudgetAction"`

	// The description of the queue.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateQueueInput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the queue.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID of the farm to connect to the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job attachment settings for the queue. These are the Amazon S3 bucket
	// name and the Amazon S3 prefix.
	JobAttachmentSettings *JobAttachmentSettings `locationName:"jobAttachmentSettings" type:"structure"`

	// The jobs in the queue run as the specified POSIX user.
	JobRunAsUser *JobRunAsUser `locationName:"jobRunAsUser" type:"structure"`

	// The file system location name to include in the queue.
	RequiredFileSystemLocationNames []*string `locationName:"requiredFileSystemLocationNames" type:"list"`

	// The IAM role ARN that workers will use while running jobs for this queue.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// Each tag consists of a tag key and a tag value. Tag keys and values are both
	// required, but tag values can be empty strings.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobAttachmentSettings != nil {
		if err := s.JobAttachmentSettings.Validate(); err != nil {
			invalidParams.AddNested("JobAttachmentSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.JobRunAsUser != nil {
		if err := s.JobRunAsUser.Validate(); err != nil {
			invalidParams.AddNested("JobRunAsUser", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedStorageProfileIds sets the AllowedStorageProfileIds field's value.
func (s *CreateQueueInput) SetAllowedStorageProfileIds(v []*string) *CreateQueueInput {
	s.AllowedStorageProfileIds = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateQueueInput) SetClientToken(v string) *CreateQueueInput {
	s.ClientToken = &v
	return s
}

// SetDefaultBudgetAction sets the DefaultBudgetAction field's value.
func (s *CreateQueueInput) SetDefaultBudgetAction(v string) *CreateQueueInput {
	s.DefaultBudgetAction = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateQueueInput) SetDescription(v string) *CreateQueueInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateQueueInput) SetDisplayName(v string) *CreateQueueInput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateQueueInput) SetFarmId(v string) *CreateQueueInput {
	s.FarmId = &v
	return s
}

// SetJobAttachmentSettings sets the JobAttachmentSettings field's value.
func (s *CreateQueueInput) SetJobAttachmentSettings(v *JobAttachmentSettings) *CreateQueueInput {
	s.JobAttachmentSettings = v
	return s
}

// SetJobRunAsUser sets the JobRunAsUser field's value.
func (s *CreateQueueInput) SetJobRunAsUser(v *JobRunAsUser) *CreateQueueInput {
	s.JobRunAsUser = v
	return s
}

// SetRequiredFileSystemLocationNames sets the RequiredFileSystemLocationNames field's value.
func (s *CreateQueueInput) SetRequiredFileSystemLocationNames(v []*string) *CreateQueueInput {
	s.RequiredFileSystemLocationNames = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateQueueInput) SetRoleArn(v string) *CreateQueueInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQueueInput) SetTags(v map[string]*string) *CreateQueueInput {
	s.Tags = v
	return s
}

type CreateQueueOutput struct {
	_ struct{} `type:"structure"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) GoString() string {
	return s.String()
}

// SetQueueId sets the QueueId field's value.
func (s *CreateQueueOutput) SetQueueId(v string) *CreateQueueOutput {
	s.QueueId = &v
	return s
}

type CreateStorageProfileInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The display name of the storage profile.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID of the farm to connect to the storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// File system paths to include in the storage profile.
	FileSystemLocations []*FileSystemLocation `locationName:"fileSystemLocations" type:"list"`

	// The type of operating system (OS) for the storage profile.
	//
	// OsFamily is a required field
	OsFamily *string `locationName:"osFamily" type:"string" required:"true" enum:"StorageProfileOperatingSystemFamily"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStorageProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStorageProfileInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.DisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("DisplayName"))
	}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.OsFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("OsFamily"))
	}
	if s.FileSystemLocations != nil {
		for i, v := range s.FileSystemLocations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FileSystemLocations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateStorageProfileInput) SetClientToken(v string) *CreateStorageProfileInput {
	s.ClientToken = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateStorageProfileInput) SetDisplayName(v string) *CreateStorageProfileInput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateStorageProfileInput) SetFarmId(v string) *CreateStorageProfileInput {
	s.FarmId = &v
	return s
}

// SetFileSystemLocations sets the FileSystemLocations field's value.
func (s *CreateStorageProfileInput) SetFileSystemLocations(v []*FileSystemLocation) *CreateStorageProfileInput {
	s.FileSystemLocations = v
	return s
}

// SetOsFamily sets the OsFamily field's value.
func (s *CreateStorageProfileInput) SetOsFamily(v string) *CreateStorageProfileInput {
	s.OsFamily = &v
	return s
}

type CreateStorageProfileOutput struct {
	_ struct{} `type:"structure"`

	// The storage profile ID.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `locationName:"storageProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStorageProfileOutput) GoString() string {
	return s.String()
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *CreateStorageProfileOutput) SetStorageProfileId(v string) *CreateStorageProfileOutput {
	s.StorageProfileId = &v
	return s
}

type CreateWorkerInput struct {
	_ struct{} `type:"structure"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The farm ID of the farm to connect to the worker.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID to connect to the worker.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The IP address and host name of the worker.
	HostProperties *HostPropertiesRequest `locationName:"hostProperties" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkerInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkerInput) SetClientToken(v string) *CreateWorkerInput {
	s.ClientToken = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *CreateWorkerInput) SetFarmId(v string) *CreateWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *CreateWorkerInput) SetFleetId(v string) *CreateWorkerInput {
	s.FleetId = &v
	return s
}

// SetHostProperties sets the HostProperties field's value.
func (s *CreateWorkerInput) SetHostProperties(v *HostPropertiesRequest) *CreateWorkerInput {
	s.HostProperties = v
	return s
}

type CreateWorkerOutput struct {
	_ struct{} `type:"structure"`

	// The worker ID.
	//
	// WorkerId is a required field
	WorkerId *string `locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkerOutput) GoString() string {
	return s.String()
}

// SetWorkerId sets the WorkerId field's value.
func (s *CreateWorkerOutput) SetWorkerId(v string) *CreateWorkerOutput {
	s.WorkerId = &v
	return s
}

// The details of a customer managed fleet configuration.
type CustomerManagedFleetConfiguration struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling mode for the customer managed fleet configuration.
	//
	// Mode is a required field
	Mode *string `locationName:"mode" type:"string" required:"true" enum:"AutoScalingMode"`

	// The storage profile ID.
	StorageProfileId *string `locationName:"storageProfileId" type:"string"`

	// The worker capabilities for a customer managed fleet configuration.
	//
	// WorkerCapabilities is a required field
	WorkerCapabilities *CustomerManagedWorkerCapabilities `locationName:"workerCapabilities" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedFleetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedFleetConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedFleetConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomerManagedFleetConfiguration"}
	if s.Mode == nil {
		invalidParams.Add(request.NewErrParamRequired("Mode"))
	}
	if s.WorkerCapabilities == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerCapabilities"))
	}
	if s.WorkerCapabilities != nil {
		if err := s.WorkerCapabilities.Validate(); err != nil {
			invalidParams.AddNested("WorkerCapabilities", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMode sets the Mode field's value.
func (s *CustomerManagedFleetConfiguration) SetMode(v string) *CustomerManagedFleetConfiguration {
	s.Mode = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *CustomerManagedFleetConfiguration) SetStorageProfileId(v string) *CustomerManagedFleetConfiguration {
	s.StorageProfileId = &v
	return s
}

// SetWorkerCapabilities sets the WorkerCapabilities field's value.
func (s *CustomerManagedFleetConfiguration) SetWorkerCapabilities(v *CustomerManagedWorkerCapabilities) *CustomerManagedFleetConfiguration {
	s.WorkerCapabilities = v
	return s
}

// The worker capabilities for a customer managed workflow.
type CustomerManagedWorkerCapabilities struct {
	_ struct{} `type:"structure"`

	// The range of the accelerator.
	AcceleratorCount *AcceleratorCountRange `locationName:"acceleratorCount" type:"structure"`

	// The total memory (MiB) for the customer managed worker capabilities.
	AcceleratorTotalMemoryMiB *AcceleratorTotalMemoryMiBRange `locationName:"acceleratorTotalMemoryMiB" type:"structure"`

	// The accelerator types for the customer managed worker capabilities.
	AcceleratorTypes []*string `locationName:"acceleratorTypes" type:"list" enum:"AcceleratorType"`

	// The CPU architecture type for the customer managed worker capabilities.
	//
	// CpuArchitectureType is a required field
	CpuArchitectureType *string `locationName:"cpuArchitectureType" type:"string" required:"true" enum:"CpuArchitectureType"`

	// Custom requirement ranges for customer managed worker capabilities.
	CustomAmounts []*FleetAmountCapability `locationName:"customAmounts" min:"1" type:"list"`

	// Custom attributes for the customer manged worker capabilities.
	CustomAttributes []*FleetAttributeCapability `locationName:"customAttributes" min:"1" type:"list"`

	// The memory (MiB).
	//
	// MemoryMiB is a required field
	MemoryMiB *MemoryMiBRange `locationName:"memoryMiB" type:"structure" required:"true"`

	// The operating system (OS) family.
	//
	// OsFamily is a required field
	OsFamily *string `locationName:"osFamily" type:"string" required:"true" enum:"CustomerManagedFleetOperatingSystemFamily"`

	// The vCPU count for the customer manged worker capabilities.
	//
	// VCpuCount is a required field
	VCpuCount *VCpuCountRange `locationName:"vCpuCount" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedWorkerCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CustomerManagedWorkerCapabilities) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CustomerManagedWorkerCapabilities) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CustomerManagedWorkerCapabilities"}
	if s.CpuArchitectureType == nil {
		invalidParams.Add(request.NewErrParamRequired("CpuArchitectureType"))
	}
	if s.CustomAmounts != nil && len(s.CustomAmounts) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAmounts", 1))
	}
	if s.CustomAttributes != nil && len(s.CustomAttributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomAttributes", 1))
	}
	if s.MemoryMiB == nil {
		invalidParams.Add(request.NewErrParamRequired("MemoryMiB"))
	}
	if s.OsFamily == nil {
		invalidParams.Add(request.NewErrParamRequired("OsFamily"))
	}
	if s.VCpuCount == nil {
		invalidParams.Add(request.NewErrParamRequired("VCpuCount"))
	}
	if s.AcceleratorCount != nil {
		if err := s.AcceleratorCount.Validate(); err != nil {
			invalidParams.AddNested("AcceleratorCount", err.(request.ErrInvalidParams))
		}
	}
	if s.AcceleratorTotalMemoryMiB != nil {
		if err := s.AcceleratorTotalMemoryMiB.Validate(); err != nil {
			invalidParams.AddNested("AcceleratorTotalMemoryMiB", err.(request.ErrInvalidParams))
		}
	}
	if s.CustomAmounts != nil {
		for i, v := range s.CustomAmounts {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAmounts", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.CustomAttributes != nil {
		for i, v := range s.CustomAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CustomAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MemoryMiB != nil {
		if err := s.MemoryMiB.Validate(); err != nil {
			invalidParams.AddNested("MemoryMiB", err.(request.ErrInvalidParams))
		}
	}
	if s.VCpuCount != nil {
		if err := s.VCpuCount.Validate(); err != nil {
			invalidParams.AddNested("VCpuCount", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAcceleratorCount sets the AcceleratorCount field's value.
func (s *CustomerManagedWorkerCapabilities) SetAcceleratorCount(v *AcceleratorCountRange) *CustomerManagedWorkerCapabilities {
	s.AcceleratorCount = v
	return s
}

// SetAcceleratorTotalMemoryMiB sets the AcceleratorTotalMemoryMiB field's value.
func (s *CustomerManagedWorkerCapabilities) SetAcceleratorTotalMemoryMiB(v *AcceleratorTotalMemoryMiBRange) *CustomerManagedWorkerCapabilities {
	s.AcceleratorTotalMemoryMiB = v
	return s
}

// SetAcceleratorTypes sets the AcceleratorTypes field's value.
func (s *CustomerManagedWorkerCapabilities) SetAcceleratorTypes(v []*string) *CustomerManagedWorkerCapabilities {
	s.AcceleratorTypes = v
	return s
}

// SetCpuArchitectureType sets the CpuArchitectureType field's value.
func (s *CustomerManagedWorkerCapabilities) SetCpuArchitectureType(v string) *CustomerManagedWorkerCapabilities {
	s.CpuArchitectureType = &v
	return s
}

// SetCustomAmounts sets the CustomAmounts field's value.
func (s *CustomerManagedWorkerCapabilities) SetCustomAmounts(v []*FleetAmountCapability) *CustomerManagedWorkerCapabilities {
	s.CustomAmounts = v
	return s
}

// SetCustomAttributes sets the CustomAttributes field's value.
func (s *CustomerManagedWorkerCapabilities) SetCustomAttributes(v []*FleetAttributeCapability) *CustomerManagedWorkerCapabilities {
	s.CustomAttributes = v
	return s
}

// SetMemoryMiB sets the MemoryMiB field's value.
func (s *CustomerManagedWorkerCapabilities) SetMemoryMiB(v *MemoryMiBRange) *CustomerManagedWorkerCapabilities {
	s.MemoryMiB = v
	return s
}

// SetOsFamily sets the OsFamily field's value.
func (s *CustomerManagedWorkerCapabilities) SetOsFamily(v string) *CustomerManagedWorkerCapabilities {
	s.OsFamily = &v
	return s
}

// SetVCpuCount sets the VCpuCount field's value.
func (s *CustomerManagedWorkerCapabilities) SetVCpuCount(v *VCpuCountRange) *CustomerManagedWorkerCapabilities {
	s.VCpuCount = v
	return s
}

// The time stamp in date-time format.
type DateTimeFilterExpression struct {
	_ struct{} `type:"structure"`

	// The date and time.
	//
	// DateTime is a required field
	DateTime *time.Time `locationName:"dateTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The name of the date-time field to filter on.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of comparison to use to filter the results.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"ComparisonOperator"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateTimeFilterExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateTimeFilterExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateTimeFilterExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateTimeFilterExpression"}
	if s.DateTime == nil {
		invalidParams.Add(request.NewErrParamRequired("DateTime"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateTime sets the DateTime field's value.
func (s *DateTimeFilterExpression) SetDateTime(v time.Time) *DateTimeFilterExpression {
	s.DateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DateTimeFilterExpression) SetName(v string) *DateTimeFilterExpression {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *DateTimeFilterExpression) SetOperator(v string) *DateTimeFilterExpression {
	s.Operator = &v
	return s
}

type DeleteBudgetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The budget ID of the budget to delete.
	//
	// BudgetId is a required field
	BudgetId *string `location:"uri" locationName:"budgetId" type:"string" required:"true"`

	// The farm ID of the farm to remove from the budget.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBudgetInput"}
	if s.BudgetId == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetId"))
	}
	if s.BudgetId != nil && len(*s.BudgetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetId", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBudgetId sets the BudgetId field's value.
func (s *DeleteBudgetInput) SetBudgetId(v string) *DeleteBudgetInput {
	s.BudgetId = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteBudgetInput) SetFarmId(v string) *DeleteBudgetInput {
	s.FarmId = &v
	return s
}

type DeleteBudgetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBudgetOutput) GoString() string {
	return s.String()
}

type DeleteFarmInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm to delete.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFarmInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteFarmInput) SetFarmId(v string) *DeleteFarmInput {
	s.FarmId = &v
	return s
}

type DeleteFarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFarmOutput) GoString() string {
	return s.String()
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique token which the server uses to recognize retries of the same request.
	ClientToken *string `location:"header" locationName:"X-Amz-Client-Token" min:"1" type:"string" idempotencyToken:"true"`

	// The farm ID of the farm to remove from the fleet.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the fleet to delete.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteFleetInput) SetClientToken(v string) *DeleteFleetInput {
	s.ClientToken = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteFleetInput) SetFarmId(v string) *DeleteFleetInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteFleetInput) SetFleetId(v string) *DeleteFleetInput {
	s.FleetId = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DeleteLicenseEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The license endpoint ID of the license endpoint to delete.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `location:"uri" locationName:"licenseEndpointId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLicenseEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLicenseEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLicenseEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLicenseEndpointInput"}
	if s.LicenseEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseEndpointId"))
	}
	if s.LicenseEndpointId != nil && len(*s.LicenseEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *DeleteLicenseEndpointInput) SetLicenseEndpointId(v string) *DeleteLicenseEndpointInput {
	s.LicenseEndpointId = &v
	return s
}

type DeleteLicenseEndpointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLicenseEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteLicenseEndpointOutput) GoString() string {
	return s.String()
}

type DeleteMeteredProductInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the license endpoint from which to remove the metered product.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `location:"uri" locationName:"licenseEndpointId" type:"string" required:"true"`

	// The product ID to remove from the license endpoint.
	//
	// ProductId is a required field
	ProductId *string `location:"uri" locationName:"productId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeteredProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeteredProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMeteredProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMeteredProductInput"}
	if s.LicenseEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseEndpointId"))
	}
	if s.LicenseEndpointId != nil && len(*s.LicenseEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseEndpointId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *DeleteMeteredProductInput) SetLicenseEndpointId(v string) *DeleteMeteredProductInput {
	s.LicenseEndpointId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *DeleteMeteredProductInput) SetProductId(v string) *DeleteMeteredProductInput {
	s.ProductId = &v
	return s
}

type DeleteMeteredProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeteredProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMeteredProductOutput) GoString() string {
	return s.String()
}

type DeleteMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier of the monitor to delete. This ID is returned by the
	// CreateMonitor operation, and is included in the response to the GetMonitor
	// operation.
	//
	// MonitorId is a required field
	MonitorId *string `location:"uri" locationName:"monitorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMonitorInput"}
	if s.MonitorId == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorId"))
	}
	if s.MonitorId != nil && len(*s.MonitorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorId sets the MonitorId field's value.
func (s *DeleteMonitorInput) SetMonitorId(v string) *DeleteMonitorInput {
	s.MonitorId = &v
	return s
}

type DeleteMonitorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMonitorOutput) GoString() string {
	return s.String()
}

type DeleteQueueEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm from which to remove the queue environment.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue environment ID of the queue environment to delete.
	//
	// QueueEnvironmentId is a required field
	QueueEnvironmentId *string `location:"uri" locationName:"queueEnvironmentId" type:"string" required:"true"`

	// The queue ID of the queue environment to delete.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueueEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQueueEnvironmentInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueEnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueEnvironmentId"))
	}
	if s.QueueEnvironmentId != nil && len(*s.QueueEnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueEnvironmentId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteQueueEnvironmentInput) SetFarmId(v string) *DeleteQueueEnvironmentInput {
	s.FarmId = &v
	return s
}

// SetQueueEnvironmentId sets the QueueEnvironmentId field's value.
func (s *DeleteQueueEnvironmentInput) SetQueueEnvironmentId(v string) *DeleteQueueEnvironmentInput {
	s.QueueEnvironmentId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *DeleteQueueEnvironmentInput) SetQueueId(v string) *DeleteQueueEnvironmentInput {
	s.QueueId = &v
	return s
}

type DeleteQueueEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueEnvironmentOutput) GoString() string {
	return s.String()
}

type DeleteQueueFleetAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm that holds the queue-fleet association.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the queue-fleet association.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The queue ID of the queue-fleet association.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueFleetAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueFleetAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueueFleetAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQueueFleetAssociationInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteQueueFleetAssociationInput) SetFarmId(v string) *DeleteQueueFleetAssociationInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteQueueFleetAssociationInput) SetFleetId(v string) *DeleteQueueFleetAssociationInput {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *DeleteQueueFleetAssociationInput) SetQueueId(v string) *DeleteQueueFleetAssociationInput {
	s.QueueId = &v
	return s
}

type DeleteQueueFleetAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueFleetAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueFleetAssociationOutput) GoString() string {
	return s.String()
}

type DeleteQueueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the farm from which to remove the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue ID of the queue to delete.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteQueueInput) SetFarmId(v string) *DeleteQueueInput {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *DeleteQueueInput) SetQueueId(v string) *DeleteQueueInput {
	s.QueueId = &v
	return s
}

type DeleteQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteQueueOutput) GoString() string {
	return s.String()
}

type DeleteStorageProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm from which to remove the storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The storage profile ID of the storage profile to delete.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `location:"uri" locationName:"storageProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStorageProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStorageProfileInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.StorageProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageProfileId"))
	}
	if s.StorageProfileId != nil && len(*s.StorageProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteStorageProfileInput) SetFarmId(v string) *DeleteStorageProfileInput {
	s.FarmId = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *DeleteStorageProfileInput) SetStorageProfileId(v string) *DeleteStorageProfileInput {
	s.StorageProfileId = &v
	return s
}

type DeleteStorageProfileOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStorageProfileOutput) GoString() string {
	return s.String()
}

type DeleteWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the worker to delete.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the worker to delete.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The worker ID of the worker to delete.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkerInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DeleteWorkerInput) SetFarmId(v string) *DeleteWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DeleteWorkerInput) SetFleetId(v string) *DeleteWorkerInput {
	s.FleetId = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *DeleteWorkerInput) SetWorkerId(v string) *DeleteWorkerInput {
	s.WorkerId = &v
	return s
}

type DeleteWorkerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkerOutput) GoString() string {
	return s.String()
}

// The number of dependencies for the consumer.
type DependencyCounts struct {
	_ struct{} `type:"structure"`

	// The number of consumers resolved.
	//
	// ConsumersResolved is a required field
	ConsumersResolved *int64 `locationName:"consumersResolved" type:"integer" required:"true"`

	// The number of unresolved consumers.
	//
	// ConsumersUnresolved is a required field
	ConsumersUnresolved *int64 `locationName:"consumersUnresolved" type:"integer" required:"true"`

	// The number of resolved dependencies.
	//
	// DependenciesResolved is a required field
	DependenciesResolved *int64 `locationName:"dependenciesResolved" type:"integer" required:"true"`

	// The number of unresolved dependencies.
	//
	// DependenciesUnresolved is a required field
	DependenciesUnresolved *int64 `locationName:"dependenciesUnresolved" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyCounts) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyCounts) GoString() string {
	return s.String()
}

// SetConsumersResolved sets the ConsumersResolved field's value.
func (s *DependencyCounts) SetConsumersResolved(v int64) *DependencyCounts {
	s.ConsumersResolved = &v
	return s
}

// SetConsumersUnresolved sets the ConsumersUnresolved field's value.
func (s *DependencyCounts) SetConsumersUnresolved(v int64) *DependencyCounts {
	s.ConsumersUnresolved = &v
	return s
}

// SetDependenciesResolved sets the DependenciesResolved field's value.
func (s *DependencyCounts) SetDependenciesResolved(v int64) *DependencyCounts {
	s.DependenciesResolved = &v
	return s
}

// SetDependenciesUnresolved sets the DependenciesUnresolved field's value.
func (s *DependencyCounts) SetDependenciesUnresolved(v int64) *DependencyCounts {
	s.DependenciesUnresolved = &v
	return s
}

type DisassociateMemberFromFarmInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm to disassociate from the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// A member's principal ID to disassociate from a farm.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromFarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromFarmInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DisassociateMemberFromFarmInput) SetFarmId(v string) *DisassociateMemberFromFarmInput {
	s.FarmId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DisassociateMemberFromFarmInput) SetPrincipalId(v string) *DisassociateMemberFromFarmInput {
	s.PrincipalId = &v
	return s
}

type DisassociateMemberFromFarmOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFarmOutput) GoString() string {
	return s.String()
}

type DisassociateMemberFromFleetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the fleet to disassociate a member from.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the fleet to from which to disassociate a member.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// A member's principal ID to disassociate from a fleet.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromFleetInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DisassociateMemberFromFleetInput) SetFarmId(v string) *DisassociateMemberFromFleetInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *DisassociateMemberFromFleetInput) SetFleetId(v string) *DisassociateMemberFromFleetInput {
	s.FleetId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DisassociateMemberFromFleetInput) SetPrincipalId(v string) *DisassociateMemberFromFleetInput {
	s.PrincipalId = &v
	return s
}

type DisassociateMemberFromFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromFleetOutput) GoString() string {
	return s.String()
}

type DisassociateMemberFromJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the job to disassociate from the member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID to disassociate from a member in a job.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// A member's principal ID to disassociate from a job.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The queue ID connected to a job for which you're disassociating a member.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromJobInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DisassociateMemberFromJobInput) SetFarmId(v string) *DisassociateMemberFromJobInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *DisassociateMemberFromJobInput) SetJobId(v string) *DisassociateMemberFromJobInput {
	s.JobId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DisassociateMemberFromJobInput) SetPrincipalId(v string) *DisassociateMemberFromJobInput {
	s.PrincipalId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *DisassociateMemberFromJobInput) SetQueueId(v string) *DisassociateMemberFromJobInput {
	s.QueueId = &v
	return s
}

type DisassociateMemberFromJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromJobOutput) GoString() string {
	return s.String()
}

type DisassociateMemberFromQueueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue to disassociate from a member.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// A member's principal ID to disassociate from a queue.
	//
	// PrincipalId is a required field
	PrincipalId *string `location:"uri" locationName:"principalId" min:"1" type:"string" required:"true"`

	// The queue ID of the queue in which you're disassociating from a member.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateMemberFromQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateMemberFromQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.PrincipalId == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalId"))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *DisassociateMemberFromQueueInput) SetFarmId(v string) *DisassociateMemberFromQueueInput {
	s.FarmId = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *DisassociateMemberFromQueueInput) SetPrincipalId(v string) *DisassociateMemberFromQueueInput {
	s.PrincipalId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *DisassociateMemberFromQueueInput) SetQueueId(v string) *DisassociateMemberFromQueueInput {
	s.QueueId = &v
	return s
}

type DisassociateMemberFromQueueOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateMemberFromQueueOutput) GoString() string {
	return s.String()
}

// Specifies the EBS volume.
type Ec2EbsVolume struct {
	_ struct{} `type:"structure"`

	// The IOPS per volume.
	Iops *int64 `locationName:"iops" min:"3000" type:"integer"`

	// The EBS volume size in GiB.
	SizeGiB *int64 `locationName:"sizeGiB" type:"integer"`

	// The throughput per volume in MiB.
	ThroughputMiB *int64 `locationName:"throughputMiB" min:"125" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2EbsVolume) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ec2EbsVolume) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Ec2EbsVolume) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Ec2EbsVolume"}
	if s.Iops != nil && *s.Iops < 3000 {
		invalidParams.Add(request.NewErrParamMinValue("Iops", 3000))
	}
	if s.ThroughputMiB != nil && *s.ThroughputMiB < 125 {
		invalidParams.Add(request.NewErrParamMinValue("ThroughputMiB", 125))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIops sets the Iops field's value.
func (s *Ec2EbsVolume) SetIops(v int64) *Ec2EbsVolume {
	s.Iops = &v
	return s
}

// SetSizeGiB sets the SizeGiB field's value.
func (s *Ec2EbsVolume) SetSizeGiB(v int64) *Ec2EbsVolume {
	s.SizeGiB = &v
	return s
}

// SetThroughputMiB sets the ThroughputMiB field's value.
func (s *Ec2EbsVolume) SetThroughputMiB(v int64) *Ec2EbsVolume {
	s.ThroughputMiB = &v
	return s
}

// The error details for the environment.
type EnvironmentDetailsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"JobEntityErrorCode"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The error message detailing the error's cause.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentDetailsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentDetailsError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *EnvironmentDetailsError) SetCode(v string) *EnvironmentDetailsError {
	s.Code = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentDetailsError) SetEnvironmentId(v string) *EnvironmentDetailsError {
	s.EnvironmentId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EnvironmentDetailsError) SetJobId(v string) *EnvironmentDetailsError {
	s.JobId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *EnvironmentDetailsError) SetMessage(v string) *EnvironmentDetailsError {
	s.Message = &v
	return s
}

// The IDs of the job and environment.
type EnvironmentDetailsIdentifiers struct {
	_ struct{} `type:"structure"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentDetailsIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentDetailsIdentifiers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EnvironmentDetailsIdentifiers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EnvironmentDetailsIdentifiers"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.EnvironmentId != nil && len(*s.EnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentDetailsIdentifiers) SetEnvironmentId(v string) *EnvironmentDetailsIdentifiers {
	s.EnvironmentId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *EnvironmentDetailsIdentifiers) SetJobId(v string) *EnvironmentDetailsIdentifiers {
	s.JobId = &v
	return s
}

// The environment ID to use to enter a session action.
type EnvironmentEnterSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentEnterSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentEnterSessionActionDefinition) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentEnterSessionActionDefinition) SetEnvironmentId(v string) *EnvironmentEnterSessionActionDefinition {
	s.EnvironmentId = &v
	return s
}

// Defines the environment a session action enters in.
type EnvironmentEnterSessionActionDefinitionSummary struct {
	_ struct{} `type:"structure"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentEnterSessionActionDefinitionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentEnterSessionActionDefinitionSummary) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentEnterSessionActionDefinitionSummary) SetEnvironmentId(v string) *EnvironmentEnterSessionActionDefinitionSummary {
	s.EnvironmentId = &v
	return s
}

// Defines the environment a session action exits from.
type EnvironmentExitSessionActionDefinition struct {
	_ struct{} `type:"structure"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentExitSessionActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentExitSessionActionDefinition) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentExitSessionActionDefinition) SetEnvironmentId(v string) *EnvironmentExitSessionActionDefinition {
	s.EnvironmentId = &v
	return s
}

// A summary of the environment details for which a session action to exits.
type EnvironmentExitSessionActionDefinitionSummary struct {
	_ struct{} `type:"structure"`

	// The environment ID.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentExitSessionActionDefinitionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EnvironmentExitSessionActionDefinitionSummary) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentExitSessionActionDefinitionSummary) SetEnvironmentId(v string) *EnvironmentExitSessionActionDefinitionSummary {
	s.EnvironmentId = &v
	return s
}

// The member of a farm.
type FarmMember struct {
	_ struct{} `type:"structure"`

	// The farm ID of the farm member.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The identity store ID of the farm member.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The farm member's membership level.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The principal ID of the farm member.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" min:"1" type:"string" required:"true"`

	// The principal type of the farm member.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FarmMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FarmMember) GoString() string {
	return s.String()
}

// SetFarmId sets the FarmId field's value.
func (s *FarmMember) SetFarmId(v string) *FarmMember {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *FarmMember) SetIdentityStoreId(v string) *FarmMember {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *FarmMember) SetMembershipLevel(v string) *FarmMember {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *FarmMember) SetPrincipalId(v string) *FarmMember {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *FarmMember) SetPrincipalType(v string) *FarmMember {
	s.PrincipalType = &v
	return s
}

// The summary of details for a farm.
type FarmSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The display name of the farm.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The ARN for the KMS key.
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FarmSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FarmSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FarmSummary) SetCreatedAt(v time.Time) *FarmSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *FarmSummary) SetCreatedBy(v string) *FarmSummary {
	s.CreatedBy = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *FarmSummary) SetDisplayName(v string) *FarmSummary {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *FarmSummary) SetFarmId(v string) *FarmSummary {
	s.FarmId = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *FarmSummary) SetKmsKeyArn(v string) *FarmSummary {
	s.KmsKeyArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FarmSummary) SetUpdatedAt(v time.Time) *FarmSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *FarmSummary) SetUpdatedBy(v string) *FarmSummary {
	s.UpdatedBy = &v
	return s
}

// The field sorting order and name of the field.
type FieldSortExpression struct {
	_ struct{} `type:"structure"`

	// The name of the field.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The sort order for the field.
	//
	// SortOrder is a required field
	SortOrder *string `locationName:"sortOrder" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSortExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FieldSortExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldSortExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldSortExpression"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *FieldSortExpression) SetName(v string) *FieldSortExpression {
	s.Name = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *FieldSortExpression) SetSortOrder(v string) *FieldSortExpression {
	s.SortOrder = &v
	return s
}

// The details of the file system location for the resource.
type FileSystemLocation struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The location name.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by FileSystemLocation's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true" sensitive:"true"`

	// The file path.
	//
	// Path is a required field
	Path *string `locationName:"path" type:"string" required:"true"`

	// The type of file.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"FileSystemLocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FileSystemLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FileSystemLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FileSystemLocation"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *FileSystemLocation) SetName(v string) *FileSystemLocation {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *FileSystemLocation) SetPath(v string) *FileSystemLocation {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *FileSystemLocation) SetType(v string) *FileSystemLocation {
	s.Type = &v
	return s
}

// The details of a fixed budget schedule.
type FixedBudgetSchedule struct {
	_ struct{} `type:"structure"`

	// When the budget ends.
	//
	// EndTime is a required field
	EndTime *time.Time `locationName:"endTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// When the budget starts.
	//
	// StartTime is a required field
	StartTime *time.Time `locationName:"startTime" type:"timestamp" timestampFormat:"iso8601" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedBudgetSchedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FixedBudgetSchedule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FixedBudgetSchedule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FixedBudgetSchedule"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *FixedBudgetSchedule) SetEndTime(v time.Time) *FixedBudgetSchedule {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *FixedBudgetSchedule) SetStartTime(v time.Time) *FixedBudgetSchedule {
	s.StartTime = &v
	return s
}

// The fleet amount and attribute capabilities.
type FleetAmountCapability struct {
	_ struct{} `type:"structure"`

	// The maximum amount of the fleet worker capability.
	Max *float64 `locationName:"max" type:"float"`

	// The minimum amount of fleet worker capability.
	//
	// Min is a required field
	Min *float64 `locationName:"min" type:"float" required:"true"`

	// The name of the fleet capability.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAmountCapability) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAmountCapability) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetAmountCapability) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FleetAmountCapability"}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *FleetAmountCapability) SetMax(v float64) *FleetAmountCapability {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *FleetAmountCapability) SetMin(v float64) *FleetAmountCapability {
	s.Min = &v
	return s
}

// SetName sets the Name field's value.
func (s *FleetAmountCapability) SetName(v string) *FleetAmountCapability {
	s.Name = &v
	return s
}

// Defines the fleet's capability name, minimum, and maximum.
type FleetAttributeCapability struct {
	_ struct{} `type:"structure"`

	// The name of the fleet attribute capability for the worker.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The number of fleet attribute capabilities.
	//
	// Values is a required field
	Values []*string `locationName:"values" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAttributeCapability) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetAttributeCapability) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetAttributeCapability) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FleetAttributeCapability"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *FleetAttributeCapability) SetName(v string) *FleetAttributeCapability {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *FleetAttributeCapability) SetValues(v []*string) *FleetAttributeCapability {
	s.Values = v
	return s
}

// The amounts and attributes of fleets.
type FleetCapabilities struct {
	_ struct{} `type:"structure"`

	// Amount capabilities of the fleet.
	Amounts []*FleetAmountCapability `locationName:"amounts" min:"1" type:"list"`

	// Attribute capabilities of the fleet.
	Attributes []*FleetAttributeCapability `locationName:"attributes" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapabilities) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetCapabilities) GoString() string {
	return s.String()
}

// SetAmounts sets the Amounts field's value.
func (s *FleetCapabilities) SetAmounts(v []*FleetAmountCapability) *FleetCapabilities {
	s.Amounts = v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *FleetCapabilities) SetAttributes(v []*FleetAttributeCapability) *FleetCapabilities {
	s.Attributes = v
	return s
}

// Fleet configuration details.
type FleetConfiguration struct {
	_ struct{} `type:"structure"`

	// The customer managed fleets within a fleet configuration.
	CustomerManaged *CustomerManagedFleetConfiguration `locationName:"customerManaged" type:"structure"`

	// The service managed Amazon EC2 instances for a fleet configuration.
	ServiceManagedEc2 *ServiceManagedEc2FleetConfiguration `locationName:"serviceManagedEc2" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FleetConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FleetConfiguration"}
	if s.CustomerManaged != nil {
		if err := s.CustomerManaged.Validate(); err != nil {
			invalidParams.AddNested("CustomerManaged", err.(request.ErrInvalidParams))
		}
	}
	if s.ServiceManagedEc2 != nil {
		if err := s.ServiceManagedEc2.Validate(); err != nil {
			invalidParams.AddNested("ServiceManagedEc2", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomerManaged sets the CustomerManaged field's value.
func (s *FleetConfiguration) SetCustomerManaged(v *CustomerManagedFleetConfiguration) *FleetConfiguration {
	s.CustomerManaged = v
	return s
}

// SetServiceManagedEc2 sets the ServiceManagedEc2 field's value.
func (s *FleetConfiguration) SetServiceManagedEc2(v *ServiceManagedEc2FleetConfiguration) *FleetConfiguration {
	s.ServiceManagedEc2 = v
	return s
}

// The fleet member.
type FleetMember struct {
	_ struct{} `type:"structure"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The identity store ID.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The fleet member's membership level.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The principal ID of the fleet member.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" min:"1" type:"string" required:"true"`

	// The principal type of the fleet member.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetMember) GoString() string {
	return s.String()
}

// SetFarmId sets the FarmId field's value.
func (s *FleetMember) SetFarmId(v string) *FleetMember {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetMember) SetFleetId(v string) *FleetMember {
	s.FleetId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *FleetMember) SetIdentityStoreId(v string) *FleetMember {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *FleetMember) SetMembershipLevel(v string) *FleetMember {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *FleetMember) SetPrincipalId(v string) *FleetMember {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *FleetMember) SetPrincipalType(v string) *FleetMember {
	s.PrincipalType = &v
	return s
}

// The details of a fleet.
type FleetSummary struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling status of a fleet.
	AutoScalingStatus *string `locationName:"autoScalingStatus" type:"string" enum:"AutoScalingStatus"`

	// The configuration details for the fleet.
	//
	// Configuration is a required field
	Configuration *FleetConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The display name of the fleet summary to update.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The maximum number of workers specified in the fleet.
	//
	// MaxWorkerCount is a required field
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" type:"integer" required:"true"`

	// The minimum number of workers in the fleet.
	//
	// MinWorkerCount is a required field
	MinWorkerCount *int64 `locationName:"minWorkerCount" type:"integer" required:"true"`

	// The status of the fleet.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FleetStatus"`

	// The target number of workers in a fleet.
	TargetWorkerCount *int64 `locationName:"targetWorkerCount" type:"integer"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The number of workers in the fleet summary.
	//
	// WorkerCount is a required field
	WorkerCount *int64 `locationName:"workerCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FleetSummary) GoString() string {
	return s.String()
}

// SetAutoScalingStatus sets the AutoScalingStatus field's value.
func (s *FleetSummary) SetAutoScalingStatus(v string) *FleetSummary {
	s.AutoScalingStatus = &v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *FleetSummary) SetConfiguration(v *FleetConfiguration) *FleetSummary {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FleetSummary) SetCreatedAt(v time.Time) *FleetSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *FleetSummary) SetCreatedBy(v string) *FleetSummary {
	s.CreatedBy = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *FleetSummary) SetDisplayName(v string) *FleetSummary {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *FleetSummary) SetFarmId(v string) *FleetSummary {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *FleetSummary) SetFleetId(v string) *FleetSummary {
	s.FleetId = &v
	return s
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *FleetSummary) SetMaxWorkerCount(v int64) *FleetSummary {
	s.MaxWorkerCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *FleetSummary) SetMinWorkerCount(v int64) *FleetSummary {
	s.MinWorkerCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FleetSummary) SetStatus(v string) *FleetSummary {
	s.Status = &v
	return s
}

// SetTargetWorkerCount sets the TargetWorkerCount field's value.
func (s *FleetSummary) SetTargetWorkerCount(v int64) *FleetSummary {
	s.TargetWorkerCount = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *FleetSummary) SetUpdatedAt(v time.Time) *FleetSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *FleetSummary) SetUpdatedBy(v string) *FleetSummary {
	s.UpdatedBy = &v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *FleetSummary) SetWorkerCount(v int64) *FleetSummary {
	s.WorkerCount = &v
	return s
}

type GetBudgetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The budget ID.
	//
	// BudgetId is a required field
	BudgetId *string `location:"uri" locationName:"budgetId" type:"string" required:"true"`

	// The farm ID of the farm connected to the budget.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBudgetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBudgetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBudgetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBudgetInput"}
	if s.BudgetId == nil {
		invalidParams.Add(request.NewErrParamRequired("BudgetId"))
	}
	if s.BudgetId != nil && len(*s.BudgetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BudgetId", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBudgetId sets the BudgetId field's value.
func (s *GetBudgetInput) SetBudgetId(v string) *GetBudgetInput {
	s.BudgetId = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetBudgetInput) SetFarmId(v string) *GetBudgetInput {
	s.FarmId = &v
	return s
}

type GetBudgetOutput struct {
	_ struct{} `type:"structure"`

	// The budget actions for the budget.
	//
	// Actions is a required field
	Actions []*ResponseBudgetAction `locationName:"actions" type:"list" required:"true"`

	// The consumed usage limit for the budget.
	//
	// ApproximateDollarLimit is a required field
	ApproximateDollarLimit *float64 `locationName:"approximateDollarLimit" min:"0.01" type:"float" required:"true"`

	// The budget ID.
	//
	// BudgetId is a required field
	BudgetId *string `locationName:"budgetId" type:"string" required:"true"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the budget.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetBudgetOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the budget.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The date and time the queue stopped.
	QueueStoppedAt *time.Time `locationName:"queueStoppedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The budget schedule.
	//
	// Schedule is a required field
	Schedule *BudgetSchedule `locationName:"schedule" type:"structure" required:"true"`

	// The status of the budget.
	//
	//    * ACTIVE–Get a budget being evaluated.
	//
	//    * INACTIVE–Get an inactive budget. This can include expired, canceled,
	//    or deleted statuses.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"BudgetStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The resource that the budget is tracking usage for.
	//
	// UsageTrackingResource is a required field
	UsageTrackingResource *UsageTrackingResource `locationName:"usageTrackingResource" type:"structure" required:"true"`

	// The usages of the budget.
	//
	// Usages is a required field
	Usages *ConsumedUsages `locationName:"usages" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBudgetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBudgetOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *GetBudgetOutput) SetActions(v []*ResponseBudgetAction) *GetBudgetOutput {
	s.Actions = v
	return s
}

// SetApproximateDollarLimit sets the ApproximateDollarLimit field's value.
func (s *GetBudgetOutput) SetApproximateDollarLimit(v float64) *GetBudgetOutput {
	s.ApproximateDollarLimit = &v
	return s
}

// SetBudgetId sets the BudgetId field's value.
func (s *GetBudgetOutput) SetBudgetId(v string) *GetBudgetOutput {
	s.BudgetId = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetBudgetOutput) SetCreatedAt(v time.Time) *GetBudgetOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetBudgetOutput) SetCreatedBy(v string) *GetBudgetOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetBudgetOutput) SetDescription(v string) *GetBudgetOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetBudgetOutput) SetDisplayName(v string) *GetBudgetOutput {
	s.DisplayName = &v
	return s
}

// SetQueueStoppedAt sets the QueueStoppedAt field's value.
func (s *GetBudgetOutput) SetQueueStoppedAt(v time.Time) *GetBudgetOutput {
	s.QueueStoppedAt = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *GetBudgetOutput) SetSchedule(v *BudgetSchedule) *GetBudgetOutput {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetBudgetOutput) SetStatus(v string) *GetBudgetOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetBudgetOutput) SetUpdatedAt(v time.Time) *GetBudgetOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetBudgetOutput) SetUpdatedBy(v string) *GetBudgetOutput {
	s.UpdatedBy = &v
	return s
}

// SetUsageTrackingResource sets the UsageTrackingResource field's value.
func (s *GetBudgetOutput) SetUsageTrackingResource(v *UsageTrackingResource) *GetBudgetOutput {
	s.UsageTrackingResource = v
	return s
}

// SetUsages sets the Usages field's value.
func (s *GetBudgetOutput) SetUsages(v *ConsumedUsages) *GetBudgetOutput {
	s.Usages = v
	return s
}

type GetFarmInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFarmInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFarmInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFarmInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFarmInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetFarmInput) SetFarmId(v string) *GetFarmInput {
	s.FarmId = &v
	return s
}

type GetFarmOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the farm.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetFarmOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the farm.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID of the farm to get.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The ARN of the KMS key used on the farm.
	//
	// KmsKeyArn is a required field
	KmsKeyArn *string `locationName:"kmsKeyArn" type:"string" required:"true"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFarmOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFarmOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetFarmOutput) SetCreatedAt(v time.Time) *GetFarmOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetFarmOutput) SetCreatedBy(v string) *GetFarmOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFarmOutput) SetDescription(v string) *GetFarmOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetFarmOutput) SetDisplayName(v string) *GetFarmOutput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetFarmOutput) SetFarmId(v string) *GetFarmOutput {
	s.FarmId = &v
	return s
}

// SetKmsKeyArn sets the KmsKeyArn field's value.
func (s *GetFarmOutput) SetKmsKeyArn(v string) *GetFarmOutput {
	s.KmsKeyArn = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetFarmOutput) SetUpdatedAt(v time.Time) *GetFarmOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetFarmOutput) SetUpdatedBy(v string) *GetFarmOutput {
	s.UpdatedBy = &v
	return s
}

type GetFleetInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm in the fleet.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the fleet to get.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetFleetInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetFleetInput) SetFarmId(v string) *GetFleetInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetFleetInput) SetFleetId(v string) *GetFleetInput {
	s.FleetId = &v
	return s
}

type GetFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling status of the fleet. Either GROWING, STEADY, or SHRINKING.
	AutoScalingStatus *string `locationName:"autoScalingStatus" type:"string" enum:"AutoScalingStatus"`

	// Outlines what the fleet is capable of for minimums, maximums, and naming,
	// in addition to attribute names and values.
	Capabilities *FleetCapabilities `locationName:"capabilities" type:"structure"`

	// The configuration setting for the fleet.
	//
	// Configuration is a required field
	Configuration *FleetConfiguration `locationName:"configuration" type:"structure" required:"true"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the fleet.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetFleetOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the fleet.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID of the farm in the fleet.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The maximum number of workers specified in the fleet.
	//
	// MaxWorkerCount is a required field
	MaxWorkerCount *int64 `locationName:"maxWorkerCount" type:"integer" required:"true"`

	// The minimum number of workers specified in the fleet.
	//
	// MinWorkerCount is a required field
	MinWorkerCount *int64 `locationName:"minWorkerCount" type:"integer" required:"true"`

	// The IAM role ARN.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The Auto Scaling status of the fleet.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"FleetStatus"`

	// The number of target workers in the fleet.
	TargetWorkerCount *int64 `locationName:"targetWorkerCount" type:"integer"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The number of workers in the fleet.
	//
	// WorkerCount is a required field
	WorkerCount *int64 `locationName:"workerCount" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetFleetOutput) GoString() string {
	return s.String()
}

// SetAutoScalingStatus sets the AutoScalingStatus field's value.
func (s *GetFleetOutput) SetAutoScalingStatus(v string) *GetFleetOutput {
	s.AutoScalingStatus = &v
	return s
}

// SetCapabilities sets the Capabilities field's value.
func (s *GetFleetOutput) SetCapabilities(v *FleetCapabilities) *GetFleetOutput {
	s.Capabilities = v
	return s
}

// SetConfiguration sets the Configuration field's value.
func (s *GetFleetOutput) SetConfiguration(v *FleetConfiguration) *GetFleetOutput {
	s.Configuration = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetFleetOutput) SetCreatedAt(v time.Time) *GetFleetOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetFleetOutput) SetCreatedBy(v string) *GetFleetOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetFleetOutput) SetDescription(v string) *GetFleetOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetFleetOutput) SetDisplayName(v string) *GetFleetOutput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetFleetOutput) SetFarmId(v string) *GetFleetOutput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetFleetOutput) SetFleetId(v string) *GetFleetOutput {
	s.FleetId = &v
	return s
}

// SetMaxWorkerCount sets the MaxWorkerCount field's value.
func (s *GetFleetOutput) SetMaxWorkerCount(v int64) *GetFleetOutput {
	s.MaxWorkerCount = &v
	return s
}

// SetMinWorkerCount sets the MinWorkerCount field's value.
func (s *GetFleetOutput) SetMinWorkerCount(v int64) *GetFleetOutput {
	s.MinWorkerCount = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetFleetOutput) SetRoleArn(v string) *GetFleetOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetFleetOutput) SetStatus(v string) *GetFleetOutput {
	s.Status = &v
	return s
}

// SetTargetWorkerCount sets the TargetWorkerCount field's value.
func (s *GetFleetOutput) SetTargetWorkerCount(v int64) *GetFleetOutput {
	s.TargetWorkerCount = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetFleetOutput) SetUpdatedAt(v time.Time) *GetFleetOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetFleetOutput) SetUpdatedBy(v string) *GetFleetOutput {
	s.UpdatedBy = &v
	return s
}

// SetWorkerCount sets the WorkerCount field's value.
func (s *GetFleetOutput) SetWorkerCount(v int64) *GetFleetOutput {
	s.WorkerCount = &v
	return s
}

// The error for the job entity.
type GetJobEntityError struct {
	_ struct{} `type:"structure"`

	// The environment details for the failed job entity.
	EnvironmentDetails *EnvironmentDetailsError `locationName:"environmentDetails" type:"structure"`

	// The job attachment details for the failed job entity.
	JobAttachmentDetails *JobAttachmentDetailsError `locationName:"jobAttachmentDetails" type:"structure"`

	// The job details for the failed job entity.
	JobDetails *JobDetailsError `locationName:"jobDetails" type:"structure"`

	// The step details for the failed job entity.
	StepDetails *StepDetailsError `locationName:"stepDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobEntityError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobEntityError) GoString() string {
	return s.String()
}

// SetEnvironmentDetails sets the EnvironmentDetails field's value.
func (s *GetJobEntityError) SetEnvironmentDetails(v *EnvironmentDetailsError) *GetJobEntityError {
	s.EnvironmentDetails = v
	return s
}

// SetJobAttachmentDetails sets the JobAttachmentDetails field's value.
func (s *GetJobEntityError) SetJobAttachmentDetails(v *JobAttachmentDetailsError) *GetJobEntityError {
	s.JobAttachmentDetails = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *GetJobEntityError) SetJobDetails(v *JobDetailsError) *GetJobEntityError {
	s.JobDetails = v
	return s
}

// SetStepDetails sets the StepDetails field's value.
func (s *GetJobEntityError) SetStepDetails(v *StepDetailsError) *GetJobEntityError {
	s.StepDetails = v
	return s
}

type GetJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm in the job.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID associated with the job.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetJobInput) SetFarmId(v string) *GetJobInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobInput) SetJobId(v string) *GetJobInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetJobInput) SetQueueId(v string) *GetJobInput {
	s.QueueId = &v
	return s
}

type GetJobOutput struct {
	_ struct{} `type:"structure"`

	// The attachments for the job.
	Attachments *Attachments `locationName:"attachments" type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The description of the job.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetJobOutput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The life cycle status for the job.
	//
	// LifecycleStatus is a required field
	LifecycleStatus *string `locationName:"lifecycleStatus" type:"string" required:"true" enum:"JobLifecycleStatus"`

	// A message that communicates the status of the life cycle for the job.
	//
	// LifecycleStatusMessage is a required field
	LifecycleStatusMessage *string `locationName:"lifecycleStatusMessage" type:"string" required:"true"`

	// The number of task failures before the job stops running and is marked as
	// FAILED.
	MaxFailedTasksCount *int64 `locationName:"maxFailedTasksCount" type:"integer"`

	// The maximum number of retries per failed tasks.
	MaxRetriesPerTask *int64 `locationName:"maxRetriesPerTask" type:"integer"`

	// The name of the job.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The parameters for the job.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetJobOutput's
	// String and GoString methods.
	Parameters map[string]*JobParameter `locationName:"parameters" type:"map" sensitive:"true"`

	// The job priority.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The storage profile ID associated with the job.
	StorageProfileId *string `locationName:"storageProfileId" type:"string"`

	// The task status with which the job started.
	TargetTaskRunStatus *string `locationName:"targetTaskRunStatus" type:"string" enum:"JobTargetTaskRunStatus"`

	// The task run status for the job.
	TaskRunStatus *string `locationName:"taskRunStatus" type:"string" enum:"TaskRunStatus"`

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]*int64 `locationName:"taskRunStatusCounts" type:"map"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *GetJobOutput) SetAttachments(v *Attachments) *GetJobOutput {
	s.Attachments = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetJobOutput) SetCreatedAt(v time.Time) *GetJobOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetJobOutput) SetCreatedBy(v string) *GetJobOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetJobOutput) SetDescription(v string) *GetJobOutput {
	s.Description = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetJobOutput) SetEndedAt(v time.Time) *GetJobOutput {
	s.EndedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetJobOutput) SetJobId(v string) *GetJobOutput {
	s.JobId = &v
	return s
}

// SetLifecycleStatus sets the LifecycleStatus field's value.
func (s *GetJobOutput) SetLifecycleStatus(v string) *GetJobOutput {
	s.LifecycleStatus = &v
	return s
}

// SetLifecycleStatusMessage sets the LifecycleStatusMessage field's value.
func (s *GetJobOutput) SetLifecycleStatusMessage(v string) *GetJobOutput {
	s.LifecycleStatusMessage = &v
	return s
}

// SetMaxFailedTasksCount sets the MaxFailedTasksCount field's value.
func (s *GetJobOutput) SetMaxFailedTasksCount(v int64) *GetJobOutput {
	s.MaxFailedTasksCount = &v
	return s
}

// SetMaxRetriesPerTask sets the MaxRetriesPerTask field's value.
func (s *GetJobOutput) SetMaxRetriesPerTask(v int64) *GetJobOutput {
	s.MaxRetriesPerTask = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetJobOutput) SetName(v string) *GetJobOutput {
	s.Name = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetJobOutput) SetParameters(v map[string]*JobParameter) *GetJobOutput {
	s.Parameters = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetJobOutput) SetPriority(v int64) *GetJobOutput {
	s.Priority = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetJobOutput) SetStartedAt(v time.Time) *GetJobOutput {
	s.StartedAt = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *GetJobOutput) SetStorageProfileId(v string) *GetJobOutput {
	s.StorageProfileId = &v
	return s
}

// SetTargetTaskRunStatus sets the TargetTaskRunStatus field's value.
func (s *GetJobOutput) SetTargetTaskRunStatus(v string) *GetJobOutput {
	s.TargetTaskRunStatus = &v
	return s
}

// SetTaskRunStatus sets the TaskRunStatus field's value.
func (s *GetJobOutput) SetTaskRunStatus(v string) *GetJobOutput {
	s.TaskRunStatus = &v
	return s
}

// SetTaskRunStatusCounts sets the TaskRunStatusCounts field's value.
func (s *GetJobOutput) SetTaskRunStatusCounts(v map[string]*int64) *GetJobOutput {
	s.TaskRunStatusCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetJobOutput) SetUpdatedAt(v time.Time) *GetJobOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetJobOutput) SetUpdatedBy(v string) *GetJobOutput {
	s.UpdatedBy = &v
	return s
}

type GetLicenseEndpointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The license endpoint ID.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `location:"uri" locationName:"licenseEndpointId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLicenseEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLicenseEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLicenseEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLicenseEndpointInput"}
	if s.LicenseEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseEndpointId"))
	}
	if s.LicenseEndpointId != nil && len(*s.LicenseEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseEndpointId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *GetLicenseEndpointInput) SetLicenseEndpointId(v string) *GetLicenseEndpointInput {
	s.LicenseEndpointId = &v
	return s
}

type GetLicenseEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The DNS name.
	DnsName *string `locationName:"dnsName" type:"string"`

	// The license endpoint ID.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `locationName:"licenseEndpointId" type:"string" required:"true"`

	// The security group IDs for the license endpoint.
	SecurityGroupIds []*string `locationName:"securityGroupIds" min:"1" type:"list"`

	// The status of the license endpoint.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"LicenseEndpointStatus"`

	// The status message of the license endpoint.
	//
	// StatusMessage is a required field
	StatusMessage *string `locationName:"statusMessage" type:"string" required:"true"`

	// The subnet IDs.
	SubnetIds []*string `locationName:"subnetIds" min:"1" type:"list"`

	// The VCP(virtual private cloud) ID associated with the license endpoint.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLicenseEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLicenseEndpointOutput) GoString() string {
	return s.String()
}

// SetDnsName sets the DnsName field's value.
func (s *GetLicenseEndpointOutput) SetDnsName(v string) *GetLicenseEndpointOutput {
	s.DnsName = &v
	return s
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *GetLicenseEndpointOutput) SetLicenseEndpointId(v string) *GetLicenseEndpointOutput {
	s.LicenseEndpointId = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *GetLicenseEndpointOutput) SetSecurityGroupIds(v []*string) *GetLicenseEndpointOutput {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetLicenseEndpointOutput) SetStatus(v string) *GetLicenseEndpointOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetLicenseEndpointOutput) SetStatusMessage(v string) *GetLicenseEndpointOutput {
	s.StatusMessage = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *GetLicenseEndpointOutput) SetSubnetIds(v []*string) *GetLicenseEndpointOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetLicenseEndpointOutput) SetVpcId(v string) *GetLicenseEndpointOutput {
	s.VpcId = &v
	return s
}

type GetMonitorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique identifier for the monitor. This ID is returned by the CreateMonitor
	// operation.
	//
	// MonitorId is a required field
	MonitorId *string `location:"uri" locationName:"monitorId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMonitorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMonitorInput"}
	if s.MonitorId == nil {
		invalidParams.Add(request.NewErrParamRequired("MonitorId"))
	}
	if s.MonitorId != nil && len(*s.MonitorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MonitorId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMonitorId sets the MonitorId field's value.
func (s *GetMonitorInput) SetMonitorId(v string) *GetMonitorInput {
	s.MonitorId = &v
	return s
}

type GetMonitorOutput struct {
	_ struct{} `type:"structure"`

	// The UNIX timestamp of the date and time that the monitor was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user name of the person that created the monitor.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The name used to identify the monitor on the Deadline Cloud console.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the
	// monitor when it was created.
	//
	// IdentityCenterApplicationArn is a required field
	IdentityCenterApplicationArn *string `locationName:"identityCenterApplicationArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible
	// for authenticating monitor users.
	//
	// IdentityCenterInstanceArn is a required field
	IdentityCenterInstanceArn *string `locationName:"identityCenterInstanceArn" type:"string" required:"true"`

	// The unique identifier for the monitor.
	//
	// MonitorId is a required field
	MonitorId *string `locationName:"monitorId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of
	// the monitor use this role to access Deadline Cloud resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// Subdomain is a required field
	Subdomain *string `locationName:"subdomain" type:"string" required:"true"`

	// The UNIX timestamp of the last date and time that the monitor was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user name of the person that last updated the monitor.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMonitorOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetMonitorOutput) SetCreatedAt(v time.Time) *GetMonitorOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetMonitorOutput) SetCreatedBy(v string) *GetMonitorOutput {
	s.CreatedBy = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetMonitorOutput) SetDisplayName(v string) *GetMonitorOutput {
	s.DisplayName = &v
	return s
}

// SetIdentityCenterApplicationArn sets the IdentityCenterApplicationArn field's value.
func (s *GetMonitorOutput) SetIdentityCenterApplicationArn(v string) *GetMonitorOutput {
	s.IdentityCenterApplicationArn = &v
	return s
}

// SetIdentityCenterInstanceArn sets the IdentityCenterInstanceArn field's value.
func (s *GetMonitorOutput) SetIdentityCenterInstanceArn(v string) *GetMonitorOutput {
	s.IdentityCenterInstanceArn = &v
	return s
}

// SetMonitorId sets the MonitorId field's value.
func (s *GetMonitorOutput) SetMonitorId(v string) *GetMonitorOutput {
	s.MonitorId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetMonitorOutput) SetRoleArn(v string) *GetMonitorOutput {
	s.RoleArn = &v
	return s
}

// SetSubdomain sets the Subdomain field's value.
func (s *GetMonitorOutput) SetSubdomain(v string) *GetMonitorOutput {
	s.Subdomain = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetMonitorOutput) SetUpdatedAt(v time.Time) *GetMonitorOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetMonitorOutput) SetUpdatedBy(v string) *GetMonitorOutput {
	s.UpdatedBy = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *GetMonitorOutput) SetUrl(v string) *GetMonitorOutput {
	s.Url = &v
	return s
}

type GetQueueEnvironmentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue environment.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue environment ID.
	//
	// QueueEnvironmentId is a required field
	QueueEnvironmentId *string `location:"uri" locationName:"queueEnvironmentId" type:"string" required:"true"`

	// The queue ID for the queue environment.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueueEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueueEnvironmentInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueEnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueEnvironmentId"))
	}
	if s.QueueEnvironmentId != nil && len(*s.QueueEnvironmentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueEnvironmentId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetQueueEnvironmentInput) SetFarmId(v string) *GetQueueEnvironmentInput {
	s.FarmId = &v
	return s
}

// SetQueueEnvironmentId sets the QueueEnvironmentId field's value.
func (s *GetQueueEnvironmentInput) SetQueueEnvironmentId(v string) *GetQueueEnvironmentInput {
	s.QueueEnvironmentId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetQueueEnvironmentInput) SetQueueId(v string) *GetQueueEnvironmentInput {
	s.QueueId = &v
	return s
}

type GetQueueEnvironmentOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.>
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The name of the queue environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The priority of the queue environment.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The queue environment ID.
	//
	// QueueEnvironmentId is a required field
	QueueEnvironmentId *string `locationName:"queueEnvironmentId" type:"string" required:"true"`

	// The template for the queue environment.
	//
	// Template is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetQueueEnvironmentOutput's
	// String and GoString methods.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true" sensitive:"true"`

	// The type of template for the queue environment.
	//
	// TemplateType is a required field
	TemplateType *string `locationName:"templateType" type:"string" required:"true" enum:"EnvironmentTemplateType"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueEnvironmentOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetQueueEnvironmentOutput) SetCreatedAt(v time.Time) *GetQueueEnvironmentOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetQueueEnvironmentOutput) SetCreatedBy(v string) *GetQueueEnvironmentOutput {
	s.CreatedBy = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetQueueEnvironmentOutput) SetName(v string) *GetQueueEnvironmentOutput {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *GetQueueEnvironmentOutput) SetPriority(v int64) *GetQueueEnvironmentOutput {
	s.Priority = &v
	return s
}

// SetQueueEnvironmentId sets the QueueEnvironmentId field's value.
func (s *GetQueueEnvironmentOutput) SetQueueEnvironmentId(v string) *GetQueueEnvironmentOutput {
	s.QueueEnvironmentId = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *GetQueueEnvironmentOutput) SetTemplate(v string) *GetQueueEnvironmentOutput {
	s.Template = &v
	return s
}

// SetTemplateType sets the TemplateType field's value.
func (s *GetQueueEnvironmentOutput) SetTemplateType(v string) *GetQueueEnvironmentOutput {
	s.TemplateType = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetQueueEnvironmentOutput) SetUpdatedAt(v time.Time) *GetQueueEnvironmentOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetQueueEnvironmentOutput) SetUpdatedBy(v string) *GetQueueEnvironmentOutput {
	s.UpdatedBy = &v
	return s
}

type GetQueueFleetAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm that contains the queue-fleet association.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID for the queue-fleet association.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The queue ID for the queue-fleet association.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueFleetAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueFleetAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueueFleetAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueueFleetAssociationInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetQueueFleetAssociationInput) SetFarmId(v string) *GetQueueFleetAssociationInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetQueueFleetAssociationInput) SetFleetId(v string) *GetQueueFleetAssociationInput {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetQueueFleetAssociationInput) SetQueueId(v string) *GetQueueFleetAssociationInput {
	s.QueueId = &v
	return s
}

type GetQueueFleetAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The fleet ID for the queue-fleet association.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The queue ID for the queue-fleet association.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`

	// The status of the queue-fleet association.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QueueFleetAssociationStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueFleetAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueFleetAssociationOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetQueueFleetAssociationOutput) SetCreatedAt(v time.Time) *GetQueueFleetAssociationOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetQueueFleetAssociationOutput) SetCreatedBy(v string) *GetQueueFleetAssociationOutput {
	s.CreatedBy = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetQueueFleetAssociationOutput) SetFleetId(v string) *GetQueueFleetAssociationOutput {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetQueueFleetAssociationOutput) SetQueueId(v string) *GetQueueFleetAssociationOutput {
	s.QueueId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetQueueFleetAssociationOutput) SetStatus(v string) *GetQueueFleetAssociationOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetQueueFleetAssociationOutput) SetUpdatedAt(v time.Time) *GetQueueFleetAssociationOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetQueueFleetAssociationOutput) SetUpdatedBy(v string) *GetQueueFleetAssociationOutput {
	s.UpdatedBy = &v
	return s
}

type GetQueueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm in the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue ID for the queue to retrieve.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetQueueInput) SetFarmId(v string) *GetQueueInput {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetQueueInput) SetQueueId(v string) *GetQueueInput {
	s.QueueId = &v
	return s
}

type GetQueueOutput struct {
	_ struct{} `type:"structure"`

	// The storage profile IDs for the queue.
	AllowedStorageProfileIds []*string `locationName:"allowedStorageProfileIds" type:"list"`

	// The reason the queue was blocked.
	BlockedReason *string `locationName:"blockedReason" type:"string" enum:"QueueBlockedReason"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The default action taken on a queue if a budget wasn't configured.
	//
	// DefaultBudgetAction is a required field
	DefaultBudgetAction *string `locationName:"defaultBudgetAction" type:"string" required:"true" enum:"DefaultQueueBudgetAction"`

	// The description of the queue.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetQueueOutput's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The display name of the queue.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID for the queue.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The job attachment settings for the queue.
	JobAttachmentSettings *JobAttachmentSettings `locationName:"jobAttachmentSettings" type:"structure"`

	// The jobs in the queue ran as this specified POSIX user.
	JobRunAsUser *JobRunAsUser `locationName:"jobRunAsUser" type:"structure"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`

	// A list of the required file system location names in the queue.
	RequiredFileSystemLocationNames []*string `locationName:"requiredFileSystemLocationNames" type:"list"`

	// The IAM role ARN.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The status of the queue.
	//
	//    * ACTIVE–The queue is active.
	//
	//    * SCHEDULING–The queue is scheduling.
	//
	//    * SCHEDULING_BLOCKED–The queue scheduling is blocked. See the provided
	//    reason.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QueueStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetQueueOutput) GoString() string {
	return s.String()
}

// SetAllowedStorageProfileIds sets the AllowedStorageProfileIds field's value.
func (s *GetQueueOutput) SetAllowedStorageProfileIds(v []*string) *GetQueueOutput {
	s.AllowedStorageProfileIds = v
	return s
}

// SetBlockedReason sets the BlockedReason field's value.
func (s *GetQueueOutput) SetBlockedReason(v string) *GetQueueOutput {
	s.BlockedReason = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetQueueOutput) SetCreatedAt(v time.Time) *GetQueueOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetQueueOutput) SetCreatedBy(v string) *GetQueueOutput {
	s.CreatedBy = &v
	return s
}

// SetDefaultBudgetAction sets the DefaultBudgetAction field's value.
func (s *GetQueueOutput) SetDefaultBudgetAction(v string) *GetQueueOutput {
	s.DefaultBudgetAction = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetQueueOutput) SetDescription(v string) *GetQueueOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetQueueOutput) SetDisplayName(v string) *GetQueueOutput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetQueueOutput) SetFarmId(v string) *GetQueueOutput {
	s.FarmId = &v
	return s
}

// SetJobAttachmentSettings sets the JobAttachmentSettings field's value.
func (s *GetQueueOutput) SetJobAttachmentSettings(v *JobAttachmentSettings) *GetQueueOutput {
	s.JobAttachmentSettings = v
	return s
}

// SetJobRunAsUser sets the JobRunAsUser field's value.
func (s *GetQueueOutput) SetJobRunAsUser(v *JobRunAsUser) *GetQueueOutput {
	s.JobRunAsUser = v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetQueueOutput) SetQueueId(v string) *GetQueueOutput {
	s.QueueId = &v
	return s
}

// SetRequiredFileSystemLocationNames sets the RequiredFileSystemLocationNames field's value.
func (s *GetQueueOutput) SetRequiredFileSystemLocationNames(v []*string) *GetQueueOutput {
	s.RequiredFileSystemLocationNames = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *GetQueueOutput) SetRoleArn(v string) *GetQueueOutput {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetQueueOutput) SetStatus(v string) *GetQueueOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetQueueOutput) SetUpdatedAt(v time.Time) *GetQueueOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetQueueOutput) SetUpdatedBy(v string) *GetQueueOutput {
	s.UpdatedBy = &v
	return s
}

type GetSessionActionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the session action.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the session.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID for the session action.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The session action ID for the session.
	//
	// SessionActionId is a required field
	SessionActionId *string `location:"uri" locationName:"sessionActionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionActionInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.SessionActionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionActionId"))
	}
	if s.SessionActionId != nil && len(*s.SessionActionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionActionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetSessionActionInput) SetFarmId(v string) *GetSessionActionInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetSessionActionInput) SetJobId(v string) *GetSessionActionInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetSessionActionInput) SetQueueId(v string) *GetSessionActionInput {
	s.QueueId = &v
	return s
}

// SetSessionActionId sets the SessionActionId field's value.
func (s *GetSessionActionInput) SetSessionActionId(v string) *GetSessionActionInput {
	s.SessionActionId = &v
	return s
}

type GetSessionActionOutput struct {
	_ struct{} `type:"structure"`

	// The session action definition.
	//
	// Definition is a required field
	Definition *SessionActionDefinition `locationName:"definition" type:"structure" required:"true"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The exit code to exit the session.
	ProcessExitCode *int64 `locationName:"processExitCode" type:"integer"`

	// The message that communicates the progress of the session action.
	//
	// ProgressMessage is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetSessionActionOutput's
	// String and GoString methods.
	ProgressMessage *string `locationName:"progressMessage" type:"string" sensitive:"true"`

	// The percentage completed for a session action.
	ProgressPercent *float64 `locationName:"progressPercent" type:"float"`

	// The session action ID.
	//
	// SessionActionId is a required field
	SessionActionId *string `locationName:"sessionActionId" type:"string" required:"true"`

	// The session ID for the session action.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The status of the session action.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SessionActionStatus"`

	// The Linux timestamp of the date and time the session action was last updated.
	WorkerUpdatedAt *time.Time `locationName:"workerUpdatedAt" type:"timestamp" timestampFormat:"iso8601"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionActionOutput) GoString() string {
	return s.String()
}

// SetDefinition sets the Definition field's value.
func (s *GetSessionActionOutput) SetDefinition(v *SessionActionDefinition) *GetSessionActionOutput {
	s.Definition = v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetSessionActionOutput) SetEndedAt(v time.Time) *GetSessionActionOutput {
	s.EndedAt = &v
	return s
}

// SetProcessExitCode sets the ProcessExitCode field's value.
func (s *GetSessionActionOutput) SetProcessExitCode(v int64) *GetSessionActionOutput {
	s.ProcessExitCode = &v
	return s
}

// SetProgressMessage sets the ProgressMessage field's value.
func (s *GetSessionActionOutput) SetProgressMessage(v string) *GetSessionActionOutput {
	s.ProgressMessage = &v
	return s
}

// SetProgressPercent sets the ProgressPercent field's value.
func (s *GetSessionActionOutput) SetProgressPercent(v float64) *GetSessionActionOutput {
	s.ProgressPercent = &v
	return s
}

// SetSessionActionId sets the SessionActionId field's value.
func (s *GetSessionActionOutput) SetSessionActionId(v string) *GetSessionActionOutput {
	s.SessionActionId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionActionOutput) SetSessionId(v string) *GetSessionActionOutput {
	s.SessionId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetSessionActionOutput) SetStartedAt(v time.Time) *GetSessionActionOutput {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSessionActionOutput) SetStatus(v string) *GetSessionActionOutput {
	s.Status = &v
	return s
}

// SetWorkerUpdatedAt sets the WorkerUpdatedAt field's value.
func (s *GetSessionActionOutput) SetWorkerUpdatedAt(v time.Time) *GetSessionActionOutput {
	s.WorkerUpdatedAt = &v
	return s
}

type GetSessionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the session.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the session.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID for the session.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The session ID.
	//
	// SessionId is a required field
	SessionId *string `location:"uri" locationName:"sessionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.SessionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetSessionInput) SetFarmId(v string) *GetSessionInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetSessionInput) SetJobId(v string) *GetSessionInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetSessionInput) SetQueueId(v string) *GetSessionInput {
	s.QueueId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionInput) SetSessionId(v string) *GetSessionInput {
	s.SessionId = &v
	return s
}

type GetSessionOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The fleet ID for the session.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// Provides the Amazon EC2 properties of the host.
	HostProperties *HostPropertiesResponse `locationName:"hostProperties" type:"structure"`

	// The life cycle status of the session.
	//
	// LifecycleStatus is a required field
	LifecycleStatus *string `locationName:"lifecycleStatus" type:"string" required:"true" enum:"SessionLifecycleStatus"`

	// The session log.
	//
	// Log is a required field
	Log *LogConfiguration `locationName:"log" type:"structure" required:"true"`

	// The session ID.
	//
	// SessionId is a required field
	SessionId *string `locationName:"sessionId" type:"string" required:"true"`

	// The date and time the resource started running.
	//
	// StartedAt is a required field
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The life cycle status with which the session started.
	TargetLifecycleStatus *string `locationName:"targetLifecycleStatus" type:"string" enum:"SessionLifecycleTargetStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The worker ID for the session.
	//
	// WorkerId is a required field
	WorkerId *string `locationName:"workerId" type:"string" required:"true"`

	// The worker log for the session.
	WorkerLog *LogConfiguration `locationName:"workerLog" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionOutput) GoString() string {
	return s.String()
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetSessionOutput) SetEndedAt(v time.Time) *GetSessionOutput {
	s.EndedAt = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetSessionOutput) SetFleetId(v string) *GetSessionOutput {
	s.FleetId = &v
	return s
}

// SetHostProperties sets the HostProperties field's value.
func (s *GetSessionOutput) SetHostProperties(v *HostPropertiesResponse) *GetSessionOutput {
	s.HostProperties = v
	return s
}

// SetLifecycleStatus sets the LifecycleStatus field's value.
func (s *GetSessionOutput) SetLifecycleStatus(v string) *GetSessionOutput {
	s.LifecycleStatus = &v
	return s
}

// SetLog sets the Log field's value.
func (s *GetSessionOutput) SetLog(v *LogConfiguration) *GetSessionOutput {
	s.Log = v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *GetSessionOutput) SetSessionId(v string) *GetSessionOutput {
	s.SessionId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetSessionOutput) SetStartedAt(v time.Time) *GetSessionOutput {
	s.StartedAt = &v
	return s
}

// SetTargetLifecycleStatus sets the TargetLifecycleStatus field's value.
func (s *GetSessionOutput) SetTargetLifecycleStatus(v string) *GetSessionOutput {
	s.TargetLifecycleStatus = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetSessionOutput) SetUpdatedAt(v time.Time) *GetSessionOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetSessionOutput) SetUpdatedBy(v string) *GetSessionOutput {
	s.UpdatedBy = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *GetSessionOutput) SetWorkerId(v string) *GetSessionOutput {
	s.WorkerId = &v
	return s
}

// SetWorkerLog sets the WorkerLog field's value.
func (s *GetSessionOutput) SetWorkerLog(v *LogConfiguration) *GetSessionOutput {
	s.WorkerLog = v
	return s
}

type GetSessionsStatisticsAggregationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier returned by the StartSessionsStatisticsAggregation operation
	// that identifies the aggregated statistics.
	//
	// AggregationId is a required field
	AggregationId *string `location:"querystring" locationName:"aggregationId" type:"string" required:"true"`

	// The identifier of the farm to include in the statistics. This should be the
	// same as the farm ID used in the call to the StartSessionsStatisticsAggregation
	// operation.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionsStatisticsAggregationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionsStatisticsAggregationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSessionsStatisticsAggregationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSessionsStatisticsAggregationInput"}
	if s.AggregationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AggregationId"))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAggregationId sets the AggregationId field's value.
func (s *GetSessionsStatisticsAggregationInput) SetAggregationId(v string) *GetSessionsStatisticsAggregationInput {
	s.AggregationId = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetSessionsStatisticsAggregationInput) SetFarmId(v string) *GetSessionsStatisticsAggregationInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetSessionsStatisticsAggregationInput) SetMaxResults(v int64) *GetSessionsStatisticsAggregationInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetSessionsStatisticsAggregationInput) SetNextToken(v string) *GetSessionsStatisticsAggregationInput {
	s.NextToken = &v
	return s
}

type GetSessionsStatisticsAggregationOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The statistics for the specified fleets or queues.
	Statistics []*Statistics `locationName:"statistics" type:"list"`

	// The status of the aggregated results.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"SessionsStatisticsAggregationStatus"`

	// A message that describes the status.
	StatusMessage *string `locationName:"statusMessage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionsStatisticsAggregationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSessionsStatisticsAggregationOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetSessionsStatisticsAggregationOutput) SetNextToken(v string) *GetSessionsStatisticsAggregationOutput {
	s.NextToken = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *GetSessionsStatisticsAggregationOutput) SetStatistics(v []*Statistics) *GetSessionsStatisticsAggregationOutput {
	s.Statistics = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSessionsStatisticsAggregationOutput) SetStatus(v string) *GetSessionsStatisticsAggregationOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetSessionsStatisticsAggregationOutput) SetStatusMessage(v string) *GetSessionsStatisticsAggregationOutput {
	s.StatusMessage = &v
	return s
}

type GetStepInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the step.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the step.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID for the step.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The step ID.
	//
	// StepId is a required field
	StepId *string `location:"uri" locationName:"stepId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStepInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStepInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStepInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}
	if s.StepId != nil && len(*s.StepId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetStepInput) SetFarmId(v string) *GetStepInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetStepInput) SetJobId(v string) *GetStepInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetStepInput) SetQueueId(v string) *GetStepInput {
	s.QueueId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *GetStepInput) SetStepId(v string) *GetStepInput {
	s.StepId = &v
	return s
}

type GetStepOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The number of dependencies in the step.
	DependencyCounts *DependencyCounts `locationName:"dependencyCounts" type:"structure"`

	// The description of the step.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetStepOutput's
	// String and GoString methods.
	Description *string `locationName:"description" min:"1" type:"string" sensitive:"true"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The life cycle status of the step.
	//
	// LifecycleStatus is a required field
	LifecycleStatus *string `locationName:"lifecycleStatus" type:"string" required:"true" enum:"StepLifecycleStatus"`

	// A message that describes the lifecycle status of the step.
	LifecycleStatusMessage *string `locationName:"lifecycleStatusMessage" type:"string"`

	// The name of the step.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A list of step parameters and the combination expression for the step.
	ParameterSpace *ParameterSpace `locationName:"parameterSpace" type:"structure"`

	// The required capabilities of the step.
	RequiredCapabilities *StepRequiredCapabilities `locationName:"requiredCapabilities" type:"structure"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The step ID.
	//
	// StepId is a required field
	StepId *string `locationName:"stepId" type:"string" required:"true"`

	// The task status with which the job started.
	TargetTaskRunStatus *string `locationName:"targetTaskRunStatus" type:"string" enum:"StepTargetTaskRunStatus"`

	// The task run status for the job.
	//
	// TaskRunStatus is a required field
	TaskRunStatus *string `locationName:"taskRunStatus" type:"string" required:"true" enum:"TaskRunStatus"`

	// The number of tasks running on the job.
	//
	// TaskRunStatusCounts is a required field
	TaskRunStatusCounts map[string]*int64 `locationName:"taskRunStatusCounts" type:"map" required:"true"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStepOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetStepOutput) SetCreatedAt(v time.Time) *GetStepOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetStepOutput) SetCreatedBy(v string) *GetStepOutput {
	s.CreatedBy = &v
	return s
}

// SetDependencyCounts sets the DependencyCounts field's value.
func (s *GetStepOutput) SetDependencyCounts(v *DependencyCounts) *GetStepOutput {
	s.DependencyCounts = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetStepOutput) SetDescription(v string) *GetStepOutput {
	s.Description = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetStepOutput) SetEndedAt(v time.Time) *GetStepOutput {
	s.EndedAt = &v
	return s
}

// SetLifecycleStatus sets the LifecycleStatus field's value.
func (s *GetStepOutput) SetLifecycleStatus(v string) *GetStepOutput {
	s.LifecycleStatus = &v
	return s
}

// SetLifecycleStatusMessage sets the LifecycleStatusMessage field's value.
func (s *GetStepOutput) SetLifecycleStatusMessage(v string) *GetStepOutput {
	s.LifecycleStatusMessage = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetStepOutput) SetName(v string) *GetStepOutput {
	s.Name = &v
	return s
}

// SetParameterSpace sets the ParameterSpace field's value.
func (s *GetStepOutput) SetParameterSpace(v *ParameterSpace) *GetStepOutput {
	s.ParameterSpace = v
	return s
}

// SetRequiredCapabilities sets the RequiredCapabilities field's value.
func (s *GetStepOutput) SetRequiredCapabilities(v *StepRequiredCapabilities) *GetStepOutput {
	s.RequiredCapabilities = v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetStepOutput) SetStartedAt(v time.Time) *GetStepOutput {
	s.StartedAt = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *GetStepOutput) SetStepId(v string) *GetStepOutput {
	s.StepId = &v
	return s
}

// SetTargetTaskRunStatus sets the TargetTaskRunStatus field's value.
func (s *GetStepOutput) SetTargetTaskRunStatus(v string) *GetStepOutput {
	s.TargetTaskRunStatus = &v
	return s
}

// SetTaskRunStatus sets the TaskRunStatus field's value.
func (s *GetStepOutput) SetTaskRunStatus(v string) *GetStepOutput {
	s.TaskRunStatus = &v
	return s
}

// SetTaskRunStatusCounts sets the TaskRunStatusCounts field's value.
func (s *GetStepOutput) SetTaskRunStatusCounts(v map[string]*int64) *GetStepOutput {
	s.TaskRunStatusCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetStepOutput) SetUpdatedAt(v time.Time) *GetStepOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetStepOutput) SetUpdatedBy(v string) *GetStepOutput {
	s.UpdatedBy = &v
	return s
}

type GetStorageProfileForQueueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue in storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The queue ID the queue in the storage profile.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The storage profile ID for the storage profile in the queue.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `location:"uri" locationName:"storageProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileForQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileForQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageProfileForQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageProfileForQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StorageProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageProfileId"))
	}
	if s.StorageProfileId != nil && len(*s.StorageProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetStorageProfileForQueueInput) SetFarmId(v string) *GetStorageProfileForQueueInput {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetStorageProfileForQueueInput) SetQueueId(v string) *GetStorageProfileForQueueInput {
	s.QueueId = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *GetStorageProfileForQueueInput) SetStorageProfileId(v string) *GetStorageProfileForQueueInput {
	s.StorageProfileId = &v
	return s
}

type GetStorageProfileForQueueOutput struct {
	_ struct{} `type:"structure"`

	// The display name of the storage profile connected to a queue.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The location of the files for the storage profile within the queue.
	FileSystemLocations []*FileSystemLocation `locationName:"fileSystemLocations" type:"list"`

	// The operating system of the storage profile in the queue.
	//
	// OsFamily is a required field
	OsFamily *string `locationName:"osFamily" type:"string" required:"true" enum:"StorageProfileOperatingSystemFamily"`

	// The storage profile ID.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `locationName:"storageProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileForQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileForQueueOutput) GoString() string {
	return s.String()
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetStorageProfileForQueueOutput) SetDisplayName(v string) *GetStorageProfileForQueueOutput {
	s.DisplayName = &v
	return s
}

// SetFileSystemLocations sets the FileSystemLocations field's value.
func (s *GetStorageProfileForQueueOutput) SetFileSystemLocations(v []*FileSystemLocation) *GetStorageProfileForQueueOutput {
	s.FileSystemLocations = v
	return s
}

// SetOsFamily sets the OsFamily field's value.
func (s *GetStorageProfileForQueueOutput) SetOsFamily(v string) *GetStorageProfileForQueueOutput {
	s.OsFamily = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *GetStorageProfileForQueueOutput) SetStorageProfileId(v string) *GetStorageProfileForQueueOutput {
	s.StorageProfileId = &v
	return s
}

type GetStorageProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The storage profile ID.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `location:"uri" locationName:"storageProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStorageProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStorageProfileInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.StorageProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageProfileId"))
	}
	if s.StorageProfileId != nil && len(*s.StorageProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StorageProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetStorageProfileInput) SetFarmId(v string) *GetStorageProfileInput {
	s.FarmId = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *GetStorageProfileInput) SetStorageProfileId(v string) *GetStorageProfileInput {
	s.StorageProfileId = &v
	return s
}

type GetStorageProfileOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The display name of the storage profile.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The location of the files for the storage profile.
	FileSystemLocations []*FileSystemLocation `locationName:"fileSystemLocations" type:"list"`

	// The operating system (OS) for the storage profile.
	//
	// OsFamily is a required field
	OsFamily *string `locationName:"osFamily" type:"string" required:"true" enum:"StorageProfileOperatingSystemFamily"`

	// The storage profile ID.
	//
	// StorageProfileId is a required field
	StorageProfileId *string `locationName:"storageProfileId" type:"string" required:"true"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStorageProfileOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetStorageProfileOutput) SetCreatedAt(v time.Time) *GetStorageProfileOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetStorageProfileOutput) SetCreatedBy(v string) *GetStorageProfileOutput {
	s.CreatedBy = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *GetStorageProfileOutput) SetDisplayName(v string) *GetStorageProfileOutput {
	s.DisplayName = &v
	return s
}

// SetFileSystemLocations sets the FileSystemLocations field's value.
func (s *GetStorageProfileOutput) SetFileSystemLocations(v []*FileSystemLocation) *GetStorageProfileOutput {
	s.FileSystemLocations = v
	return s
}

// SetOsFamily sets the OsFamily field's value.
func (s *GetStorageProfileOutput) SetOsFamily(v string) *GetStorageProfileOutput {
	s.OsFamily = &v
	return s
}

// SetStorageProfileId sets the StorageProfileId field's value.
func (s *GetStorageProfileOutput) SetStorageProfileId(v string) *GetStorageProfileOutput {
	s.StorageProfileId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetStorageProfileOutput) SetUpdatedAt(v time.Time) *GetStorageProfileOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetStorageProfileOutput) SetUpdatedBy(v string) *GetStorageProfileOutput {
	s.UpdatedBy = &v
	return s
}

type GetTaskInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the farm connected to the task.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID of the job connected to the task.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The queue ID for the queue connected to the task.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The step ID for the step connected to the task.
	//
	// StepId is a required field
	StepId *string `location:"uri" locationName:"stepId" type:"string" required:"true"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `location:"uri" locationName:"taskId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTaskInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}
	if s.StepId != nil && len(*s.StepId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepId", 1))
	}
	if s.TaskId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskId"))
	}
	if s.TaskId != nil && len(*s.TaskId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetTaskInput) SetFarmId(v string) *GetTaskInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *GetTaskInput) SetJobId(v string) *GetTaskInput {
	s.JobId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *GetTaskInput) SetQueueId(v string) *GetTaskInput {
	s.QueueId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *GetTaskInput) SetStepId(v string) *GetTaskInput {
	s.StepId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetTaskInput) SetTaskId(v string) *GetTaskInput {
	s.TaskId = &v
	return s
}

type GetTaskOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The number of times that the task failed and was retried.
	FailureRetryCount *int64 `locationName:"failureRetryCount" type:"integer"`

	// The latest session ID for the task.
	LatestSessionActionId *string `locationName:"latestSessionActionId" type:"string"`

	// The parameters for the task.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetTaskOutput's
	// String and GoString methods.
	Parameters map[string]*TaskParameterValue `locationName:"parameters" type:"map" sensitive:"true"`

	// The run status for the task.
	//
	// RunStatus is a required field
	RunStatus *string `locationName:"runStatus" type:"string" required:"true" enum:"TaskRunStatus"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The run status with which to start the task.
	TargetRunStatus *string `locationName:"targetRunStatus" type:"string" enum:"TaskTargetRunStatus"`

	// The task ID.
	//
	// TaskId is a required field
	TaskId *string `locationName:"taskId" type:"string" required:"true"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTaskOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetTaskOutput) SetCreatedAt(v time.Time) *GetTaskOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetTaskOutput) SetCreatedBy(v string) *GetTaskOutput {
	s.CreatedBy = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *GetTaskOutput) SetEndedAt(v time.Time) *GetTaskOutput {
	s.EndedAt = &v
	return s
}

// SetFailureRetryCount sets the FailureRetryCount field's value.
func (s *GetTaskOutput) SetFailureRetryCount(v int64) *GetTaskOutput {
	s.FailureRetryCount = &v
	return s
}

// SetLatestSessionActionId sets the LatestSessionActionId field's value.
func (s *GetTaskOutput) SetLatestSessionActionId(v string) *GetTaskOutput {
	s.LatestSessionActionId = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetTaskOutput) SetParameters(v map[string]*TaskParameterValue) *GetTaskOutput {
	s.Parameters = v
	return s
}

// SetRunStatus sets the RunStatus field's value.
func (s *GetTaskOutput) SetRunStatus(v string) *GetTaskOutput {
	s.RunStatus = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *GetTaskOutput) SetStartedAt(v time.Time) *GetTaskOutput {
	s.StartedAt = &v
	return s
}

// SetTargetRunStatus sets the TargetRunStatus field's value.
func (s *GetTaskOutput) SetTargetRunStatus(v string) *GetTaskOutput {
	s.TargetRunStatus = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *GetTaskOutput) SetTaskId(v string) *GetTaskOutput {
	s.TaskId = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetTaskOutput) SetUpdatedAt(v time.Time) *GetTaskOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetTaskOutput) SetUpdatedBy(v string) *GetTaskOutput {
	s.UpdatedBy = &v
	return s
}

type GetWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the worker.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the worker.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The worker ID.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkerInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *GetWorkerInput) SetFarmId(v string) *GetWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetWorkerInput) SetFleetId(v string) *GetWorkerInput {
	s.FleetId = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *GetWorkerInput) SetWorkerId(v string) *GetWorkerInput {
	s.WorkerId = &v
	return s
}

type GetWorkerOutput struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The host properties for the worker.
	HostProperties *HostPropertiesResponse `locationName:"hostProperties" type:"structure"`

	// The logs for the associated worker.
	Log *LogConfiguration `locationName:"log" type:"structure"`

	// The status of the worker.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"WorkerStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The worker ID.
	//
	// WorkerId is a required field
	WorkerId *string `locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkerOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetWorkerOutput) SetCreatedAt(v time.Time) *GetWorkerOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetWorkerOutput) SetCreatedBy(v string) *GetWorkerOutput {
	s.CreatedBy = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *GetWorkerOutput) SetFarmId(v string) *GetWorkerOutput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *GetWorkerOutput) SetFleetId(v string) *GetWorkerOutput {
	s.FleetId = &v
	return s
}

// SetHostProperties sets the HostProperties field's value.
func (s *GetWorkerOutput) SetHostProperties(v *HostPropertiesResponse) *GetWorkerOutput {
	s.HostProperties = v
	return s
}

// SetLog sets the Log field's value.
func (s *GetWorkerOutput) SetLog(v *LogConfiguration) *GetWorkerOutput {
	s.Log = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetWorkerOutput) SetStatus(v string) *GetWorkerOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *GetWorkerOutput) SetUpdatedAt(v time.Time) *GetWorkerOutput {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *GetWorkerOutput) SetUpdatedBy(v string) *GetWorkerOutput {
	s.UpdatedBy = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *GetWorkerOutput) SetWorkerId(v string) *GetWorkerOutput {
	s.WorkerId = &v
	return s
}

// The host property details.
type HostPropertiesRequest struct {
	_ struct{} `type:"structure"`

	// The host name.
	HostName *string `locationName:"hostName" type:"string"`

	// The IP address of the host.
	IpAddresses *IpAddresses `locationName:"ipAddresses" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostPropertiesRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostPropertiesRequest) GoString() string {
	return s.String()
}

// SetHostName sets the HostName field's value.
func (s *HostPropertiesRequest) SetHostName(v string) *HostPropertiesRequest {
	s.HostName = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *HostPropertiesRequest) SetIpAddresses(v *IpAddresses) *HostPropertiesRequest {
	s.IpAddresses = v
	return s
}

// The host property details.
type HostPropertiesResponse struct {
	_ struct{} `type:"structure"`

	// The ARN of the host EC2 instance.
	Ec2InstanceArn *string `locationName:"ec2InstanceArn" type:"string"`

	// The instance type of the host EC2 instance.
	Ec2InstanceType *string `locationName:"ec2InstanceType" type:"string"`

	// The host name.
	HostName *string `locationName:"hostName" type:"string"`

	// The IP address of the host.
	IpAddresses *IpAddresses `locationName:"ipAddresses" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostPropertiesResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HostPropertiesResponse) GoString() string {
	return s.String()
}

// SetEc2InstanceArn sets the Ec2InstanceArn field's value.
func (s *HostPropertiesResponse) SetEc2InstanceArn(v string) *HostPropertiesResponse {
	s.Ec2InstanceArn = &v
	return s
}

// SetEc2InstanceType sets the Ec2InstanceType field's value.
func (s *HostPropertiesResponse) SetEc2InstanceType(v string) *HostPropertiesResponse {
	s.Ec2InstanceType = &v
	return s
}

// SetHostName sets the HostName field's value.
func (s *HostPropertiesResponse) SetHostName(v string) *HostPropertiesResponse {
	s.HostName = &v
	return s
}

// SetIpAddresses sets the IpAddresses field's value.
func (s *HostPropertiesResponse) SetIpAddresses(v *IpAddresses) *HostPropertiesResponse {
	s.IpAddresses = v
	return s
}

// Deadline Cloud can't process your request right now. Try again later.
type InternalServerErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds a client should wait before retrying the request.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServerErrorException(v protocol.ResponseMetadata) error {
	return &InternalServerErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerErrorException) Code() string {
	return "InternalServerErrorException"
}

// Message returns the exception's message.
func (s *InternalServerErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerErrorException) OrigErr() error {
	return nil
}

func (s *InternalServerErrorException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The IP addresses for a host.
type IpAddresses struct {
	_ struct{} `type:"structure"`

	// The IpV4 address of the network.
	IpV4Addresses []*string `locationName:"ipV4Addresses" type:"list"`

	// The IpV6 address for the network and node component.
	IpV6Addresses []*string `locationName:"ipV6Addresses" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddresses) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpAddresses) GoString() string {
	return s.String()
}

// SetIpV4Addresses sets the IpV4Addresses field's value.
func (s *IpAddresses) SetIpV4Addresses(v []*string) *IpAddresses {
	s.IpV4Addresses = v
	return s
}

// SetIpV6Addresses sets the IpV6Addresses field's value.
func (s *IpAddresses) SetIpV6Addresses(v []*string) *IpAddresses {
	s.IpV6Addresses = v
	return s
}

// The job attachments.
type JobAttachmentDetailsEntity struct {
	_ struct{} `type:"structure"`

	// The job attachments.
	//
	// Attachments is a required field
	Attachments *Attachments `locationName:"attachments" type:"structure" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsEntity) GoString() string {
	return s.String()
}

// SetAttachments sets the Attachments field's value.
func (s *JobAttachmentDetailsEntity) SetAttachments(v *Attachments) *JobAttachmentDetailsEntity {
	s.Attachments = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobAttachmentDetailsEntity) SetJobId(v string) *JobAttachmentDetailsEntity {
	s.JobId = &v
	return s
}

// The error details for job attachments.
type JobAttachmentDetailsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"JobEntityErrorCode"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The error message detailing the error's cause.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *JobAttachmentDetailsError) SetCode(v string) *JobAttachmentDetailsError {
	s.Code = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobAttachmentDetailsError) SetJobId(v string) *JobAttachmentDetailsError {
	s.JobId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *JobAttachmentDetailsError) SetMessage(v string) *JobAttachmentDetailsError {
	s.Message = &v
	return s
}

// Identifier details for job attachments.
type JobAttachmentDetailsIdentifiers struct {
	_ struct{} `type:"structure"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentDetailsIdentifiers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobAttachmentDetailsIdentifiers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobAttachmentDetailsIdentifiers"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *JobAttachmentDetailsIdentifiers) SetJobId(v string) *JobAttachmentDetailsIdentifiers {
	s.JobId = &v
	return s
}

// The job attachment settings. These are the Amazon S3 bucket name and the
// Amazon S3 prefix.
type JobAttachmentSettings struct {
	_ struct{} `type:"structure"`

	// The root prefix.
	//
	// RootPrefix is a required field
	RootPrefix *string `locationName:"rootPrefix" min:"1" type:"string" required:"true"`

	// The Amazon S3 bucket name.
	//
	// S3BucketName is a required field
	S3BucketName *string `locationName:"s3BucketName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobAttachmentSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobAttachmentSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobAttachmentSettings"}
	if s.RootPrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("RootPrefix"))
	}
	if s.RootPrefix != nil && len(*s.RootPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RootPrefix", 1))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}
	if s.S3BucketName != nil && len(*s.S3BucketName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3BucketName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRootPrefix sets the RootPrefix field's value.
func (s *JobAttachmentSettings) SetRootPrefix(v string) *JobAttachmentSettings {
	s.RootPrefix = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *JobAttachmentSettings) SetS3BucketName(v string) *JobAttachmentSettings {
	s.S3BucketName = &v
	return s
}

// The job details for a specific job.
type JobDetailsEntity struct {
	_ struct{} `type:"structure"`

	// The job attachment settings.
	JobAttachmentSettings *JobAttachmentSettings `locationName:"jobAttachmentSettings" type:"structure"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The user name and group that the job uses when run.
	JobRunAsUser *JobRunAsUser `locationName:"jobRunAsUser" type:"structure"`

	// The log group name.
	//
	// LogGroupName is a required field
	LogGroupName *string `locationName:"logGroupName" type:"string" required:"true"`

	// The parameters.
	//
	// Parameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by JobDetailsEntity's
	// String and GoString methods.
	Parameters map[string]*JobParameter `locationName:"parameters" type:"map" sensitive:"true"`

	// The path mapping rules.
	PathMappingRules []*PathMappingRule `locationName:"pathMappingRules" type:"list"`

	// The queue role ARN.
	QueueRoleArn *string `locationName:"queueRoleArn" type:"string"`

	// The schema version.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `locationName:"schemaVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsEntity) GoString() string {
	return s.String()
}

// SetJobAttachmentSettings sets the JobAttachmentSettings field's value.
func (s *JobDetailsEntity) SetJobAttachmentSettings(v *JobAttachmentSettings) *JobDetailsEntity {
	s.JobAttachmentSettings = v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDetailsEntity) SetJobId(v string) *JobDetailsEntity {
	s.JobId = &v
	return s
}

// SetJobRunAsUser sets the JobRunAsUser field's value.
func (s *JobDetailsEntity) SetJobRunAsUser(v *JobRunAsUser) *JobDetailsEntity {
	s.JobRunAsUser = v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *JobDetailsEntity) SetLogGroupName(v string) *JobDetailsEntity {
	s.LogGroupName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *JobDetailsEntity) SetParameters(v map[string]*JobParameter) *JobDetailsEntity {
	s.Parameters = v
	return s
}

// SetPathMappingRules sets the PathMappingRules field's value.
func (s *JobDetailsEntity) SetPathMappingRules(v []*PathMappingRule) *JobDetailsEntity {
	s.PathMappingRules = v
	return s
}

// SetQueueRoleArn sets the QueueRoleArn field's value.
func (s *JobDetailsEntity) SetQueueRoleArn(v string) *JobDetailsEntity {
	s.QueueRoleArn = &v
	return s
}

// SetSchemaVersion sets the SchemaVersion field's value.
func (s *JobDetailsEntity) SetSchemaVersion(v string) *JobDetailsEntity {
	s.SchemaVersion = &v
	return s
}

// The details of a job error.
type JobDetailsError struct {
	_ struct{} `type:"structure"`

	// The error code.
	//
	// Code is a required field
	Code *string `locationName:"code" type:"string" required:"true" enum:"JobEntityErrorCode"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The error message detailing the error's cause.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsError) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *JobDetailsError) SetCode(v string) *JobDetailsError {
	s.Code = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobDetailsError) SetJobId(v string) *JobDetailsError {
	s.JobId = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *JobDetailsError) SetMessage(v string) *JobDetailsError {
	s.Message = &v
	return s
}

// The identifiers for a job.
type JobDetailsIdentifiers struct {
	_ struct{} `type:"structure"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsIdentifiers) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobDetailsIdentifiers) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobDetailsIdentifiers) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobDetailsIdentifiers"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *JobDetailsIdentifiers) SetJobId(v string) *JobDetailsIdentifiers {
	s.JobId = &v
	return s
}

// The details of a job entity.
type JobEntity struct {
	_ struct{} `type:"structure"`

	// The job attachment details.
	JobAttachmentDetails *JobAttachmentDetailsEntity `locationName:"jobAttachmentDetails" type:"structure"`

	// The job details.
	JobDetails *JobDetailsEntity `locationName:"jobDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntity) GoString() string {
	return s.String()
}

// SetJobAttachmentDetails sets the JobAttachmentDetails field's value.
func (s *JobEntity) SetJobAttachmentDetails(v *JobAttachmentDetailsEntity) *JobEntity {
	s.JobAttachmentDetails = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *JobEntity) SetJobDetails(v *JobDetailsEntity) *JobEntity {
	s.JobDetails = v
	return s
}

// The details of a job entity identifier.
type JobEntityIdentifiersUnion struct {
	_ struct{} `type:"structure"`

	// The environment details.
	EnvironmentDetails *EnvironmentDetailsIdentifiers `locationName:"environmentDetails" type:"structure"`

	// The job attachment details.
	JobAttachmentDetails *JobAttachmentDetailsIdentifiers `locationName:"jobAttachmentDetails" type:"structure"`

	// The job details.
	JobDetails *JobDetailsIdentifiers `locationName:"jobDetails" type:"structure"`

	// The step details.
	StepDetails *StepDetailsIdentifiers `locationName:"stepDetails" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntityIdentifiersUnion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobEntityIdentifiersUnion) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobEntityIdentifiersUnion) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobEntityIdentifiersUnion"}
	if s.EnvironmentDetails != nil {
		if err := s.EnvironmentDetails.Validate(); err != nil {
			invalidParams.AddNested("EnvironmentDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.JobAttachmentDetails != nil {
		if err := s.JobAttachmentDetails.Validate(); err != nil {
			invalidParams.AddNested("JobAttachmentDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.JobDetails != nil {
		if err := s.JobDetails.Validate(); err != nil {
			invalidParams.AddNested("JobDetails", err.(request.ErrInvalidParams))
		}
	}
	if s.StepDetails != nil {
		if err := s.StepDetails.Validate(); err != nil {
			invalidParams.AddNested("StepDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentDetails sets the EnvironmentDetails field's value.
func (s *JobEntityIdentifiersUnion) SetEnvironmentDetails(v *EnvironmentDetailsIdentifiers) *JobEntityIdentifiersUnion {
	s.EnvironmentDetails = v
	return s
}

// SetJobAttachmentDetails sets the JobAttachmentDetails field's value.
func (s *JobEntityIdentifiersUnion) SetJobAttachmentDetails(v *JobAttachmentDetailsIdentifiers) *JobEntityIdentifiersUnion {
	s.JobAttachmentDetails = v
	return s
}

// SetJobDetails sets the JobDetails field's value.
func (s *JobEntityIdentifiersUnion) SetJobDetails(v *JobDetailsIdentifiers) *JobEntityIdentifiersUnion {
	s.JobDetails = v
	return s
}

// SetStepDetails sets the StepDetails field's value.
func (s *JobEntityIdentifiersUnion) SetStepDetails(v *StepDetailsIdentifiers) *JobEntityIdentifiersUnion {
	s.StepDetails = v
	return s
}

// The details for a job member.
type JobMember struct {
	_ struct{} `type:"structure"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The identity store ID.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The job member's membership level.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The principal ID of the job member.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" min:"1" type:"string" required:"true"`

	// The principal type of the job member.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobMember) GoString() string {
	return s.String()
}

// SetFarmId sets the FarmId field's value.
func (s *JobMember) SetFarmId(v string) *JobMember {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *JobMember) SetIdentityStoreId(v string) *JobMember {
	s.IdentityStoreId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobMember) SetJobId(v string) *JobMember {
	s.JobId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *JobMember) SetMembershipLevel(v string) *JobMember {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *JobMember) SetPrincipalId(v string) *JobMember {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *JobMember) SetPrincipalType(v string) *JobMember {
	s.PrincipalType = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *JobMember) SetQueueId(v string) *JobMember {
	s.QueueId = &v
	return s
}

// The details of job parameters.
type JobParameter struct {
	_ struct{} `type:"structure"`

	// A double precision IEEE-754 floating point number represented as a string.
	Float *string `locationName:"float" min:"1" type:"string"`

	// A signed integer represented as a string.
	Int *string `locationName:"int" min:"1" type:"string"`

	// A file system path represented as a string.
	Path *string `locationName:"path" type:"string"`

	// A UTF-8 string.
	String_ *string `locationName:"string" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobParameter"}
	if s.Float != nil && len(*s.Float) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Float", 1))
	}
	if s.Int != nil && len(*s.Int) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Int", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFloat sets the Float field's value.
func (s *JobParameter) SetFloat(v string) *JobParameter {
	s.Float = &v
	return s
}

// SetInt sets the Int field's value.
func (s *JobParameter) SetInt(v string) *JobParameter {
	s.Int = &v
	return s
}

// SetPath sets the Path field's value.
func (s *JobParameter) SetPath(v string) *JobParameter {
	s.Path = &v
	return s
}

// SetString_ sets the String_ field's value.
func (s *JobParameter) SetString_(v string) *JobParameter {
	s.String_ = &v
	return s
}

// Identifies the user for a job.
type JobRunAsUser struct {
	_ struct{} `type:"structure"`

	// The user and group that the jobs in the queue run as.
	Posix *PosixUser `locationName:"posix" type:"structure"`

	// Specifies whether the job should run using the queue's system user or if
	// the job should run using the worker agent system user.
	//
	// RunAs is a required field
	RunAs *string `locationName:"runAs" type:"string" required:"true" enum:"RunAs"`

	// Identifies a Microsoft Windows user.
	Windows *WindowsUser `locationName:"windows" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRunAsUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobRunAsUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *JobRunAsUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "JobRunAsUser"}
	if s.RunAs == nil {
		invalidParams.Add(request.NewErrParamRequired("RunAs"))
	}
	if s.Posix != nil {
		if err := s.Posix.Validate(); err != nil {
			invalidParams.AddNested("Posix", err.(request.ErrInvalidParams))
		}
	}
	if s.Windows != nil {
		if err := s.Windows.Validate(); err != nil {
			invalidParams.AddNested("Windows", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPosix sets the Posix field's value.
func (s *JobRunAsUser) SetPosix(v *PosixUser) *JobRunAsUser {
	s.Posix = v
	return s
}

// SetRunAs sets the RunAs field's value.
func (s *JobRunAsUser) SetRunAs(v string) *JobRunAsUser {
	s.RunAs = &v
	return s
}

// SetWindows sets the Windows field's value.
func (s *JobRunAsUser) SetWindows(v *WindowsUser) *JobRunAsUser {
	s.Windows = v
	return s
}

// The details of a job search.
type JobSearchSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that created this resource.
	CreatedBy *string `locationName:"createdBy" type:"string"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The job ID.
	JobId *string `locationName:"jobId" type:"string"`

	// The job parameters.
	//
	// JobParameters is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by JobSearchSummary's
	// String and GoString methods.
	JobParameters map[string]*JobParameter `locationName:"jobParameters" type:"map" sensitive:"true"`

	// The life cycle status.
	LifecycleStatus *string `locationName:"lifecycleStatus" type:"string" enum:"JobLifecycleStatus"`

	// The life cycle status message.
	LifecycleStatusMessage *string `locationName:"lifecycleStatusMessage" type:"string"`

	// The number of task failures before the job stops running and is marked as
	// FAILED.
	MaxFailedTasksCount *int64 `locationName:"maxFailedTasksCount" type:"integer"`

	// The maximum number of retries for a job.
	MaxRetriesPerTask *int64 `locationName:"maxRetriesPerTask" type:"integer"`

	// The job name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The job priority.
	Priority *int64 `locationName:"priority" type:"integer"`

	// The queue ID.
	QueueId *string `locationName:"queueId" type:"string"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The task status to start with on the job.
	TargetTaskRunStatus *string `locationName:"targetTaskRunStatus" type:"string" enum:"JobTargetTaskRunStatus"`

	// task run status for the job.
	//
	//    * PENDING–pending and waiting for resources.
	//
	//    * READY–ready to be processed.
	//
	//    * ASSIGNED–assigned and will run next on a worker.
	//
	//    * SCHEDULED–scheduled to be run on a worker.
	//
	//    * INTERRUPTING–being interrupted.
	//
	//    * RUNNING–running on a worker.
	//
	//    * SUSPENDED–the task is suspended.
	//
	//    * CANCELED–the task has been canceled.
	//
	//    * FAILED–the task has failed.
	//
	//    * SUCCEEDED–the task has succeeded.
	TaskRunStatus *string `locationName:"taskRunStatus" type:"string" enum:"TaskRunStatus"`

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]*int64 `locationName:"taskRunStatusCounts" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSearchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSearchSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobSearchSummary) SetCreatedAt(v time.Time) *JobSearchSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *JobSearchSummary) SetCreatedBy(v string) *JobSearchSummary {
	s.CreatedBy = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *JobSearchSummary) SetEndedAt(v time.Time) *JobSearchSummary {
	s.EndedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSearchSummary) SetJobId(v string) *JobSearchSummary {
	s.JobId = &v
	return s
}

// SetJobParameters sets the JobParameters field's value.
func (s *JobSearchSummary) SetJobParameters(v map[string]*JobParameter) *JobSearchSummary {
	s.JobParameters = v
	return s
}

// SetLifecycleStatus sets the LifecycleStatus field's value.
func (s *JobSearchSummary) SetLifecycleStatus(v string) *JobSearchSummary {
	s.LifecycleStatus = &v
	return s
}

// SetLifecycleStatusMessage sets the LifecycleStatusMessage field's value.
func (s *JobSearchSummary) SetLifecycleStatusMessage(v string) *JobSearchSummary {
	s.LifecycleStatusMessage = &v
	return s
}

// SetMaxFailedTasksCount sets the MaxFailedTasksCount field's value.
func (s *JobSearchSummary) SetMaxFailedTasksCount(v int64) *JobSearchSummary {
	s.MaxFailedTasksCount = &v
	return s
}

// SetMaxRetriesPerTask sets the MaxRetriesPerTask field's value.
func (s *JobSearchSummary) SetMaxRetriesPerTask(v int64) *JobSearchSummary {
	s.MaxRetriesPerTask = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobSearchSummary) SetName(v string) *JobSearchSummary {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobSearchSummary) SetPriority(v int64) *JobSearchSummary {
	s.Priority = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *JobSearchSummary) SetQueueId(v string) *JobSearchSummary {
	s.QueueId = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobSearchSummary) SetStartedAt(v time.Time) *JobSearchSummary {
	s.StartedAt = &v
	return s
}

// SetTargetTaskRunStatus sets the TargetTaskRunStatus field's value.
func (s *JobSearchSummary) SetTargetTaskRunStatus(v string) *JobSearchSummary {
	s.TargetTaskRunStatus = &v
	return s
}

// SetTaskRunStatus sets the TaskRunStatus field's value.
func (s *JobSearchSummary) SetTaskRunStatus(v string) *JobSearchSummary {
	s.TaskRunStatus = &v
	return s
}

// SetTaskRunStatusCounts sets the TaskRunStatusCounts field's value.
func (s *JobSearchSummary) SetTaskRunStatusCounts(v map[string]*int64) *JobSearchSummary {
	s.TaskRunStatusCounts = v
	return s
}

// A summary of job details.
type JobSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The date and time the resource ended running.
	EndedAt *time.Time `locationName:"endedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The job ID.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// The life cycle status.
	//
	// LifecycleStatus is a required field
	LifecycleStatus *string `locationName:"lifecycleStatus" type:"string" required:"true" enum:"JobLifecycleStatus"`

	// The life cycle status message.
	//
	// LifecycleStatusMessage is a required field
	LifecycleStatusMessage *string `locationName:"lifecycleStatusMessage" type:"string" required:"true"`

	// The number of task failures before the job stops running and is marked as
	// FAILED.
	MaxFailedTasksCount *int64 `locationName:"maxFailedTasksCount" type:"integer"`

	// The maximum number of retries for a job.
	MaxRetriesPerTask *int64 `locationName:"maxRetriesPerTask" type:"integer"`

	// The job name.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The job priority.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The date and time the resource started running.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The task status to start with on the job.
	TargetTaskRunStatus *string `locationName:"targetTaskRunStatus" type:"string" enum:"JobTargetTaskRunStatus"`

	// The task run status for the job.
	//
	//    * PENDING–pending and waiting for resources.
	//
	//    * READY–ready to be processed.
	//
	//    * ASSIGNED–assigned and will run next on a worker.
	//
	//    * SCHEDULED–scheduled to be run on a worker.
	//
	//    * INTERRUPTING–being interrupted.
	//
	//    * RUNNING–running on a worker.
	//
	//    * SUSPENDED–the task is suspended.
	//
	//    * CANCELED–the task has been canceled.
	//
	//    * FAILED–the task has failed.
	//
	//    * SUCCEEDED–the task has succeeded.
	TaskRunStatus *string `locationName:"taskRunStatus" type:"string" enum:"TaskRunStatus"`

	// The number of tasks running on the job.
	TaskRunStatusCounts map[string]*int64 `locationName:"taskRunStatusCounts" type:"map"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s JobSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *JobSummary) SetCreatedAt(v time.Time) *JobSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *JobSummary) SetCreatedBy(v string) *JobSummary {
	s.CreatedBy = &v
	return s
}

// SetEndedAt sets the EndedAt field's value.
func (s *JobSummary) SetEndedAt(v time.Time) *JobSummary {
	s.EndedAt = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *JobSummary) SetJobId(v string) *JobSummary {
	s.JobId = &v
	return s
}

// SetLifecycleStatus sets the LifecycleStatus field's value.
func (s *JobSummary) SetLifecycleStatus(v string) *JobSummary {
	s.LifecycleStatus = &v
	return s
}

// SetLifecycleStatusMessage sets the LifecycleStatusMessage field's value.
func (s *JobSummary) SetLifecycleStatusMessage(v string) *JobSummary {
	s.LifecycleStatusMessage = &v
	return s
}

// SetMaxFailedTasksCount sets the MaxFailedTasksCount field's value.
func (s *JobSummary) SetMaxFailedTasksCount(v int64) *JobSummary {
	s.MaxFailedTasksCount = &v
	return s
}

// SetMaxRetriesPerTask sets the MaxRetriesPerTask field's value.
func (s *JobSummary) SetMaxRetriesPerTask(v int64) *JobSummary {
	s.MaxRetriesPerTask = &v
	return s
}

// SetName sets the Name field's value.
func (s *JobSummary) SetName(v string) *JobSummary {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *JobSummary) SetPriority(v int64) *JobSummary {
	s.Priority = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *JobSummary) SetStartedAt(v time.Time) *JobSummary {
	s.StartedAt = &v
	return s
}

// SetTargetTaskRunStatus sets the TargetTaskRunStatus field's value.
func (s *JobSummary) SetTargetTaskRunStatus(v string) *JobSummary {
	s.TargetTaskRunStatus = &v
	return s
}

// SetTaskRunStatus sets the TaskRunStatus field's value.
func (s *JobSummary) SetTaskRunStatus(v string) *JobSummary {
	s.TaskRunStatus = &v
	return s
}

// SetTaskRunStatusCounts sets the TaskRunStatusCounts field's value.
func (s *JobSummary) SetTaskRunStatusCounts(v map[string]*int64) *JobSummary {
	s.TaskRunStatusCounts = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *JobSummary) SetUpdatedAt(v time.Time) *JobSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *JobSummary) SetUpdatedBy(v string) *JobSummary {
	s.UpdatedBy = &v
	return s
}

// The details for a license endpoint.
type LicenseEndpointSummary struct {
	_ struct{} `type:"structure"`

	// The license endpoint ID.
	LicenseEndpointId *string `locationName:"licenseEndpointId" type:"string"`

	// The status of the license endpoint.
	Status *string `locationName:"status" type:"string" enum:"LicenseEndpointStatus"`

	// The status message of the license endpoint.
	StatusMessage *string `locationName:"statusMessage" type:"string"`

	// The VCP(virtual private cloud) ID associated with the license endpoint.
	VpcId *string `locationName:"vpcId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseEndpointSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LicenseEndpointSummary) GoString() string {
	return s.String()
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *LicenseEndpointSummary) SetLicenseEndpointId(v string) *LicenseEndpointSummary {
	s.LicenseEndpointId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LicenseEndpointSummary) SetStatus(v string) *LicenseEndpointSummary {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *LicenseEndpointSummary) SetStatusMessage(v string) *LicenseEndpointSummary {
	s.StatusMessage = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *LicenseEndpointSummary) SetVpcId(v string) *LicenseEndpointSummary {
	s.VpcId = &v
	return s
}

type ListAvailableMeteredProductsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableMeteredProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableMeteredProductsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableMeteredProductsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableMeteredProductsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableMeteredProductsInput) SetMaxResults(v int64) *ListAvailableMeteredProductsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableMeteredProductsInput) SetNextToken(v string) *ListAvailableMeteredProductsInput {
	s.NextToken = &v
	return s
}

type ListAvailableMeteredProductsOutput struct {
	_ struct{} `type:"structure"`

	// The metered products.
	//
	// MeteredProducts is a required field
	MeteredProducts []*MeteredProductSummary `locationName:"meteredProducts" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableMeteredProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableMeteredProductsOutput) GoString() string {
	return s.String()
}

// SetMeteredProducts sets the MeteredProducts field's value.
func (s *ListAvailableMeteredProductsOutput) SetMeteredProducts(v []*MeteredProductSummary) *ListAvailableMeteredProductsOutput {
	s.MeteredProducts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableMeteredProductsOutput) SetNextToken(v string) *ListAvailableMeteredProductsOutput {
	s.NextToken = &v
	return s
}

type ListBudgetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID associated with the budgets.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The status to list for the budgets.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"BudgetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBudgetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBudgetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBudgetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBudgetsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListBudgetsInput) SetFarmId(v string) *ListBudgetsInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBudgetsInput) SetMaxResults(v int64) *ListBudgetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBudgetsInput) SetNextToken(v string) *ListBudgetsInput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListBudgetsInput) SetStatus(v string) *ListBudgetsInput {
	s.Status = &v
	return s
}

type ListBudgetsOutput struct {
	_ struct{} `type:"structure"`

	// The budgets to include on the list.
	//
	// Budgets is a required field
	Budgets []*BudgetSummary `locationName:"budgets" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBudgetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBudgetsOutput) GoString() string {
	return s.String()
}

// SetBudgets sets the Budgets field's value.
func (s *ListBudgetsOutput) SetBudgets(v []*BudgetSummary) *ListBudgetsOutput {
	s.Budgets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBudgetsOutput) SetNextToken(v string) *ListBudgetsOutput {
	s.NextToken = &v
	return s
}

type ListFarmMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFarmMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFarmMembersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListFarmMembersInput) SetFarmId(v string) *ListFarmMembersInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFarmMembersInput) SetMaxResults(v int64) *ListFarmMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFarmMembersInput) SetNextToken(v string) *ListFarmMembersInput {
	s.NextToken = &v
	return s
}

type ListFarmMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members on the list.
	//
	// Members is a required field
	Members []*FarmMember `locationName:"members" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListFarmMembersOutput) SetMembers(v []*FarmMember) *ListFarmMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFarmMembersOutput) SetNextToken(v string) *ListFarmMembersOutput {
	s.NextToken = &v
	return s
}

type ListFarmsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal ID of the member to list on the farm.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFarmsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFarmsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFarmsInput) SetMaxResults(v int64) *ListFarmsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFarmsInput) SetNextToken(v string) *ListFarmsInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListFarmsInput) SetPrincipalId(v string) *ListFarmsInput {
	s.PrincipalId = &v
	return s
}

type ListFarmsOutput struct {
	_ struct{} `type:"structure"`

	// Farms on the list.
	//
	// Farms is a required field
	Farms []*FarmSummary `locationName:"farms" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFarmsOutput) GoString() string {
	return s.String()
}

// SetFarms sets the Farms field's value.
func (s *ListFarmsOutput) SetFarms(v []*FarmSummary) *ListFarmsOutput {
	s.Farms = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFarmsOutput) SetNextToken(v string) *ListFarmsOutput {
	s.NextToken = &v
	return s
}

type ListFleetMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the fleet.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID to include on the list.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetMembersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListFleetMembersInput) SetFarmId(v string) *ListFleetMembersInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ListFleetMembersInput) SetFleetId(v string) *ListFleetMembersInput {
	s.FleetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetMembersInput) SetMaxResults(v int64) *ListFleetMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetMembersInput) SetNextToken(v string) *ListFleetMembersInput {
	s.NextToken = &v
	return s
}

type ListFleetMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members on the list.
	//
	// Members is a required field
	Members []*FleetMember `locationName:"members" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListFleetMembersOutput) SetMembers(v []*FleetMember) *ListFleetMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetMembersOutput) SetNextToken(v string) *ListFleetMembersOutput {
	s.NextToken = &v
	return s
}

type ListFleetsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The display names of a list of fleets.
	DisplayName *string `location:"querystring" locationName:"displayName" min:"1" type:"string"`

	// The farm ID of the fleets.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal ID of the members to include in the fleet.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`

	// The status of the fleet.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"FleetStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.DisplayName != nil && len(*s.DisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DisplayName", 1))
	}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayName sets the DisplayName field's value.
func (s *ListFleetsInput) SetDisplayName(v string) *ListFleetsInput {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *ListFleetsInput) SetFarmId(v string) *ListFleetsInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetsInput) SetMaxResults(v int64) *ListFleetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListFleetsInput) SetPrincipalId(v string) *ListFleetsInput {
	s.PrincipalId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListFleetsInput) SetStatus(v string) *ListFleetsInput {
	s.Status = &v
	return s
}

type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The fleets on the list.
	//
	// Fleets is a required field
	Fleets []*FleetSummary `locationName:"fleets" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleets sets the Fleets field's value.
func (s *ListFleetsOutput) SetFleets(v []*FleetSummary) *ListFleetsOutput {
	s.Fleets = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

type ListJobMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the job to list.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID to include on the list.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID to include on the list.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobMembersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListJobMembersInput) SetFarmId(v string) *ListJobMembersInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListJobMembersInput) SetJobId(v string) *ListJobMembersInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobMembersInput) SetMaxResults(v int64) *ListJobMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobMembersInput) SetNextToken(v string) *ListJobMembersInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListJobMembersInput) SetQueueId(v string) *ListJobMembersInput {
	s.QueueId = &v
	return s
}

type ListJobMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members on the list.
	//
	// Members is a required field
	Members []*JobMember `locationName:"members" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListJobMembersOutput) SetMembers(v []*JobMember) *ListJobMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobMembersOutput) SetNextToken(v string) *ListJobMembersOutput {
	s.NextToken = &v
	return s
}

type ListJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the jobs.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal ID of the members on the jobs.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`

	// The queue ID for the job.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListJobsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListJobsInput) SetFarmId(v string) *ListJobsInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListJobsInput) SetMaxResults(v int64) *ListJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsInput) SetNextToken(v string) *ListJobsInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListJobsInput) SetPrincipalId(v string) *ListJobsInput {
	s.PrincipalId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListJobsInput) SetQueueId(v string) *ListJobsInput {
	s.QueueId = &v
	return s
}

type ListJobsOutput struct {
	_ struct{} `type:"structure"`

	// The jobs on the list.
	//
	// Jobs is a required field
	Jobs []*JobSummary `locationName:"jobs" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *ListJobsOutput) SetJobs(v []*JobSummary) *ListJobsOutput {
	s.Jobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListJobsOutput) SetNextToken(v string) *ListJobsOutput {
	s.NextToken = &v
	return s
}

type ListLicenseEndpointsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLicenseEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLicenseEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLicenseEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLicenseEndpointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLicenseEndpointsInput) SetMaxResults(v int64) *ListLicenseEndpointsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseEndpointsInput) SetNextToken(v string) *ListLicenseEndpointsInput {
	s.NextToken = &v
	return s
}

type ListLicenseEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// The license endpoints.
	//
	// LicenseEndpoints is a required field
	LicenseEndpoints []*LicenseEndpointSummary `locationName:"licenseEndpoints" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLicenseEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLicenseEndpointsOutput) GoString() string {
	return s.String()
}

// SetLicenseEndpoints sets the LicenseEndpoints field's value.
func (s *ListLicenseEndpointsOutput) SetLicenseEndpoints(v []*LicenseEndpointSummary) *ListLicenseEndpointsOutput {
	s.LicenseEndpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLicenseEndpointsOutput) SetNextToken(v string) *ListLicenseEndpointsOutput {
	s.NextToken = &v
	return s
}

type ListMeteredProductsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The license endpoint ID to include on the list of metered products.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `location:"uri" locationName:"licenseEndpointId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeteredProductsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeteredProductsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMeteredProductsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMeteredProductsInput"}
	if s.LicenseEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseEndpointId"))
	}
	if s.LicenseEndpointId != nil && len(*s.LicenseEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseEndpointId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *ListMeteredProductsInput) SetLicenseEndpointId(v string) *ListMeteredProductsInput {
	s.LicenseEndpointId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMeteredProductsInput) SetMaxResults(v int64) *ListMeteredProductsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeteredProductsInput) SetNextToken(v string) *ListMeteredProductsInput {
	s.NextToken = &v
	return s
}

type ListMeteredProductsOutput struct {
	_ struct{} `type:"structure"`

	// The metered products to list.
	//
	// MeteredProducts is a required field
	MeteredProducts []*MeteredProductSummary `locationName:"meteredProducts" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeteredProductsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMeteredProductsOutput) GoString() string {
	return s.String()
}

// SetMeteredProducts sets the MeteredProducts field's value.
func (s *ListMeteredProductsOutput) SetMeteredProducts(v []*MeteredProductSummary) *ListMeteredProductsOutput {
	s.MeteredProducts = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMeteredProductsOutput) SetNextToken(v string) *ListMeteredProductsOutput {
	s.NextToken = &v
	return s
}

type ListMonitorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMonitorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListMonitorsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListMonitorsInput) SetMaxResults(v int64) *ListMonitorsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsInput) SetNextToken(v string) *ListMonitorsInput {
	s.NextToken = &v
	return s
}

type ListMonitorsOutput struct {
	_ struct{} `type:"structure"`

	// A list of MonitorSummary objects that describe your monitors in the Deadline
	// Cloud.
	//
	// Monitors is a required field
	Monitors []*MonitorSummary `locationName:"monitors" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListMonitorsOutput) GoString() string {
	return s.String()
}

// SetMonitors sets the Monitors field's value.
func (s *ListMonitorsOutput) SetMonitors(v []*MonitorSummary) *ListMonitorsOutput {
	s.Monitors = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListMonitorsOutput) SetNextToken(v string) *ListMonitorsOutput {
	s.NextToken = &v
	return s
}

type ListQueueEnvironmentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue environment list.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the queue environment list.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueueEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueueEnvironmentsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListQueueEnvironmentsInput) SetFarmId(v string) *ListQueueEnvironmentsInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueueEnvironmentsInput) SetMaxResults(v int64) *ListQueueEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueEnvironmentsInput) SetNextToken(v string) *ListQueueEnvironmentsInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListQueueEnvironmentsInput) SetQueueId(v string) *ListQueueEnvironmentsInput {
	s.QueueId = &v
	return s
}

type ListQueueEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The environments to include in the queue environments list.
	//
	// Environments is a required field
	Environments []*QueueEnvironmentSummary `locationName:"environments" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *ListQueueEnvironmentsOutput) SetEnvironments(v []*QueueEnvironmentSummary) *ListQueueEnvironmentsOutput {
	s.Environments = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueEnvironmentsOutput) SetNextToken(v string) *ListQueueEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type ListQueueFleetAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue-fleet association list.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID for the queue-fleet association list.
	FleetId *string `location:"querystring" locationName:"fleetId" type:"string"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the queue-fleet association list.
	QueueId *string `location:"querystring" locationName:"queueId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueFleetAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueFleetAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueueFleetAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueueFleetAssociationsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListQueueFleetAssociationsInput) SetFarmId(v string) *ListQueueFleetAssociationsInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ListQueueFleetAssociationsInput) SetFleetId(v string) *ListQueueFleetAssociationsInput {
	s.FleetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueueFleetAssociationsInput) SetMaxResults(v int64) *ListQueueFleetAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueFleetAssociationsInput) SetNextToken(v string) *ListQueueFleetAssociationsInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListQueueFleetAssociationsInput) SetQueueId(v string) *ListQueueFleetAssociationsInput {
	s.QueueId = &v
	return s
}

type ListQueueFleetAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The queue-fleet associations on the list.
	//
	// QueueFleetAssociations is a required field
	QueueFleetAssociations []*QueueFleetAssociationSummary `locationName:"queueFleetAssociations" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueFleetAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueFleetAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueFleetAssociationsOutput) SetNextToken(v string) *ListQueueFleetAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetQueueFleetAssociations sets the QueueFleetAssociations field's value.
func (s *ListQueueFleetAssociationsOutput) SetQueueFleetAssociations(v []*QueueFleetAssociationSummary) *ListQueueFleetAssociationsOutput {
	s.QueueFleetAssociations = v
	return s
}

type ListQueueMembersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID to include on the list.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueMembersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueueMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueueMembersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListQueueMembersInput) SetFarmId(v string) *ListQueueMembersInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueueMembersInput) SetMaxResults(v int64) *ListQueueMembersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueMembersInput) SetNextToken(v string) *ListQueueMembersInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListQueueMembersInput) SetQueueId(v string) *ListQueueMembersInput {
	s.QueueId = &v
	return s
}

type ListQueueMembersOutput struct {
	_ struct{} `type:"structure"`

	// The members on the list.
	//
	// Members is a required field
	Members []*QueueMember `locationName:"members" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueMembersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueueMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListQueueMembersOutput) SetMembers(v []*QueueMember) *ListQueueMembersOutput {
	s.Members = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueueMembersOutput) SetNextToken(v string) *ListQueueMembersOutput {
	s.NextToken = &v
	return s
}

type ListQueuesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the queue.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The principal ID. This filter is only valid when using Nimble Studio credentials
	// and should match the user ID in the credentials of the caller.
	PrincipalId *string `location:"querystring" locationName:"principalId" min:"1" type:"string"`

	// The status of the queues listed.
	//
	//    * ACTIVE–The queues are active.
	//
	//    * SCHEDULING–The queues are scheduling.
	//
	//    * SCHEDULING_BLOCKED–The queue scheduling is blocked for these queues.
	Status *string `location:"querystring" locationName:"status" type:"string" enum:"QueueStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListQueuesInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalId != nil && len(*s.PrincipalId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListQueuesInput) SetFarmId(v string) *ListQueuesInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListQueuesInput) SetMaxResults(v int64) *ListQueuesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueuesInput) SetNextToken(v string) *ListQueuesInput {
	s.NextToken = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *ListQueuesInput) SetPrincipalId(v string) *ListQueuesInput {
	s.PrincipalId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListQueuesInput) SetStatus(v string) *ListQueuesInput {
	s.Status = &v
	return s
}

type ListQueuesOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The queues on the list.
	//
	// Queues is a required field
	Queues []*QueueSummary `locationName:"queues" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListQueuesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListQueuesOutput) SetNextToken(v string) *ListQueuesOutput {
	s.NextToken = &v
	return s
}

// SetQueues sets the Queues field's value.
func (s *ListQueuesOutput) SetQueues(v []*QueueSummary) *ListQueuesOutput {
	s.Queues = v
	return s
}

type ListSessionActionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the session actions list.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the session actions list.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the session actions list.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The session ID to include on the sessions action list.
	SessionId *string `location:"querystring" locationName:"sessionId" type:"string"`

	// The task ID for the session actions list.
	TaskId *string `location:"querystring" locationName:"taskId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSessionActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSessionActionsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListSessionActionsInput) SetFarmId(v string) *ListSessionActionsInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListSessionActionsInput) SetJobId(v string) *ListSessionActionsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSessionActionsInput) SetMaxResults(v int64) *ListSessionActionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionActionsInput) SetNextToken(v string) *ListSessionActionsInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListSessionActionsInput) SetQueueId(v string) *ListSessionActionsInput {
	s.QueueId = &v
	return s
}

// SetSessionId sets the SessionId field's value.
func (s *ListSessionActionsInput) SetSessionId(v string) *ListSessionActionsInput {
	s.SessionId = &v
	return s
}

// SetTaskId sets the TaskId field's value.
func (s *ListSessionActionsInput) SetTaskId(v string) *ListSessionActionsInput {
	s.TaskId = &v
	return s
}

type ListSessionActionsOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The session actions.
	//
	// SessionActions is a required field
	SessionActions []*SessionActionSummary `locationName:"sessionActions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionActionsOutput) SetNextToken(v string) *ListSessionActionsOutput {
	s.NextToken = &v
	return s
}

// SetSessionActions sets the SessionActions field's value.
func (s *ListSessionActionsOutput) SetSessionActions(v []*SessionActionSummary) *ListSessionActionsOutput {
	s.SessionActions = v
	return s
}

type ListSessionsForWorkerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the session.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID for the session.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The worker ID for the session.
	//
	// WorkerId is a required field
	WorkerId *string `location:"uri" locationName:"workerId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsForWorkerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsForWorkerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSessionsForWorkerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSessionsForWorkerInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.WorkerId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkerId"))
	}
	if s.WorkerId != nil && len(*s.WorkerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListSessionsForWorkerInput) SetFarmId(v string) *ListSessionsForWorkerInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ListSessionsForWorkerInput) SetFleetId(v string) *ListSessionsForWorkerInput {
	s.FleetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSessionsForWorkerInput) SetMaxResults(v int64) *ListSessionsForWorkerInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionsForWorkerInput) SetNextToken(v string) *ListSessionsForWorkerInput {
	s.NextToken = &v
	return s
}

// SetWorkerId sets the WorkerId field's value.
func (s *ListSessionsForWorkerInput) SetWorkerId(v string) *ListSessionsForWorkerInput {
	s.WorkerId = &v
	return s
}

type ListSessionsForWorkerOutput struct {
	_ struct{} `type:"structure"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sessions in the response.
	//
	// Sessions is a required field
	Sessions []*WorkerSessionSummary `locationName:"sessions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsForWorkerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsForWorkerOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionsForWorkerOutput) SetNextToken(v string) *ListSessionsForWorkerOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *ListSessionsForWorkerOutput) SetSessions(v []*WorkerSessionSummary) *ListSessionsForWorkerOutput {
	s.Sessions = v
	return s
}

type ListSessionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the list of sessions.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the list of sessions.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the list of sessions
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSessionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSessionsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListSessionsInput) SetFarmId(v string) *ListSessionsInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListSessionsInput) SetJobId(v string) *ListSessionsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSessionsInput) SetMaxResults(v int64) *ListSessionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionsInput) SetNextToken(v string) *ListSessionsInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListSessionsInput) SetQueueId(v string) *ListSessionsInput {
	s.QueueId = &v
	return s
}

type ListSessionsOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The sessions on the list.
	//
	// Sessions is a required field
	Sessions []*SessionSummary `locationName:"sessions" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSessionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSessionsOutput) SetNextToken(v string) *ListSessionsOutput {
	s.NextToken = &v
	return s
}

// SetSessions sets the Sessions field's value.
func (s *ListSessionsOutput) SetSessions(v []*SessionSummary) *ListSessionsOutput {
	s.Sessions = v
	return s
}

type ListStepConsumersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the list of step consumers.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the step consumer.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the step consumer.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The step ID to include on the list.
	//
	// StepId is a required field
	StepId *string `location:"uri" locationName:"stepId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepConsumersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepConsumersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStepConsumersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStepConsumersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}
	if s.StepId != nil && len(*s.StepId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListStepConsumersInput) SetFarmId(v string) *ListStepConsumersInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListStepConsumersInput) SetJobId(v string) *ListStepConsumersInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStepConsumersInput) SetMaxResults(v int64) *ListStepConsumersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepConsumersInput) SetNextToken(v string) *ListStepConsumersInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListStepConsumersInput) SetQueueId(v string) *ListStepConsumersInput {
	s.QueueId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *ListStepConsumersInput) SetStepId(v string) *ListStepConsumersInput {
	s.StepId = &v
	return s
}

type ListStepConsumersOutput struct {
	_ struct{} `type:"structure"`

	// The consumers on the list.
	//
	// Consumers is a required field
	Consumers []*StepConsumer `locationName:"consumers" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepConsumersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepConsumersOutput) GoString() string {
	return s.String()
}

// SetConsumers sets the Consumers field's value.
func (s *ListStepConsumersOutput) SetConsumers(v []*StepConsumer) *ListStepConsumersOutput {
	s.Consumers = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepConsumersOutput) SetNextToken(v string) *ListStepConsumersOutput {
	s.NextToken = &v
	return s
}

type ListStepDependenciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID for the step dependencies list.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the step dependencies list.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the step dependencies list.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The step ID to include on the list.
	//
	// StepId is a required field
	StepId *string `location:"uri" locationName:"stepId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepDependenciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepDependenciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStepDependenciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStepDependenciesInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}
	if s.StepId != nil && len(*s.StepId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListStepDependenciesInput) SetFarmId(v string) *ListStepDependenciesInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListStepDependenciesInput) SetJobId(v string) *ListStepDependenciesInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStepDependenciesInput) SetMaxResults(v int64) *ListStepDependenciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepDependenciesInput) SetNextToken(v string) *ListStepDependenciesInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListStepDependenciesInput) SetQueueId(v string) *ListStepDependenciesInput {
	s.QueueId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *ListStepDependenciesInput) SetStepId(v string) *ListStepDependenciesInput {
	s.StepId = &v
	return s
}

type ListStepDependenciesOutput struct {
	_ struct{} `type:"structure"`

	// The dependencies on the list.
	//
	// Dependencies is a required field
	Dependencies []*StepDependency `locationName:"dependencies" type:"list" required:"true"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepDependenciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepDependenciesOutput) GoString() string {
	return s.String()
}

// SetDependencies sets the Dependencies field's value.
func (s *ListStepDependenciesOutput) SetDependencies(v []*StepDependency) *ListStepDependenciesOutput {
	s.Dependencies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepDependenciesOutput) SetNextToken(v string) *ListStepDependenciesOutput {
	s.NextToken = &v
	return s
}

type ListStepsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID to include on the list of steps.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID to include on the list of steps.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID to include on the list of steps.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStepsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStepsInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListStepsInput) SetFarmId(v string) *ListStepsInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListStepsInput) SetJobId(v string) *ListStepsInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStepsInput) SetMaxResults(v int64) *ListStepsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepsInput) SetNextToken(v string) *ListStepsInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListStepsInput) SetQueueId(v string) *ListStepsInput {
	s.QueueId = &v
	return s
}

type ListStepsOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The steps on the list.
	//
	// Steps is a required field
	Steps []*StepSummary `locationName:"steps" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStepsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStepsOutput) SetNextToken(v string) *ListStepsOutput {
	s.NextToken = &v
	return s
}

// SetSteps sets the Steps field's value.
func (s *ListStepsOutput) SetSteps(v []*StepSummary) *ListStepsOutput {
	s.Steps = v
	return s
}

type ListStorageProfilesForQueueInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the queue's storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID for the storage profile.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesForQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesForQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageProfilesForQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageProfilesForQueueInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListStorageProfilesForQueueInput) SetFarmId(v string) *ListStorageProfilesForQueueInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStorageProfilesForQueueInput) SetMaxResults(v int64) *ListStorageProfilesForQueueInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageProfilesForQueueInput) SetNextToken(v string) *ListStorageProfilesForQueueInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListStorageProfilesForQueueInput) SetQueueId(v string) *ListStorageProfilesForQueueInput {
	s.QueueId = &v
	return s
}

type ListStorageProfilesForQueueOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The storage profiles in the queue.
	//
	// StorageProfiles is a required field
	StorageProfiles []*StorageProfileSummary `locationName:"storageProfiles" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesForQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesForQueueOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageProfilesForQueueOutput) SetNextToken(v string) *ListStorageProfilesForQueueOutput {
	s.NextToken = &v
	return s
}

// SetStorageProfiles sets the StorageProfiles field's value.
func (s *ListStorageProfilesForQueueOutput) SetStorageProfiles(v []*StorageProfileSummary) *ListStorageProfilesForQueueOutput {
	s.StorageProfiles = v
	return s
}

type ListStorageProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID of the storage profile.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListStorageProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListStorageProfilesInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListStorageProfilesInput) SetFarmId(v string) *ListStorageProfilesInput {
	s.FarmId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListStorageProfilesInput) SetMaxResults(v int64) *ListStorageProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageProfilesInput) SetNextToken(v string) *ListStorageProfilesInput {
	s.NextToken = &v
	return s
}

type ListStorageProfilesOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The storage profiles.
	//
	// StorageProfiles is a required field
	StorageProfiles []*StorageProfileSummary `locationName:"storageProfiles" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListStorageProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListStorageProfilesOutput) SetNextToken(v string) *ListStorageProfilesOutput {
	s.NextToken = &v
	return s
}

// SetStorageProfiles sets the StorageProfiles field's value.
func (s *ListStorageProfilesOutput) SetStorageProfiles(v []*StorageProfileSummary) *ListStorageProfilesOutput {
	s.StorageProfiles = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource ARN to list tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Each tag consists of a tag key and a tag value. Tag keys and values are both
	// required, but tag values can be empty strings.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListTasksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID connected to the tasks.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The job ID for the tasks.
	//
	// JobId is a required field
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The queue ID connected to the tasks.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"queueId" type:"string" required:"true"`

	// The step ID for the tasks.
	//
	// StepId is a required field
	StepId *string `location:"uri" locationName:"stepId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTasksInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.StepId == nil {
		invalidParams.Add(request.NewErrParamRequired("StepId"))
	}
	if s.StepId != nil && len(*s.StepId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StepId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListTasksInput) SetFarmId(v string) *ListTasksInput {
	s.FarmId = &v
	return s
}

// SetJobId sets the JobId field's value.
func (s *ListTasksInput) SetJobId(v string) *ListTasksInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTasksInput) SetMaxResults(v int64) *ListTasksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksInput) SetNextToken(v string) *ListTasksInput {
	s.NextToken = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *ListTasksInput) SetQueueId(v string) *ListTasksInput {
	s.QueueId = &v
	return s
}

// SetStepId sets the StepId field's value.
func (s *ListTasksInput) SetStepId(v string) *ListTasksInput {
	s.StepId = &v
	return s
}

type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Tasks for the job.
	//
	// Tasks is a required field
	Tasks []*TaskSummary `locationName:"tasks" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTasksOutput) SetNextToken(v string) *ListTasksOutput {
	s.NextToken = &v
	return s
}

// SetTasks sets the Tasks field's value.
func (s *ListTasksOutput) SetTasks(v []*TaskSummary) *ListTasksOutput {
	s.Tasks = v
	return s
}

type ListWorkersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The farm ID connected to the workers.
	//
	// FarmId is a required field
	FarmId *string `location:"uri" locationName:"farmId" type:"string" required:"true"`

	// The fleet ID of the workers.
	//
	// FleetId is a required field
	FleetId *string `location:"uri" locationName:"fleetId" type:"string" required:"true"`

	// The maximum number of results to return. Use this parameter with NextToken
	// to get results as a set of sequential pages.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results, or null to start from the beginning.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkersInput"}
	if s.FarmId == nil {
		invalidParams.Add(request.NewErrParamRequired("FarmId"))
	}
	if s.FarmId != nil && len(*s.FarmId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FarmId", 1))
	}
	if s.FleetId == nil {
		invalidParams.Add(request.NewErrParamRequired("FleetId"))
	}
	if s.FleetId != nil && len(*s.FleetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FleetId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFarmId sets the FarmId field's value.
func (s *ListWorkersInput) SetFarmId(v string) *ListWorkersInput {
	s.FarmId = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *ListWorkersInput) SetFleetId(v string) *ListWorkersInput {
	s.FleetId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkersInput) SetMaxResults(v int64) *ListWorkersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersInput) SetNextToken(v string) *ListWorkersInput {
	s.NextToken = &v
	return s
}

type ListWorkersOutput struct {
	_ struct{} `type:"structure"`

	// If Deadline Cloud returns nextToken, then there are more results available.
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page, call the operation again using the returned token. Keep all
	// other arguments unchanged. If no results remain, then nextToken is set to
	// null. Each pagination token expires after 24 hours. If you provide a token
	// that isn't valid, then you receive an HTTP 400 ValidationException error.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The workers on the list.
	//
	// Workers is a required field
	Workers []*WorkerSummary `locationName:"workers" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkersOutput) SetNextToken(v string) *ListWorkersOutput {
	s.NextToken = &v
	return s
}

// SetWorkers sets the Workers field's value.
func (s *ListWorkersOutput) SetWorkers(v []*WorkerSummary) *ListWorkersOutput {
	s.Workers = v
	return s
}

// Log configuration details.
type LogConfiguration struct {
	_ struct{} `type:"structure"`

	// The log configuration error details.
	Error *string `locationName:"error" min:"1" type:"string"`

	// The log drivers for worker related logs.
	//
	// LogDriver is a required field
	LogDriver *string `locationName:"logDriver" min:"1" type:"string" required:"true"`

	// The options for a log driver.
	Options map[string]*string `locationName:"options" type:"map"`

	// The parameters for the log configuration.
	Parameters map[string]*string `locationName:"parameters" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogConfiguration) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *LogConfiguration) SetError(v string) *LogConfiguration {
	s.Error = &v
	return s
}

// SetLogDriver sets the LogDriver field's value.
func (s *LogConfiguration) SetLogDriver(v string) *LogConfiguration {
	s.LogDriver = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *LogConfiguration) SetOptions(v map[string]*string) *LogConfiguration {
	s.Options = v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *LogConfiguration) SetParameters(v map[string]*string) *LogConfiguration {
	s.Parameters = v
	return s
}

// The details of the manifest that links a job's source information.
type ManifestProperties struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The file system location name.
	//
	// FileSystemLocationName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ManifestProperties's
	// String and GoString methods.
	FileSystemLocationName *string `locationName:"fileSystemLocationName" min:"1" type:"string" sensitive:"true"`

	// The has value of the file.
	InputManifestHash *string `locationName:"inputManifestHash" min:"1" type:"string"`

	// The file path.
	InputManifestPath *string `locationName:"inputManifestPath" min:"1" type:"string"`

	// The file path relative to the directory.
	OutputRelativeDirectories []*string `locationName:"outputRelativeDirectories" type:"list"`

	// The file's root path.
	//
	// RootPath is a required field
	RootPath *string `locationName:"rootPath" min:"1" type:"string" required:"true"`

	// The format of the root path.
	//
	// RootPathFormat is a required field
	RootPathFormat *string `locationName:"rootPathFormat" type:"string" required:"true" enum:"PathFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ManifestProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ManifestProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ManifestProperties"}
	if s.FileSystemLocationName != nil && len(*s.FileSystemLocationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FileSystemLocationName", 1))
	}
	if s.InputManifestHash != nil && len(*s.InputManifestHash) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputManifestHash", 1))
	}
	if s.InputManifestPath != nil && len(*s.InputManifestPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InputManifestPath", 1))
	}
	if s.RootPath == nil {
		invalidParams.Add(request.NewErrParamRequired("RootPath"))
	}
	if s.RootPath != nil && len(*s.RootPath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RootPath", 1))
	}
	if s.RootPathFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("RootPathFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemLocationName sets the FileSystemLocationName field's value.
func (s *ManifestProperties) SetFileSystemLocationName(v string) *ManifestProperties {
	s.FileSystemLocationName = &v
	return s
}

// SetInputManifestHash sets the InputManifestHash field's value.
func (s *ManifestProperties) SetInputManifestHash(v string) *ManifestProperties {
	s.InputManifestHash = &v
	return s
}

// SetInputManifestPath sets the InputManifestPath field's value.
func (s *ManifestProperties) SetInputManifestPath(v string) *ManifestProperties {
	s.InputManifestPath = &v
	return s
}

// SetOutputRelativeDirectories sets the OutputRelativeDirectories field's value.
func (s *ManifestProperties) SetOutputRelativeDirectories(v []*string) *ManifestProperties {
	s.OutputRelativeDirectories = v
	return s
}

// SetRootPath sets the RootPath field's value.
func (s *ManifestProperties) SetRootPath(v string) *ManifestProperties {
	s.RootPath = &v
	return s
}

// SetRootPathFormat sets the RootPathFormat field's value.
func (s *ManifestProperties) SetRootPathFormat(v string) *ManifestProperties {
	s.RootPathFormat = &v
	return s
}

// The range of memory in MiB.
type MemoryMiBRange struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory (in MiB).
	Max *int64 `locationName:"max" min:"512" type:"integer"`

	// The minimum amount of memory (in MiB).
	//
	// Min is a required field
	Min *int64 `locationName:"min" min:"512" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryMiBRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MemoryMiBRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MemoryMiBRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MemoryMiBRange"}
	if s.Max != nil && *s.Max < 512 {
		invalidParams.Add(request.NewErrParamMinValue("Max", 512))
	}
	if s.Min == nil {
		invalidParams.Add(request.NewErrParamRequired("Min"))
	}
	if s.Min != nil && *s.Min < 512 {
		invalidParams.Add(request.NewErrParamMinValue("Min", 512))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMax sets the Max field's value.
func (s *MemoryMiBRange) SetMax(v int64) *MemoryMiBRange {
	s.Max = &v
	return s
}

// SetMin sets the Min field's value.
func (s *MemoryMiBRange) SetMin(v int64) *MemoryMiBRange {
	s.Min = &v
	return s
}

// The details of a metered product.
type MeteredProductSummary struct {
	_ struct{} `type:"structure"`

	// The family to which the metered product belongs.
	//
	// Family is a required field
	Family *string `locationName:"family" min:"1" type:"string" required:"true"`

	// The port on which the metered product should run.
	//
	// Port is a required field
	Port *int64 `locationName:"port" min:"1024" type:"integer" required:"true"`

	// The product ID.
	//
	// ProductId is a required field
	ProductId *string `locationName:"productId" type:"string" required:"true"`

	// The vendor.
	//
	// Vendor is a required field
	Vendor *string `locationName:"vendor" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeteredProductSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MeteredProductSummary) GoString() string {
	return s.String()
}

// SetFamily sets the Family field's value.
func (s *MeteredProductSummary) SetFamily(v string) *MeteredProductSummary {
	s.Family = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MeteredProductSummary) SetPort(v int64) *MeteredProductSummary {
	s.Port = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *MeteredProductSummary) SetProductId(v string) *MeteredProductSummary {
	s.ProductId = &v
	return s
}

// SetVendor sets the Vendor field's value.
func (s *MeteredProductSummary) SetVendor(v string) *MeteredProductSummary {
	s.Vendor = &v
	return s
}

// Provides information about a monitor in Deadline Cloud.
type MonitorSummary struct {
	_ struct{} `type:"structure"`

	// The UNIX timestamp of the date and time that the monitor was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user name of the person that created the monitor.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The name of the monitor that displays on the Deadline Cloud console.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that the IAM Identity Center assigned to the
	// monitor when it was created.
	//
	// IdentityCenterApplicationArn is a required field
	IdentityCenterApplicationArn *string `locationName:"identityCenterApplicationArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM Identity Center instance responsible
	// for authenticating monitor users.
	//
	// IdentityCenterInstanceArn is a required field
	IdentityCenterInstanceArn *string `locationName:"identityCenterInstanceArn" type:"string" required:"true"`

	// The unique identifier for the monitor.
	//
	// MonitorId is a required field
	MonitorId *string `locationName:"monitorId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role for the monitor. Users of
	// the monitor use this role to access Deadline Cloud resources.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The subdomain used for the monitor URL. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// Subdomain is a required field
	Subdomain *string `locationName:"subdomain" type:"string" required:"true"`

	// The UNIX timestamp of the date and time that the monitor was last updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user name of the person that last updated the monitor.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`

	// The complete URL of the monitor. The full URL of the monitor is subdomain.Region.deadlinecloud.amazonaws.com.
	//
	// Url is a required field
	Url *string `locationName:"url" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MonitorSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *MonitorSummary) SetCreatedAt(v time.Time) *MonitorSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *MonitorSummary) SetCreatedBy(v string) *MonitorSummary {
	s.CreatedBy = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MonitorSummary) SetDisplayName(v string) *MonitorSummary {
	s.DisplayName = &v
	return s
}

// SetIdentityCenterApplicationArn sets the IdentityCenterApplicationArn field's value.
func (s *MonitorSummary) SetIdentityCenterApplicationArn(v string) *MonitorSummary {
	s.IdentityCenterApplicationArn = &v
	return s
}

// SetIdentityCenterInstanceArn sets the IdentityCenterInstanceArn field's value.
func (s *MonitorSummary) SetIdentityCenterInstanceArn(v string) *MonitorSummary {
	s.IdentityCenterInstanceArn = &v
	return s
}

// SetMonitorId sets the MonitorId field's value.
func (s *MonitorSummary) SetMonitorId(v string) *MonitorSummary {
	s.MonitorId = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *MonitorSummary) SetRoleArn(v string) *MonitorSummary {
	s.RoleArn = &v
	return s
}

// SetSubdomain sets the Subdomain field's value.
func (s *MonitorSummary) SetSubdomain(v string) *MonitorSummary {
	s.Subdomain = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *MonitorSummary) SetUpdatedAt(v time.Time) *MonitorSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *MonitorSummary) SetUpdatedBy(v string) *MonitorSummary {
	s.UpdatedBy = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *MonitorSummary) SetUrl(v string) *MonitorSummary {
	s.Url = &v
	return s
}

// The details of a filtered search for parameters.
type ParameterFilterExpression struct {
	_ struct{} `type:"structure"`

	// The name of the parameter to filter on.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of comparison to use to filter results.
	//
	// Operator is a required field
	Operator *string `locationName:"operator" type:"string" required:"true" enum:"ComparisonOperator"`

	// The parameter's value.
	//
	// Value is a required field
	Value *string `locationName:"value" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterFilterExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterFilterExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterFilterExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterFilterExpression"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Operator == nil {
		invalidParams.Add(request.NewErrParamRequired("Operator"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}
	if s.Value != nil && len(*s.Value) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Value", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ParameterFilterExpression) SetName(v string) *ParameterFilterExpression {
	s.Name = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ParameterFilterExpression) SetOperator(v string) *ParameterFilterExpression {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ParameterFilterExpression) SetValue(v string) *ParameterFilterExpression {
	s.Value = &v
	return s
}

// Organizes parameters according to your specifications.
type ParameterSortExpression struct {
	_ struct{} `type:"structure"`

	// The parameter name to sort by.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The sort order for the parameter.
	//
	// SortOrder is a required field
	SortOrder *string `locationName:"sortOrder" type:"string" required:"true" enum:"SortOrder"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterSortExpression) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterSortExpression) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParameterSortExpression) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParameterSortExpression"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.SortOrder == nil {
		invalidParams.Add(request.NewErrParamRequired("SortOrder"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ParameterSortExpression) SetName(v string) *ParameterSortExpression {
	s.Name = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ParameterSortExpression) SetSortOrder(v string) *ParameterSortExpression {
	s.SortOrder = &v
	return s
}

// The details of a search for two or more step parameters.
type ParameterSpace struct {
	_ struct{} `type:"structure"`

	// The combination expression to use in the search.
	Combination *string `locationName:"combination" min:"1" type:"string"`

	// The parameters to search for.
	//
	// Parameters is a required field
	Parameters []*StepParameter `locationName:"parameters" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterSpace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParameterSpace) GoString() string {
	return s.String()
}

// SetCombination sets the Combination field's value.
func (s *ParameterSpace) SetCombination(v string) *ParameterSpace {
	s.Combination = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ParameterSpace) SetParameters(v []*StepParameter) *ParameterSpace {
	s.Parameters = v
	return s
}

// The details of a source and destination path.
type PathMappingRule struct {
	_ struct{} `type:"structure" sensitive:"true"`

	// The destination path.
	//
	// DestinationPath is a required field
	DestinationPath *string `locationName:"destinationPath" type:"string" required:"true"`

	// The source path.
	//
	// SourcePath is a required field
	SourcePath *string `locationName:"sourcePath" type:"string" required:"true"`

	// The source path format.
	//
	// SourcePathFormat is a required field
	SourcePathFormat *string `locationName:"sourcePathFormat" type:"string" required:"true" enum:"PathFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMappingRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PathMappingRule) GoString() string {
	return s.String()
}

// SetDestinationPath sets the DestinationPath field's value.
func (s *PathMappingRule) SetDestinationPath(v string) *PathMappingRule {
	s.DestinationPath = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *PathMappingRule) SetSourcePath(v string) *PathMappingRule {
	s.SourcePath = &v
	return s
}

// SetSourcePathFormat sets the SourcePathFormat field's value.
func (s *PathMappingRule) SetSourcePathFormat(v string) *PathMappingRule {
	s.SourcePathFormat = &v
	return s
}

// The POSIX user.
type PosixUser struct {
	_ struct{} `type:"structure"`

	// The name of the POSIX user's group.
	//
	// Group is a required field
	Group *string `locationName:"group" type:"string" required:"true"`

	// The name of the POSIX user.
	//
	// User is a required field
	User *string `locationName:"user" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PosixUser) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PosixUser) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PosixUser"}
	if s.Group == nil {
		invalidParams.Add(request.NewErrParamRequired("Group"))
	}
	if s.User == nil {
		invalidParams.Add(request.NewErrParamRequired("User"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroup sets the Group field's value.
func (s *PosixUser) SetGroup(v string) *PosixUser {
	s.Group = &v
	return s
}

// SetUser sets the User field's value.
func (s *PosixUser) SetUser(v string) *PosixUser {
	s.User = &v
	return s
}

type PutMeteredProductInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The license endpoint ID to add to the metered product.
	//
	// LicenseEndpointId is a required field
	LicenseEndpointId *string `location:"uri" locationName:"licenseEndpointId" type:"string" required:"true"`

	// The product ID to add to the metered product.
	//
	// ProductId is a required field
	ProductId *string `location:"uri" locationName:"productId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMeteredProductInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMeteredProductInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMeteredProductInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMeteredProductInput"}
	if s.LicenseEndpointId == nil {
		invalidParams.Add(request.NewErrParamRequired("LicenseEndpointId"))
	}
	if s.LicenseEndpointId != nil && len(*s.LicenseEndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LicenseEndpointId", 1))
	}
	if s.ProductId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProductId"))
	}
	if s.ProductId != nil && len(*s.ProductId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProductId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLicenseEndpointId sets the LicenseEndpointId field's value.
func (s *PutMeteredProductInput) SetLicenseEndpointId(v string) *PutMeteredProductInput {
	s.LicenseEndpointId = &v
	return s
}

// SetProductId sets the ProductId field's value.
func (s *PutMeteredProductInput) SetProductId(v string) *PutMeteredProductInput {
	s.ProductId = &v
	return s
}

type PutMeteredProductOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMeteredProductOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMeteredProductOutput) GoString() string {
	return s.String()
}

// The summary of a queue environment.
type QueueEnvironmentSummary struct {
	_ struct{} `type:"structure"`

	// The name of the queue environment.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The queue environment's priority.
	//
	// Priority is a required field
	Priority *int64 `locationName:"priority" type:"integer" required:"true"`

	// The queue environment ID.
	//
	// QueueEnvironmentId is a required field
	QueueEnvironmentId *string `locationName:"queueEnvironmentId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueEnvironmentSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueEnvironmentSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *QueueEnvironmentSummary) SetName(v string) *QueueEnvironmentSummary {
	s.Name = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *QueueEnvironmentSummary) SetPriority(v int64) *QueueEnvironmentSummary {
	s.Priority = &v
	return s
}

// SetQueueEnvironmentId sets the QueueEnvironmentId field's value.
func (s *QueueEnvironmentSummary) SetQueueEnvironmentId(v string) *QueueEnvironmentSummary {
	s.QueueEnvironmentId = &v
	return s
}

// The details of a queue-fleet association.
type QueueFleetAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The fleet ID.
	//
	// FleetId is a required field
	FleetId *string `locationName:"fleetId" type:"string" required:"true"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`

	// The status of task scheduling in the queue-fleet association.
	//
	//    * ACTIVE–Association is active.
	//
	//    * STOP_SCHEDULING_AND_COMPLETE_TASKS–Association has stopped scheduling
	//    new tasks and is completing current tasks.
	//
	//    * STOP_SCHEDULING_AND_CANCEL_TASKS–Association has stopped scheduling
	//    new tasks and is canceling current tasks.
	//
	//    * STOPPED–Association has been stopped.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QueueFleetAssociationStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueFleetAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueFleetAssociationSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *QueueFleetAssociationSummary) SetCreatedAt(v time.Time) *QueueFleetAssociationSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *QueueFleetAssociationSummary) SetCreatedBy(v string) *QueueFleetAssociationSummary {
	s.CreatedBy = &v
	return s
}

// SetFleetId sets the FleetId field's value.
func (s *QueueFleetAssociationSummary) SetFleetId(v string) *QueueFleetAssociationSummary {
	s.FleetId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *QueueFleetAssociationSummary) SetQueueId(v string) *QueueFleetAssociationSummary {
	s.QueueId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueueFleetAssociationSummary) SetStatus(v string) *QueueFleetAssociationSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *QueueFleetAssociationSummary) SetUpdatedAt(v time.Time) *QueueFleetAssociationSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *QueueFleetAssociationSummary) SetUpdatedBy(v string) *QueueFleetAssociationSummary {
	s.UpdatedBy = &v
	return s
}

// The details of a queue member.
type QueueMember struct {
	_ struct{} `type:"structure"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The identity store ID.
	//
	// IdentityStoreId is a required field
	IdentityStoreId *string `locationName:"identityStoreId" min:"1" type:"string" required:"true"`

	// The queue member's membership level.
	//
	// MembershipLevel is a required field
	MembershipLevel *string `locationName:"membershipLevel" type:"string" required:"true" enum:"MembershipLevel"`

	// The principal ID of the queue member.
	//
	// PrincipalId is a required field
	PrincipalId *string `locationName:"principalId" min:"1" type:"string" required:"true"`

	// The principal type of the queue member.
	//
	// PrincipalType is a required field
	PrincipalType *string `locationName:"principalType" type:"string" required:"true" enum:"PrincipalType"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueMember) GoString() string {
	return s.String()
}

// SetFarmId sets the FarmId field's value.
func (s *QueueMember) SetFarmId(v string) *QueueMember {
	s.FarmId = &v
	return s
}

// SetIdentityStoreId sets the IdentityStoreId field's value.
func (s *QueueMember) SetIdentityStoreId(v string) *QueueMember {
	s.IdentityStoreId = &v
	return s
}

// SetMembershipLevel sets the MembershipLevel field's value.
func (s *QueueMember) SetMembershipLevel(v string) *QueueMember {
	s.MembershipLevel = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *QueueMember) SetPrincipalId(v string) *QueueMember {
	s.PrincipalId = &v
	return s
}

// SetPrincipalType sets the PrincipalType field's value.
func (s *QueueMember) SetPrincipalType(v string) *QueueMember {
	s.PrincipalType = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *QueueMember) SetQueueId(v string) *QueueMember {
	s.QueueId = &v
	return s
}

// The details of a queue summary.
type QueueSummary struct {
	_ struct{} `type:"structure"`

	// The reason the queue is blocked, if applicable.
	BlockedReason *string `locationName:"blockedReason" type:"string" enum:"QueueBlockedReason"`

	// The date and time the resource was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The user or system that created this resource.
	//
	// CreatedBy is a required field
	CreatedBy *string `locationName:"createdBy" type:"string" required:"true"`

	// The default action taken on a queue summary if a budget wasn't configured.
	//
	// DefaultBudgetAction is a required field
	DefaultBudgetAction *string `locationName:"defaultBudgetAction" type:"string" required:"true" enum:"DefaultQueueBudgetAction"`

	// The display name of the queue summary to update.
	//
	// DisplayName is a required field
	DisplayName *string `locationName:"displayName" min:"1" type:"string" required:"true"`

	// The farm ID.
	//
	// FarmId is a required field
	FarmId *string `locationName:"farmId" type:"string" required:"true"`

	// The queue ID.
	//
	// QueueId is a required field
	QueueId *string `locationName:"queueId" type:"string" required:"true"`

	// That status of the queue.
	//
	// Status is a required field
	Status *string `locationName:"status" type:"string" required:"true" enum:"QueueStatus"`

	// The date and time the resource was updated.
	UpdatedAt *time.Time `locationName:"updatedAt" type:"timestamp" timestampFormat:"iso8601"`

	// The user or system that updated this resource.
	UpdatedBy *string `locationName:"updatedBy" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueueSummary) GoString() string {
	return s.String()
}

// SetBlockedReason sets the BlockedReason field's value.
func (s *QueueSummary) SetBlockedReason(v string) *QueueSummary {
	s.BlockedReason = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *QueueSummary) SetCreatedAt(v time.Time) *QueueSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *QueueSummary) SetCreatedBy(v string) *QueueSummary {
	s.CreatedBy = &v
	return s
}

// SetDefaultBudgetAction sets the DefaultBudgetAction field's value.
func (s *QueueSummary) SetDefaultBudgetAction(v string) *QueueSummary {
	s.DefaultBudgetAction = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *QueueSummary) SetDisplayName(v string) *QueueSummary {
	s.DisplayName = &v
	return s
}

// SetFarmId sets the FarmId field's value.
func (s *QueueSummary) SetFarmId(v string) *QueueSummary {
	s.FarmId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *QueueSummary) SetQueueId(v string) *QueueSummary {
	s.QueueId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueueSummary) SetStatus(v string) *QueueSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *QueueSummary) SetUpdatedAt(v time.Time) *QueueSummary {
	s.UpdatedAt = &v
	return s
}

// SetUpdatedBy sets the UpdatedBy field's value.
func (s *QueueSummary) SetUpdatedBy(v string) *QueueSummary {
	s.UpdatedBy = &v
	return s
}

// The requested resource can't be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Information about the resources in use when the exception was thrown.
	Context map[string]*string `locationName:"context" type:"map"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that couldn't be found.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of the resource that couldn't be found.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The details of a budget action.
type ResponseBudgetAction struct {
	_ struct{} `type:"structure"`

	// The budget action description.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ResponseBudgetAction's
	// String and GoString methods.
	Description *string `locationName:"description" type:"string" sensitive:"true"`

	// The percentage threshold for the budget.
	//
	// ThresholdPercentage is a required field
	ThresholdPercentage *float64 `locationName:"thresholdPercentage" type:"float" required:"true"`

	// The action taken on the budget once scheduling stops.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"BudgetActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseBudgetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResponseBudgetAction) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ResponseBudgetAction) SetDescription(v string) *ResponseBudgetAction {
	s.Description = &v
	return s
}

// SetThresholdPercentage sets the ThresholdPercentage field's value.
func (s *ResponseBudgetAction) SetThresholdPercentage(v float64) *ResponseBudgetAction {
	s.ThresholdPercentage = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResponseBudgetAction) SetType(v string) *ResponseBudgetAction {
	s.Type = &v
	return s
}

// The Amazon S3 location information.
type S3Location struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket.
	//
	