/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.jboss.cache.pojo.PojoCache;
import org.jboss.cache.pojo.PojoCacheFactory;
import org.jboss.cache.transaction.DummyTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PojoCache220Wrapper
implements CacheWrapper {
    private PojoCache cache;
    private Log log = LogFactory.getLog(PojoCache220Wrapper.class);
    private Map replicatedData;

    @Override
    public void init(Map parameters) throws Exception {
        boolean isCoordinator;
        this.log.info((Object)("Creating pojo cache with the following configuration: " + parameters));
        String configFile = (String)parameters.get("config");
        URL url = Thread.currentThread().getContextClassLoader().getResource(configFile);
        this.log.info((Object)("Loading cache with config file: " + url));
        this.cache = PojoCacheFactory.createCache((String)configFile);
        boolean bl = isCoordinator = this.cache.getCache().getMembers().indexOf(this.cache.getCache().getLocalAddress()) == 0;
        if (isCoordinator) {
            this.replicatedData = new HashMap();
            this.cache.attach("/data", (Object)this.replicatedData);
        } else {
            for (int i = 0; i < 10; ++i) {
                this.replicatedData = (Map)this.cache.find("/data");
                if (this.replicatedData != null) break;
                this.log.info((Object)"This is not the coordinator, sleeping for a second before trying to refetched the map.");
                Thread.sleep(1000L);
            }
        }
        this.replicatedData = (Map)this.cache.find("/data");
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        this.replicatedData.put(key, value);
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        return this.replicatedData.get(key);
    }

    @Override
    public void empty() throws Exception {
        this.replicatedData.clear();
    }

    @Override
    public int getNumMembers() {
        return this.cache.getCache().getMembers().size();
    }

    @Override
    public String getInfo() {
        return "n/a info for pojocache";
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        return this.replicatedData.get(key);
    }

    public Transaction startTransaction() {
        try {
            DummyTransactionManager.getInstance().begin();
            return DummyTransactionManager.getInstance().getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction(boolean successful) {
        try {
            if (successful) {
                DummyTransactionManager.getInstance().commit();
            } else {
                DummyTransactionManager.getInstance().rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

