/*
 * Decompiled with CFR 0.152.
 */
package org.cachebench.cachewrappers;

import java.util.List;
import java.util.Map;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cachebench.CacheWrapper;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Option;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jboss.cache.util.Caches;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCache300Wrapper
implements CacheWrapper {
    private Cache cache;
    private Map flatCache;
    private Log log = LogFactory.getLog(JBossCache300Wrapper.class);
    private final boolean FLAT = Boolean.getBoolean("cacheBenchFwk.useFlatCache");

    @Override
    public void init(Map parameters) throws Exception {
        this.log.info((Object)("Creating cache with the following configuration: " + parameters));
        this.cache = new DefaultCacheFactory().createCache((String)parameters.get("config"));
        this.log.info((Object)("Running cache with following config: " + this.cache.getConfiguration()));
        this.log.info((Object)"Running following JBossCacheVersion: 3.0.3.GA");
        this.log.info((Object)"Running following JBossCacheCodeName: Naga");
        if (this.FLAT) {
            this.log.info((Object)"Using FLAT MAP wrapper");
            this.flatCache = Caches.asMap((Cache)this.cache);
        }
    }

    @Override
    public void setUp() throws Exception {
    }

    @Override
    public void tearDown() throws Exception {
        this.cache.stop();
    }

    @Override
    public void put(List<String> path, Object key, Object value) throws Exception {
        if (this.FLAT) {
            this.flatCache.put(key, value);
        } else {
            this.cache.put(Fqn.fromList(path, (boolean)true), key, value);
        }
    }

    @Override
    public Object get(List<String> path, Object key) throws Exception {
        if (this.FLAT) {
            return this.flatCache.get(key);
        }
        return this.cache.get(Fqn.fromList(path, (boolean)true), key);
    }

    @Override
    public void empty() throws Exception {
        if (this.FLAT) {
            this.flatCache.clear();
        } else {
            this.cache.removeNode(Fqn.fromElements((Object[])new String[]{"test"}));
        }
    }

    @Override
    public int getNumMembers() {
        return this.cache.getMembers() == null ? 0 : this.cache.getMembers().size();
    }

    @Override
    public String getInfo() {
        return "Num direct children: " + this.cache.getRoot().getChildren().size();
    }

    @Override
    public Object getReplicatedData(List<String> path, String key) throws Exception {
        if (!this.cache.getConfiguration().getCacheMode().isSynchronous()) {
            this.log.info((Object)"Sleeping 5 seconds because the cache is replicated asynchronious!");
            Thread.sleep(5000L);
        }
        Option option = this.cache.getInvocationContext().getOptionOverrides();
        option.setForceDataGravitation(true);
        return this.get(path, key);
    }

    public Transaction startTransaction() {
        try {
            DummyTransactionManager.getInstance().begin();
            return DummyTransactionManager.getInstance().getTransaction();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void endTransaction(boolean successful) {
        try {
            if (successful) {
                DummyTransactionManager.getInstance().commit();
            } else {
                DummyTransactionManager.getInstance().rollback();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

