/* 
   crypt -- take a soon-to-be password from the command line, and output
	    it in it's crypted form.  This is probably not the best
	    implementation ever done. :)

   Copyright (C) 2000 A.L.Lambert.
   
   Version 1.1 by Joachim Fenkes <dojoe@gmx.net> - added MD5 support.
   Version 1.2 - fixes a bug introduced by A.L.Lambert in the argv[] handling.
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
*/


#include "include.h"



short int cr_crypt() {
       	char *cp;

	/* if we're in debug mode, tell operatore where we are and what we're doing*/
	if(debug) fprintf(stderr, "in cr_crypt();\n");
	if(debug) fprintf(stderr, "\tpassword: %s\n", cleartext_pass);
	if(debug) fprintf(stderr, "\tsalt:     %s\n", salt);

	/* since only the first 8 characters can be encrypted with non-MD5 crypt(), if the user
	 * asked us to encrypt a bigger password, let's warn them about this. */
	if(strlen(salt) == 2 && strlen(cleartext_pass) > 8) {
		fprintf(stderr, "WARNING: only the first 8 characters are encrypted when not using MD5\n");
	}

	
	/* see if we can't crypt that thing */
	cp = crypt(cleartext_pass, salt);
	if(cp == NULL) {	/* oops - crypt returned error! */
		fprintf(stderr, "error: crypt(%s, %s) returned error\n", cleartext_pass, salt);
		return -1;
	}
	/* ok, life is good till now, copy that thing over to it's final resting place */
	strncpy(encrypted_pass, cp, LSIZE);
	return (0);
}
