/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.Cardinality;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleLocator role;
    private SourceLocator locator;
    private int count = 0;
    private int level = 0;
    private HashSet<Long> checkedElements = new HashSet(10);

    public TypeCheckingFilter(Receiver next) {
        super(next);
    }

    public void setRequiredType(ItemType type, int cardinality, RoleLocator role, SourceLocator locator) {
        this.itemType = type;
        this.cardinality = cardinality;
        this.role = role;
        this.locator = locator;
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            CombinedNodeTest type = new CombinedNodeTest(new NameTest(2, nameCode, this.getNamePool()), 23, new ContentTypeTest(2, typeCode, this.getConfiguration(), false));
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.TEXT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.COMMENT;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    public void namespace(NamespaceBinding namespaceBinding, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest type = NodeKindTest.NAMESPACE;
            this.checkItemType(type, 0);
        }
        this.nextReceiver.namespace(namespaceBinding, properties);
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            NodeKindTest type = NodeKindTest.PROCESSING_INSTRUCTION;
            this.checkItemType(type, locationId);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    public void startDocument(int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(0);
            }
            NodeKindTest type = NodeKindTest.DOCUMENT;
            this.checkItemType(type, 0);
        }
        ++this.level;
        this.nextReceiver.startDocument(properties);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                this.checkItemType(type, locationId);
            } else {
                long key;
                if (this.count == 2) {
                    this.checkAllowsMany(locationId);
                }
                if (!this.checkedElements.contains(key = (long)(nameCode.allocateNameCode(this.getNamePool()) & 0xFFFFF) << 32 | (long)typeCode.getFingerprint())) {
                    CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nameCode, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                    this.checkItemType(type, locationId);
                    this.checkedElements.add(key);
                }
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void endDocument() throws XPathException {
        --this.level;
        this.nextReceiver.endDocument();
    }

    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            throw err;
        }
    }

    public void append(Item item, int locationId, int copyNamespaces) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(Type.getItemType(item, this.getConfiguration().getTypeHierarchy()), locationId);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            ((SequenceReceiver)this.nextReceiver).append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }

    private void checkItemType(ItemType type, int locationId) throws XPathException {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(type, this.itemType)) {
            String message = this.role.composeErrorMessage(this.itemType, type);
            String errorCode = this.role.getErrorCode();
            XPathException err = new XPathException(message);
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == 0) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(ExpressionLocation.getSourceLocator(locationId, this.getPipelineConfiguration().getLocationProvider()));
            }
            throw err;
        }
    }

    private void checkAllowsMany(int locationId) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            XPathException err = new XPathException("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == 0) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(ExpressionLocation.getSourceLocator(locationId, this.getPipelineConfiguration().getLocationProvider()));
            }
            throw err;
        }
    }
}

