// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package rds_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/rds"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleRDS_AddRoleToDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.AddRoleToDBClusterInput{
		DBClusterIdentifier: aws.String("String"), // Required
		RoleArn:             aws.String("String"), // Required
	}
	resp, err := svc.AddRoleToDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_AddSourceIdentifierToSubscription() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.AddSourceIdentifierToSubscriptionInput{
		SourceIdentifier: aws.String("String"), // Required
		SubscriptionName: aws.String("String"), // Required
	}
	resp, err := svc.AddSourceIdentifierToSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_AddTagsToResource() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.AddTagsToResourceInput{
		ResourceName: aws.String("String"), // Required
		Tags: []*rds.Tag{ // Required
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.AddTagsToResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ApplyPendingMaintenanceAction() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ApplyPendingMaintenanceActionInput{
		ApplyAction:        aws.String("String"), // Required
		OptInType:          aws.String("String"), // Required
		ResourceIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.ApplyPendingMaintenanceAction(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_AuthorizeDBSecurityGroupIngress() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.AuthorizeDBSecurityGroupIngressInput{
		DBSecurityGroupName:     aws.String("String"), // Required
		CIDRIP:                  aws.String("String"),
		EC2SecurityGroupId:      aws.String("String"),
		EC2SecurityGroupName:    aws.String("String"),
		EC2SecurityGroupOwnerId: aws.String("String"),
	}
	resp, err := svc.AuthorizeDBSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CopyDBClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CopyDBClusterParameterGroupInput{
		SourceDBClusterParameterGroupIdentifier:  aws.String("String"), // Required
		TargetDBClusterParameterGroupDescription: aws.String("String"), // Required
		TargetDBClusterParameterGroupIdentifier:  aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CopyDBClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CopyDBClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CopyDBClusterSnapshotInput{
		SourceDBClusterSnapshotIdentifier: aws.String("String"), // Required
		TargetDBClusterSnapshotIdentifier: aws.String("String"), // Required
		CopyTags:          aws.Bool(true),
		DestinationRegion: aws.String("String"),
		KmsKeyId:          aws.String("String"),
		PreSignedUrl:      aws.String("String"),
		SourceRegion:      aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CopyDBClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CopyDBParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CopyDBParameterGroupInput{
		SourceDBParameterGroupIdentifier:  aws.String("String"), // Required
		TargetDBParameterGroupDescription: aws.String("String"), // Required
		TargetDBParameterGroupIdentifier:  aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CopyDBParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CopyDBSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CopyDBSnapshotInput{
		SourceDBSnapshotIdentifier: aws.String("String"), // Required
		TargetDBSnapshotIdentifier: aws.String("String"), // Required
		CopyTags:                   aws.Bool(true),
		DestinationRegion:          aws.String("String"),
		KmsKeyId:                   aws.String("String"),
		PreSignedUrl:               aws.String("String"),
		SourceRegion:               aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CopyDBSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CopyOptionGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CopyOptionGroupInput{
		SourceOptionGroupIdentifier:  aws.String("String"), // Required
		TargetOptionGroupDescription: aws.String("String"), // Required
		TargetOptionGroupIdentifier:  aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CopyOptionGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBClusterInput{
		DBClusterIdentifier: aws.String("String"), // Required
		Engine:              aws.String("String"), // Required
		AvailabilityZones: []*string{
			aws.String("String"), // Required
			// More values...
		},
		BackupRetentionPeriod:       aws.Int64(1),
		CharacterSetName:            aws.String("String"),
		DBClusterParameterGroupName: aws.String("String"),
		DBSubnetGroupName:           aws.String("String"),
		DatabaseName:                aws.String("String"),
		DestinationRegion:           aws.String("String"),
		EngineVersion:               aws.String("String"),
		KmsKeyId:                    aws.String("String"),
		MasterUserPassword:          aws.String("String"),
		MasterUsername:              aws.String("String"),
		OptionGroupName:             aws.String("String"),
		Port:                        aws.Int64(1),
		PreSignedUrl:                aws.String("String"),
		PreferredBackupWindow:       aws.String("String"),
		PreferredMaintenanceWindow:  aws.String("String"),
		ReplicationSourceIdentifier: aws.String("String"),
		SourceRegion:                aws.String("String"),
		StorageEncrypted:            aws.Bool(true),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("String"), // Required
		DBParameterGroupFamily:      aws.String("String"), // Required
		Description:                 aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBClusterSnapshotInput{
		DBClusterIdentifier:         aws.String("String"), // Required
		DBClusterSnapshotIdentifier: aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBInstance() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBInstanceInput{
		DBInstanceClass:         aws.String("String"), // Required
		DBInstanceIdentifier:    aws.String("String"), // Required
		Engine:                  aws.String("String"), // Required
		AllocatedStorage:        aws.Int64(1),
		AutoMinorVersionUpgrade: aws.Bool(true),
		AvailabilityZone:        aws.String("String"),
		BackupRetentionPeriod:   aws.Int64(1),
		CharacterSetName:        aws.String("String"),
		CopyTagsToSnapshot:      aws.Bool(true),
		DBClusterIdentifier:     aws.String("String"),
		DBName:                  aws.String("String"),
		DBParameterGroupName:    aws.String("String"),
		DBSecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DBSubnetGroupName:  aws.String("String"),
		Domain:             aws.String("String"),
		DomainIAMRoleName:  aws.String("String"),
		EngineVersion:      aws.String("String"),
		Iops:               aws.Int64(1),
		KmsKeyId:           aws.String("String"),
		LicenseModel:       aws.String("String"),
		MasterUserPassword: aws.String("String"),
		MasterUsername:     aws.String("String"),
		MonitoringInterval: aws.Int64(1),
		MonitoringRoleArn:  aws.String("String"),
		MultiAZ:            aws.Bool(true),
		OptionGroupName:    aws.String("String"),
		Port:               aws.Int64(1),
		PreferredBackupWindow:      aws.String("String"),
		PreferredMaintenanceWindow: aws.String("String"),
		PromotionTier:              aws.Int64(1),
		PubliclyAccessible:         aws.Bool(true),
		StorageEncrypted:           aws.Bool(true),
		StorageType:                aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		TdeCredentialArn:      aws.String("String"),
		TdeCredentialPassword: aws.String("String"),
		Timezone:              aws.String("String"),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateDBInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBInstanceReadReplica() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBInstanceReadReplicaInput{
		DBInstanceIdentifier:       aws.String("String"), // Required
		SourceDBInstanceIdentifier: aws.String("String"), // Required
		AutoMinorVersionUpgrade:    aws.Bool(true),
		AvailabilityZone:           aws.String("String"),
		CopyTagsToSnapshot:         aws.Bool(true),
		DBInstanceClass:            aws.String("String"),
		DBSubnetGroupName:          aws.String("String"),
		DestinationRegion:          aws.String("String"),
		Iops:                       aws.Int64(1),
		KmsKeyId:                   aws.String("String"),
		MonitoringInterval:         aws.Int64(1),
		MonitoringRoleArn:          aws.String("String"),
		OptionGroupName:            aws.String("String"),
		Port:                       aws.Int64(1),
		PreSignedUrl:               aws.String("String"),
		PubliclyAccessible:         aws.Bool(true),
		SourceRegion:               aws.String("String"),
		StorageType:                aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBInstanceReadReplica(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBParameterGroupInput{
		DBParameterGroupFamily: aws.String("String"), // Required
		DBParameterGroupName:   aws.String("String"), // Required
		Description:            aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBSecurityGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBSecurityGroupInput{
		DBSecurityGroupDescription: aws.String("String"), // Required
		DBSecurityGroupName:        aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBSnapshotInput{
		DBInstanceIdentifier: aws.String("String"), // Required
		DBSnapshotIdentifier: aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateDBSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateDBSubnetGroupInput{
		DBSubnetGroupDescription: aws.String("String"), // Required
		DBSubnetGroupName:        aws.String("String"), // Required
		SubnetIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateDBSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateEventSubscriptionInput{
		SnsTopicArn:      aws.String("String"), // Required
		SubscriptionName: aws.String("String"), // Required
		Enabled:          aws.Bool(true),
		EventCategories: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SourceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SourceType: aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_CreateOptionGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.CreateOptionGroupInput{
		EngineName:             aws.String("String"), // Required
		MajorEngineVersion:     aws.String("String"), // Required
		OptionGroupDescription: aws.String("String"), // Required
		OptionGroupName:        aws.String("String"), // Required
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.CreateOptionGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBClusterInput{
		DBClusterIdentifier:       aws.String("String"), // Required
		FinalDBSnapshotIdentifier: aws.String("String"),
		SkipFinalSnapshot:         aws.Bool(true),
	}
	resp, err := svc.DeleteDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBClusterSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBClusterSnapshotInput{
		DBClusterSnapshotIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBClusterSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBInstance() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBInstanceInput{
		DBInstanceIdentifier:      aws.String("String"), // Required
		FinalDBSnapshotIdentifier: aws.String("String"),
		SkipFinalSnapshot:         aws.Bool(true),
	}
	resp, err := svc.DeleteDBInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBParameterGroupInput{
		DBParameterGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBSecurityGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBSecurityGroupInput{
		DBSecurityGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBSnapshotInput{
		DBSnapshotIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteDBSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteDBSubnetGroupInput{
		DBSubnetGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteDBSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteEventSubscriptionInput{
		SubscriptionName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DeleteOptionGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DeleteOptionGroupInput{
		OptionGroupName: aws.String("String"), // Required
	}
	resp, err := svc.DeleteOptionGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeAccountAttributes() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	var params *rds.DescribeAccountAttributesInput
	resp, err := svc.DescribeAccountAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeCertificates() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeCertificatesInput{
		CertificateIdentifier: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeCertificates(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBClusterParameterGroups() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBClusterParameterGroupsInput{
		DBClusterParameterGroupName: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBClusterParameterGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBClusterParameters() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBClusterParametersInput{
		DBClusterParameterGroupName: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		Source:     aws.String("String"),
	}
	resp, err := svc.DescribeDBClusterParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBClusterSnapshotAttributes() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBClusterSnapshotAttributesInput{
		DBClusterSnapshotIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DescribeDBClusterSnapshotAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBClusterSnapshots() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBClusterSnapshotsInput{
		DBClusterIdentifier:         aws.String("String"),
		DBClusterSnapshotIdentifier: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		IncludePublic: aws.Bool(true),
		IncludeShared: aws.Bool(true),
		Marker:        aws.String("String"),
		MaxRecords:    aws.Int64(1),
		SnapshotType:  aws.String("String"),
	}
	resp, err := svc.DescribeDBClusterSnapshots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBClusters() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBClustersInput{
		DBClusterIdentifier: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBClusters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBEngineVersions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBEngineVersionsInput{
		DBParameterGroupFamily: aws.String("String"),
		DefaultOnly:            aws.Bool(true),
		Engine:                 aws.String("String"),
		EngineVersion:          aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ListSupportedCharacterSets: aws.Bool(true),
		ListSupportedTimezones:     aws.Bool(true),
		Marker:                     aws.String("String"),
		MaxRecords:                 aws.Int64(1),
	}
	resp, err := svc.DescribeDBEngineVersions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBInstances() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBInstancesInput{
		DBInstanceIdentifier: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBLogFiles() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBLogFilesInput{
		DBInstanceIdentifier: aws.String("String"), // Required
		FileLastWritten:      aws.Int64(1),
		FileSize:             aws.Int64(1),
		FilenameContains:     aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBLogFiles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBParameterGroups() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBParameterGroupsInput{
		DBParameterGroupName: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBParameterGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBParameters() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBParametersInput{
		DBParameterGroupName: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		Source:     aws.String("String"),
	}
	resp, err := svc.DescribeDBParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBSecurityGroups() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBSecurityGroupsInput{
		DBSecurityGroupName: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBSnapshotAttributes() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBSnapshotAttributesInput{
		DBSnapshotIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.DescribeDBSnapshotAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBSnapshots() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBSnapshotsInput{
		DBInstanceIdentifier: aws.String("String"),
		DBSnapshotIdentifier: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		IncludePublic: aws.Bool(true),
		IncludeShared: aws.Bool(true),
		Marker:        aws.String("String"),
		MaxRecords:    aws.Int64(1),
		SnapshotType:  aws.String("String"),
	}
	resp, err := svc.DescribeDBSnapshots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeDBSubnetGroups() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeDBSubnetGroupsInput{
		DBSubnetGroupName: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeDBSubnetGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeEngineDefaultClusterParameters() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeEngineDefaultClusterParametersInput{
		DBParameterGroupFamily: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeEngineDefaultClusterParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeEngineDefaultParameters() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeEngineDefaultParametersInput{
		DBParameterGroupFamily: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
	}
	resp, err := svc.DescribeEngineDefaultParameters(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeEventCategories() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeEventCategoriesInput{
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		SourceType: aws.String("String"),
	}
	resp, err := svc.DescribeEventCategories(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeEventSubscriptions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeEventSubscriptionsInput{
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:           aws.String("String"),
		MaxRecords:       aws.Int64(1),
		SubscriptionName: aws.String("String"),
	}
	resp, err := svc.DescribeEventSubscriptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeEvents() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeEventsInput{
		Duration: aws.Int64(1),
		EndTime:  aws.Time(time.Now()),
		EventCategories: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:           aws.String("String"),
		MaxRecords:       aws.Int64(1),
		SourceIdentifier: aws.String("String"),
		SourceType:       aws.String("SourceType"),
		StartTime:        aws.Time(time.Now()),
	}
	resp, err := svc.DescribeEvents(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeOptionGroupOptions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeOptionGroupOptionsInput{
		EngineName: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MajorEngineVersion: aws.String("String"),
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
	}
	resp, err := svc.DescribeOptionGroupOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeOptionGroups() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeOptionGroupsInput{
		EngineName: aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MajorEngineVersion: aws.String("String"),
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
		OptionGroupName:    aws.String("String"),
	}
	resp, err := svc.DescribeOptionGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeOrderableDBInstanceOptions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeOrderableDBInstanceOptionsInput{
		Engine:          aws.String("String"), // Required
		DBInstanceClass: aws.String("String"),
		EngineVersion:   aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		LicenseModel: aws.String("String"),
		Marker:       aws.String("String"),
		MaxRecords:   aws.Int64(1),
		Vpc:          aws.Bool(true),
	}
	resp, err := svc.DescribeOrderableDBInstanceOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribePendingMaintenanceActions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribePendingMaintenanceActionsInput{
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:             aws.String("String"),
		MaxRecords:         aws.Int64(1),
		ResourceIdentifier: aws.String("String"),
	}
	resp, err := svc.DescribePendingMaintenanceActions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeReservedDBInstances() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeReservedDBInstancesInput{
		DBInstanceClass: aws.String("String"),
		Duration:        aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:                        aws.String("String"),
		MaxRecords:                    aws.Int64(1),
		MultiAZ:                       aws.Bool(true),
		OfferingType:                  aws.String("String"),
		ProductDescription:            aws.String("String"),
		ReservedDBInstanceId:          aws.String("String"),
		ReservedDBInstancesOfferingId: aws.String("String"),
	}
	resp, err := svc.DescribeReservedDBInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeReservedDBInstancesOfferings() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeReservedDBInstancesOfferingsInput{
		DBInstanceClass: aws.String("String"),
		Duration:        aws.String("String"),
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:                        aws.String("String"),
		MaxRecords:                    aws.Int64(1),
		MultiAZ:                       aws.Bool(true),
		OfferingType:                  aws.String("String"),
		ProductDescription:            aws.String("String"),
		ReservedDBInstancesOfferingId: aws.String("String"),
	}
	resp, err := svc.DescribeReservedDBInstancesOfferings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DescribeSourceRegions() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DescribeSourceRegionsInput{
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		Marker:     aws.String("String"),
		MaxRecords: aws.Int64(1),
		RegionName: aws.String("String"),
	}
	resp, err := svc.DescribeSourceRegions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_DownloadDBLogFilePortion() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.DownloadDBLogFilePortionInput{
		DBInstanceIdentifier: aws.String("String"), // Required
		LogFileName:          aws.String("String"), // Required
		Marker:               aws.String("String"),
		NumberOfLines:        aws.Int64(1),
	}
	resp, err := svc.DownloadDBLogFilePortion(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_FailoverDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.FailoverDBClusterInput{
		DBClusterIdentifier:        aws.String("String"),
		TargetDBInstanceIdentifier: aws.String("String"),
	}
	resp, err := svc.FailoverDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ListTagsForResource() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ListTagsForResourceInput{
		ResourceName: aws.String("String"), // Required
		Filters: []*rds.Filter{
			{ // Required
				Name: aws.String("String"), // Required
				Values: []*string{ // Required
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.ListTagsForResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBClusterInput{
		DBClusterIdentifier:         aws.String("String"), // Required
		ApplyImmediately:            aws.Bool(true),
		BackupRetentionPeriod:       aws.Int64(1),
		DBClusterParameterGroupName: aws.String("String"),
		MasterUserPassword:          aws.String("String"),
		NewDBClusterIdentifier:      aws.String("String"),
		OptionGroupName:             aws.String("String"),
		Port:                        aws.Int64(1),
		PreferredBackupWindow:      aws.String("String"),
		PreferredMaintenanceWindow: aws.String("String"),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("String"), // Required
		Parameters: []*rds.Parameter{ // Required
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyMethod:          aws.String("ApplyMethod"),
				ApplyType:            aws.String("String"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.ModifyDBClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBClusterSnapshotAttribute() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBClusterSnapshotAttributeInput{
		AttributeName:               aws.String("String"), // Required
		DBClusterSnapshotIdentifier: aws.String("String"), // Required
		ValuesToAdd: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ValuesToRemove: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyDBClusterSnapshotAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBInstance() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBInstanceInput{
		DBInstanceIdentifier:     aws.String("String"), // Required
		AllocatedStorage:         aws.Int64(1),
		AllowMajorVersionUpgrade: aws.Bool(true),
		ApplyImmediately:         aws.Bool(true),
		AutoMinorVersionUpgrade:  aws.Bool(true),
		BackupRetentionPeriod:    aws.Int64(1),
		CACertificateIdentifier:  aws.String("String"),
		CopyTagsToSnapshot:       aws.Bool(true),
		DBInstanceClass:          aws.String("String"),
		DBParameterGroupName:     aws.String("String"),
		DBPortNumber:             aws.Int64(1),
		DBSecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DBSubnetGroupName:          aws.String("String"),
		Domain:                     aws.String("String"),
		DomainIAMRoleName:          aws.String("String"),
		EngineVersion:              aws.String("String"),
		Iops:                       aws.Int64(1),
		LicenseModel:               aws.String("String"),
		MasterUserPassword:         aws.String("String"),
		MonitoringInterval:         aws.Int64(1),
		MonitoringRoleArn:          aws.String("String"),
		MultiAZ:                    aws.Bool(true),
		NewDBInstanceIdentifier:    aws.String("String"),
		OptionGroupName:            aws.String("String"),
		PreferredBackupWindow:      aws.String("String"),
		PreferredMaintenanceWindow: aws.String("String"),
		PromotionTier:              aws.Int64(1),
		PubliclyAccessible:         aws.Bool(true),
		StorageType:                aws.String("String"),
		TdeCredentialArn:           aws.String("String"),
		TdeCredentialPassword:      aws.String("String"),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyDBInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBParameterGroupInput{
		DBParameterGroupName: aws.String("String"), // Required
		Parameters: []*rds.Parameter{ // Required
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyMethod:          aws.String("ApplyMethod"),
				ApplyType:            aws.String("String"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.ModifyDBParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBSnapshotInput{
		DBSnapshotIdentifier: aws.String("String"), // Required
		EngineVersion:        aws.String("String"),
	}
	resp, err := svc.ModifyDBSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBSnapshotAttribute() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBSnapshotAttributeInput{
		AttributeName:        aws.String("String"), // Required
		DBSnapshotIdentifier: aws.String("String"), // Required
		ValuesToAdd: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ValuesToRemove: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyDBSnapshotAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyDBSubnetGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyDBSubnetGroupInput{
		DBSubnetGroupName: aws.String("String"), // Required
		SubnetIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DBSubnetGroupDescription: aws.String("String"),
	}
	resp, err := svc.ModifyDBSubnetGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyEventSubscription() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyEventSubscriptionInput{
		SubscriptionName: aws.String("String"), // Required
		Enabled:          aws.Bool(true),
		EventCategories: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SnsTopicArn: aws.String("String"),
		SourceType:  aws.String("String"),
	}
	resp, err := svc.ModifyEventSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ModifyOptionGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ModifyOptionGroupInput{
		OptionGroupName:  aws.String("String"), // Required
		ApplyImmediately: aws.Bool(true),
		OptionsToInclude: []*rds.OptionConfiguration{
			{ // Required
				OptionName: aws.String("String"), // Required
				DBSecurityGroupMemberships: []*string{
					aws.String("String"), // Required
					// More values...
				},
				OptionSettings: []*rds.OptionSetting{
					{ // Required
						AllowedValues: aws.String("String"),
						ApplyType:     aws.String("String"),
						DataType:      aws.String("String"),
						DefaultValue:  aws.String("String"),
						Description:   aws.String("String"),
						IsCollection:  aws.Bool(true),
						IsModifiable:  aws.Bool(true),
						Name:          aws.String("String"),
						Value:         aws.String("String"),
					},
					// More values...
				},
				OptionVersion: aws.String("String"),
				Port:          aws.Int64(1),
				VpcSecurityGroupMemberships: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		OptionsToRemove: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyOptionGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_PromoteReadReplica() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.PromoteReadReplicaInput{
		DBInstanceIdentifier:  aws.String("String"), // Required
		BackupRetentionPeriod: aws.Int64(1),
		PreferredBackupWindow: aws.String("String"),
	}
	resp, err := svc.PromoteReadReplica(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_PromoteReadReplicaDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.PromoteReadReplicaDBClusterInput{
		DBClusterIdentifier: aws.String("String"), // Required
	}
	resp, err := svc.PromoteReadReplicaDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_PurchaseReservedDBInstancesOffering() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.PurchaseReservedDBInstancesOfferingInput{
		ReservedDBInstancesOfferingId: aws.String("String"), // Required
		DBInstanceCount:               aws.Int64(1),
		ReservedDBInstanceId:          aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.PurchaseReservedDBInstancesOffering(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RebootDBInstance() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RebootDBInstanceInput{
		DBInstanceIdentifier: aws.String("String"), // Required
		ForceFailover:        aws.Bool(true),
	}
	resp, err := svc.RebootDBInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RemoveRoleFromDBCluster() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RemoveRoleFromDBClusterInput{
		DBClusterIdentifier: aws.String("String"), // Required
		RoleArn:             aws.String("String"), // Required
	}
	resp, err := svc.RemoveRoleFromDBCluster(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RemoveSourceIdentifierFromSubscription() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RemoveSourceIdentifierFromSubscriptionInput{
		SourceIdentifier: aws.String("String"), // Required
		SubscriptionName: aws.String("String"), // Required
	}
	resp, err := svc.RemoveSourceIdentifierFromSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RemoveTagsFromResource() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RemoveTagsFromResourceInput{
		ResourceName: aws.String("String"), // Required
		TagKeys: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.RemoveTagsFromResource(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ResetDBClusterParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ResetDBClusterParameterGroupInput{
		DBClusterParameterGroupName: aws.String("String"), // Required
		Parameters: []*rds.Parameter{
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyMethod:          aws.String("ApplyMethod"),
				ApplyType:            aws.String("String"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
		ResetAllParameters: aws.Bool(true),
	}
	resp, err := svc.ResetDBClusterParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_ResetDBParameterGroup() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.ResetDBParameterGroupInput{
		DBParameterGroupName: aws.String("String"), // Required
		Parameters: []*rds.Parameter{
			{ // Required
				AllowedValues:        aws.String("String"),
				ApplyMethod:          aws.String("ApplyMethod"),
				ApplyType:            aws.String("String"),
				DataType:             aws.String("String"),
				Description:          aws.String("String"),
				IsModifiable:         aws.Bool(true),
				MinimumEngineVersion: aws.String("String"),
				ParameterName:        aws.String("String"),
				ParameterValue:       aws.String("String"),
				Source:               aws.String("String"),
			},
			// More values...
		},
		ResetAllParameters: aws.Bool(true),
	}
	resp, err := svc.ResetDBParameterGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RestoreDBClusterFromS3() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RestoreDBClusterFromS3Input{
		DBClusterIdentifier: aws.String("String"), // Required
		Engine:              aws.String("String"), // Required
		MasterUserPassword:  aws.String("String"), // Required
		MasterUsername:      aws.String("String"), // Required
		S3BucketName:        aws.String("String"), // Required
		S3IngestionRoleArn:  aws.String("String"), // Required
		SourceEngine:        aws.String("String"), // Required
		SourceEngineVersion: aws.String("String"), // Required
		AvailabilityZones: []*string{
			aws.String("String"), // Required
			// More values...
		},
		BackupRetentionPeriod:       aws.Int64(1),
		CharacterSetName:            aws.String("String"),
		DBClusterParameterGroupName: aws.String("String"),
		DBSubnetGroupName:           aws.String("String"),
		DatabaseName:                aws.String("String"),
		EngineVersion:               aws.String("String"),
		KmsKeyId:                    aws.String("String"),
		OptionGroupName:             aws.String("String"),
		Port:                        aws.Int64(1),
		PreferredBackupWindow:      aws.String("String"),
		PreferredMaintenanceWindow: aws.String("String"),
		S3Prefix:                   aws.String("String"),
		StorageEncrypted:           aws.Bool(true),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.RestoreDBClusterFromS3(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RestoreDBClusterFromSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RestoreDBClusterFromSnapshotInput{
		DBClusterIdentifier: aws.String("String"), // Required
		Engine:              aws.String("String"), // Required
		SnapshotIdentifier:  aws.String("String"), // Required
		AvailabilityZones: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DBSubnetGroupName: aws.String("String"),
		DatabaseName:      aws.String("String"),
		EngineVersion:     aws.String("String"),
		KmsKeyId:          aws.String("String"),
		OptionGroupName:   aws.String("String"),
		Port:              aws.Int64(1),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.RestoreDBClusterFromSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RestoreDBClusterToPointInTime() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RestoreDBClusterToPointInTimeInput{
		DBClusterIdentifier:       aws.String("String"), // Required
		SourceDBClusterIdentifier: aws.String("String"), // Required
		DBSubnetGroupName:         aws.String("String"),
		KmsKeyId:                  aws.String("String"),
		OptionGroupName:           aws.String("String"),
		Port:                      aws.Int64(1),
		RestoreToTime:             aws.Time(time.Now()),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		UseLatestRestorableTime: aws.Bool(true),
		VpcSecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.RestoreDBClusterToPointInTime(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RestoreDBInstanceFromDBSnapshot() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RestoreDBInstanceFromDBSnapshotInput{
		DBInstanceIdentifier:    aws.String("String"), // Required
		DBSnapshotIdentifier:    aws.String("String"), // Required
		AutoMinorVersionUpgrade: aws.Bool(true),
		AvailabilityZone:        aws.String("String"),
		CopyTagsToSnapshot:      aws.Bool(true),
		DBInstanceClass:         aws.String("String"),
		DBName:                  aws.String("String"),
		DBSubnetGroupName:       aws.String("String"),
		Domain:                  aws.String("String"),
		DomainIAMRoleName:       aws.String("String"),
		Engine:                  aws.String("String"),
		Iops:                    aws.Int64(1),
		LicenseModel:            aws.String("String"),
		MultiAZ:                 aws.Bool(true),
		OptionGroupName:         aws.String("String"),
		Port:                    aws.Int64(1),
		PubliclyAccessible:      aws.Bool(true),
		StorageType:             aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		TdeCredentialArn:      aws.String("String"),
		TdeCredentialPassword: aws.String("String"),
	}
	resp, err := svc.RestoreDBInstanceFromDBSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RestoreDBInstanceToPointInTime() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RestoreDBInstanceToPointInTimeInput{
		SourceDBInstanceIdentifier: aws.String("String"), // Required
		TargetDBInstanceIdentifier: aws.String("String"), // Required
		AutoMinorVersionUpgrade:    aws.Bool(true),
		AvailabilityZone:           aws.String("String"),
		CopyTagsToSnapshot:         aws.Bool(true),
		DBInstanceClass:            aws.String("String"),
		DBName:                     aws.String("String"),
		DBSubnetGroupName:          aws.String("String"),
		Domain:                     aws.String("String"),
		DomainIAMRoleName:          aws.String("String"),
		Engine:                     aws.String("String"),
		Iops:                       aws.Int64(1),
		LicenseModel:               aws.String("String"),
		MultiAZ:                    aws.Bool(true),
		OptionGroupName:            aws.String("String"),
		Port:                       aws.Int64(1),
		PubliclyAccessible:         aws.Bool(true),
		RestoreTime:                aws.Time(time.Now()),
		StorageType:                aws.String("String"),
		Tags: []*rds.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		TdeCredentialArn:        aws.String("String"),
		TdeCredentialPassword:   aws.String("String"),
		UseLatestRestorableTime: aws.Bool(true),
	}
	resp, err := svc.RestoreDBInstanceToPointInTime(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleRDS_RevokeDBSecurityGroupIngress() {
	sess := session.Must(session.NewSession())

	svc := rds.New(sess)

	params := &rds.RevokeDBSecurityGroupIngressInput{
		DBSecurityGroupName:     aws.String("String"), // Required
		CIDRIP:                  aws.String("String"),
		EC2SecurityGroupId:      aws.String("String"),
		EC2SecurityGroupName:    aws.String("String"),
		EC2SecurityGroupOwnerId: aws.String("String"),
	}
	resp, err := svc.RevokeDBSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
