#!/usr/bin/env python
# -*- coding: utf-8 -*-

#
# Generated Thu Dec  1 09:58:36 2011 by generateDS.py version 2.7a.
#

import re as re_
import sys

etree_ = None
Verbose_import_ = False
(XMLParser_import_none, XMLParser_import_lxml,
    XMLParser_import_elementtree
 ) = range(3)
XMLParser_import_library = None
try:
    # lxml
    from lxml import etree as etree_
    XMLParser_import_library = XMLParser_import_lxml
    if Verbose_import_:
        print("running with lxml.etree")
except ImportError:
    try:
        # cElementTree from Python 2.5+
        # pylint: disable=E0602, E0611
        import xml.etree.cElementTree as etree_
        XMLParser_import_library = XMLParser_import_elementtree
        if Verbose_import_:
            print("running with cElementTree on Python 2.5+")
    except ImportError:
        try:
            # ElementTree from Python 2.5+
            # pylint: disable=E0602,E0611
            import xml.etree.ElementTree as etree_
            XMLParser_import_library = XMLParser_import_elementtree
            if Verbose_import_:
                print("running with ElementTree on Python 2.5+")
        except ImportError:
            try:
                # normal cElementTree install
                import cElementTree as etree_
                XMLParser_import_library = XMLParser_import_elementtree
                if Verbose_import_:
                    print("running with cElementTree")
            except ImportError:
                try:
                    # normal ElementTree install
                    import elementtree.ElementTree as etree_
                    XMLParser_import_library = XMLParser_import_elementtree
                    if Verbose_import_:
                        print("running with ElementTree")
                except ImportError:
                    raise ImportError("Failed to import ElementTree from any known place")


def parsexml_(*args, **kwargs):
    if (XMLParser_import_library == XMLParser_import_lxml and
            'parser' not in kwargs):
        # Use the lxml ElementTree compatible parser so that, e.g.,
        #   we ignore comments.
        kwargs['parser'] = etree_.ETCompatXMLParser()
    doc = etree_.parse(*args, **kwargs)
    return doc

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.


try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):

        def gds_format_string(self, input_data, input_name=''):
            return input_data

        def gds_validate_string(self, input_data, node, input_name=''):
            return input_data

        def gds_format_integer(self, input_data, input_name=''):
            return '%d' % input_data

        def gds_validate_integer(self, input_data, node, input_name=''):
            return input_data

        def gds_format_integer_list(self, input_data, input_name=''):
            return '%s' % input_data

        def gds_validate_integer_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of integers')
            return input_data

        def gds_format_float(self, input_data, input_name=''):
            return '%f' % input_data

        def gds_validate_float(self, input_data, node, input_name=''):
            return input_data

        def gds_format_float_list(self, input_data, input_name=''):
            return '%s' % input_data

        def gds_validate_float_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of floats')
            return input_data

        def gds_format_double(self, input_data, input_name=''):
            return '%e' % input_data

        def gds_validate_double(self, input_data, node, input_name=''):
            return input_data

        def gds_format_double_list(self, input_data, input_name=''):
            return '%s' % input_data

        def gds_validate_double_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                try:
                    fvalue = float(value)
                except (TypeError, ValueError), exp:
                    raise_parse_error(node, 'Requires sequence of doubles')
            return input_data

        def gds_format_boolean(self, input_data, input_name=''):
            return '%s' % input_data

        def gds_validate_boolean(self, input_data, node, input_name=''):
            return input_data

        def gds_format_boolean_list(self, input_data, input_name=''):
            return '%s' % input_data

        def gds_validate_boolean_list(self, input_data, node, input_name=''):
            values = input_data.split()
            for value in values:
                if value not in ('true', '1', 'false', '0', ):
                    raise_parse_error(node, 'Requires sequence of booleans ("true", "1", "false", "0")')
            return input_data

        def gds_str_lower(self, instring):
            return instring.lower()

        def get_path_(self, node):
            path_list = []
            self.get_path_list_(node, path_list)
            path_list.reverse()
            path = '/'.join(path_list)
            return path
        Tag_strip_pattern_ = re_.compile(r'\{.*\}')

        def get_path_list_(self, node, path_list):
            if node is None:
                return
            tag = GeneratedsSuper.Tag_strip_pattern_.sub('', node.tag)
            if tag:
                path_list.append(tag)
            self.get_path_list_(node.getparent(), path_list)

        def get_class_obj_(self, node, default_class=None):
            class_obj1 = default_class
            if 'xsi' in node.nsmap:
                classname = node.get('{%s}type' % node.nsmap['xsi'])
                if classname is not None:
                    names = classname.split(':')
                    if len(names) == 2:
                        classname = names[1]
                    class_obj2 = globals().get(classname)
                    if class_obj2 is not None:
                        class_obj1 = class_obj2
            return class_obj1

        def gds_build_any(self, node, type_name=None):
            return None


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

# from IPython.Shell import IPShellEmbed
# args = ''
# ipshell = IPShellEmbed(args,
#     banner = 'Dropping into IPython',
# exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'
Tag_pattern_ = re_.compile(r'({.*})?(.*)')
String_cleanup_pat_ = re_.compile(r"[\n\r\s]+")
Namespace_extract_pat_ = re_.compile(r'{(.*)}(.*)')

#
# Support/utility functions.
#


def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')


def quote_xml(inStr):
    if not inStr:
        return ''
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1


def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1


def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


def get_all_text_(node):
    if node.text is not None:
        text = node.text
    else:
        text = ''
    for child in node:
        if child.tail is not None:
            text += child.tail
    return text


def find_attr_value_(attr_name, node):
    attrs = node.attrib
    attr_parts = attr_name.split(':')
    value = None
    if len(attr_parts) == 1:
        value = attrs.get(attr_name)
    elif len(attr_parts) == 2:
        prefix, name = attr_parts
        namespace = node.nsmap.get(prefix)
        if namespace is not None:
            value = attrs.get('{%s}%s' % (namespace, name, ))
    return value


class GDSParseError(Exception):
    pass


def raise_parse_error(node, msg):
    if XMLParser_import_library == XMLParser_import_lxml:
        msg = '%s (element %s/line %d)' % (msg, node.tag, node.sourceline, )
    else:
        msg = '%s (element %s)' % (msg, node.tag, )
    raise GDSParseError(msg)


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7

    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value

    def getCategory(self):
        return self.category

    def getContenttype(self, content_type):
        return self.content_type

    def getValue(self):
        return self.value

    def getName(self):
        return self.name

    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            # Prevent exporting empty content as empty lines.
            if self.value.strip():
                outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace, name)

    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))

    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' %
                          (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s", "%s"),\n' %
                          (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('model_.MixedContainer(%d, %d, "%s",\n' %
                          (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):

    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container

    def set_name(self, name):
        self.name = name

    def get_name(self):
        return self.name

    def set_data_type(self, data_type):
        self.data_type = data_type

    def get_data_type_chain(self):
        return self.data_type

    def get_data_type(self):
        if isinstance(self.data_type, list):
            if len(self.data_type) > 0:
                return self.data_type[-1]
            else:
                return 'xs:string'
        else:
            return self.data_type

    def set_container(self, container):
        self.container = container

    def get_container(self):
        return self.container


def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#


class testsuites(GeneratedsSuper):

    """Contains an aggregation of testsuite results"""
    subclass = None
    superclass = None

    def __init__(self, testsuite=None):
        if testsuite is None:
            self.testsuite = []
        else:
            self.testsuite = testsuite

    def factory(*args_, **kwargs_):
        if testsuites.subclass:
            # pylint: disable=E1102
            return testsuites.subclass(*args_, **kwargs_)
        else:
            return testsuites(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_testsuite(self):
        return self.testsuite

    def set_testsuite(self, testsuite):
        self.testsuite = testsuite

    def add_testsuite(self, value):
        self.testsuite.append(value)

    def insert_testsuite(self, index, value):
        self.testsuite[index] = value

    def export(self, outfile, level, namespace_='', name_='testsuites', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='testsuites')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='testsuites'):
        pass

    def exportChildren(self, outfile, level, namespace_='', name_='testsuites', fromsubclass_=False):
        for testsuite_ in self.testsuite:
            testsuite_.export(outfile, level, namespace_, name_='testsuite')

    def hasContent_(self):
        if (
            self.testsuite
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='testsuites'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass

    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('testsuite=[\n')
        level += 1
        for testsuite_ in self.testsuite:
            showIndent(outfile, level)
            outfile.write('model_.testsuiteType(\n')
            testsuite_.exportLiteral(outfile, level, name_='testsuiteType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'testsuite':
            obj_ = testsuiteType.factory()
            obj_.build(child_)
            self.testsuite.append(obj_)
# end class testsuites


class testsuite(GeneratedsSuper):

    """Contains the results of exexuting a testsuiteFull class name of the
    test for non-aggregated testsuite documents. Class name without
    the package for aggregated testsuites documentswhen the test was
    executed. Timezone may not be specified.Host on which the tests
    were executed. 'localhost' should be used if the hostname cannot
    be determined.The total number of tests in the suiteThe total
    number of tests in the suite that failed. A failure is a test
    which the code has explicitly failed by using the mechanisms for
    that purpose. e.g., via an assertEqualsThe total number of tests
    in the suite that errorrd. An errored test is one that had an
    unanticipated problem. e.g., an unchecked throwable; or a
    problem with the implementation of the test.Time taken (in
    seconds) to execute the tests in the suite"""
    subclass = None
    superclass = None

    def __init__(self, tests=None, errors=None, name=None, timestamp=None, hostname=None, time=None, failures=None, properties=None, testcase=None, system_out=None, system_err=None, extensiontype_=None):
        self.tests = _cast(int, tests)
        self.errors = _cast(int, errors)
        self.name = _cast(None, name)
        self.timestamp = _cast(None, timestamp)
        self.hostname = _cast(None, hostname)
        self.time = _cast(float, time)
        self.failures = _cast(int, failures)
        self.properties = properties
        if testcase is None:
            self.testcase = []
        else:
            self.testcase = testcase
        self.system_out = system_out
        self.system_err = system_err
        self.extensiontype_ = extensiontype_

    def factory(*args_, **kwargs_):
        if testsuite.subclass:
            # pylint: disable=E1102
            return testsuite.subclass(*args_, **kwargs_)
        else:
            return testsuite(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_properties(self):
        return self.properties

    def set_properties(self, properties):
        self.properties = properties

    def get_testcase(self):
        return self.testcase

    def set_testcase(self, testcase):
        self.testcase = testcase

    def add_testcase(self, value):
        self.testcase.append(value)

    def insert_testcase(self, index, value):
        self.testcase[index] = value

    def get_system_out(self):
        return self.system_out

    def set_system_out(self, system_out):
        self.system_out = system_out

    def get_system_err(self):
        return self.system_err

    def set_system_err(self, system_err):
        self.system_err = system_err

    def get_tests(self):
        return self.tests

    def set_tests(self, tests):
        self.tests = tests

    def get_errors(self):
        return self.errors

    def set_errors(self, errors):
        self.errors = errors

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_timestamp(self):
        return self.timestamp

    def set_timestamp(self, timestamp):
        self.timestamp = timestamp

    def validate_ISO8601_DATETIME_PATTERN(self, value):
        # Validate type ISO8601_DATETIME_PATTERN, a restriction on xs:dateTime.
        pass

    def get_hostname(self):
        return self.hostname

    def set_hostname(self, hostname):
        self.hostname = hostname

    def get_time(self):
        return self.time

    def set_time(self, time):
        self.time = time

    def get_failures(self):
        return self.failures

    def set_failures(self, failures):
        self.failures = failures

    def get_extensiontype_(self):
        return self.extensiontype_

    def set_extensiontype_(self, extensiontype_):
        self.extensiontype_ = extensiontype_

    def export(self, outfile, level, namespace_='', name_='testsuite', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='testsuite')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='testsuite'):
        if self.tests is not None and 'tests' not in already_processed:
            already_processed.append('tests')
            outfile.write(' tests="%s"' % self.gds_format_integer(self.tests, input_name='tests'))
        if self.errors is not None and 'errors' not in already_processed:
            already_processed.append('errors')
            outfile.write(' errors="%s"' % self.gds_format_integer(self.errors, input_name='errors'))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            outfile.write(' timestamp=%s' % (quote_attrib(self.timestamp), ))
        if self.hostname is not None and 'hostname' not in already_processed:
            already_processed.append('hostname')
            outfile.write(' hostname=%s' % (self.gds_format_string(quote_attrib(self.hostname).encode(ExternalEncoding), input_name='hostname'), ))
        if self.time is not None and 'time' not in already_processed:
            already_processed.append('time')
            outfile.write(' time="%s"' % self.gds_format_float(self.time, input_name='time'))
        if self.failures is not None and 'failures' not in already_processed:
            already_processed.append('failures')
            outfile.write(' failures="%s"' % self.gds_format_integer(self.failures, input_name='failures'))
        if self.extensiontype_ is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            outfile.write(' xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"')
            outfile.write(' xsi:type="%s"' % self.extensiontype_)

    def exportChildren(self, outfile, level, namespace_='', name_='testsuite', fromsubclass_=False):
        if self.properties is not None:
            self.properties.export(outfile, level, namespace_, name_='properties', )
        for testcase_ in self.testcase:
            testcase_.export(outfile, level, namespace_, name_='testcase')
        if self.system_out is not None:
            showIndent(outfile, level)
            outfile.write('<%ssystem-out>%s</%ssystem-out>\n' % (namespace_, self.gds_format_string(quote_xml(self.system_out).encode(ExternalEncoding), input_name='system-out'), namespace_))
        if self.system_err is not None:
            showIndent(outfile, level)
            outfile.write('<%ssystem-err>%s</%ssystem-err>\n' % (namespace_, self.gds_format_string(quote_xml(self.system_err).encode(ExternalEncoding), input_name='system-err'), namespace_))

    def hasContent_(self):
        if (
            self.properties is not None or
            self.testcase or
            self.system_out is not None or
            self.system_err is not None
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='testsuite'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.tests is not None and 'tests' not in already_processed:
            already_processed.append('tests')
            showIndent(outfile, level)
            outfile.write('tests = %d,\n' % (self.tests,))
        if self.errors is not None and 'errors' not in already_processed:
            already_processed.append('errors')
            showIndent(outfile, level)
            outfile.write('errors = %d,\n' % (self.errors,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.timestamp is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            showIndent(outfile, level)
            outfile.write('timestamp = "%s",\n' % (self.timestamp,))
        if self.hostname is not None and 'hostname' not in already_processed:
            already_processed.append('hostname')
            showIndent(outfile, level)
            outfile.write('hostname = "%s",\n' % (self.hostname,))
        if self.time is not None and 'time' not in already_processed:
            already_processed.append('time')
            showIndent(outfile, level)
            outfile.write('time = %f,\n' % (self.time,))
        if self.failures is not None and 'failures' not in already_processed:
            already_processed.append('failures')
            showIndent(outfile, level)
            outfile.write('failures = %d,\n' % (self.failures,))

    def exportLiteralChildren(self, outfile, level, name_):
        if self.properties is not None:
            showIndent(outfile, level)
            outfile.write('properties=model_.propertiesType(\n')
            self.properties.exportLiteral(outfile, level, name_='properties')
            showIndent(outfile, level)
            outfile.write('),\n')
        showIndent(outfile, level)
        outfile.write('testcase=[\n')
        level += 1
        for testcase_ in self.testcase:
            showIndent(outfile, level)
            outfile.write('model_.testcaseType(\n')
            testcase_.exportLiteral(outfile, level, name_='testcaseType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        if self.system_out is not None:
            showIndent(outfile, level)
            outfile.write('system_out=%s,\n' % quote_python(self.system_out).encode(ExternalEncoding))
        if self.system_err is not None:
            showIndent(outfile, level)
            outfile.write('system_err=%s,\n' % quote_python(self.system_err).encode(ExternalEncoding))

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('tests', node)
        if value is not None and 'tests' not in already_processed:
            already_processed.append('tests')
            try:
                self.tests = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('errors', node)
        if value is not None and 'errors' not in already_processed:
            already_processed.append('errors')
            try:
                self.errors = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
            self.name = ' '.join(self.name.split())
        value = find_attr_value_('timestamp', node)
        if value is not None and 'timestamp' not in already_processed:
            already_processed.append('timestamp')
            self.timestamp = value
            self.validate_ISO8601_DATETIME_PATTERN(self.timestamp)    # validate type ISO8601_DATETIME_PATTERN
        value = find_attr_value_('hostname', node)
        if value is not None and 'hostname' not in already_processed:
            already_processed.append('hostname')
            self.hostname = value
            self.hostname = ' '.join(self.hostname.split())
        value = find_attr_value_('time', node)
        if value is not None and 'time' not in already_processed:
            already_processed.append('time')
            try:
                self.time = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (time): %s' % exp)
        value = find_attr_value_('failures', node)
        if value is not None and 'failures' not in already_processed:
            already_processed.append('failures')
            try:
                self.failures = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('xsi:type', node)
        if value is not None and 'xsi:type' not in already_processed:
            already_processed.append('xsi:type')
            self.extensiontype_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'properties':
            obj_ = propertiesType.factory()
            obj_.build(child_)
            self.set_properties(obj_)
        elif nodeName_ == 'testcase':
            obj_ = testcaseType.factory()
            obj_.build(child_)
            self.testcase.append(obj_)
        elif nodeName_ == 'system-out':
            system_out_ = child_.text
            system_out_ = self.gds_validate_string(system_out_, node, 'system_out')
            self.system_out = system_out_
        elif nodeName_ == 'system-err':
            system_err_ = child_.text
            system_err_ = self.gds_validate_string(system_err_, node, 'system_err')
            self.system_err = system_err_
# end class testsuite


class system_out(GeneratedsSuper):

    """Data that was written to standard out while the test was executed"""
    subclass = None
    superclass = None

    def __init__(self):
        pass

    def factory(*args_, **kwargs_):
        if system_out.subclass:
            # pylint: disable=E1102
            return system_out.subclass(*args_, **kwargs_)
        else:
            return system_out(*args_, **kwargs_)
    factory = staticmethod(factory)

    def export(self, outfile, level, namespace_='', name_='system-out', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='system-out')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='system-out'):
        pass

    def exportChildren(self, outfile, level, namespace_='', name_='system-out', fromsubclass_=False):
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='system-out'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass

    def exportLiteralChildren(self, outfile, level, name_):
        pass

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class system_out


class system_err(GeneratedsSuper):

    """Data that was written to standard error while the test was executed"""
    subclass = None
    superclass = None

    def __init__(self):
        pass

    def factory(*args_, **kwargs_):
        if system_err.subclass:
            # pylint: disable=E1102
            return system_err.subclass(*args_, **kwargs_)
        else:
            return system_err(*args_, **kwargs_)
    factory = staticmethod(factory)

    def export(self, outfile, level, namespace_='', name_='system-err', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='system-err')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='system-err'):
        pass

    def exportChildren(self, outfile, level, namespace_='', name_='system-err', fromsubclass_=False):
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='system-err'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass

    def exportLiteralChildren(self, outfile, level, name_):
        pass

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class system_err


class testsuiteType(testsuite):

    """Derived from testsuite/@name in the non-aggregated documentsStarts
    at '0' for the first testsuite and is incremented by 1 for each
    following testsuite"""
    subclass = None
    superclass = testsuite

    def __init__(self, tests=None, errors=None, name=None, timestamp=None, hostname=None, time=None, failures=None, properties=None, testcase=None, system_out=None, system_err=None, id=None, package=None):
        super(testsuiteType, self).__init__(tests, errors, name, timestamp, hostname, time, failures, properties, testcase, system_out, system_err, )
        self.id = _cast(int, id)
        self.package = _cast(None, package)
        pass

    def factory(*args_, **kwargs_):
        if testsuiteType.subclass:
            return testsuiteType.subclass(*args_, **kwargs_)
        else:
            return testsuiteType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_id(self):
        return self.id

    def set_id(self, id):
        self.id = id

    def get_package(self):
        return self.package

    def set_package(self, package):
        self.package = package

    def export(self, outfile, level, namespace_='', name_='testsuiteType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='testsuiteType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='testsuiteType'):
        super(testsuiteType, self).exportAttributes(outfile, level, already_processed, namespace_, name_='testsuiteType')
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            outfile.write(' id="%s"' % self.gds_format_integer(self.id, input_name='id'))
        if self.package is not None and 'package' not in already_processed:
            already_processed.append('package')
            outfile.write(' package=%s' % (self.gds_format_string(quote_attrib(self.package).encode(ExternalEncoding), input_name='package'), ))

    def exportChildren(self, outfile, level, namespace_='', name_='testsuiteType', fromsubclass_=False):
        super(testsuiteType, self).exportChildren(outfile, level, namespace_, name_, True)

    def hasContent_(self):
        if (
            super(testsuiteType, self).hasContent_()
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='testsuiteType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.id is not None and 'id' not in already_processed:
            already_processed.append('id')
            showIndent(outfile, level)
            outfile.write('id = %d,\n' % (self.id,))
        if self.package is not None and 'package' not in already_processed:
            already_processed.append('package')
            showIndent(outfile, level)
            outfile.write('package = "%s",\n' % (self.package,))
        super(testsuiteType, self).exportLiteralAttributes(outfile, level, already_processed, name_)

    def exportLiteralChildren(self, outfile, level, name_):
        super(testsuiteType, self).exportLiteralChildren(outfile, level, name_)

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('id', node)
        if value is not None and 'id' not in already_processed:
            already_processed.append('id')
            try:
                self.id = int(value)
            except ValueError, exp:
                raise_parse_error(node, 'Bad integer attribute: %s' % exp)
        value = find_attr_value_('package', node)
        if value is not None and 'package' not in already_processed:
            already_processed.append('package')
            self.package = value
            self.package = ' '.join(self.package.split())
        super(testsuiteType, self).buildAttributes(node, attrs, already_processed)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        super(testsuiteType, self).buildChildren(child_, node, nodeName_, True)
        pass
# end class testsuiteType


class propertiesType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, property=None):
        if property is None:
            self.property = []
        else:
            self.property = property

    def factory(*args_, **kwargs_):
        if propertiesType.subclass:
            # pylint: disable=E1102
            return propertiesType.subclass(*args_, **kwargs_)
        else:
            return propertiesType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_property(self):
        return self.property

    def set_property(self, property):
        self.property = property

    def add_property(self, value):
        self.property.append(value)

    def insert_property(self, index, value):
        self.property[index] = value

    def export(self, outfile, level, namespace_='', name_='propertiesType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='propertiesType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='propertiesType'):
        pass

    def exportChildren(self, outfile, level, namespace_='', name_='propertiesType', fromsubclass_=False):
        for property_ in self.property:
            property_.export(outfile, level, namespace_, name_='property')

    def hasContent_(self):
        if (
            self.property
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='propertiesType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        pass

    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('property=[\n')
        level += 1
        for property_ in self.property:
            showIndent(outfile, level)
            outfile.write('model_.propertyType(\n')
            property_.exportLiteral(outfile, level, name_='propertyType')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        pass

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'property':
            obj_ = propertyType.factory()
            obj_.build(child_)
            self.property.append(obj_)
# end class propertiesType


class propertyType(GeneratedsSuper):
    subclass = None
    superclass = None

    def __init__(self, name=None, value=None):
        self.name = _cast(None, name)
        self.value = _cast(None, value)
        pass

    def factory(*args_, **kwargs_):
        if propertyType.subclass:
            # pylint: disable=E1102
            return propertyType.subclass(*args_, **kwargs_)
        else:
            return propertyType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_value(self):
        return self.value

    def set_value(self, value):
        self.value = value

    def export(self, outfile, level, namespace_='', name_='propertyType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='propertyType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='propertyType'):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            outfile.write(' value=%s' % (self.gds_format_string(quote_attrib(self.value).encode(ExternalEncoding), input_name='value'), ))

    def exportChildren(self, outfile, level, namespace_='', name_='propertyType', fromsubclass_=False):
        pass

    def hasContent_(self):
        if (

        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='propertyType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.value is not None and 'value' not in already_processed:
            already_processed.append('value')
            showIndent(outfile, level)
            outfile.write('value = "%s",\n' % (self.value,))

    def exportLiteralChildren(self, outfile, level, name_):
        pass

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
            self.name = ' '.join(self.name.split())
        value = find_attr_value_('value', node)
        if value is not None and 'value' not in already_processed:
            already_processed.append('value')
            self.value = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class propertyType


class testcaseType(GeneratedsSuper):

    """Name of the test methodFull class name for the class the test method
    is in.Time taken (in seconds) to execute the test"""
    subclass = None
    superclass = None

    def __init__(self, classname=None, name=None, time=None, error=None, failure=None):
        self.classname = _cast(None, classname)
        self.name = _cast(None, name)
        self.time = _cast(float, time)
        self.error = error
        self.failure = failure

    def factory(*args_, **kwargs_):
        if testcaseType.subclass:
            # pylint: disable=E1102
            return testcaseType.subclass(*args_, **kwargs_)
        else:
            return testcaseType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_error(self):
        return self.error

    def set_error(self, error):
        self.error = error

    def get_failure(self):
        return self.failure

    def set_failure(self, failure):
        self.failure = failure

    def get_classname(self):
        return self.classname

    def set_classname(self, classname):
        self.classname = classname

    def get_name(self):
        return self.name

    def set_name(self, name):
        self.name = name

    def get_time(self):
        return self.time

    def set_time(self, time):
        self.time = time

    def export(self, outfile, level, namespace_='', name_='testcaseType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='testcaseType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='testcaseType'):
        if self.classname is not None and 'classname' not in already_processed:
            already_processed.append('classname')
            outfile.write(' classname=%s' % (self.gds_format_string(quote_attrib(self.classname).encode(ExternalEncoding), input_name='classname'), ))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            outfile.write(' name=%s' % (self.gds_format_string(quote_attrib(self.name).encode(ExternalEncoding), input_name='name'), ))
        if self.time is not None and 'time' not in already_processed:
            already_processed.append('time')
            outfile.write(' time="%s"' % self.gds_format_float(self.time, input_name='time'))

    def exportChildren(self, outfile, level, namespace_='', name_='testcaseType', fromsubclass_=False):
        if self.error is not None:
            self.error.export(outfile, level, namespace_, name_='error')
        if self.failure is not None:
            self.failure.export(outfile, level, namespace_, name_='failure')

    def hasContent_(self):
        if (
            self.error is not None or
            self.failure is not None
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='testcaseType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.classname is not None and 'classname' not in already_processed:
            already_processed.append('classname')
            showIndent(outfile, level)
            outfile.write('classname = "%s",\n' % (self.classname,))
        if self.name is not None and 'name' not in already_processed:
            already_processed.append('name')
            showIndent(outfile, level)
            outfile.write('name = "%s",\n' % (self.name,))
        if self.time is not None and 'time' not in already_processed:
            already_processed.append('time')
            showIndent(outfile, level)
            outfile.write('time = %f,\n' % (self.time,))

    def exportLiteralChildren(self, outfile, level, name_):
        if self.error is not None:
            showIndent(outfile, level)
            outfile.write('error=model_.errorType(\n')
            self.error.exportLiteral(outfile, level, name_='error')
            showIndent(outfile, level)
            outfile.write('),\n')
        if self.failure is not None:
            showIndent(outfile, level)
            outfile.write('failure=model_.failureType(\n')
            self.failure.exportLiteral(outfile, level, name_='failure')
            showIndent(outfile, level)
            outfile.write('),\n')

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('classname', node)
        if value is not None and 'classname' not in already_processed:
            already_processed.append('classname')
            self.classname = value
            self.classname = ' '.join(self.classname.split())
        value = find_attr_value_('name', node)
        if value is not None and 'name' not in already_processed:
            already_processed.append('name')
            self.name = value
            self.name = ' '.join(self.name.split())
        value = find_attr_value_('time', node)
        if value is not None and 'time' not in already_processed:
            already_processed.append('time')
            try:
                self.time = float(value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (time): %s' % exp)

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        if nodeName_ == 'error':
            obj_ = errorType.factory()
            obj_.build(child_)
            self.set_error(obj_)
        elif nodeName_ == 'failure':
            obj_ = failureType.factory()
            obj_.build(child_)
            self.set_failure(obj_)
# end class testcaseType


class errorType(GeneratedsSuper):

    """The error message. e.g., if a java exception is thrown, the return
    value of getMessage()The type of error that occurred. e.g., if a
    java execption is thrown the full class name of the exception."""
    subclass = None
    superclass = None

    def __init__(self, message=None, type_=None, valueOf_=None):
        self.message = _cast(None, message)
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if errorType.subclass:
            # pylint: disable=E1102
            return errorType.subclass(*args_, **kwargs_)
        else:
            return errorType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_message(self):
        return self.message

    def set_message(self, message):
        self.message = message

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def export(self, outfile, level, namespace_='', name_='errorType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='errorType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='errorType'):
        if self.message is not None and 'message' not in already_processed:
            already_processed.append('message')
            outfile.write(' message=%s' % (self.gds_format_string(quote_attrib(self.message).encode(ExternalEncoding), input_name='message'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))

    def exportChildren(self, outfile, level, namespace_='', name_='errorType', fromsubclass_=False):
        pass

    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='errorType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.message is not None and 'message' not in already_processed:
            already_processed.append('message')
            showIndent(outfile, level)
            outfile.write('message = "%s",\n' % (self.message,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))

    def exportLiteralChildren(self, outfile, level, name_):
        pass

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('message', node)
        if value is not None and 'message' not in already_processed:
            already_processed.append('message')
            self.message = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class errorType


class failureType(GeneratedsSuper):

    """The message specified in the assertThe type of the assert."""
    subclass = None
    superclass = None

    def __init__(self, message=None, type_=None, valueOf_=None):
        self.message = _cast(None, message)
        self.type_ = _cast(None, type_)
        self.valueOf_ = valueOf_

    def factory(*args_, **kwargs_):
        if failureType.subclass:
            # pylint: disable=E1102
            return failureType.subclass(*args_, **kwargs_)
        else:
            return failureType(*args_, **kwargs_)
    factory = staticmethod(factory)

    def get_message(self):
        return self.message

    def set_message(self, message):
        self.message = message

    def get_type(self):
        return self.type_

    def set_type(self, type_):
        self.type_ = type_

    def get_valueOf_(self):
        return self.valueOf_

    def set_valueOf_(self, valueOf_):
        self.valueOf_ = valueOf_

    def export(self, outfile, level, namespace_='', name_='failureType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        already_processed = []
        self.exportAttributes(outfile, level, already_processed, namespace_, name_='failureType')
        if self.hasContent_():
            outfile.write('>')
            outfile.write(str(self.valueOf_).encode(ExternalEncoding))
            self.exportChildren(outfile, level + 1, namespace_, name_)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')

    def exportAttributes(self, outfile, level, already_processed, namespace_='', name_='failureType'):
        if self.message is not None and 'message' not in already_processed:
            already_processed.append('message')
            outfile.write(' message=%s' % (self.gds_format_string(quote_attrib(self.message).encode(ExternalEncoding), input_name='message'), ))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            outfile.write(' type=%s' % (self.gds_format_string(quote_attrib(self.type_).encode(ExternalEncoding), input_name='type'), ))

    def exportChildren(self, outfile, level, namespace_='', name_='failureType', fromsubclass_=False):
        pass

    def hasContent_(self):
        if (
            self.valueOf_
        ):
            return True
        else:
            return False

    def exportLiteral(self, outfile, level, name_='failureType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, [], name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
        showIndent(outfile, level)
        outfile.write('valueOf_ = """%s""",\n' % (self.valueOf_,))

    def exportLiteralAttributes(self, outfile, level, already_processed, name_):
        if self.message is not None and 'message' not in already_processed:
            already_processed.append('message')
            showIndent(outfile, level)
            outfile.write('message = "%s",\n' % (self.message,))
        if self.type_ is not None and 'type_' not in already_processed:
            already_processed.append('type_')
            showIndent(outfile, level)
            outfile.write('type_ = "%s",\n' % (self.type_,))

    def exportLiteralChildren(self, outfile, level, name_):
        pass

    def build(self, node):
        self.buildAttributes(node, node.attrib, [])
        self.valueOf_ = get_all_text_(node)
        for child in node:
            nodeName_ = Tag_pattern_.match(child.tag).groups()[-1]
            self.buildChildren(child, node, nodeName_)

    def buildAttributes(self, node, attrs, already_processed):
        value = find_attr_value_('message', node)
        if value is not None and 'message' not in already_processed:
            already_processed.append('message')
            self.message = value
        value = find_attr_value_('type', node)
        if value is not None and 'type' not in already_processed:
            already_processed.append('type')
            self.type_ = value

    def buildChildren(self, child_, node, nodeName_, fromsubclass_=False):
        pass
# end class failureType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""


def usage():
    print USAGE_TEXT
    sys.exit(1)


def get_root_tag(node):
    tag = Tag_pattern_.match(node.tag).groups()[-1]
    rootClass = globals().get(tag)
    return tag, rootClass


def parse(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'testsuite'
        rootClass = testsuite
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_=rootTag,
                   namespacedef_='')
    return rootObj


def parseString(inString):
    from StringIO import StringIO
    doc = parsexml_(StringIO(inString))
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'testsuite'
        rootClass = testsuite
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="testsuite",
                   namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = parsexml_(inFileName)
    rootNode = doc.getroot()
    rootTag, rootClass = get_root_tag(rootNode)
    if rootClass is None:
        rootTag = 'testsuite'
        rootClass = testsuite
    rootObj = rootClass.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('#from JUnit_api import *\n\n')
    sys.stdout.write('import JUnit_api as model_\n\n')
    sys.stdout.write('rootObj = model_.rootTag(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_=rootTag)
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()


__all__ = [
    "errorType",
    "failureType",
    "propertiesType",
    "propertyType",
    "system_err",
    "system_out",
    "testcaseType",
    "testsuite",
    "testsuiteType",
    "testsuites"
]
