/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.task;

import de.unkrig.antology.util.Logging;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.time.Duration;
import de.unkrig.commons.util.time.PointOfTime;
import de.unkrig.commons.util.time.TimeInterval;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitStatusException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.property.LocalProperties;

public class ThroughputTask
extends Task
implements TaskContainer {
    private static final Locale LOCALE = Locale.US;
    private String message = "Starting...";
    private final List<Task> nestedTasks = new ArrayList<Task>();
    @Nullable
    private Double previousQuantity;
    @Nullable
    private Double currentQuantity;
    @Nullable
    private Double remainingQuantity;
    @Nullable
    private Double totalQuantity;
    private final TimeInterval previousInterval = new TimeInterval();
    private final TimeInterval currentInterval = new TimeInterval();
    private final TimeInterval remainingInterval = new TimeInterval();
    @Nullable
    private String quantityUnit;
    private boolean showEta;

    public void setMessage(String text) {
        this.message = text;
    }

    public void setPreviousQuantity(double number) {
        this.previousQuantity = number;
        this.checkConsistency();
    }

    public void setCurrentQuantity(double number) {
        this.currentQuantity = number;
        this.checkConsistency();
    }

    public void setRemainingQuantity(double number) {
        this.remainingQuantity = number;
        this.checkConsistency();
    }

    public void setTotalQuantity(double number) {
        this.totalQuantity = number;
        this.checkConsistency();
    }

    public void setPreviousBeginning(PointOfTime value) {
        this.previousInterval.setBeginning(value);
    }

    public void setPreviousDuration(Duration value) {
        this.previousInterval.setDuration(value);
    }

    public void setPreviousEnding(PointOfTime value) {
        this.previousInterval.setEnding(value);
    }

    public void setCurrentBeginning(PointOfTime value) {
        this.currentInterval.setBeginning(value);
    }

    public void setCurrentDuration(Duration value) {
        this.currentInterval.setDuration(value);
    }

    public void setCurrentEnding(PointOfTime value) {
        this.currentInterval.setEnding(value);
    }

    public void setRemainingBeginning(PointOfTime value) {
        this.remainingInterval.setBeginning(value);
    }

    public void setQuantityUnit(@Nullable String unitName) {
        this.quantityUnit = unitName;
    }

    public void setShowEta(boolean value) {
        this.showEta = value;
    }

    public void addTask(@Nullable Task task) {
        this.nestedTasks.add(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        Double previousQuantity = this.previousQuantity;
        Double currentQuantity = this.currentQuantity;
        Double remainingQuantity = this.remainingQuantity;
        TimeInterval previousInterval = this.previousInterval;
        TimeInterval currentInterval = this.currentInterval;
        PointOfTime now = new PointOfTime();
        if (previousInterval.getEnding() == null) {
            previousInterval = new TimeInterval(previousInterval).setEnding(now);
        }
        if (currentInterval.getBeginning() == null) {
            currentInterval = new TimeInterval(currentInterval).setBeginning(now);
        }
        PointOfTime currentIntervalBeginning = currentInterval.getBeginning();
        assert (currentIntervalBeginning != null);
        this.log(ThroughputTask.composeBeforeMessage(this.message, previousQuantity, previousInterval.getDuration(), currentQuantity, currentIntervalBeginning, remainingQuantity, this.showEta, this.quantityUnit));
        LocalProperties localProperties = LocalProperties.get((Project)this.getProject());
        localProperties.enterScope();
        String originalMessagePrefix = Logging.getLogMessagePrefix(this.getProject());
        try {
            Logging.setLogMessagePrefix(this.getProject(), originalMessagePrefix + "| ");
            for (Task t : this.nestedTasks) {
                t.perform();
            }
        }
        catch (ExitStatusException ese) {
            if (ese.getStatus() != 0) {
                throw ese;
            }
        }
        finally {
            localProperties.exitScope();
            Logging.setLogMessagePrefix(this.getProject(), originalMessagePrefix);
        }
        TimeInterval remainingInterval = this.remainingInterval;
        PointOfTime now2 = new PointOfTime();
        if (currentInterval.getEnding() == null) {
            currentInterval = new TimeInterval(currentInterval).setEnding(now2);
        }
        if (remainingInterval.getBeginning() == null) {
            remainingInterval = new TimeInterval(remainingInterval).setBeginning(now2);
        }
        Duration currentDuration = currentInterval.getDuration();
        assert (currentDuration != null);
        PointOfTime remainingBeginning = remainingInterval.getBeginning();
        assert (remainingBeginning != null);
        this.log(ThroughputTask.composeAfterMessage(previousQuantity, previousInterval.getDuration(), currentQuantity, currentDuration, remainingQuantity, remainingBeginning, this.showEta, this.quantityUnit));
    }

    public static String composeBeforeMessage(String message, @Nullable Double previousQuantity, @Nullable Duration previousDuration, @Nullable Double currentQuantity, PointOfTime currentBeginning, @Nullable Double remainingQuantity, boolean showEta, @Nullable String quantityUnit) {
        if (currentQuantity != null) {
            String string = quantityUnit = quantityUnit == null ? "" : " " + quantityUnit;
            if (previousQuantity != null && remainingQuantity != null) {
                double totalQuantity = previousQuantity + currentQuantity + remainingQuantity;
                message = message + String.format(LOCALE, " (%,.0f of %,.0f%s", currentQuantity, totalQuantity, ThroughputTask.singularize(quantityUnit, totalQuantity));
                if (totalQuantity != 0.0) {
                    message = message + String.format(LOCALE, " = %.1f%%", 100.0 * currentQuantity / totalQuantity);
                }
            } else {
                message = message + String.format(LOCALE, " (%,.0f%s", currentQuantity, ThroughputTask.singularize(quantityUnit, currentQuantity));
            }
            if (previousQuantity != null && previousQuantity != 0.0 && previousDuration != null) {
                Duration estimatedCurrentDuration = previousDuration.multiply(currentQuantity).divide(previousQuantity);
                message = message + String.format(LOCALE, " = approx. %s", estimatedCurrentDuration);
                if (showEta) {
                    message = message + String.format(" = ETA %s", currentBeginning.add(estimatedCurrentDuration));
                }
            }
            message = message + ")";
        }
        return message;
    }

    private static String singularize(String word, Double quantity) {
        return quantity != 1.0 ? word : (word.endsWith("ies") ? word.substring(0, word.length() - 3) + "y" : (word.endsWith("s") ? word.substring(0, word.length() - 1) : word));
    }

    public static String composeAfterMessage(@Nullable Double previousQuantity, @Nullable Duration previousDuration, @Nullable Double currentQuantity, Duration currentDuration, @Nullable Double remainingQuantity, PointOfTime remainingBeginning, boolean showEta, @Nullable String quantityUnit) {
        Double secondsPerUnit;
        String afterMessage = String.format(LOCALE, "... done! Took %s", currentDuration);
        if (currentQuantity == null) {
            return afterMessage;
        }
        quantityUnit = quantityUnit == null ? "" : " " + quantityUnit;
        afterMessage = afterMessage + String.format(LOCALE, " (%,.0f%s", currentQuantity, ThroughputTask.singularize(quantityUnit, currentQuantity));
        if (!currentDuration.isZero()) {
            double currentRate = currentQuantity / currentDuration.toSeconds();
            afterMessage = afterMessage + String.format(LOCALE, " @ %,.0f%s/s", currentRate, ThroughputTask.singularize(quantityUnit, currentRate));
        }
        if (previousQuantity != null && (previousQuantity > 0.0 || remainingQuantity != null)) {
            Duration cumulatedDuration;
            double totalQuantity;
            afterMessage = afterMessage + String.format(LOCALE, "; %,.0f", previousQuantity + currentQuantity);
            if (remainingQuantity != null) {
                afterMessage = afterMessage + String.format(LOCALE, " of %,.0f", previousQuantity + currentQuantity + remainingQuantity);
            }
            afterMessage = afterMessage + String.format(LOCALE, "%s complete", ThroughputTask.singularize(quantityUnit, previousQuantity + currentQuantity + (remainingQuantity == null ? 0.0 : remainingQuantity)));
            if (remainingQuantity != null && (totalQuantity = previousQuantity + currentQuantity + remainingQuantity) != 0.0) {
                afterMessage = afterMessage + String.format(LOCALE, " = %.1f%%", 100.0 * (previousQuantity + currentQuantity) / totalQuantity);
            }
            if (previousDuration != null && !(cumulatedDuration = previousDuration.add(currentDuration)).isZero()) {
                double cumulatedRate = (previousQuantity + currentQuantity) / cumulatedDuration.toSeconds();
                afterMessage = afterMessage + String.format(LOCALE, " @ %,.0f%s/s", cumulatedRate, ThroughputTask.singularize(quantityUnit, cumulatedRate));
            }
        }
        if (remainingQuantity == null) {
            return afterMessage + ")";
        }
        if (remainingQuantity == 0.0) {
            return afterMessage + ")";
        }
        afterMessage = afterMessage + String.format(LOCALE, "; %,.0f%s remaining", remainingQuantity, ThroughputTask.singularize(quantityUnit, remainingQuantity));
        Double d = previousDuration != null && previousQuantity != null && previousQuantity + currentQuantity > 0.0 ? Double.valueOf(previousDuration.add(currentDuration).toSeconds() / (previousQuantity + currentQuantity)) : (secondsPerUnit = currentQuantity > 0.0 ? Double.valueOf(currentDuration.toSeconds() / currentQuantity) : null);
        if (secondsPerUnit != null) {
            Duration remainingDuration = new Duration(remainingQuantity * secondsPerUnit);
            afterMessage = afterMessage + String.format(LOCALE, " = approx. %s", remainingDuration);
            if (showEta) {
                afterMessage = afterMessage + String.format(LOCALE, " = ETA %s", remainingBeginning.add(remainingDuration));
            }
        }
        return afterMessage + ")";
    }

    private void checkConsistency() {
        Double previousQuantity = this.previousQuantity;
        Double currentQuantity = this.currentQuantity;
        Double remainingQuantity = this.remainingQuantity;
        Double totalQuantity = this.totalQuantity;
        if (previousQuantity == null) {
            if (currentQuantity != null && remainingQuantity != null && totalQuantity != null) {
                this.previousQuantity = totalQuantity - currentQuantity - remainingQuantity;
            }
        } else if (currentQuantity == null) {
            if (remainingQuantity != null && totalQuantity != null) {
                this.currentQuantity = totalQuantity - previousQuantity - remainingQuantity;
            }
        } else if (remainingQuantity == null) {
            if (totalQuantity != null) {
                this.remainingQuantity = totalQuantity - previousQuantity - currentQuantity;
            }
        } else if (totalQuantity == null) {
            this.totalQuantity = previousQuantity + currentQuantity + remainingQuantity;
        } else if (previousQuantity + currentQuantity + remainingQuantity != totalQuantity) {
            throw new BuildException("'previousQuantity=...', 'currentQuantity=...', 'remainingQuantity=...' and 'totalQuantity=...' are inconsistently configured");
        }
    }
}

