/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.antology.filter;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.filters.ChainableReader;

@NotNullByDefault(value=false)
public class ProgressFilter
extends ProjectComponent
implements ChainableReader {
    private boolean exponential = true;
    private int bytesPerTick = 1024;
    private long totalBytes;
    private boolean dotsPending;
    private int previousLogicalTicks;
    private static final int ASYMPTOTE = 80;

    public Reader chain(Reader reader) {
        return new FilterReader(reader){

            @Override
            public int read() throws IOException {
                int c = this.in.read();
                if (c != -1) {
                    ProgressFilter.this.reportBytes(1L);
                }
                return c;
            }

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                int n = this.in.read(cbuf, off, len);
                if (n != -1) {
                    ProgressFilter.this.reportBytes(n);
                }
                return n;
            }

            @Override
            public long skip(long n) throws IOException {
                long skipped = this.in.skip(n);
                ProgressFilter.this.reportBytes(skipped);
                return skipped;
            }

            @Override
            public void close() throws IOException {
                ProgressFilter.this.reportEndOfProgress();
                this.in.close();
            }
        };
    }

    public void setExponential(boolean value) {
        this.exponential = value;
    }

    public void setBytesPerTick(int n) {
        this.bytesPerTick = n;
    }

    private synchronized void reportBytes(long n) {
        this.totalBytes += n;
        int ticks = (int)(this.totalBytes / (long)this.bytesPerTick);
        this.setProgress(ticks);
    }

    private void reportEndOfProgress() {
        if (this.dotsPending) {
            this.dotsPending = false;
            System.err.println();
            System.err.flush();
        }
    }

    private synchronized void setProgress(int ticks) {
        int logicalTicks1 = this.previousLogicalTicks;
        this.previousLogicalTicks = this.logicalizeTicks(ticks);
        int logicalTicks2 = this.previousLogicalTicks;
        if (logicalTicks2 > logicalTicks1) {
            for (int i = logicalTicks1; i < logicalTicks2; ++i) {
                System.err.print('.');
            }
            System.err.flush();
            this.dotsPending = true;
        }
    }

    private int logicalizeTicks(int physicalTicks) {
        return this.exponential ? 80 - (int)(80.0 * Math.exp((double)physicalTicks * -0.0125)) : physicalTicks;
    }
}

