/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.database;

import java.lang.reflect.Field;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;

public abstract class DBMetadata {
    private static final Logger LOG = Logger.getLogger(DBMetadata.class);
    protected DBElement repository;
    protected Object connection;
    protected Object dbmd;
    protected static Hashtable htTypesToNames;

    public DBMetadata(DBElement rep, Object conn) throws SQLException, ClassNotFoundException, IllegalArgumentException {
        this.repository = rep;
        this.connection = conn;
    }

    public abstract Object[] getTablesInSchema(String var1) throws SQLException;

    public abstract Object[] getViewsInSchema(String var1) throws SQLException;

    public abstract Object[] getSchemas() throws SQLException;

    public abstract Object[] getDatabases() throws Exception;

    public abstract Database getDatabase(String var1) throws Exception;

    public abstract Table getTable(String var1, String var2) throws SQLException;

    public abstract View getView(String var1, String var2) throws SQLException;

    protected abstract Table newTable(String var1);

    protected abstract Table newView(String var1);

    protected abstract Column newColumn(String var1);

    protected abstract void setPrimaryKeys(String var1, String var2, Column[] var3, ResultSet var4) throws SQLException;

    protected abstract void setForeignKeys(Table var1, String var2, Column[] var3, ResultSet var4) throws SQLException;

    protected abstract void setIndexInfo(Table var1, Column[] var2, ResultSet var3) throws SQLException;

    protected abstract Column[] getColumns(String var1, String var2) throws SQLException;

    protected abstract Column[] makeColumns(Object var1) throws SQLException;

    protected abstract void setJDBCType(Object var1, Column var2) throws SQLException;

    public abstract boolean supportsSchemaInTableDefinitions() throws SQLException;

    public static String[] getPrimitiveTypes() {
        return htTypesToNames.values().toArray(new String[0]);
    }

    public static String getPrimitiveTypeName(int id) {
        return (String)htTypesToNames.get(new Integer(id));
    }

    public Object getConnection() {
        return this.connection;
    }

    public DBElement getRepository() {
        return this.repository;
    }

    public String[] getNewTypes() throws SQLException {
        return this.getNewTypes(((DatabaseMetaData)this.dbmd).getTypeInfo());
    }

    protected abstract String[] getNewTypes(ResultSet var1) throws SQLException;

    public void initDatabase(Database db) {
        try {
            db.setIdentifierQuoteString(((DatabaseMetaData)this.dbmd).getIdentifierQuoteString());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesLowerCaseIdentifier(((DatabaseMetaData)this.dbmd).storesLowerCaseIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesUpperCaseIdentifier(((DatabaseMetaData)this.dbmd).storesUpperCaseIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesMixedCaseIdentifier(((DatabaseMetaData)this.dbmd).storesMixedCaseIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesLowerCaseQuotedIdentifier(((DatabaseMetaData)this.dbmd).storesLowerCaseQuotedIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesUpperCaseQuotedIdentifier(((DatabaseMetaData)this.dbmd).storesUpperCaseQuotedIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
        try {
            db.likesMixedCaseQuotedIdentifier(((DatabaseMetaData)this.dbmd).storesMixedCaseQuotedIdentifiers());
        }
        catch (Exception e) {
            LOG.info((Object)e.getMessage());
        }
    }

    static {
        Field[] aFields = Types.class.getDeclaredFields();
        htTypesToNames = new Hashtable();
        for (int i = 0; i < aFields.length; ++i) {
            Integer id = new Integer(0);
            try {
                id = (Integer)aFields[i].get(null);
            }
            catch (Exception e) {
                LOG.info((Object)e.getMessage());
            }
            htTypesToNames.put(id, aFields[i].getName());
        }
        htTypesToNames.put(new Integer(9), "DATE");
        htTypesToNames.put(new Integer(10), "TIME");
        htTypesToNames.put(new Integer(11), "TIMESTAMP");
    }
}

