/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.typeresolution.rules;

import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTExtendsList;
import net.sourceforge.pmd.ast.ASTImplementsList;
import net.sourceforge.pmd.ast.ASTImportDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTName;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.properties.BooleanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureDeclareThrowsException
extends AbstractRule {
    private static final PropertyDescriptor ignoreJUnitCompletelyDescriptor = new BooleanProperty("IgnoreJUnitCompletely", "If true, all methods in a JUnit testcase may throw Exception", false, 1.0f);
    private boolean junitImported = false;

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (this.junitImported) {
            return super.visit(node, data);
        }
        ASTImplementsList impl = node.getFirstChildOfType(ASTImplementsList.class);
        if (impl != null && impl.jjtGetParent().equals(node)) {
            for (int ix = 0; ix < impl.jjtGetNumChildren(); ++ix) {
                ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)impl.jjtGetChild(ix);
                if (type.getType() == null) {
                    if (!"junit.framework.Test".equals(type.getImage())) continue;
                    this.junitImported = true;
                    return super.visit(node, data);
                }
                if (type.getType().equals(Test.class)) {
                    this.junitImported = true;
                    return super.visit(node, data);
                }
                List<Class<?>> implementors = Arrays.asList(type.getType().getInterfaces());
                if (!implementors.contains(Test.class)) continue;
                this.junitImported = true;
                return super.visit(node, data);
            }
        }
        if (node.jjtGetNumChildren() != 0 && node.jjtGetChild(0).getClass().equals(ASTExtendsList.class)) {
            ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)((SimpleNode)node.jjtGetChild(0)).jjtGetChild(0);
            Class clazz = type.getType();
            if (clazz != null && clazz.equals(Test.class)) {
                this.junitImported = true;
                return super.visit(node, data);
            }
            while (clazz != null && !Object.class.equals((Object)clazz)) {
                if (Arrays.asList(clazz.getInterfaces()).contains(Test.class)) {
                    this.junitImported = true;
                    return super.visit(node, data);
                }
                clazz = clazz.getSuperclass();
            }
        }
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTImportDeclaration node, Object o) {
        if (node.getImportedName().indexOf("junit") != -1) {
            this.junitImported = true;
        }
        return super.visit(node, o);
    }

    @Override
    public Object visit(ASTMethodDeclaration methodDeclaration, Object o) {
        if (this.junitImported && this.isAllowedMethod(methodDeclaration)) {
            return super.visit(methodDeclaration, o);
        }
        this.checkExceptions(methodDeclaration, o);
        return super.visit(methodDeclaration, o);
    }

    private boolean isAllowedMethod(ASTMethodDeclaration methodDeclaration) {
        if (this.getBooleanProperty(ignoreJUnitCompletelyDescriptor)) {
            return true;
        }
        return methodDeclaration.getMethodName().equals("setUp") || methodDeclaration.getMethodName().equals("tearDown");
    }

    @Override
    public Object visit(ASTConstructorDeclaration constructorDeclaration, Object o) {
        this.checkExceptions(constructorDeclaration, o);
        return super.visit(constructorDeclaration, o);
    }

    private void checkExceptions(SimpleNode method, Object o) {
        List<ASTName> exceptionList = method.findChildrenOfType(ASTName.class);
        if (!exceptionList.isEmpty()) {
            this.evaluateExceptions(exceptionList, o);
        }
    }

    private void evaluateExceptions(List<ASTName> exceptionList, Object context) {
        for (ASTName exception : exceptionList) {
            if (!this.hasDeclaredExceptionInSignature(exception)) continue;
            this.addViolation(context, exception);
        }
    }

    private boolean hasDeclaredExceptionInSignature(ASTName exception) {
        return exception.hasImageEqualTo("Exception") && this.isParentSignatureDeclaration(exception);
    }

    private boolean isParentSignatureDeclaration(ASTName exception) {
        Node parent = exception.jjtGetParent().jjtGetParent();
        return parent instanceof ASTMethodDeclaration || parent instanceof ASTConstructorDeclaration;
    }
}

