/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * bounce.h contains the declarations of some functions used in the bubble-
 * bouncing algorithm.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/

#ifndef BOUNCE_H
#define BOUNCE_H

#include "sprite.h"
#include "screen.h"
 
#define PI 3.1415926535

// Given a vector with components x and y, realarctan() returns its angle.
double realarctan(double y,double x);

/* Solves quadratic formulas, passes back the number of real solutions and, if
 * the solutions are real, the solutions. */
void quadraticFormula(double a,double b,double c,char & numberOfSolutions,
                      double & solution1,double & solution2);

#endif
