/* This file is part of OpenBubbles.
 *
 * OpenBubbles is an SDL clone of Bubbles.
 * Copyright (C) 2004  Benny Sperisen
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * audioplayer.h contains the declaration for the audioPlayer class.
 *
 * Written by:
 *  Benny Sperisen
 *  lasindi@gmail.com
 *  www.freewebs.com/lasindi
 *****************************************************************************/
 
#ifndef AUDIOPLAYER_H
#define AUDIOPLAYER_H

#include "SDL.h"
#include <iostream>
#include <cstdlib>
#include <cassert>
#include <string>
#include <list>
#include <ext/hash_map>
using namespace std;
using namespace __gnu_cxx;

#define VOLUME_PER_SOUND SDL_MIX_MAXVOLUME/2

/* audioPlayer provides a wrapper around SDL's mixer. The only instance of
 * audioPlayer that should ever be instantiated is the audio instance declared
 * below. Do NOT use any instance other than audio; all of the private
 * variables are static, so you won't get anywhere. */
class audioPlayer
{
public:
  /* The constructor configures SDL for playing audio. */
  audioPlayer();
  ~audioPlayer();

  /* loadSound() loads WAV file at filename and returns a key that is >=0 used
   * to play the sound with playSound(). If loadSound() returns -1, an error
   * occurred and the sound was not loaded. */
  int loadSound(string filename);

  void clearSounds(); // stops all sounds currently playing

  void playSound(int key); // playSound() uses the key returned by loadSound()

  bool isMuted() const;

  void mute(bool status); // on is true for muting, false for unmuting

private:
  // sound_c is a class for loaded sounds
  class sound_c
  {
  public:
    sound_c(Uint8 *samples=NULL,Uint32 length=0);
    Uint8* getSamples() const;
    Uint32 getLength() const;
    void setSamples(Uint8 *samples);
    void setLength(Uint32 length);
    void freeSamples();
  private:
    Uint8 *_samples;
    Uint32 _length;
  };
  // playing_c is a class for playing sounds
  class playing_c
  {
  public:
    playing_c(sound_c sound=0,Uint32 position=0);
    sound_c getSound() const;
    Uint32 getPosition() const;
    void setPosition(Uint32 position);
  private:
    sound_c _sound;
    Uint32 _position;
  };
  // callback() is used by SDL as a callback function
  static void callback(void *user_data,Uint8 *audio,int length);
  static list<playing_c> playing; // playing contains all playing sounds
  // contains the audio specifications being used by SDL
  static SDL_AudioSpec spec;
  static hash_map<int,sound_c> sounds; // contains all loaded sounds
  static int numSounds; // contains the number of loaded sounds
  static bool _muted;
};

extern audioPlayer *audio; // a pointer to the only instance that should ever
                           // be declared

#endif
