/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.extractor.scan.Severity;

public class Issue
implements Comparable<Issue> {
    private String created;
    private String description;
    private String issueType = "N/A";
    private String provider;
    private Severity severity = Severity.Normal;
    private String summary;
    private String component = "";
    private List<String> fixedVersions;

    public Issue() {
    }

    public Issue(String created, String description, String issueType, String provider, Severity severity, String summary, List<String> fixedVersions) {
        this.created = created;
        this.description = description;
        this.issueType = issueType;
        this.provider = provider;
        this.severity = severity;
        this.summary = summary;
        this.fixedVersions = fixedVersions;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public String getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getSummary() {
        return this.summary;
    }

    public List<String> getFixedVersions() {
        return this.fixedVersions;
    }

    public void setFixedVersions(List<String> fixedVersions) {
        this.fixedVersions = fixedVersions;
    }

    @JsonIgnore
    public boolean isTopSeverity() {
        return this.getSeverity() == Severity.High;
    }

    @JsonIgnore
    public boolean isHigherSeverityThan(Issue o) {
        return this.getSeverity().isHigherThan(o.getSeverity());
    }

    @Override
    public int compareTo(@Nonnull Issue otherIssue) {
        return Integer.compare(this.hashCode(), Objects.hashCode(otherIssue));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Issue otherIssue = (Issue)other;
        if (StringUtils.isEmpty(this.component)) {
            return StringUtils.equals(this.description, otherIssue.description) && StringUtils.equals(this.summary, otherIssue.summary);
        }
        return StringUtils.equals(this.component, otherIssue.component) && StringUtils.equals(this.summary, otherIssue.summary);
    }

    public int hashCode() {
        return Objects.hash(this.summary, this.component, this.description);
    }
}

