// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Game_manager_h
#define Game_manager_h




#include "SDL.h"
#include "Game_timer.h"
#include "Title_screen.h"
#include "Play.h"
#include "Get_ready_screen.h"
#include "enums.h"
#include "Sound_engine.h"
#include "High_scores_display.h"
#include "Settings.h"
#include "Settings_screen.h"
#include "User_input.h"
#include <iostream>
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::User_input> input_ptr;
extern FS::Mode current_mode;




namespace FS
{

class Game_manager
{
    public:
        enum State { INTRO, SELECTING_START_LEVEL, GET_READY, PLAY, 
                SETTINGS, HI_SCORES, ENTERING_NAME };
        
        static const int MAX_EVENTS = 10;
        
        Game_manager();
        ~Game_manager();
        
        void start_loop();
        
    private:
        GameTimer timer;    
        Title_screen my_title_screen;
        Play p_model;
        Get_ready_screen my_gr_screen;
        Sound_engine snd_engine;
        High_scores_display my_hs_screen;
        Settings my_settings;
        Settings_screen my_settings_screen;
        
        State current_state;
        bool loop_running;
        
        void handle_selection(Title_screen::Selection sel);
        
}; // class Game_manager

} // namespace FS




#endif
    
