[![Build Status](https://travis-ci.org/JohnCGriffin/overflow.png)](https://travis-ci.org/JohnCGriffin/overflow)
# overflow
Check for int/int8/int16/int64/int32 integer overflow in Golang arithmetic.
### Install
```
go get github.com/johncgriffin/overflow
```
Note that because Go has no template types, the majority of repetitive code is 
generated by overflow_template.sh.  If you have to change an
algorithm, change it there and regenerate the Go code via:
```
go generate
```
### Synopsis

```
package main

import "fmt"
import "math"
import "github.com/JohnCGriffin/overflow"

func main() {

	addend := math.MaxInt64 - 5

	for i := 0; i < 10; i++ {
		sum, ok := overflow.Add(addend, i)
		fmt.Printf("%v+%v -> (%v,%v)\n",
			addend, i, sum, ok)
	}

}
```
yields the output
```
9223372036854775802+0 -> (9223372036854775802,true)
9223372036854775802+1 -> (9223372036854775803,true)
9223372036854775802+2 -> (9223372036854775804,true)
9223372036854775802+3 -> (9223372036854775805,true)
9223372036854775802+4 -> (9223372036854775806,true)
9223372036854775802+5 -> (9223372036854775807,true)
9223372036854775802+6 -> (0,false)
9223372036854775802+7 -> (0,false)
9223372036854775802+8 -> (0,false)
9223372036854775802+9 -> (0,false)
```

For int, int64, and int32 types, provide Add, Add32, Add64, Sub, Sub32, Sub64, etc.  
Unsigned types not covered at the moment, but such additions are welcome.

### Stay calm and panic

There's a good case to be made that a panic is an unidiomatic but proper response.  Iff you
believe that there's no valid way to continue your program after math goes wayward, you can
use the easier Addp, Mulp, Subp, and Divp versions which return the normal result or panic.


- - -
MIT License

Copyright (c) 2017 John C. Griffin, 

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.




