import { browserTracingIntegration as originalBrowserTracingIntegration } from '@sentry/browser';
import { Integration } from '@sentry/types';
/**
 * A custom browser tracing integration for TanStack Router.
 *
 * The minimum compatible version of `@tanstack/router` is `1.34.5`.
 *
 * @param router A TanStack Router `Router` instance that should be used for routing instrumentation.
 * @param options Sentry browser tracing configuration.
 */
export declare function tanstackRouterBrowserTracingIntegration(router: any, // This is `any` because we don't want any type mismatches if TanStack Router changes their types
options?: Parameters<typeof originalBrowserTracingIntegration>[0]): Integration;
//# sourceMappingURL=tanstackrouter.d.ts.map
