/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package test.java.time;

import org.junit.runner.RunWith;
import org.junit.runners.Suite;

/** Test suite for java.time package. */
@RunWith(Suite.class)
@Suite.SuiteClasses({
  TestClock_Fixed.class,
  TestClock_Offset.class,
  TestClock_System.class,
  TestClock_Tick.class,
  TestDuration.class,
  TestInstant.class,
  TestLocalDate.class,
  TestLocalDateTime.class,
  TestLocalTime.class,
  TestMonthDay.class,
  TestOffsetDateTime.class,
  TestOffsetDateTime_instants.class,
  TestOffsetTime.class,
  TestPeriod.class,
  TestYear.class,
  TestYearMonth.class,
  TestZoneId.class,
  TestZoneOffset.class,
  TestZonedDateTime.class,
  libcore.java.time.DateTimeExceptionTest.class,
  libcore.java.time.DurationTest.class,
  libcore.java.time.InstantTest.class,
  libcore.java.time.LocalDateTest.class,
  libcore.java.time.OffsetDateTimeTest.class,
  libcore.java.time.OffsetTimeTest.class,
  libcore.java.time.PeriodTest.class,
  libcore.java.time.YearMonthTest.class,
  libcore.java.time.YearTest.class,
  libcore.java.time.ZoneOffsetTest.class,
  libcore.java.time.ZonedDateTimeTest.class,
  libcore.java.time.format.DateTimeFormatterBuilderTest.class,
  libcore.java.time.format.DateTimeFormatterTest.class,
  libcore.java.time.format.DateTimeParseExceptionTest.class,
  libcore.java.time.temporal.UnsupportedTemporalTypeExceptionTest.class,
  libcore.java.time.zone.IcuZoneRulesProviderTest.class,
  libcore.java.time.zone.ZoneOffsetTransitionTest.class,
  libcore.java.time.zone.ZoneRulesExceptionTest.class,
  libcore.java.time.zone.ZoneRulesTest.class,
  tck.java.time.TCKClock.class,
  tck.java.time.TCKClock_Fixed.class,
  tck.java.time.TCKClock_Offset.class,
  tck.java.time.TCKClock_System.class,
  tck.java.time.TCKClock_Tick.class,
  tck.java.time.TCKDayOfWeek.class,
  tck.java.time.TCKDuration.class,
  tck.java.time.TCKInstant.class,
  tck.java.time.TCKLocalDate.class,
  tck.java.time.TCKLocalDateTime.class,
  tck.java.time.TCKLocalTime.class,
  tck.java.time.TCKMonth.class,
  tck.java.time.TCKMonthDay.class,
  tck.java.time.TCKOffsetDateTime.class,
  tck.java.time.TCKOffsetTime.class,
  tck.java.time.TCKPeriod.class,
  tck.java.time.TCKYear.class,
  tck.java.time.TCKYearMonth.class,
  tck.java.time.TCKZoneId.class,
  tck.java.time.TCKZoneOffset.class,
  tck.java.time.TCKZonedDateTime.class,
  tck.java.time.TestIsoChronology.class,
  tck.java.time.chrono.TCKChronoLocalDate.class,
  tck.java.time.chrono.TCKChronoLocalDateTime.class,
  tck.java.time.chrono.TCKChronoPeriod.class,
  tck.java.time.chrono.TCKChronoZonedDateTime.class,
  tck.java.time.chrono.TCKChronology.class,
  tck.java.time.chrono.TCKIsoChronology.class,
  tck.java.time.chrono.TCKIsoEra.class,
  tck.java.time.chrono.serial.TCKChronoLocalDateTimeSerialization.class,
  tck.java.time.chrono.serial.TCKChronoZonedDateTimeSerialization.class,
  tck.java.time.chrono.serial.TCKChronologySerialization.class,
  tck.java.time.chrono.serial.TCKEraSerialization.class,
  tck.java.time.format.TCKChronoPrinterParser.class,
  tck.java.time.format.TCKDateTimeFormatter.class,
  tck.java.time.format.TCKDateTimeFormatterBuilder.class,
  tck.java.time.format.TCKDateTimeFormatters.class,
  tck.java.time.format.TCKDateTimeParseResolver.class,
  tck.java.time.format.TCKDateTimeTextPrinting.class,
  tck.java.time.format.TCKDecimalStyle.class,
  tck.java.time.format.TCKFormatStyle.class,
  tck.java.time.format.TCKInstantPrinterParser.class,
  tck.java.time.format.TCKLocalizedFieldParser.class,
  tck.java.time.format.TCKLocalizedFieldPrinter.class,
  tck.java.time.format.TCKOffsetPrinterParser.class,
  tck.java.time.format.TCKPadPrinterParser.class,
  tck.java.time.format.TCKResolverStyle.class,
  tck.java.time.format.TCKSignStyle.class,
  tck.java.time.format.TCKTextStyle.class,
  tck.java.time.format.TCKZoneIdPrinterParser.class,
  tck.java.time.serial.TCKClockSerialization.class,
  tck.java.time.serial.TCKDurationSerialization.class,
  tck.java.time.serial.TCKInstantSerialization.class,
  tck.java.time.serial.TCKLocalDateSerialization.class,
  tck.java.time.serial.TCKLocalDateTimeSerialization.class,
  tck.java.time.serial.TCKLocalTimeSerialization.class,
  tck.java.time.serial.TCKMonthDaySerialization.class,
  tck.java.time.serial.TCKOffsetDateTimeSerialization.class,
  tck.java.time.serial.TCKOffsetTimeSerialization.class,
  tck.java.time.serial.TCKPeriodSerialization.class,
  tck.java.time.serial.TCKYearMonthSerialization.class,
  tck.java.time.serial.TCKYearSerialization.class,
  tck.java.time.serial.TCKZoneIdSerialization.class,
  tck.java.time.serial.TCKZoneOffsetSerialization.class,
  tck.java.time.serial.TCKZonedDateTimeSerialization.class,
  tck.java.time.temporal.TCKChronoField.class,
  tck.java.time.temporal.TCKChronoUnit.class,
  tck.java.time.temporal.TCKIsoFields.class,
  tck.java.time.temporal.TCKJulianFields.class,
  tck.java.time.temporal.TCKTemporalAdjusters.class,
  tck.java.time.temporal.TCKWeekFields.class,
  tck.java.time.temporal.serial.TCKChronoFieldSerialization.class,
  tck.java.time.temporal.serial.TCKChronoUnitSerialization.class,
  tck.java.time.temporal.serial.TCKJulianFieldsSerialization.class,
  tck.java.time.temporal.serial.TCKValueRangeSerialization.class,
  tck.java.time.temporal.serial.TCKWeekFieldsSerialization.class,
  tck.java.time.zone.TCKFixedZoneRules.class,
  tck.java.time.zone.TCKZoneOffsetTransition.class,
  tck.java.time.zone.TCKZoneOffsetTransitionRule.class,
  tck.java.time.zone.TCKZoneRules.class,
  tck.java.time.zone.TCKZoneRulesProvider.class,
  tck.java.time.zone.serial.TCKFixedZoneRulesSerialization.class,
  tck.java.time.zone.serial.TCKZoneOffsetTransitionRuleSerialization.class,
  tck.java.time.zone.serial.TCKZoneOffsetTransitionSerialization.class,
  tck.java.time.zone.serial.TCKZoneRulesSerialization.class,
  test.java.time.TestClock_Fixed.class,
  test.java.time.TestClock_Offset.class,
  test.java.time.TestClock_System.class,
  test.java.time.TestClock_Tick.class,
  test.java.time.TestDuration.class,
  test.java.time.TestInstant.class,
  test.java.time.TestLocalDate.class,
  test.java.time.TestLocalDateTime.class,
  test.java.time.TestLocalTime.class,
  test.java.time.TestMonthDay.class,
  test.java.time.TestOffsetDateTime.class,
  test.java.time.TestOffsetDateTime_instants.class,
  test.java.time.TestOffsetTime.class,
  test.java.time.TestPeriod.class,
  test.java.time.TestYear.class,
  test.java.time.TestYearMonth.class,
  test.java.time.TestZoneId.class,
  test.java.time.TestZoneOffset.class,
  test.java.time.TestZonedDateTime.class,
  test.java.time.chrono.TestChronoLocalDate.class,
  test.java.time.chrono.TestIsoChronoImpl.class,
  test.java.time.format.TestCharLiteralParser.class,
  test.java.time.format.TestCharLiteralPrinter.class,
  test.java.time.format.TestDateTimeFormatter.class,
  test.java.time.format.TestDateTimeFormatterBuilder.class,
  test.java.time.format.TestDateTimeParsing.class,
  test.java.time.format.TestDateTimeTextProvider.class,
  test.java.time.format.TestDecimalStyle.class,
  test.java.time.format.TestFractionPrinterParser.class,
  test.java.time.format.TestNumberParser.class,
  test.java.time.format.TestNumberPrinter.class,
  test.java.time.format.TestPadPrinterDecorator.class,
  test.java.time.format.TestReducedParser.class,
  test.java.time.format.TestReducedPrinter.class,
  test.java.time.format.TestSettingsParser.class,
  test.java.time.format.TestStringLiteralParser.class,
  test.java.time.format.TestStringLiteralPrinter.class,
  test.java.time.format.TestTextParser.class,
  test.java.time.format.TestTextPrinter.class,
  test.java.time.format.TestZoneOffsetParser.class,
  test.java.time.format.TestZoneOffsetPrinter.class,
  test.java.time.temporal.TestChronoField.class,
  test.java.time.temporal.TestChronoUnit.class,
  test.java.time.temporal.TestDateTimeBuilderCombinations.class,
  test.java.time.temporal.TestDateTimeValueRange.class,
  test.java.time.temporal.TestIsoWeekFields.class,
  test.java.time.temporal.TestJulianFields.class,
  test.java.time.zone.TestFixedZoneRules.class,
})
public class Tests {}
