/* $Id: move.c,v 1.9 2005/06/10 08:51:43 cegger Exp $
******************************************************************************

   Graphics library for GGI. WMH stuff.

   Copyright (C) 1998 Andreas Beck	[becka@ggi-project.org]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************************
*/

#include "config.h"
#include "xwmh.h"


int GGIwmh_x_move(ggi_visual *vis,int x,int y)
{
	ggi_x_priv *priv = GGIX_PRIV(vis);

	ggLock(priv->xliblock);                                        
	XMoveWindow(priv->disp, priv->parentwin, x, y);
        XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}

static int _ggiwmh_getgeometry(ggi_visual *vis,int *x,int *y,int *w,int *h) {

	ggi_x_priv *priv;
	int rc=0;
	int x1, y1;
	unsigned int w1,h1,bw1,d1;
	Window root_return,child_return;

	priv = GGIX_PRIV(vis);

	root_return = None;
	child_return = None;

	ggLock(priv->xliblock);
	XGetGeometry(priv->disp,priv->parentwin,&root_return,
		     &x1,&y1,&w1,&h1,&bw1,&d1);
	XSync(priv->disp,0);
#warning error handling needed here.
	XTranslateCoordinates(priv->disp,priv->parentwin,root_return,
			   0,0,&x1,&y1,&child_return);
	XSync(priv->disp,0);
	ggUnlock(priv->xliblock);
	if (x) *x=x1;
	if (y) *y=y1;
	if (w) *w=w1;
	if (h) *h=h1;
	return rc;
}

int GGIwmh_x_getpos(ggi_visual *vis,int *x,int *y)
{
	return _ggiwmh_getgeometry(vis,x,y,NULL,NULL);
}

int GGIwmh_x_getsize(ggi_visual *vis,int *x,int *y)
{
	return _ggiwmh_getgeometry(vis,NULL,NULL,x,y);
}

int GGIwmh_x_resize(ggi_visual *vis,int x,int y)
{
	ggi_x_priv *priv = LIBGGI_PRIVATE(vis);

	ggLock(priv->xliblock);                                        
	XResizeWindow(priv->disp, priv->parentwin,
			(unsigned int)(x), (unsigned int)(y));
        XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}

int GGIwmh_x_allowresize(ggi_visual *vis, int xmin, int ymin,
			 int xmax, int ymax, int xstep, int ystep)
{
	XSizeHints hints;
	ggi_x_priv *priv = GGIX_PRIV(vis);

	if (xmin<0  || ymin<0  || xstep<1 || ystep<1 || 
	    xmin>xmax || ymin>ymax ) return GGI_ENOSPACE;

	ggLock(priv->xliblock);

	hints.flags=PMinSize|PMaxSize|PResizeInc;

	hints.min_width =xmin;
	hints.min_height=ymin;
	hints.max_width =xmax;
	hints.max_height=ymax;
	hints.width_inc =xstep;
	hints.height_inc=ystep;

	XSetWMNormalHints(priv->disp, priv->parentwin, &hints);
        XSync(priv->disp,0);

	ggUnlock(priv->xliblock);

	return 0;
}

int GGIwmh_x_maximize(ggi_visual *vis,int x,int y)
{
	ggi_x_priv *priv;
	Window w_dummy;
	int i_dummy;
	unsigned int ui_dummy,width,height;
	
	priv = GGIX_PRIV(vis);

	ggLock(priv->xliblock);                                        

	XGetGeometry(priv->disp, 
		     RootWindow(priv->disp, 
				priv->vilist[priv->viidx].vi->screen),
		     &w_dummy, &i_dummy, &i_dummy,
		     &width,&height,
		     &ui_dummy,&ui_dummy);
	XResizeWindow(priv->disp, priv->parentwin, x*width/100, y*height/100);
        XSync(priv->disp,0);
	ggUnlock(priv->xliblock);

	return 0;
}

int GGIwmh_x_moveicon(ggi_visual *vis,int x,int y)
{
	return GGI_ENOFUNC;
}
