/* -*- C++ -*- */
/*  XScreenSaver.App XScreenSaver Dockapp
 *  Copyright (C) 2003 A.Sleep <a.sleep@asleep.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <dockapp.h>
#include <unistd.h>
#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#include "pixmap.h"

#define VERSION "2.3"

/*---------------------------------------------------------------------------*/
/*                             Prototypes                                    */
/*---------------------------------------------------------------------------*/

void ActionLaunch(int x, int y, DARect rect, void *data);
void buttonPress(int button, int state, int x, int y);
void buttonRelease(int button, int state, int x, int y);
void *DisplayThread(void *p);
void *CheckThread(void *p);
void popConfig(void);

/*----------------------------------------------------------------------------*/
/*                             Variables                                      */
/*----------------------------------------------------------------------------*/

char *startup_cmd="xscreensaver";
char *left_cmd="xscreensaver-command -lock";
char *right_cmd="xscreensaver-command -prefs";

time_t t;
int n=5;
char *displayName = "";
GC gc;
Pixmap pixmap, mask;		/* Pixmap that is displayed */

static DAActionRect theRect[] = {
  {{1, 1, 48, 48}, ActionLaunch}
};

static DAProgramOption options[] = {
  {"-d", "--display", "Display to use", DOString, False, {&displayName} },
  {"-s", "--start", "Command to launch on startup", DOString, False, {&startup_cmd} },
  {"-l", "--left", "Command to launch on left click", DOString, False, {&left_cmd} },
  {"-r", "--right", "Command to launch on right click", DOString, False, {&right_cmd} }
};

/*----------------------------------------------------------------------------*/
/*                              Functions                                     */
/*----------------------------------------------------------------------------*/

void ActionLaunch(int x, int y, DARect rect, void *data)
{
  char *command;
  int status;

  command = malloc(strlen(left_cmd)+5);
  sprintf(command, "%s &", left_cmd);
  status = system(command);

  if (status) {
    fprintf(stderr, "Action can't be launched...");
  }

  free(command);
}

void buttonPress(int button, int state, int x, int y)
{
  if (button == 1) {
    DAProcessActionRects(x, y, theRect, 3, NULL);
  }
  if (button == 3) {
    popConfig();
  }
}

void popConfig()
{
  char *cfg_command;
  int status;

  cfg_command = malloc(strlen(right_cmd)+5);
  sprintf(cfg_command, "%s &", right_cmd);
  status = system(cfg_command);

  if (status) {
    fprintf(stderr, "XScreenSaver could not be launched.");
  }

  free(cfg_command);
}

/*----------------------------------------------------------------------------*/
/*                                   Main                                     */
/*----------------------------------------------------------------------------*/

int main(int argc, char **argv)
{
  unsigned height, width;
  char *st_command;
  int status;

  DACallbacks callbacks={NULL, buttonPress, NULL, NULL,
			 NULL, NULL, NULL};

  DAParseArguments(argc, argv, options,
		   sizeof(options)/sizeof(DAProgramOption),
		   "XScreenSaver DockApp by A.Sleep <a.sleep@asleep.net>\n",
		   VERSION);
  
  DAInitialize(displayName, "XScreenSaver.App", 50, 50, argc, argv);
  DASetCallbacks(&callbacks);

  DAMakePixmapFromData(xscreensaver_app_master_xpm, &pixmap, &mask, &height, &width);

  gc = DefaultGC(DADisplay, DefaultScreen(DADisplay));

  DASetPixmap(pixmap);
  DAShow();

  st_command = malloc(strlen(startup_cmd)+5);
  sprintf(st_command, "%s &", startup_cmd);
  status = system(st_command);

  if (status) {
    fprintf(stderr, "XScreenSaver could not be launched.");
  }

  free(st_command);

  while (1) {
    XEvent ev;
    DASetPixmap(pixmap);
    
    /* handle all pending X events */
    while (XPending(DADisplay)) {
      XNextEvent(DADisplay, &ev);
      DAProcessEvent(&ev);
    }

    usleep(10000);

  }

  return 0;
}
