/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer.search;

import com.ca.commons.cbutil.CBBasicComboBoxRenderer;
import com.ca.commons.cbutil.CBButton;
import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBSingleSelectionModel;
import com.ca.commons.cbutil.CBUtility;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.search.SearchModel;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ReturnAttributesDialog
extends CBDialog {
    private static Logger log = Logger.getLogger(ReturnAttributesDialog.class.getName());
    private JList availableList;
    private JList selectedList;
    private CBButton btnAdd;
    private CBButton btnRemove;
    private CBButton btnSave;
    private CBButton btnLoad;
    private CBButton btnDelete;
    private JTextField nameField;
    private JCheckBox includeDNCheckBox;
    private ArrayList arrayList = new ArrayList();
    private String localDir = "";
    private JXplorerBrowser browser;
    private boolean hasSaved = false;
    public static final String FILENAME = "return_attributes.txt";
    public static final String INCLUDE_DN = "[DN]";
    public static final String DEFAULT_RETURN_ATTRS = "None";
    static String configSavePath;
    static Properties returnAttProperties;

    public static ArrayList getSelectedValues(JXplorerBrowser jx) {
        ReturnAttributesDialog listSelector = new ReturnAttributesDialog(jx);
        listSelector.setVisible(true);
        return listSelector.getSelectedValues();
    }

    public static String[] getReturnAttributes(String name) {
        ArrayList list = new ArrayList(0);
        if (returnAttProperties == null) {
            return new String[]{"objectClass"};
        }
        String value = returnAttProperties.getProperty(name);
        if (value == null) {
            return new String[]{"objectClass"};
        }
        ReturnAttributesDialog.getReturnAttributes(value, list);
        return list.toArray(new String[list.size()]);
    }

    public static void getReturnAttributes(String value, ArrayList list) {
        if (value.indexOf(";") > -1) {
            list.add(value.substring(0, value.indexOf(";")));
            ReturnAttributesDialog.getReturnAttributes(value.substring(value.indexOf(";") + 1), list);
        }
    }

    public static Object[] getSavedListNames() {
        Enumeration<?> en = null;
        ArrayList<String> list = new ArrayList<String>(0);
        try {
            en = returnAttProperties.propertyNames();
        }
        catch (Exception e) {
            list.add(DEFAULT_RETURN_ATTRS);
            return list.toArray();
        }
        list.add(DEFAULT_RETURN_ATTRS);
        while (en.hasMoreElements()) {
            list.add(en.nextElement().toString());
        }
        return list.toArray();
    }

    public ReturnAttributesDialog(JXplorerBrowser jx) {
        super((Frame)jx, CBIntText.get("Return Attributes"), "return.attributes");
        this.browser = jx;
        if (returnAttProperties == null) {
            configSavePath = CBUtility.getPropertyConfigPath(JXplorer.APPLICATION_NAME, FILENAME);
            returnAttProperties = CBUtility.readPropertyFile(configSavePath);
        }
        CBPanel topPanel = new CBPanel();
        CBPanel leftPanel = new CBPanel();
        CBPanel middlePanel = new CBPanel();
        CBPanel rightPanel = new CBPanel();
        CBPanel bottomPanel = new CBPanel();
        topPanel.makeLight();
        topPanel.add(new JLabel(CBIntText.get("Name") + ": "));
        topPanel.makeWide();
        this.nameField = new JTextField(CBIntText.get("Untitled"));
        topPanel.add(this.nameField);
        topPanel.makeLight();
        this.btnSave = new CBButton(CBIntText.get("Save"), CBIntText.get("Save your selected return attributes for use in the Search dialog."));
        topPanel.add(this.btnSave);
        this.btnLoad = new CBButton(CBIntText.get("Load"), CBIntText.get("Load an already saved list of return attributes."));
        topPanel.add(this.btnLoad);
        this.btnDelete = new CBButton(CBIntText.get("Delete"), CBIntText.get("Delete a already saved list of return attributes."));
        topPanel.add(this.btnDelete);
        this.btnSave.setPreferredSize(new Dimension(62, 20));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReturnAttributesDialog.this.save();
                ReturnAttributesDialog.this.hasSaved = true;
            }
        });
        this.btnLoad.setPreferredSize(new Dimension(62, 20));
        this.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReturnAttributesDialog.this.load();
                ReturnAttributesDialog.this.hasSaved = false;
            }
        });
        this.btnDelete.setPreferredSize(new Dimension(70, 20));
        this.btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReturnAttributesDialog.this.delete();
                ReturnAttributesDialog.this.hasSaved = true;
            }
        });
        leftPanel.addln(new JLabel(CBIntText.get("Available Attributes") + ":"));
        leftPanel.makeHeavy();
        this.availableList = new JList<String>(this.getAttributes());
        this.availableList.setSelectionMode(0);
        this.availableList.setSelectionModel(new CBSingleSelectionModel(this.availableList));
        leftPanel.addln(new JScrollPane(this.availableList));
        this.btnAdd = new CBButton(CBIntText.get(">"), CBIntText.get("Add an attribute from the attribute list on the left to the selection list on the right."));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReturnAttributesDialog.this.add();
                ReturnAttributesDialog.this.hasSaved = false;
            }
        });
        this.btnRemove = new CBButton(CBIntText.get("<"), CBIntText.get("Remove an attribute from the selection list on the right."));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReturnAttributesDialog.this.remove();
                ReturnAttributesDialog.this.hasSaved = false;
            }
        });
        middlePanel.makeHeavy();
        middlePanel.addln(new JLabel("  "));
        middlePanel.makeLight();
        middlePanel.addln(this.btnAdd);
        middlePanel.addln(this.btnRemove);
        middlePanel.makeHeavy();
        middlePanel.addln(new JLabel("  "));
        rightPanel.addln(new JLabel(CBIntText.get("Selected Attributes") + ":"));
        rightPanel.makeHeavy();
        this.selectedList = new JList();
        this.selectedList.setSelectionMode(0);
        this.selectedList.setSelectionModel(new CBSingleSelectionModel(this.selectedList));
        rightPanel.addln(new JScrollPane(this.selectedList));
        this.includeDNCheckBox = new JCheckBox(CBIntText.get("Include DN in search results."));
        this.includeDNCheckBox.setToolTipText(CBIntText.get("Click the checkbox if you want the DN of each result displayed in the results window."));
        bottomPanel.makeLight();
        bottomPanel.add(this.includeDNCheckBox);
        bottomPanel.makeHeavy();
        bottomPanel.addln(new JLabel("  "));
        this.display.addln(new JLabel("  "));
        this.display.makeWide();
        this.display.addln(topPanel);
        this.display.makeHeavy();
        this.display.add(leftPanel);
        this.display.makeLight();
        this.display.add(middlePanel);
        this.display.makeHeavy();
        this.display.add(rightPanel);
        this.display.newLine();
        this.display.makeLight();
        this.display.addln(bottomPanel);
        this.setSize(400, 350);
        CBUtility.center(this, this.owner);
        this.registerMouseListeners();
    }

    protected String[] getAttributes() {
        try {
            JNDIDataBroker searchBroker = this.browser.getSearchBroker();
            ArrayList<String> en = searchBroker.getSchemaOps().getKnownAttributeNames();
            if (en == null) {
                return null;
            }
            String[] temp = en.toArray(new String[0]);
            Arrays.sort(temp, new CBUtility.IgnoreCaseStringComparator());
            return temp;
        }
        catch (NamingException e) {
            log.log(Level.WARNING, "Error accessing attribute defs in ReturnAttributesDialog ", e);
            return null;
        }
    }

    protected void registerMouseListeners() {
        this.availableList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReturnAttributesDialog.this.add();
                }
                ReturnAttributesDialog.this.hasSaved = false;
            }
        });
        this.selectedList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    ReturnAttributesDialog.this.remove();
                }
                ReturnAttributesDialog.this.hasSaved = false;
            }
        });
    }

    public void add() {
        try {
            if (!this.arrayList.contains(this.availableList.getSelectedValue())) {
                this.arrayList.add(this.availableList.getSelectedValue());
            }
            this.selectedList.setListData(this.arrayList.toArray());
        }
        catch (Exception e) {
            log.warning("No selection to add.");
        }
    }

    public void remove() {
        try {
            this.arrayList.remove(this.selectedList.getSelectedIndex());
            this.selectedList.setListData(this.arrayList.toArray());
        }
        catch (Exception e) {
            log.warning("No selection to remove.");
        }
    }

    public void save() {
        int response;
        ArrayList list = this.getSelectedValues();
        if (list == null) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Please select the return attributes that you want to save in your list"), CBIntText.get("Nothing to Save"), 1);
            return;
        }
        String name = this.nameField.getText();
        if (name == null || name.trim().length() <= 0 || name.equalsIgnoreCase("Untitled")) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Please enter a name for your list."), CBIntText.get("Name Not Supplied"), 1);
            return;
        }
        if (this.exists(name) && (response = JOptionPane.showConfirmDialog(this, CBIntText.get("Do you want to replace it?"), CBIntText.get("List Exists"), 2)) != 0) {
            return;
        }
        StringBuffer buffy = new StringBuffer(0);
        if (this.includeDNCheckBox.isSelected()) {
            buffy.append("[DN];");
        }
        for (int i = 0; i < list.size(); ++i) {
            buffy.append(list.get(i) + ";");
        }
        returnAttProperties.setProperty(name, buffy.toString());
        CBUtility.writePropertyFile(configSavePath, returnAttProperties, null);
        JOptionPane.showMessageDialog(this, CBIntText.get("Your return attributes list has been saved as ''{0}''.", new String[]{name}), CBIntText.get("Saved"), 1);
        this.browser.getTree().setSearchGUI(null);
        this.browser.getSearchTree().setSearchGUI(null);
        this.browser.getSchemaTree().setSearchGUI(null);
    }

    public void load() {
        Enumeration<?> en = returnAttProperties.propertyNames();
        ArrayList<String> list = new ArrayList<String>(0);
        while (en.hasMoreElements()) {
            list.add((String)en.nextElement());
        }
        if (list.size() == 0) {
            JOptionPane.showMessageDialog(this, CBIntText.get("There are no filters available to load."), CBIntText.get("Nothing to Load"), 1);
            return;
        }
        Object[] listOb = list.toArray();
        CBJComboBox loadCombo = new CBJComboBox(listOb);
        loadCombo.setRenderer(new CBBasicComboBoxRenderer(listOb));
        loadCombo.setPreferredSize(new Dimension(140, 20));
        int response = JOptionPane.showConfirmDialog(this, loadCombo, CBIntText.get("Select List"), 2);
        if (response != 0) {
            return;
        }
        this.includeDNCheckBox.setSelected(false);
        String name = loadCombo.getSelectedItem().toString();
        String loadList = this.getList(name);
        this.nameField.setText(name);
        this.arrayList.clear();
        this.getListAttrs(loadList, this.arrayList);
        this.selectedList.setListData(this.arrayList.toArray());
    }

    public void getListAttrs(String loadList, ArrayList list) {
        if (loadList.indexOf(";") > -1) {
            String temp = loadList.substring(0, loadList.indexOf(";"));
            if (temp.equalsIgnoreCase(INCLUDE_DN)) {
                this.includeDNCheckBox.setSelected(true);
            } else {
                list.add(temp);
            }
            this.getListAttrs(loadList.substring(loadList.indexOf(";") + 1), list);
        }
    }

    protected boolean exists(String name) {
        return returnAttProperties.containsKey(name);
    }

    public String getList(String name) {
        return returnAttProperties.getProperty(name);
    }

    public void delete() {
        String toDelete = this.nameField.getText();
        if (toDelete == null || toDelete.trim().length() <= 0 || toDelete.equalsIgnoreCase("Untitled")) {
            JOptionPane.showMessageDialog(this, CBIntText.get("Please enter the name of the list that you want to delete."), CBIntText.get("Nothing to Delete"), 1);
            return;
        }
        int response = JOptionPane.showConfirmDialog(this, CBIntText.get("Are you sure you want to delete the list ''{0}''?", new String[]{toDelete}), CBIntText.get("Delete List?"), 2);
        if (response != 0) {
            return;
        }
        this.removeList(toDelete);
        this.nameField.setText("");
        this.arrayList.clear();
        this.selectedList.setListData(this.arrayList.toArray());
        this.includeDNCheckBox.setSelected(false);
        this.browser.getTree().setSearchGUI(null);
        this.browser.getSearchTree().setSearchGUI(null);
        this.browser.getSchemaTree().setSearchGUI(null);
    }

    protected void removeList(String name) {
        if (!returnAttProperties.containsKey(name)) {
            return;
        }
        returnAttProperties.remove(name);
        CBUtility.writePropertyFile(configSavePath, returnAttProperties, null);
        this.removeFromSearch(name);
    }

    public void removeFromSearch(String name) {
        SearchModel sm = new SearchModel();
        sm.removeRetAttrs(name);
    }

    public ArrayList getSelectedValues() {
        if (this.arrayList.isEmpty()) {
            return null;
        }
        return this.arrayList;
    }

    @Override
    public void doOK() {
        if (!this.hasSaved) {
            int response = JOptionPane.showConfirmDialog(this, CBIntText.get("Exit without saving the return attributes list?"), CBIntText.get("Exit Without Saving"), 2);
            if (response == 0) {
                super.doOK();
            }
        } else {
            super.doOK();
        }
    }
}

