/*
 * Decompiled with CFR 0.152.
 */
package com.ca.directory.jxplorer;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBFileChooserButton;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import java.awt.Dimension;
import java.awt.Frame;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class KeystoreOptions
extends CBDialog {
    private String caStore;
    private String clientStore;
    CBFileChooserButton caChooser;
    CBFileChooserButton clientChooser;
    JTextField caKeystoreLocationText;
    JTextField clientKeystoreLocationText;
    CBJComboBox caTypeCombo;
    CBJComboBox clientTypeCombo;
    private JTextField clientKeystore;
    private JTextField trustedServerKeystore;
    private boolean debug = false;
    private Properties properties;
    private Vector keyTypes;

    KeystoreOptions(Frame owner, Properties properties) {
        super(owner, CBIntText.get("Keystore Options"), "ssl.changekeystore");
        this.properties = properties;
        this.keyTypes = new Vector(10);
        String caType = (String)properties.get("keystoreType.cacerts");
        String clientType = (String)properties.get("keystoreType.clientcerts");
        this.caStore = (String)properties.get("option.ssl.cacerts");
        this.clientStore = (String)properties.get("option.ssl.clientcerts");
        this.keyTypes.add(caType);
        if (!this.keyTypes.contains(clientType)) {
            this.keyTypes.add(clientType);
        }
        this.keyTypes = this.setupKeyList(this.keyTypes);
        this.caTypeCombo = new CBJComboBox(this.keyTypes);
        this.caTypeCombo.setSelectedItem(caType);
        this.clientTypeCombo = new CBJComboBox(this.keyTypes);
        this.clientTypeCombo.setSelectedItem(clientType);
        this.makeWide();
        CBPanel caPanel = new CBPanel();
        caPanel.setBorder(new TitledBorder(CBIntText.get("Setup the Trusted CA / Server Keystore")));
        caPanel.add(new JLabel(CBIntText.get("CA/Server Keystore") + ":"));
        this.caKeystoreLocationText = new JTextField(this.caStore);
        caPanel.addGreedyWide(this.caKeystoreLocationText, 2);
        caPanel.makeLight();
        this.caChooser = new CBFileChooserButton(this.caKeystoreLocationText, this, CBIntText.get("Load"), CBIntText.get("Open the file chooser."));
        this.caChooser.setPreferredSize(new Dimension(65, 21));
        this.caChooser.setStartingDirectory(this.caStore);
        caPanel.addln(this.caChooser);
        caPanel.add(new JLabel(CBIntText.get("Set CA/Server Keystore Type") + ":"));
        this.caTypeCombo.setPreferredSize(new Dimension(100, 21));
        caPanel.add(this.caTypeCombo);
        caPanel.add(new JLabel("  "));
        caPanel.addln(new JLabel(" "));
        this.display.addln(new JLabel(" "));
        this.display.addln(caPanel);
        this.display.addln(new JLabel(" "));
        CBPanel clientPanel = new CBPanel();
        clientPanel.setBorder(new TitledBorder(CBIntText.get("Setup the Client's Private Keystore")));
        clientPanel.add(new JLabel(CBIntText.get("Client Keystore") + ":"));
        this.clientKeystoreLocationText = new JTextField(this.clientStore);
        clientPanel.addGreedyWide(this.clientKeystoreLocationText, 2);
        clientPanel.makeLight();
        this.clientChooser = new CBFileChooserButton(this.clientKeystoreLocationText, this, CBIntText.get("Load"), CBIntText.get("Open the file chooser."));
        this.clientChooser.setPreferredSize(new Dimension(65, 21));
        this.clientChooser.setStartingDirectory(this.caStore);
        clientPanel.addln(this.clientChooser);
        clientPanel.add(new JLabel(CBIntText.get("Set Client Keystore Type") + ": "));
        this.clientTypeCombo.setPreferredSize(new Dimension(100, 21));
        clientPanel.add(this.clientTypeCombo);
        clientPanel.add(new JLabel("  "));
        clientPanel.addln(new JLabel("  "));
        this.display.addln(clientPanel);
    }

    public Vector setupKeyList(Vector keyList) {
        Set<Object> keys;
        int i;
        Provider[] providers;
        if (this.debug) {
            providers = Security.getProviders();
            for (i = 0; i < providers.length; ++i) {
                keys = providers[i].keySet();
                for (String string : keys) {
                }
            }
        }
        providers = Security.getProviders();
        for (i = 0; i < providers.length; ++i) {
            keys = providers[i].keySet();
            for (String string : keys) {
                String keyStoreName;
                if (!string.startsWith("KeyStore") || string.endsWith("ImplementedIn") || keyList.contains(keyStoreName = string.substring(9))) continue;
                keyList.add(keyStoreName);
            }
        }
        return keyList;
    }

    @Override
    public void doOK() {
        this.properties.setProperty("keystoreType.cacerts", (String)this.caTypeCombo.getSelectedItem());
        this.properties.setProperty("keystoreType.clientcerts", (String)this.clientTypeCombo.getSelectedItem());
        this.properties.setProperty("option.ssl.cacerts", this.caKeystoreLocationText.getText());
        this.properties.setProperty("option.ssl.clientcerts", this.clientKeystoreLocationText.getText());
        super.doOK();
    }
}

