/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.naming;

import com.ca.commons.cbutil.CBDialog;
import com.ca.commons.cbutil.CBErrorWin;
import com.ca.commons.cbutil.CBIntText;
import com.ca.commons.cbutil.CBJComboBox;
import com.ca.commons.cbutil.CBPanel;
import com.ca.commons.cbutil.CBSaveLoadTemplate;
import com.ca.commons.jndi.ConnectionData;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public abstract class CBOpenConWin
extends CBDialog {
    protected ConnectionData newCon;
    protected JTextField hostName;
    protected JTextField port;
    protected JTextField baseDN;
    protected JTextField managerDN;
    protected CBJComboBox version;
    protected CBJComboBox level;
    protected JCheckBox readOnly;
    protected JPasswordField password;
    protected JLabel hostLabel;
    protected JLabel portLabel;
    protected JLabel userMessage;
    protected JLabel readOnlyLabel;
    protected CBSaveLoadTemplate myTemplater;
    protected CBPanel securityPanel;
    static int threadID = 1;
    static final boolean DEBUGTHREADS = false;
    static final int NONE = 0;
    static final int USER_AUTH = 1;
    static final int SSL_NO_AUTH = 2;
    static final int SSL_USER_AUTH = 3;
    static final int SASL = 4;
    static final int GSSAPI = 5;
    protected static final String LDAPV2 = CBIntText.get("LDAP v2");
    protected static final String LDAPV3 = CBIntText.get("LDAP v3");
    protected SecurityActionListener securityListener;
    private static final Logger log = Logger.getLogger(CBOpenConWin.class.getName());
    protected String[] securityOptions = new String[]{CBIntText.get("Anonymous"), CBIntText.get("User + Password"), CBIntText.get("SSL + Anonymous"), CBIntText.get("SSL + User + Password"), CBIntText.get("SSL + SASL + Keystore Password"), CBIntText.get("GSSAPI")};

    public CBOpenConWin(Frame owner, String applicationName, JLabel statusDisplay, String clientcerts, String cacerts, String referral, String aliasType) {
        this(owner, applicationName, statusDisplay, clientcerts, cacerts, referral, aliasType, null);
    }

    public CBOpenConWin(Frame owner, String applicationName, JLabel statusDisplay, String clientcerts, String cacerts, String referral, String aliasType, String helpID) {
        this(owner, applicationName, statusDisplay, clientcerts, cacerts, helpID);
        this.newCon.referralType = referral;
        this.newCon.aliasType = aliasType;
    }

    public CBOpenConWin(Frame owner, String applicationName, JLabel statusDisplay, String clientcerts, String cacerts) {
        this(owner, applicationName, statusDisplay, clientcerts, cacerts, null);
    }

    public CBOpenConWin(Frame owner, String applicationName, JLabel statusDisplay, String clientcerts, String cacerts, String helpID) {
        super(owner, CBIntText.get("Open LDAP connection"), helpID);
        this.newCon = new ConnectionData();
        this.newCon.clientcerts = clientcerts;
        this.newCon.cacerts = cacerts;
        this.initGUI(applicationName, statusDisplay);
    }

    protected void initGUI(String applicationName, JLabel statusDisplay) {
        String oldConnection = "";
        int oldPortNo = 389;
        String oldBaseDN = "";
        this.userMessage = statusDisplay;
        this.display.makeHeavy();
        this.hostLabel = new JLabel("   " + CBIntText.get("Host") + ": ");
        this.display.add(this.hostLabel);
        this.hostName = new JTextField(oldConnection, 30);
        this.display.addWide(this.hostName, 2);
        this.hostLabel.setToolTipText(CBIntText.get("The url of the server; e.g.") + " 'www.cai.com'");
        this.portLabel = new JLabel("  " + CBIntText.get("Port") + ": ");
        this.display.add(this.portLabel);
        this.port = new JTextField(String.valueOf(oldPortNo), 5);
        this.display.addLine(this.port);
        this.portLabel.setToolTipText(CBIntText.get("The port number of the LDAP server; often 389."));
        JLabel temp = new JLabel("   " + CBIntText.get("Protocol") + ": ");
        this.display.add(temp);
        this.version = new CBJComboBox(new String[]{LDAPV2, LDAPV3});
        this.display.add(this.version);
        this.version.setSelectedIndex(1);
        temp.setToolTipText(CBIntText.get("For all but the oldest servers, this should be 'LDAP v3'."));
        this.version.setToolTipText(CBIntText.get("For all but the oldest servers, this should be 'LDAP v3'."));
        this.display.add(new JLabel(""));
        this.display.newLine();
        CBPanel inset = new CBPanel();
        inset.setBorder(new TitledBorder(CBIntText.get("Optional Values")));
        temp = new JLabel(CBIntText.get("Base DN") + ":         ");
        inset.add(temp);
        temp.setToolTipText(CBIntText.get("The base to start browsing from; e.g.") + " 'o=Democorp,c=au'");
        inset.makeWide();
        this.baseDN = new JTextField(String.valueOf(oldBaseDN), 30);
        inset.addln(this.baseDN);
        inset.makeLight();
        inset.add(new JLabel(""));
        inset.addGreedyWide(new JLabel(""));
        this.readOnlyLabel = new JLabel("  " + CBIntText.get("Read Only") + ": ");
        inset.add(this.readOnlyLabel);
        this.readOnly = new JCheckBox();
        inset.addLine(this.readOnly);
        this.display.addLines(inset, 1);
        this.securityPanel = new CBPanel();
        this.securityPanel.setBorder(new TitledBorder(CBIntText.get("Security")));
        this.securityPanel.makeLight();
        temp = new JLabel(CBIntText.get("Level") + ":");
        this.securityPanel.add(temp);
        temp.setToolTipText(CBIntText.get("The level of authentication."));
        this.level = new CBJComboBox(this.securityOptions);
        this.level.setToolTipText(CBIntText.get("Before using SSL, make sure you've set up your keystores in the 'Security' menu."));
        this.securityPanel.addln(this.level);
        temp = new JLabel(CBIntText.get("User DN") + ":  ");
        this.securityPanel.add(temp);
        this.managerDN = new JTextField(30);
        this.securityPanel.addln(this.managerDN);
        temp.setToolTipText(CBIntText.get("To log on as an authenticated user, enter your user dn here."));
        temp = new JLabel(CBIntText.get("Password") + ":   ");
        this.securityPanel.add(temp);
        this.password = new JPasswordField(30);
        this.securityPanel.addLine(this.password);
        temp.setToolTipText(CBIntText.get("Set your user password (or SASL keystore password) here."));
        this.display.addLines(this.securityPanel, 3);
        this.OK.setToolTipText(CBIntText.get("Click here to connect using current settings."));
        this.myTemplater = this.getNewCBSaveLoadTemplate(applicationName, "connections.txt");
        this.display.addWide(this.myTemplater, 5);
        this.addExtraComponent();
        this.display.newLine();
        this.display.add(new JLabel(""));
        this.display.doLayout();
        this.getContentPane().add(this.display);
        this.doLayout();
        this.myTemplater.loadDefault();
        this.checkSecurityLevel();
        this.securityListener = new SecurityActionListener();
        this.level.addActionListener(this.securityListener);
        this.myTemplater.getLoadComboBox().addActionListener(this.securityListener);
    }

    protected CBSaveLoadTemplate getNewCBSaveLoadTemplate(String applicationName, String templateName) {
        return new CBSaveLoadTemplate(applicationName, templateName);
    }

    public void addExtraComponent() {
    }

    protected int checkSecurityLevel() {
        int selected = this.level.getSelectedIndex();
        switch (selected) {
            case 0: {
                this.setState(false, false);
                return 0;
            }
            case 1: {
                this.setState(true, true);
                return 1;
            }
            case 2: {
                this.setState(false, false);
                return 2;
            }
            case 3: {
                this.setState(true, true);
                return 3;
            }
            case 4: {
                this.setState(false, true);
                return 4;
            }
            case 5: {
                this.setState(false, false);
                return 5;
            }
        }
        return 0;
    }

    private void setState(boolean user, boolean pwd) {
        this.managerDN.setEnabled(user);
        this.managerDN.setBackground(user ? Color.white : Color.lightGray);
        if (!pwd) {
            this.password.setText("");
        }
        this.password.setEnabled(pwd);
        this.password.setBackground(pwd ? Color.white : Color.lightGray);
    }

    public void resetTitleAndPassword() {
        this.setTitle(CBIntText.get("Open LDAP Connection"));
        this.password.setText("");
    }

    protected String getURL() throws NumberFormatException, URISyntaxException {
        String host = null;
        String portString = null;
        if (this.hostName != null) {
            host = this.hostName.getText();
        }
        if (this.port != null) {
            portString = this.port.getText();
        }
        if (host != null) {
            host = host.trim();
        }
        if (portString != null) {
            portString = portString.trim();
        }
        if (host == null || host.length() < 1) {
            throw new URISyntaxException("", CBIntText.get("A host name must be entered for JXplorer to connect to."));
        }
        if (portString == null || portString.length() < 1) {
            throw new URISyntaxException("", CBIntText.get("A port number must be entered for JXplorer to connect to."));
        }
        int port = Integer.parseInt(portString);
        if (port < 0) {
            throw new NumberFormatException(CBIntText.get("Negative Port Number is illegal"));
        }
        if (port > 65536) {
            throw new NumberFormatException(CBIntText.get("Port Number {0} is illegal", new String[]{portString}));
        }
        return "ldap://" + host + ":" + port;
    }

    public ConnectionData getConnectionData() throws Exception {
        return this.getConnectionData(null);
    }

    public ConnectionData getConnectionData(char[] defaultPwd) throws Exception {
        ConnectionData connection = this.newCon;
        log.fine("read values: " + this.hostName.getText() + ":" + this.port.getText());
        String url = this.getURL();
        connection.setURL(url);
        if (this.userMessage != null) {
            this.userMessage.setText(CBIntText.get("Opening Connection To") + " " + url);
        }
        connection.version = this.version.getSelectedItem() == LDAPV2 ? 2 : 3;
        int securityLevel = this.checkSecurityLevel();
        connection.userDN = null;
        connection.clearPasswords();
        connection.useGSSAPI = false;
        if (securityLevel == 1 || securityLevel == 3) {
            connection.userDN = this.managerDN.getText().trim();
            char[] cArray = connection.pwd = defaultPwd == null ? this.password.getPassword() : defaultPwd;
            if (connection.pwd.length == 0) {
                throw new Exception(CBIntText.get("No Password Provided.  Please enter a password."));
            }
        } else if (securityLevel == 4) {
            char[] cArray = connection.clientKeystorePwd = defaultPwd == null ? this.password.getPassword() : defaultPwd;
            if (connection.clientKeystorePwd.length == 0) {
                throw new Exception(CBIntText.get("No Password Provided.  Please enter a password."));
            }
        } else if (securityLevel == 5) {
            connection.useGSSAPI = true;
        }
        this.setVisible(false);
        connection.useSSL = securityLevel >= 2 && securityLevel != 5;
        connection.baseDN = this.baseDN.getText();
        connection.templateName = this.myTemplater.getCurrentTemplateName();
        connection.readOnly = this.readOnly.isSelected();
        return connection;
    }

    @Override
    public void doOK() {
        try {
            this.newCon = this.getConnectionData();
        }
        catch (Exception err) {
            new CBErrorWin((Dialog)this, "Error in data provided: " + err.getMessage(), err);
            err.printStackTrace();
            this.password.setText("");
            this.setVisible(true);
            this.setTitle(CBIntText.get("Couldn't Connect: Try Again"));
            log.warning("User error in openconwin: " + err);
            this.userMessage.setText(CBIntText.get("Error Opening Connection."));
            return;
        }
        this.connect(this.newCon);
    }

    public abstract void connect(ConnectionData var1);

    class SecurityActionListener
    implements ActionListener {
        SecurityActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CBOpenConWin.this.checkSecurityLevel();
        }
    }
}

