/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntSet;

public abstract class IntCheckingSet
implements IntSet {
    public void clear() {
        throw new UnsupportedOperationException("IntCheckingSet is immutable");
    }

    public IntSet copy() {
        return this;
    }

    public IntSet mutableCopy() {
        throw new UnsupportedOperationException("IntCheckingSet cannot be copied");
    }

    public int size() {
        return Integer.MAX_VALUE;
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract boolean contains(int var1);

    public boolean remove(int value) {
        throw new UnsupportedOperationException("IntCheckingSet is immutable");
    }

    public boolean add(int value) {
        throw new UnsupportedOperationException("IntCheckingSet is immutable");
    }

    public IntIterator iterator() {
        throw new UnsupportedOperationException("Cannot iterate over IntCheckingSet");
    }

    public IntSet union(final IntSet other) {
        final IntCheckingSet is = this;
        return new IntCheckingSet(){

            public boolean contains(int value) {
                return is.contains(value) || other.contains(value);
            }
        };
    }

    public IntSet intersect(final IntSet other) {
        final IntCheckingSet is = this;
        return new IntCheckingSet(){

            public boolean contains(int value) {
                return is.contains(value) && other.contains(value);
            }
        };
    }

    public IntSet except(final IntSet other) {
        final IntCheckingSet is = this;
        return new IntCheckingSet(){

            public boolean contains(int value) {
                return is.contains(value) && !other.contains(value);
            }
        };
    }

    public boolean containsAll(IntSet other) {
        IntIterator ii = other.iterator();
        while (ii.hasNext()) {
            if (this.contains(ii.next())) continue;
            return false;
        }
        return true;
    }
}

