/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.rms;

import com.sun.midp.rms.RecordStoreFile;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordEnumerationImpl;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordListener;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;
import javax.microedition.rms.RecordStoreNotOpenException;

public class RecordStore {
    private static final byte[] DB_INIT = new byte[]{109, 105, 100, 112, 45, 114, 109, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final int SIGNATURE_LENGTH = 8;
    private static final int DB_RECORD_HEADER_LENGTH = 16;
    private static final int DB_BLOCK_SIZE = 16;
    private static final int DB_COMPACTBUFFER_SIZE = 64;
    private static Vector dbCache = new Vector(3);
    private static final Object dbCacheLock = new Object();
    private String recordStoreName;
    private int opencount;
    private RecordStoreFile dbraf;
    Object rsLock;
    private Vector recordListener;
    private RecordHeaderCache recHeadCache;
    private static int CACHE_SIZE = 8;
    private static byte[] recHeadBuf = new byte[16];
    private int dbNextRecordID = 1;
    private int dbVersion;
    private int dbNumLiveRecords;
    private long dbLastModified;
    private int dbFirstRecordOffset;
    private int dbFirstFreeBlockOffset;
    private int dbDataStart = 48;
    private int dbDataEnd = 48;
    private static byte[] dbState = new byte[DB_INIT.length];
    private static final int RS_SIGNATURE = 0;
    private static final int RS_NUM_LIVE = 8;
    private static final int RS_RESERVED = 12;
    private static final int RS_VERSION = 16;
    private static final int RS_NEXT_ID = 20;
    private static final int RS_REC_START = 24;
    private static final int RS_FREE_START = 28;
    private static final int RS_LAST_MODIFIED = 32;
    private static final int RS_DATA_START = 40;
    private static final int RS_DATA_END = 44;

    private RecordStore() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RecordStore(String recordStoreName, boolean create) throws RecordStoreException, RecordStoreNotFoundException {
        this.recordStoreName = recordStoreName;
        this.recHeadCache = new RecordHeaderCache(CACHE_SIZE);
        this.rsLock = new Object();
        this.recordListener = new Vector(3);
        boolean exists = RecordStoreFile.exists(recordStoreName);
        if (!create && !exists) {
            throw new RecordStoreNotFoundException("cannot find record store file");
        }
        try {
            this.dbraf = new RecordStoreFile(recordStoreName);
            if (create && !exists) {
                this.dbraf.seek(0);
                RecordStore.putLong(System.currentTimeMillis(), DB_INIT, 32);
                RecordStore.putInt(48, DB_INIT, 40);
                RecordStore.putInt(48, DB_INIT, 44);
                this.dbraf.write(DB_INIT);
                return;
            }
            byte[] buf = new byte[DB_INIT.length];
            this.dbraf.seek(0);
            this.dbraf.read(buf);
            int i = 0;
            while (true) {
                if (i >= 8) {
                    this.dbNumLiveRecords = RecordStore.getInt(buf, 8);
                    this.dbVersion = RecordStore.getInt(buf, 16);
                    this.dbNextRecordID = RecordStore.getInt(buf, 20);
                    this.dbFirstRecordOffset = RecordStore.getInt(buf, 24);
                    this.dbFirstFreeBlockOffset = RecordStore.getInt(buf, 28);
                    this.dbLastModified = RecordStore.getLong(buf, 32);
                    this.dbDataStart = RecordStore.getInt(buf, 40);
                    this.dbDataEnd = RecordStore.getInt(buf, 44);
                    return;
                }
                if (buf[i] != DB_INIT[i]) {
                    throw new RecordStoreException("invalid record store contents");
                }
                ++i;
            }
        }
        catch (IOException ioe) {
            try {
                if (this.dbraf != null) {
                    this.dbraf.close();
                }
                this.dbraf = null;
                throw new RecordStoreException("error opening record store file");
            }
            catch (IOException ioe2) {
                this.dbraf = null;
                try {
                    throw new RecordStoreException("error opening record store file");
                }
                catch (Throwable throwable) {
                    this.dbraf = null;
                    throw throwable;
                }
            }
        }
    }

    public static RecordStore openRecordStore(String recordStoreName, boolean createIfNecessary) throws RecordStoreException, RecordStoreFullException, RecordStoreNotFoundException {
        Object object = dbCacheLock;
        synchronized (object) {
            RecordStore db;
            if (recordStoreName.length() > 32) {
                throw new RecordStoreException("record store name too long");
            }
            int n = 0;
            while (n < dbCache.size()) {
                db = (RecordStore)dbCache.elementAt(n);
                if (db.recordStoreName.equals(recordStoreName)) {
                    ++db.opencount;
                    RecordStore recordStore = db;
                    return recordStore;
                }
                ++n;
            }
            int space = RecordStoreFile.spaceAvailable();
            if (space - DB_INIT.length < 0) {
                throw new RecordStoreFullException();
            }
            db = new RecordStore(recordStoreName, createIfNecessary);
            db.opencount = 1;
            dbCache.addElement(db);
            RecordStore recordStore = db;
            return recordStore;
        }
    }

    public static String[] listRecordStores() {
        Object object = dbCacheLock;
        synchronized (object) {
            String[] returnstrings;
            String[] stringArray = returnstrings = RecordStoreFile.listRecordStores();
            return stringArray;
        }
    }

    public static void deleteRecordStore(String recordStoreName) throws RecordStoreException, RecordStoreNotFoundException {
        Object object = dbCacheLock;
        synchronized (object) {
            int n = 0;
            while (n < dbCache.size()) {
                RecordStore db = (RecordStore)dbCache.elementAt(n);
                if (db.recordStoreName.equals(recordStoreName)) {
                    throw new RecordStoreException("deleteRecordStore error: record store is still open");
                }
                ++n;
            }
            if (RecordStoreFile.exists(recordStoreName)) {
                boolean success = RecordStoreFile.deleteFile(recordStoreName);
                if (!success) {
                    throw new RecordStoreException("deleteRecordStore failed");
                }
            } else {
                throw new RecordStoreNotFoundException("deleteRecordStore error: file not found");
            }
        }
    }

    public int addRecord(byte[] data, int offset, int numBytes) throws RecordStoreNotOpenException, RecordStoreException, RecordStoreFullException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            if (data == null && numBytes > 0) {
                throw new NullPointerException("illegal arguments: null data,  numBytes > 0");
            }
            int id = this.dbNextRecordID++;
            RecordHeader rh = this.allocateNewRecordStorage(id, numBytes);
            try {
                if (data != null) {
                    rh.write(data, offset);
                }
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing new record data");
            }
            ++this.dbNumLiveRecords;
            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordAddedListeners(id);
            int n = id;
            return n;
        }
    }

    public void deleteRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            RecordHeader rh = null;
            try {
                rh = this.findRecord(recordId, false);
                this.freeRecord(rh);
                this.recHeadCache.invalidate(rh.id);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error updating file after record deletion");
            }
            --this.dbNumLiveRecords;
            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordDeletedListeners(recordId);
        }
    }

    /*
     * Exception decompiling
     */
    public void closeRecordStore() throws RecordStoreNotOpenException, RecordStoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getRecordSize(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            try {
                RecordHeader rh = this.findRecord(recordId, true);
                int n = rh.dataLenOrNextFree;
                return n;
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
        }
    }

    public int getRecord(int recordId, byte[] buffer, int offset) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            RecordHeader rh;
            this.checkOpen();
            try {
                rh = this.findRecord(recordId, true);
                rh.read(buffer, offset);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
            int n = rh.dataLenOrNextFree;
            return n;
        }
    }

    public byte[] getRecord(int recordId) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException {
        Object object = this.rsLock;
        synchronized (object) {
            this.checkOpen();
            boolean size = false;
            byte[] data = null;
            try {
                RecordHeader rh = this.findRecord(recordId, true);
                if (rh.dataLenOrNextFree == 0) {
                    byte[] byArray = null;
                    return byArray;
                }
                data = new byte[rh.dataLenOrNextFree];
                rh.read(data, 0);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error reading record data");
            }
            byte[] byArray = data;
            return byArray;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setRecord(int recordId, byte[] newData, int offset, int numBytes) throws RecordStoreNotOpenException, InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        var5_5 = this.rsLock;
        synchronized (var5_5) {
            this.checkOpen();
            if (newData == null && numBytes > 0) {
                throw new NullPointerException();
            }
            rh = null;
            newrh = null;
            try {
                rh = this.findRecord(recordId, false);
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error finding record data");
            }
            if (numBytes <= rh.blockSize - 16) {
                allocSize = this.getAllocSize(numBytes);
                if (rh.blockSize - allocSize >= 32) {
                    this.splitRecord(rh, allocSize);
                }
                rh.dataLenOrNextFree = numBytes;
                try {
                    rh.store();
                    this.recHeadCache.insert(rh);
                    if (newData == null) ** GOTO lbl35
                    rh.write(newData, offset);
                }
                catch (IOException ioe) {
                    throw new RecordStoreException("error writing record data");
                }
            } else {
                this.freeRecord(rh);
                newrh = this.allocateNewRecordStorage(recordId, numBytes);
                try {
                    if (newData != null) {
                        newrh.write(newData, offset);
                    }
                }
                catch (IOException ioe) {
                    throw new RecordStoreException("error moving record data");
                }
            }
lbl35:
            // 3 sources

            ++this.dbVersion;
            this.storeDBState();
            this.notifyRecordChangedListeners(recordId);
        }
    }

    public String getName() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.recordStoreName;
    }

    public int getVersion() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbVersion;
    }

    public int getNumRecords() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbNumLiveRecords;
    }

    public int getSize() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbDataEnd;
    }

    public int getSizeAvailable() throws RecordStoreNotOpenException {
        this.checkOpen();
        int rv = RecordStoreFile.spaceAvailable() - 16 - 16;
        return rv < 0 ? 0 : rv;
    }

    public long getLastModified() throws RecordStoreNotOpenException {
        this.checkOpen();
        return this.dbLastModified;
    }

    public void addRecordListener(RecordListener listener) {
        Object object = this.rsLock;
        synchronized (object) {
            if (!this.recordListener.contains(listener)) {
                this.recordListener.addElement(listener);
            }
        }
    }

    public void removeRecordListener(RecordListener listener) {
        Object object = this.rsLock;
        synchronized (object) {
            this.recordListener.removeElement(listener);
        }
    }

    public int getNextRecordID() throws RecordStoreNotOpenException, RecordStoreException {
        this.checkOpen();
        return this.dbNextRecordID;
    }

    public RecordEnumeration enumerateRecords(RecordFilter filter, RecordComparator comparator, boolean keepUpdated) throws RecordStoreNotOpenException {
        this.checkOpen();
        return new RecordEnumerationImpl(this, filter, comparator, keepUpdated);
    }

    private RecordHeader findRecord(int recordId, boolean addToCache) throws InvalidRecordIDException, IOException {
        int cur_offset = this.dbFirstRecordOffset;
        if (cur_offset == 0) {
            throw new InvalidRecordIDException();
        }
        RecordHeader rh = this.recHeadCache.get(recordId);
        if (rh != null) {
            return rh;
        }
        rh = new RecordHeader();
        while (cur_offset != 0) {
            rh.load(cur_offset);
            if (rh.id == recordId) break;
            cur_offset = rh.nextOffset;
        }
        if (cur_offset == 0) {
            throw new InvalidRecordIDException();
        }
        if (addToCache) {
            this.recHeadCache.insert(rh);
        }
        return rh;
    }

    private int getAllocSize(int numBytes) {
        int rv = 16 + numBytes;
        int pad = 16 - rv % 16;
        if (pad != 16) {
            rv += pad;
        }
        return rv;
    }

    private RecordHeader allocateNewRecordStorage(int id, int dataSize) throws RecordStoreException, RecordStoreFullException {
        int allocSize = this.getAllocSize(dataSize);
        boolean foundBlock = false;
        RecordHeader block = new RecordHeader();
        try {
            int offset = this.dbFirstFreeBlockOffset;
            while (offset != 0) {
                block.load(offset);
                if (block.blockSize >= allocSize) {
                    foundBlock = true;
                    break;
                }
                offset = block.dataLenOrNextFree;
            }
        }
        catch (IOException ioe) {
            throw new RecordStoreException("error finding first fit block");
        }
        if (!foundBlock) {
            if (RecordStoreFile.spaceAvailable() < allocSize) {
                throw new RecordStoreFullException();
            }
            block = new RecordHeader(this.dbDataEnd, id, this.dbFirstRecordOffset, allocSize, dataSize);
            try {
                block.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing new record data");
            }
            this.dbFirstRecordOffset = this.dbDataEnd;
            this.dbDataEnd += allocSize;
        } else {
            if (block.id != -1) {
                throw new RecordStoreException("ALLOC ERR " + block.id + " is not a free block!");
            }
            this.removeFreeBlock(block);
            block.id = id;
            if (block.blockSize - allocSize >= 32) {
                this.splitRecord(block, allocSize);
            }
            block.dataLenOrNextFree = dataSize;
            try {
                block.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("error writing free block after alloc");
            }
        }
        this.recHeadCache.insert(block);
        return block;
    }

    private void splitRecord(RecordHeader recHead, int allocSize) throws RecordStoreException {
        int extraSpace = recHead.blockSize - allocSize;
        recHead.blockSize = allocSize;
        if (recHead.offset != this.dbFirstRecordOffset) {
            int fboffset = recHead.offset + allocSize;
            RecordHeader newfb = new RecordHeader(fboffset, -1, recHead.offset, extraSpace, 0);
            try {
                this.freeRecord(newfb);
                RecordHeader prh = new RecordHeader(recHead.offset + recHead.blockSize);
                prh.nextOffset = fboffset;
                prh.store();
                this.recHeadCache.invalidate(prh.id);
                this.storeDBState();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("splitRecord error");
            }
        } else {
            this.dbDataEnd = recHead.offset + recHead.blockSize;
        }
    }

    private void freeRecord(RecordHeader rh) throws RecordStoreException {
        if (rh.offset == this.dbFirstRecordOffset) {
            this.dbFirstRecordOffset = rh.nextOffset;
            this.dbDataEnd = rh.offset;
        } else {
            rh.id = -1;
            rh.dataLenOrNextFree = this.dbFirstFreeBlockOffset;
            this.dbFirstFreeBlockOffset = rh.offset;
            try {
                rh.store();
            }
            catch (IOException ioe) {
                throw new RecordStoreException("free record failed");
            }
        }
    }

    private void removeFreeBlock(RecordHeader blockToFree) throws RecordStoreException {
        RecordHeader block = new RecordHeader();
        RecordHeader prev = new RecordHeader();
        RecordHeader tmp = null;
        try {
            int offset = this.dbFirstFreeBlockOffset;
            while (offset != 0) {
                block.load(offset);
                if (block.offset == blockToFree.offset) {
                    if (block.id != -1) {
                        throw new RecordStoreException("removeFreeBlock id is not -1");
                    }
                    if (prev.offset == 0) {
                        this.dbFirstFreeBlockOffset = block.dataLenOrNextFree;
                    } else {
                        prev.dataLenOrNextFree = block.dataLenOrNextFree;
                        prev.store();
                    }
                }
                offset = block.dataLenOrNextFree;
                tmp = prev;
                prev = block;
                block = tmp;
            }
        }
        catch (IOException ioe) {
            throw new RecordStoreException("removeFreeBlock block not found");
        }
    }

    private void storeDBState() throws RecordStoreException {
        try {
            this.dbLastModified = System.currentTimeMillis();
            RecordStore.putInt(this.dbNumLiveRecords, dbState, 8);
            RecordStore.putInt(0, dbState, 12);
            RecordStore.putInt(this.dbVersion, dbState, 16);
            RecordStore.putInt(this.dbNextRecordID, dbState, 20);
            RecordStore.putInt(this.dbFirstRecordOffset, dbState, 24);
            RecordStore.putInt(this.dbFirstFreeBlockOffset, dbState, 28);
            RecordStore.putLong(this.dbLastModified, dbState, 32);
            RecordStore.putInt(this.dbDataStart, dbState, 40);
            RecordStore.putInt(this.dbDataEnd, dbState, 44);
            this.dbraf.seek(8);
            int numbytes = DB_INIT.length - 8;
            this.dbraf.write(dbState, 8, numbytes);
        }
        catch (IOException ioe) {
            throw new RecordStoreException("error writing record store attributes");
        }
    }

    private void checkOpen() throws RecordStoreNotOpenException {
        if (this.dbraf == null) {
            throw new RecordStoreNotOpenException();
        }
    }

    private void notifyRecordChangedListeners(int recordId) {
        int i = 0;
        while (i < this.recordListener.size()) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordChanged(this, recordId);
            ++i;
        }
    }

    private void notifyRecordAddedListeners(int recordId) {
        int i = 0;
        while (i < this.recordListener.size()) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordAdded(this, recordId);
            ++i;
        }
    }

    private void notifyRecordDeletedListeners(int recordId) {
        int i = 0;
        while (i < this.recordListener.size()) {
            RecordListener rl = (RecordListener)this.recordListener.elementAt(i);
            rl.recordDeleted(this, recordId);
            ++i;
        }
    }

    static int getInt(byte[] data, int offset) {
        int r = data[offset++];
        r = r << 8 | data[offset++] & 0xFF;
        r = r << 8 | data[offset++] & 0xFF;
        r = r << 8 | data[offset++] & 0xFF;
        return r;
    }

    static long getLong(byte[] data, int offset) {
        long r = data[offset++];
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        r = r << 8 | (long)data[offset++] & 0xFFL;
        return r;
    }

    static int putInt(int i, byte[] data, int offset) {
        data[offset++] = (byte)(i >> 24 & 0xFF);
        data[offset++] = (byte)(i >> 16 & 0xFF);
        data[offset++] = (byte)(i >> 8 & 0xFF);
        data[offset] = (byte)(i & 0xFF);
        return 4;
    }

    static int putLong(long l, byte[] data, int offset) {
        data[offset++] = (byte)(l >> 56 & 0xFFL);
        data[offset++] = (byte)(l >> 48 & 0xFFL);
        data[offset++] = (byte)(l >> 40 & 0xFFL);
        data[offset++] = (byte)(l >> 32 & 0xFFL);
        data[offset++] = (byte)(l >> 24 & 0xFFL);
        data[offset++] = (byte)(l >> 16 & 0xFFL);
        data[offset++] = (byte)(l >> 8 & 0xFFL);
        data[offset] = (byte)(l & 0xFFL);
        return 8;
    }

    int[] getRecordIDs() {
        if (this.dbraf == null) {
            return null;
        }
        int index = 0;
        int[] tmp = new int[this.dbNumLiveRecords];
        int offset = this.dbFirstRecordOffset;
        RecordHeader rh = new RecordHeader();
        try {
            while (offset != 0) {
                rh.load(offset);
                if (rh.id > 0) {
                    tmp[index++] = rh.id;
                }
                offset = rh.nextOffset;
            }
        }
        catch (IOException ioe) {
            return null;
        }
        return tmp;
    }

    private void compactRecords() throws RecordStoreNotOpenException, RecordStoreException {
        int offset = this.dbDataStart;
        int target = 0;
        byte[] chunkBuffer = new byte[64];
        RecordHeader rh = new RecordHeader();
        int prevRec = 0;
        while (offset < this.dbDataEnd) {
            try {
                rh.load(offset);
            }
            catch (IOException ioe) {
                System.out.println("Unexpected IOException in CompactRS!");
            }
            if (rh.id == -1) {
                if (target == 0) {
                    target = offset;
                }
                offset += rh.blockSize;
                continue;
            }
            if (target == 0) {
                prevRec = offset;
                offset += rh.blockSize;
                continue;
            }
            int old_offset = target;
            rh.offset = target;
            rh.nextOffset = prevRec;
            try {
                rh.store();
                offset += 16;
                target += 16;
                int bytesLeft = rh.blockSize - 16;
                while (bytesLeft > 0) {
                    int numToMove = bytesLeft < 64 ? bytesLeft : 64;
                    this.dbraf.seek(offset);
                    this.dbraf.read(chunkBuffer, 0, numToMove);
                    this.dbraf.seek(target);
                    this.dbraf.write(chunkBuffer, 0, numToMove);
                    offset += numToMove;
                    target += numToMove;
                    bytesLeft -= numToMove;
                }
            }
            catch (IOException ioe) {
                System.out.println("Unexpected IOException in CompactRS!");
            }
            prevRec = old_offset;
        }
        if (rh.offset != 0) {
            this.dbDataEnd = rh.offset + rh.blockSize;
        }
        this.dbFirstRecordOffset = rh.offset;
        this.dbFirstFreeBlockOffset = 0;
        this.storeDBState();
    }

    private class RecordHeaderCache {
        private RecordHeader[] mCache;

        RecordHeaderCache(int size) {
            this.mCache = new RecordHeader[size];
        }

        RecordHeader get(int rec_id) {
            int idx = rec_id % this.mCache.length;
            RecordHeader rh = this.mCache[idx];
            if (this.mCache[idx] != null && this.mCache[idx].id != rec_id) {
                return null;
            }
            return rh;
        }

        void insert(RecordHeader rh) {
            int idx = rh.id % this.mCache.length;
            this.mCache[idx] = rh;
        }

        void invalidate(int rec_id) {
            int idx;
            if (rec_id > 0 && this.mCache[idx = rec_id % this.mCache.length] != null && this.mCache[idx].id == rec_id) {
                this.mCache[idx] = null;
            }
        }
    }

    private class RecordHeader {
        private static final int REC_ID = 0;
        private static final int NEXT_OFFSET = 4;
        private static final int BLOCK_SIZE = 8;
        private static final int DATALEN_OR_NEXTFREE = 12;
        private static final int DATA_OFFSET = 16;
        int offset;
        int id;
        int nextOffset;
        int blockSize;
        int dataLenOrNextFree;

        RecordHeader() {
        }

        RecordHeader(int _offset) throws IOException {
            this.load(_offset);
        }

        RecordHeader(int _offset, int _id, int next_offset, int size, int len_or_free) {
            this.offset = _offset;
            this.id = _id;
            this.nextOffset = next_offset;
            this.blockSize = size;
            this.dataLenOrNextFree = len_or_free;
        }

        void load(int _offset) throws IOException {
            this.offset = _offset;
            RecordStore.this.dbraf.seek(this.offset);
            RecordStore.this.dbraf.read(recHeadBuf, 0, 16);
            this.id = RecordStore.getInt(recHeadBuf, 0);
            this.nextOffset = RecordStore.getInt(recHeadBuf, 4);
            this.blockSize = RecordStore.getInt(recHeadBuf, 8);
            this.dataLenOrNextFree = RecordStore.getInt(recHeadBuf, 12);
        }

        void store() throws IOException {
            RecordStore.putInt(this.id, recHeadBuf, 0);
            RecordStore.putInt(this.nextOffset, recHeadBuf, 4);
            RecordStore.putInt(this.blockSize, recHeadBuf, 8);
            RecordStore.putInt(this.dataLenOrNextFree, recHeadBuf, 12);
            RecordStore.this.dbraf.seek(this.offset);
            RecordStore.this.dbraf.write(recHeadBuf, 0, 16);
        }

        int read(byte[] buf, int _offset) throws IOException {
            RecordStore.this.dbraf.seek(this.offset + 16);
            return RecordStore.this.dbraf.read(buf, _offset, this.dataLenOrNextFree);
        }

        void write(byte[] buf, int _offset) throws IOException {
            RecordStore.this.dbraf.seek(this.offset + 16);
            RecordStore.this.dbraf.write(buf, _offset, this.dataLenOrNextFree);
        }
    }
}

