/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Policy;

class TextPolicy
extends Policy {
    private int[] lineBreaks = new int[4];
    private int numLines;
    private int curLine = 0;

    TextPolicy(Font f) {
        super(f);
    }

    int moveCursor(int dir, int curPos, char[] buf, int numChars) {
        switch (dir) {
            case 1: 
            case 6: {
                int x = this.cursorX;
                this.curLine += dir == 1 ? -1 : 1;
                int t = this.numLines - 1;
                if (this.curLine < 0) {
                    this.curLine = 0;
                }
                if (this.curLine > t) {
                    this.curLine = t;
                }
                curPos = this.curLine == 0 ? 0 : this.lineBreaks[this.curLine - 1];
                int fc = curPos;
                while (x > 0 && curPos < this.lineBreaks[this.curLine]) {
                    int w;
                    if ((w = this.f.charWidth(buf[curPos++])) - x > x) break;
                    x -= w;
                }
                if (curPos > fc && curPos == this.lineBreaks[this.curLine] && curPos < numChars) {
                    --curPos;
                }
                this.cursorX = this.f.charsWidth(buf, fc, curPos - fc);
                this.cursorY = this.curLine * this.lineHeight;
                break;
            }
            case 2: {
                if (curPos <= 0) break;
                if (this.curLine > 0 && curPos == this.lineBreaks[this.curLine - 1]) {
                    --this.curLine;
                    int fc = this.curLine == 0 ? 0 : this.lineBreaks[this.curLine - 1];
                    this.cursorY -= this.lineHeight;
                    this.cursorX = this.f.charsWidth(buf, fc, curPos - 1 - fc);
                } else {
                    this.cursorX -= this.f.charWidth(buf[curPos - 1]);
                }
                --curPos;
                break;
            }
            case 5: {
                if (curPos >= numChars) break;
                if (this.curLine < this.numLines - 1 && curPos + 1 == this.lineBreaks[this.curLine]) {
                    ++this.curLine;
                    this.cursorY += this.lineHeight;
                    this.cursorX = 0;
                } else {
                    this.cursorX += this.f.charWidth(buf[curPos]);
                }
                ++curPos;
            }
        }
        return curPos;
    }

    void paint(Graphics g, char[] buf, int numChars, boolean cursorEnabled, int cursorPos, boolean noCharShow) {
        int y = g.getClipY();
        int yEnd = y + g.getClipHeight();
        int from = 0;
        int prev = 0;
        if (y > 0) {
            from = y / this.lineHeight;
            y = from * this.lineHeight;
            if (from > 0) {
                prev = this.lineBreaks[from - 1];
            }
        } else {
            y = 0;
        }
        g.setColor(0);
        g.setFont(this.f);
        int i = from;
        while (i < this.numLines && y <= yEnd) {
            int n = this.lineBreaks[i] - prev;
            if (buf[this.lineBreaks[i] - 1] == '\n') {
                --n;
            }
            if (n > 0) {
                g.drawChars(buf, prev, n, 0, y, 20);
            }
            y += this.lineHeight;
            prev = this.lineBreaks[i];
            ++i;
        }
        if (cursorEnabled) {
            g.drawLine(this.cursorX, this.cursorY, this.cursorX, this.cursorY + this.lineHeight);
        }
    }

    void addBreak(int spot) {
        if (this.numLines == this.lineBreaks.length) {
            int[] newBreaks = new int[this.lineBreaks.length + 4];
            System.arraycopy(this.lineBreaks, 0, newBreaks, 0, this.lineBreaks.length);
            this.lineBreaks = newBreaks;
        }
        this.lineBreaks[this.numLines] = spot;
    }

    int contentChanged(char[] buf, int numChars, int startChar, int cursorPos) {
        if (this.width == -1) {
            return 0;
        }
        int oldHeight = this.height;
        if (startChar <= 0 || this.numLines <= 0) {
            startChar = 0;
            this.numLines = 0;
        } else {
            int i = 0;
            while (i < this.numLines) {
                if (this.lineBreaks[i] > startChar) {
                    this.numLines = i;
                    break;
                }
                ++i;
            }
            if (this.numLines > 0) {
                --this.numLines;
            }
            startChar = this.numLines == 0 ? 0 : this.lineBreaks[this.numLines - 1];
        }
        int length = 0;
        int spaceIndex = 0;
        int wordWidth = 0;
        int i = startChar;
        while (i < numChars) {
            int charWidth = this.f.charWidth(buf[i]);
            if (buf[i] == '\n') {
                this.addBreak(i + 1);
                ++this.numLines;
                wordWidth = 0;
                length = 0;
            } else {
                if (buf[i] == ' ') {
                    spaceIndex = i;
                    wordWidth = 0;
                } else {
                    wordWidth += charWidth;
                }
                if ((length += charWidth) > this.width) {
                    if (spaceIndex == 0) {
                        this.addBreak(i);
                        length = charWidth;
                    } else {
                        this.addBreak(spaceIndex + 1);
                        int n = length = i == spaceIndex ? 0 : wordWidth;
                        if (cursorPos >= spaceIndex + 1) {
                            this.curLine = this.numLines + 1;
                            this.cursorX = 0;
                        }
                    }
                    ++this.numLines;
                    spaceIndex = 0;
                }
                if (cursorPos == i) {
                    this.curLine = this.numLines;
                    this.cursorX = length == 0 ? 0 : length - charWidth;
                }
            }
            ++i;
        }
        if (cursorPos == numChars) {
            this.curLine = this.numLines;
            this.cursorX = length;
        }
        this.cursorY = this.lineHeight * this.curLine;
        this.addBreak(numChars);
        if (numChars > 0) {
            ++this.numLines;
        }
        this.height = this.numLines * this.lineHeight;
        if (this.height < this.lineHeight) {
            this.height = this.lineHeight;
        }
        return this.height - oldHeight;
    }
}

