/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;

    protected Canvas() {
    }

    public int getWidth() {
        return Display.WIDTH;
    }

    public int getHeight() {
        return Display.HEIGHT;
    }

    public boolean isDoubleBuffered() {
        return Display.IS_DOUBLE_BUFFERED;
    }

    public boolean hasPointerEvents() {
        return Display.POINTER_SUPPORTED;
    }

    public boolean hasPointerMotionEvents() {
        return Display.MOTION_SUPPORTED;
    }

    public boolean hasRepeatEvents() {
        return Display.REPEAT_SUPPORTED;
    }

    public int getKeyCode(int gameAction) {
        int n = Display.getKeyCode(gameAction);
        if (n == 0) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    public String getKeyName(int keyCode) {
        String s = Display.getKeyName(keyCode);
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s;
    }

    public int getGameAction(int keyCode) {
        int n = Display.getGameAction(keyCode);
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        return n;
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    public final void repaint(int x, int y, int width, int height) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.repaint(x, y, width, height);
        }
    }

    public final void repaint() {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.repaint();
        }
    }

    public final void serviceRepaints() {
        Display d = this.currentDisplay;
        if (d != null) {
            d.serviceRepaints();
        }
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected abstract void paint(Graphics var1);
}

