/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.TimerTask;

class TaskQueue {
    private TimerTask[] queue = new TimerTask[4];
    private int size = 0;

    TaskQueue() {
    }

    void add(TimerTask task) {
        if (++this.size == this.queue.length) {
            TimerTask[] newQueue = new TimerTask[2 * this.queue.length];
            System.arraycopy(this.queue, 0, newQueue, 0, this.size);
            this.queue = newQueue;
        }
        this.queue[this.size] = task;
        this.fixUp(this.size);
    }

    TimerTask getMin() {
        return this.queue[1];
    }

    void removeMin() {
        this.queue[1] = this.queue[this.size];
        this.queue[this.size--] = null;
        this.fixDown(1);
    }

    void rescheduleMin(long newTime) {
        this.queue[1].nextExecutionTime = newTime;
        this.fixDown(1);
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        int i = 1;
        while (i <= this.size) {
            this.queue[i] = null;
            ++i;
        }
        this.size = 0;
    }

    private void fixUp(int k) {
        while (k > 1) {
            int j = k >> 1;
            if (this.queue[j].nextExecutionTime <= this.queue[k].nextExecutionTime) break;
            TimerTask tmp = this.queue[j];
            this.queue[j] = this.queue[k];
            this.queue[k] = tmp;
            k = j;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void fixDown(int k) {
        int j;
        while ((j = k << 1) <= this.size) {
            void var2_2;
            if (var2_2 < this.size && this.queue[var2_2].nextExecutionTime > this.queue[var2_2 + true].nextExecutionTime) {
                ++var2_2;
            }
            if (this.queue[k].nextExecutionTime <= this.queue[var2_2].nextExecutionTime) break;
            TimerTask tmp = this.queue[var2_2];
            this.queue[var2_2] = this.queue[k];
            this.queue[k] = tmp;
            k = var2_2;
        }
    }
}

