--[[--
request.add_error_handler(
  function(errobj, stacktrace)
    ...
  end
)

Registers a function to be called after an error occurred during request handling and the error response has been prepared by filling the "trace" and "system_error" slots in request.handler(...). The registered handler may, for example, send an error report to an administrator (utilizing slot.render_layout(...)). The passed handler function gets the error message (or error object) passed as first argument and the stacktrace as second argument.

--]]--

function request.add_error_handler(func)
  request.configure(function()
    local handlers = request._error_handlers
    handlers[#handlers+1] = func
  end)
end
