/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.maven.resolver;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.repository.internal.DefaultArtifactDescriptorReader;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.jfrog.build.extractor.maven.BuildInfoRecorder;
import org.jfrog.build.extractor.maven.resolver.ArtifactorySonatypeArtifactResolver;
import org.jfrog.build.extractor.maven.resolver.ArtifactorySonatypeMetadataResolver;
import org.jfrog.build.extractor.maven.resolver.ResolutionHelper;
import org.sonatype.aether.AbstractRepositoryListener;
import org.sonatype.aether.RepositoryEvent;
import org.sonatype.aether.RepositoryListener;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.impl.ArtifactResolver;
import org.sonatype.aether.impl.MetadataResolver;
import org.sonatype.aether.impl.internal.DefaultRepositorySystem;
import org.sonatype.aether.metadata.Metadata;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.ArtifactRequest;

@Component(role=RepositoryListener.class)
public class ArtifactorySonatypeRepositoryListener
extends AbstractRepositoryListener
implements Contextualizable {
    @Requirement
    private Logger logger;
    @Requirement
    private ResolutionHelper resolutionHelper;
    @Requirement
    private DefaultArtifactDescriptorReader descriptorReader;
    @Requirement
    private DefaultRepositorySystem repositorySystem;
    @Requirement
    private ArtifactResolver artifactoryArtifactResolver;
    @Requirement
    private MetadataResolver artifactoryMetadataResolver;
    BuildInfoRecorder buildInfoRecorder = null;
    private PlexusContainer plexusContainer;
    Boolean artifactoryRepositoriesEnforced = false;
    private ArtifactorySonatypeArtifactResolver artifactResolver = null;
    private ArtifactorySonatypeMetadataResolver metadataResolver = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceArtifactoryResolver() throws ComponentLookupException, InvocationTargetException, IllegalAccessException {
        Method[] methods;
        this.logger.debug("Enforcing Artifactory artifact resolver");
        this.artifactResolver = (ArtifactorySonatypeArtifactResolver)this.artifactoryArtifactResolver;
        this.metadataResolver = (ArtifactorySonatypeMetadataResolver)this.artifactoryMetadataResolver;
        this.repositorySystem.setArtifactResolver((ArtifactResolver)this.artifactResolver);
        this.repositorySystem.setMetadataResolver(this.artifactoryMetadataResolver);
        Method setArtifactResolverMethod = null;
        for (Method method : methods = DefaultArtifactDescriptorReader.class.getDeclaredMethods()) {
            if (!"setArtifactResolver".equals(method.getName())) continue;
            setArtifactResolverMethod = method;
            break;
        }
        if (setArtifactResolverMethod == null) {
            throw new RuntimeException("Failed to enforce Artifactory resolver. Method DefaultArtifactDescriptorReader.setArtifactResolver does not exist");
        }
        setArtifactResolverMethod.invoke((Object)this.descriptorReader, new Object[]{this.artifactResolver});
        Boolean bl = this.artifactoryRepositoriesEnforced = Boolean.valueOf(true);
        synchronized (bl) {
            this.artifactoryRepositoriesEnforced.notifyAll();
        }
    }

    private BuildInfoRecorder getBuildInfoRecorder() {
        if (this.buildInfoRecorder == null) {
            try {
                this.buildInfoRecorder = (BuildInfoRecorder)this.plexusContainer.lookup(BuildInfoRecorder.class.getName());
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed while trying to fetch BuildInfoRecorder from the container in " + ((Object)((Object)this)).getClass().getName(), (Throwable)e);
            }
            if (this.buildInfoRecorder == null) {
                this.logger.error("Could not fetch BuildInfoRecorder from the container in " + ((Object)((Object)this)).getClass().getName() + ". Artifacts resolution cannot be recorded.");
            }
        }
        return this.buildInfoRecorder;
    }

    public void metadataDownloading(RepositoryEvent event) {
        this.verifyArtifactoryResolutionEnforced(event);
    }

    public void artifactDownloading(RepositoryEvent event) {
        this.verifyArtifactoryResolutionEnforced(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyArtifactoryResolutionEnforced(RepositoryEvent event) {
        boolean snapshot;
        RemoteRepository artifactoryReleaseRepo;
        RemoteRepository artifactorySnapshotRepo;
        this.initResolutionHelper(event.getSession());
        if (!this.resolutionHelper.resolutionRepositoriesConfigured()) {
            return;
        }
        if (event.getArtifact() == null && event.getMetadata() == null) {
            return;
        }
        if (!(event.getRepository() instanceof RemoteRepository)) {
            return;
        }
        RemoteRepository repo = (RemoteRepository)event.getRepository();
        if (!this.artifactoryRepositoriesEnforced.booleanValue()) {
            Boolean bl = this.artifactoryRepositoriesEnforced;
            synchronized (bl) {
                if (!this.artifactoryRepositoriesEnforced.booleanValue()) {
                    try {
                        this.artifactoryRepositoriesEnforced.wait();
                    }
                    catch (InterruptedException e) {
                        this.logger.error("Failed while waiting for Artifactory repositories enforcement", (Throwable)e);
                    }
                }
            }
        }
        this.artifactResolver.initResolutionRepositories(event.getSession());
        if (event.getArtifact() != null) {
            artifactorySnapshotRepo = this.artifactResolver.getSnapshotRepository(event.getSession());
            artifactoryReleaseRepo = this.artifactResolver.getReleaseRepository(event.getSession());
            snapshot = event.getArtifact().isSnapshot();
        } else {
            artifactorySnapshotRepo = this.metadataResolver.getSnapshotRepository(event.getSession());
            artifactoryReleaseRepo = this.metadataResolver.getReleaseRepository(event.getSession());
            snapshot = event.getMetadata().getNature() == Metadata.Nature.SNAPSHOT;
        }
        try {
            if (snapshot && !repo.getUrl().equals(artifactorySnapshotRepo.getUrl())) {
                this.logger.debug("Replacing resolution repository URL: " + repo + " with: " + artifactorySnapshotRepo.getUrl());
                this.copyRepositoryFields(artifactorySnapshotRepo, repo);
                this.setRepositoryPolicy(repo);
            } else if (!snapshot && !repo.getUrl().equals(artifactoryReleaseRepo.getUrl())) {
                this.logger.debug("Replacing resolution repository URL: " + repo + " with: " + artifactoryReleaseRepo.getUrl());
                this.copyRepositoryFields(artifactoryReleaseRepo, repo);
                this.setRepositoryPolicy(repo);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed while replacing resolution repository URL", (Throwable)e);
        }
    }

    private void initResolutionHelper(RepositorySystemSession session) {
        if (this.resolutionHelper.isInitialized()) {
            return;
        }
        Properties allMavenProps = new Properties();
        allMavenProps.putAll((Map<?, ?>)session.getSystemProperties());
        allMavenProps.putAll((Map<?, ?>)session.getUserProperties());
        this.resolutionHelper.init(allMavenProps);
    }

    private void copyRepositoryFields(RemoteRepository fromRepo, RemoteRepository toRepo) throws IllegalAccessException, NoSuchFieldException {
        Field url = RemoteRepository.class.getDeclaredField("url");
        url.setAccessible(true);
        url.set(toRepo, fromRepo.getUrl());
        if (fromRepo.getAuthentication() != null) {
            Field authentication = RemoteRepository.class.getDeclaredField("authentication");
            authentication.setAccessible(true);
            authentication.set(toRepo, fromRepo.getAuthentication());
        }
        if (fromRepo.getProxy() != null) {
            Field proxy = RemoteRepository.class.getDeclaredField("proxy");
            proxy.setAccessible(true);
            proxy.set(toRepo, fromRepo.getProxy());
        }
    }

    private void setRepositoryPolicy(RemoteRepository repo) throws NoSuchFieldException, IllegalAccessException {
        RepositoryPolicy policy = new RepositoryPolicy(true, "daily", "warn");
        Field releasePolicyField = RemoteRepository.class.getDeclaredField("releasePolicy");
        Field snapshotPolicyField = RemoteRepository.class.getDeclaredField("snapshotPolicy");
        releasePolicyField.setAccessible(true);
        snapshotPolicyField.setAccessible(true);
        releasePolicyField.set(repo, policy);
        snapshotPolicyField.set(repo, policy);
    }

    public void artifactResolved(RepositoryEvent event) {
        String requestContext = ((ArtifactRequest)event.getTrace().getData()).getRequestContext();
        String scope = this.resolutionHelper.getScopeByRequestContext(requestContext);
        org.apache.maven.artifact.Artifact artifact = this.toMavenArtifact(event.getArtifact(), scope);
        if (event.getRepository() != null) {
            this.logger.debug("[buildinfo] Resolved artifact: " + artifact + " from: " + event.getRepository() + " Context is: " + requestContext);
            if (this.getBuildInfoRecorder() != null) {
                this.getBuildInfoRecorder().artifactResolved(artifact);
            }
        } else {
            this.logger.debug("[buildinfo] Could not resolve artifact: " + artifact);
        }
        super.artifactResolved(event);
    }

    private org.apache.maven.artifact.Artifact toMavenArtifact(Artifact art, String scope) {
        if (art == null) {
            return null;
        }
        String classifier = art.getClassifier();
        classifier = classifier == null ? "" : classifier;
        DefaultArtifact artifact = new DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getVersion(), scope, art.getExtension(), classifier, null);
        artifact.setFile(art.getFile());
        return artifact;
    }

    public void contextualize(Context context) throws ContextException {
        this.plexusContainer = (PlexusContainer)context.get((Object)"plexus");
        try {
            this.enforceArtifactoryResolver();
        }
        catch (Exception e) {
            this.logger.error("Failed while enforcing Artifactory artifact resolver", (Throwable)e);
        }
    }
}

