#
# Undo... not do...
#
# $Id: undo.tcl,v 1.3 2011/02/14 02:10:28 rader Exp $
#


###############################################################################

proc StartUndo { } {
  global task_id cur_task_cmd win_start win_cur debug
  global pre_undo_display_mode pre_undo_task_cmd pre_undo_win_cur pre_undo_win_start
  global display_mode task_undo

  set FD [open "|$task_undo n"]
  while { [gets $FD l] >= 0 } { set last $l }
  catch { close $FD }
  regsub -all {\x1b.*?m} $last "" last
  if { $last == "There are no recorded transactions to undo." } {
    Feedback "task undo ... there are no recorded transactions to undo"
    return
  }

  if { $debug } { puts "ExecUndo..." }
  set pre_undo_display_mode $display_mode
  set pre_undo_task_cmd $cur_task_cmd
  set pre_undo_win_start $win_start
  set pre_undo_win_cur $win_cur
  set display_mode "undo"
  Refresh "new-report"
}

###############################################################################

proc ExecUndo { } {
  global task_undo task_id cur_task_cmd win_start win_cur debug
  global pre_undo_display_mode pre_undo_task_cmd pre_undo_win_cur pre_undo_win_start
  global display_mode

  set FD [open "|$task_undo y"]
  while { [gets $FD l] >= 0 } { set last $l }
  catch { close $FD }
  if { $last == "Undo complete." || [regexp {Modified task reverted.} $last] } {
    Feedback "task undo ... modification reverted ... undo complete"
  } else {
    Feedback "task undo ... modification failed ... $last"
  }

  set display_mode $pre_undo_display_mode
  set cur_task_cmd $pre_undo_task_cmd
  set win_start $pre_undo_win_start
  set win_cur $pre_undo_win_cur
  Refresh "new-report"
}

