/*
* This code is released under the GNU General Public License.  See COPYING for 
* details.  Copyright 2003 John Spray: spray_john@users.sourceforge.net
*/

#include <stdlib.h>
#include <string>
using namespace std;
#include <physfs.h>

#include "Mesh.h"

Mesh::Mesh()
{
	geom=NULL;
	filename[0]=0;
	skinname[0]=0;
	vert_count=0;
	gl_array_id=-1;
	visual=NULL;
}

Mesh::~Mesh()
{
	if(geom)
		free(geom);
}

void Mesh::Draw()
{
	if(!visual){
					printf("Mesh::Draw: visual==NULL!\n");
					return;
	}

	visual->UseTexture(skinname);
	glInterleavedArrays(GL_T2F_C4F_N3F_V3F,0,geom);
	glDrawArrays(GL_TRIANGLES,0,vert_count);
}

int Mesh::Load(char* meshfile)
{
	PHYSFS_file* filehandle=NULL;
	char *wholefile;
	int filelength;
	int vertindex;

	string sourcetext;
	string lhs;
	string rhs;
	string curline;

	//open the file
	filehandle=PHYSFS_openRead(meshfile);

	if(!filehandle){
		printf("Mesh::Load: Can't open file %s\n",meshfile);
		printf("Mesh::Load: PHYSFS says: %s\n",PHYSFS_getLastError());
		return 1;
	}

	//how long is it (bytes)?
	filelength=PHYSFS_fileLength(filehandle);
	
	//allocate storage for whole file
	wholefile=(char*)malloc(filelength+1);

	//dump out of file, into char*
	filelength=PHYSFS_read(filehandle,wholefile,1,filelength);
	wholefile[filelength]='\0';

	//transfer that into a C++ string
	sourcetext=wholefile;

	//we're done with the C string
	free((void*)wholefile);

	//and we're done with the file
	if(!PHYSFS_close(filehandle))
		printf("Mesh::Load: PHYSFS_close failed with error %s\n",PHYSFS_getLastError());



	//Get the header line
	curline=sourcetext.substr(0,sourcetext.find("\n",0)); 
	sourcetext.erase(0,sourcetext.find("\n",0)+1);
	//Do something with it?

	//Count the vertex lines
	vert_count=0;
	for(unsigned int i=0;i<sourcetext.size();i++)
					if(sourcetext.c_str()[i]=='V'&&sourcetext.c_str()[i-1]=='\n')
									vert_count++;

	//malloc for geom vert_count*GL_T2F_C4F_N3F_V3F
	geom=(float*)malloc ( vert_count*(2+4+3+3)*sizeof(GLfloat) );
	for(int i=0;i<vert_count*12;i++)
					geom[i]=666.0f;

	vertindex=0;
	while(sourcetext.find("\n",0)!=string::npos){
		//grab up to the next newline
		curline=sourcetext.substr(0,sourcetext.find("\n",0)); 
		//scrub up to and including the newline
		sourcetext.erase(0,sourcetext.find("\n",0)+1);
	
		//empty lines, comment lines
		if(curline.size() == 0 || curline.substr(0,1)=="#")
			continue;

		if(curline.find("V",0)==0){
			//Read vertex line
			if(vertindex+1>vert_count)
				printf("Mesh::Load: found too many vertices!\n");
			sscanf(curline.c_str(),"V%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f;",
						&geom[vertindex*12+0],
						&geom[vertindex*12+1],
						&geom[vertindex*12+2],
						&geom[vertindex*12+3],
						&geom[vertindex*12+4],
						&geom[vertindex*12+5],
						&geom[vertindex*12+6],
						&geom[vertindex*12+7],
						&geom[vertindex*12+8],
						&geom[vertindex*12+9],
						&geom[vertindex*12+10],
						&geom[vertindex*12+11]
						);
			vertindex++;
		}
		else if(curline.find("T",0)==0){
			sscanf(curline.c_str(),"T%s ;",skinname);
		}
	}

	strcpy(filename,meshfile);

	visual->LoadTexture(skinname);

	return 0;
}

