/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "common.h"
#include "shared.h"

/* Runtime config data */
rc_data_t rc_data;

/* Global widgets */
GtkWidget
  *scope,
  *waterfall;

/* Scope signal display */
gint
  scope_width,
  scope_height;

/* Waterfall window pixbuf */
GdkPixbuf *wfall_pixbuf = NULL;
guchar *wfall_pixels;
gint
  wfall_rowstride,
  wfall_n_channels,
  wfall_width,
  wfall_height;

/* Pixel buffer */
guchar *pixel_buf;

int
  sat_type,   /* Weather satellite type number   */
  sync_ref,   /* Required position of sync train */
  sync_err,   /* Deviation from sync reference   */
  duration,   /* Processing duration */
  line_index; /* Index to signal samples buffer   */

/* List of required sync position references */
int sync_refs[] = { SYNC_REFS };

/* Signal/DSP samples buffer */
short line_buffer[BLOCK_BUFFER_SIZE];

GtkWidget
  *main_window   = NULL, /* xwxapt's top window   */
  *text_scroller = NULL, /* Text view scroller    */
  *level_pbar    = NULL, /* Signal level prog bar */
  *sync_pbar     = NULL, /* Sync level prog. bar  */
  *status_table  = NULL, /* Status widgets' table */
  *sync_icon     = NULL, /* Sync status indicator */
  *apt_image     = NULL; /* Image to be displayed */

GtkBuilder
  *timer_dialog_builder = NULL,
  *startstop_builder    = NULL,
  *main_window_builder  = NULL,
  *popup_menu_builder   = NULL;

/* Text buffer for text view */
GtkTextBuffer *text_buffer = NULL;

/* Pixel buffer for display */
GdkPixbuf *image_pixbuf = NULL;

/* Pixbuf rowstride and num of channels */
gint rowstride, n_channels;

/* Satellite type names */
char *sat_names[] = { SAT_NAMES };

char
  samples_file[MAX_FILE_NAME], /* Samples file name */
  image_file  [MAX_FILE_NAME]; /* Image files name  */

/* Pointer to samples file */
FILE *samples_fp = NULL;

/* Buffer for reading in DSP data */
short *snd_buffer = NULL;

/* Index for this buffer  */
guint snd_buf_idx;

/* dsp sampling rate error*/
int dsp_rate_err;

/* Common between callbacks.c and callback_func.c */
GtkWidget
  *quit_dialog  = NULL,
  *error_dialog = NULL,
  *popup_menu   = NULL,
  *filechooser  = NULL,
  *timer_dialog = NULL,
  *startstop_timer = NULL;

/* Tag to wake-up timeout function */
guint cancel_timer_tag;

/* IFFT data buffer*/
int16_t
  *ifft_data = NULL,
  ifft_data_length = 0;

/* Chebyshev filter data I/Q */
filter_data_t filter_data_i;
filter_data_t filter_data_q;

/* Playback control semaphore */
sem_t pback_semaphore;

/*------------------------------------------------------------------------*/

