/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

int sfvReadFile(pure_sfv_params* params, char* sfvname, crc_info_type* sfv_info)
{
    crc_info_item_type item;
    FILE               *fd;
    char               buf[512];
    char               *end, crc[9];
    int                len, i;

    sfvInfoInit(sfv_info);

    fd = fopen(sfvname, "r");
    if (fd == NULL) {
        fprintf(stderr, "sfv: %s: %s\n", sfvname, strerror(errno));
        return ERROR_FILE_ACCESS;
    }
    strncpy(sfv_info->name, sfvname, MAX_STRING_LEN);

    while (fgets(buf, 512, fd)) {
        /* comment in the sfv file ignore */
        if (buf[0] == ';') {
            /* Read File size if any */

        } else { 
        if (buf[0] != ';' && buf[0] != '\n' && buf[0] != '\r') {
            /* build filename and crc from the sfv file */
            end = strrchr(buf, ' ');
            if (end == NULL) {
                fprintf(stderr, "sfv: %s: incorrect sfv file format\n", sfvname);
                return ERROR_FILE_FORMAT;
            }
            *end = '\0';
            *(end + 9) = '\0';
            strncpy(crc, ++end, 9);
            sfvInfoItemNULL(&item);
            strncpy(item.file_name, buf, MAX_STRING_LEN);
            len = strlen(item.file_name);
            /* some sfv file contatins file names in quotes. */
            if (item.file_name[0] == '\"') {
                for(i = 0; i < len; i++) {
                    item.file_name[i] =  item.file_name[i + 1];
                }
                len --;
            }
            if (item.file_name[len - 1] == '\"') {
                item.file_name[len - 1] = '\0';
            }

            item.crc = strtoul(crc, '\0', 16);
            if (sfvInfoAdd(sfv_info, &item)) {
                return ERROR_MEMORY;
            }
        }
        }
    }
    fclose(fd);

    DBUG_PRINT("sfvReadFile", ("items in file %i", sfv_info->len));

    return 0;
}

/* EOF */
