/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

void set_rc(int *rc, int new_rc)
{
    if ((*rc == EXIT_NO_PROBLEMS) ||
        (*rc > new_rc)) {
        *rc = new_rc;
    }
}

void sfvPrintLogo(char* msg) 
{
      printf("pure-sfv v%s   http://pure-sfv.sourceforge.net,  %s\n", 
             PURE_SFV_VERSION, msg);
}

int reportTotal(int functions_rc, pure_sfv_params* params)
{
    int pure_sfv_return = 0;
    int atr;
    int i;
    debugParams(params);
    set_rc(&pure_sfv_return, functions_rc);
    switch (params->mode)
    {
        case MODE_COUNT:
        case MODE_TEST:
                    if (params->recurse_subdirectories) {
                        if (params->cnt.sfv_tested == 0) {
                            printf("SFV file for tests not found anywhere down this path ...\n");
                        }
                    } else {
                        if ((params->cnt.sfv_tested == 0) && (params->sfv_files.names_cnt == 0)) {
                            printf("SFV file for tests not found in this directory ...\n");
                        } else {
                            /* Report untested SFV */
                            if (params->sfv_files.names_cnt != 0) {
                                for(i = 0 ; i < params->sfv_files.len; i++) {
                                    atr = params->sfv_files.attr[i];
                                    DBUG_PRINT("report", ("[%i] atr [%i]", i, atr));
                                    if ((attr_base(atr) == PARAM_NAME) &&
                                        (!attr_is_set(atr, PARAM_NAME_FOUND))) {
                                          printf("SFV file [%s] not found \n", params->sfv_files.strs[i]);
                                          set_rc(&pure_sfv_return, EXIT_SFV_NOT_FOUND);
                                    }
                                }
                            }
                        }
                    }
                    /* Report untested Files */
                    if (params->files.names_cnt != 0) {
                        for(i = 0 ; i < params->files.len; i++) {
                            atr = params->files.attr[i];
                            DBUG_PRINT("report", ("[%i] atr [%i]", i, atr));
                            if ((attr_base(atr) == PARAM_NAME) &&
                                (!attr_is_set(atr, PARAM_NAME_FOUND))) {
                                  printf("SFV file has not been found to verify [%s]\n", params->files.strs[i]);
                                  set_rc(&pure_sfv_return, EXIT_FILE_NOT_FOUND);
                            }
                        }
                    }
                    if (params->cnt.files_not_found) {
                        set_rc(&pure_sfv_return, EXIT_TESTED_OK_MISSING);
                    }
                    if (params->cnt.files_broken) {
                        set_rc(&pure_sfv_return, EXIT_TESTED_DIFFERENT);
                    }
                    if ((params->cnt.files_broken) && (params->cnt.files_not_found)) {
                        set_rc(&pure_sfv_return, EXIT_TESTED_DIFFERENT_MISSING);
                    }
                    break;
         case MODE_CREATE:
                    if (params->files.names_cnt != 0) {
                        for(i = 0 ; i < params->files.len; i++) {
                            atr = params->files.attr[i];
                            DBUG_PRINT("report", ("[%i] atr [%i]", i, atr));
                            if ((attr_base(atr) == PARAM_NAME) &&
                                (!attr_is_set(atr, PARAM_NAME_FOUND))) {
                                  printf("File not found [%s]\n", params->files.strs[i]);
                                  set_rc(&pure_sfv_return, EXIT_FILE_NOT_FOUND);
                            }
                        }
                    }
                    break;
         default:
                    break;
    }

    if (params->cnt.directories_scaned > 1) {
        if (!params->quiet) { printf("Scaned %i directories\n", params->cnt.directories_scaned); }
    }

    if ((params->cnt.sfv_tested > 1) || (params->cnt.sfv_created > 1)) {
        if (!params->quiet) { printf("--Totals--\n"); }
    }

    if ((params->cnt.sfv_tested > 1) && (params->list_files == 0)) {
        printf("Tested %i SFV files\n", params->cnt.sfv_tested);
        printf("  Tested     %4i files\n", params->cnt.files_tested);
        printf("  Ignored    %4i files\n", params->cnt.files_ignored);
        printf("  Successful %4i files\n", params->cnt.files_ok);
        printf("  Different  %4i files\n", params->cnt.files_broken);
        printf("  Read error %4i files\n", params->cnt.files_error);
        printf("  Missing    %4i files\n", params->cnt.files_not_found);
    }
    if (params->cnt.sfv_created > 1) {
        printf("Created %i SFV files\n", params->cnt.sfv_created);
        printf("  Added %i files\n", params->cnt.files_added);
    }

   if (functions_rc) {
        /* Some fatel error happened */
        pure_sfv_return = functions_rc;
    }

    return pure_sfv_return;
}

int sfvProcess(pure_sfv_params* params)
{
    int rc = 0;
    if (params->mode == MODE_DEFAULT) {
        params->mode = MODE_TEST;
    }
    debugParams(params);
    switch (params->mode)
    {
        case MODE_COUNT:
        case MODE_TEST:
                    sfvPrintLogo("Testing");
                    if (params->recurse_subdirectories) {
                        rc = sfvTestInDirRecursive(params, params->sfv_dir);
                    } else {
                        rc = sfvTestInDir(params, params->sfv_dir);
                    }
                    break;
        case MODE_CREATE:
                    sfvPrintLogo("Creating");
                    rc = sfvCreateRecursive(params, params->sfv_dir);
                    if (params->cnt.sfv_created == 0) {
                        printf("Nothing has been created ...\n");
                    }
                    break;
        default:
                    fprintf(stderr, "Mode not implemented ...\n");
                    rc = 1;
    }
    rc = reportTotal(rc, params);
#ifndef __unix
    if (params->windows_pause) {
        printf( "Press any key to continue\n" );
        getchar();
    }
#endif
    return rc;
}

/* EOF */
