/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.ui.commandline;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.RiskAdapter;
import net.yura.domination.engine.RiskUIUtil;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.translation.TranslationBundle;

public class CommandText
extends Thread {
    private static final String version = "2";
    private Risk risk;
    private BufferedReader br;
    private boolean IgnoreNext;

    CommandText(Risk r) {
        this.risk = r;
        this.risk.addRiskListener(new RiskAdapter(){

            public void sendMessage(String output, boolean redrawNeeded, boolean repaintNeeded) {
                if (CommandText.this.IgnoreNext) {
                    CommandText.this.IgnoreNext = false;
                } else {
                    System.out.print(output + "\n");
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void needInput(int s) {
                CommandText commandText = CommandText.this;
                synchronized (commandText) {
                    CommandText.this.notify();
                }
            }

            public void noInput() {
            }
        });
        InputStreamReader in = new InputStreamReader(System.in);
        this.br = new BufferedReader(in);
        System.out.print("Welcome to Command Line Risk!\n");
        this.start();
    }

    public static void Help() {
        String commands = "";
        try {
            FileReader filein = new FileReader("commands.txt");
            BufferedReader bufferin = new BufferedReader(filein);
            String input = bufferin.readLine();
            System.out.print("Commands:\n");
            while (input != null) {
                System.out.print(input + "\n");
                input = bufferin.readLine();
            }
            bufferin.close();
        }
        catch (FileNotFoundException e) {
            System.out.print("Unable to find file commands.txt\n");
        }
        catch (IOException e) {
            System.out.print("Unable to read file commands.txt\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block9: while (true) {
            String input = "";
            System.out.print(">");
            try {
                input = this.br.readLine();
                if (input.equals("help")) {
                    CommandText.Help();
                    continue;
                }
                if (input.equals("about")) {
                    System.out.print("Command Line for Risk, version: 2\nMade by Yura Mamyrin (yura@yura.net)\n");
                    String[] info1 = TranslationBundle.getBundle().getString("about.infopanel").split(RiskUtil.quote("\n"));
                    String[] info2 = RiskUIUtil.getSystemInfoText().split(RiskUtil.quote("\n"));
                    int line = 0;
                    while (true) {
                        if (line >= info1.length || line >= info2.length) continue block9;
                        System.out.print(info1[line] + " - " + info2[line] + "\n");
                        ++line;
                    }
                }
                if (input.equals("manual")) {
                    try {
                        RiskUtil.openDocs("help/index_commands.htm");
                        System.out.print("Manual opened.\n");
                    }
                    catch (Exception e) {
                        System.out.print("unable to open manual: " + e.getMessage() + "\n");
                    }
                    continue;
                }
                if (input.equals("exit")) {
                    System.out.print("Thank you for Playing Risk.\n");
                    System.exit(0);
                    continue;
                }
                CommandText e = this;
                synchronized (e) {
                    this.IgnoreNext = true;
                    this.risk.parser(input);
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            catch (Exception e) {
                System.out.print("\nThank you for Playing Risk.\n");
                System.exit(0);
                continue;
            }
            break;
        }
    }

    public static void main(String[] argv) {
        RiskUIUtil.parseArgs(argv);
        new CommandText(new Risk());
    }
}

