/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import net.yura.domination.engine.RiskObjectOutputStream;
import net.yura.domination.engine.core.Continent;
import net.yura.domination.engine.core.Player;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Country
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Vector neighbours;
    private Player owner;
    private int armies;
    private Continent continent;
    private int color;
    private int x;
    private int y;
    private String idString;
    private transient List<Country> crossContinentNeighbours;
    private transient List<Country> incomingNeighbours = new ArrayList<Country>(2);

    Country() {
        this.neighbours = new Vector();
    }

    public Country(int p, String id, String n, Continent c, int a, int b) {
        this();
        this.idString = id;
        this.color = p;
        this.name = n;
        this.continent = c;
        this.owner = null;
        this.armies = 0;
        this.x = a;
        this.y = b;
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String a) {
        this.idString = a;
    }

    public String toString() {
        return this.idString + " (" + this.color + ")";
    }

    public boolean isNeighbours(Country t) {
        return this.neighbours.contains(t);
    }

    public Vector getNeighbours() {
        return this.neighbours;
    }

    public List<Country> getCrossContinentNeighbours() {
        if (this.crossContinentNeighbours == null) {
            ArrayList<Country> c = new ArrayList<Country>(2);
            for (int i = 0; i < this.neighbours.size(); ++i) {
                Country other = (Country)this.neighbours.get(i);
                if (other.getContinent() == this.continent) continue;
                c.add(other);
            }
            this.crossContinentNeighbours = c;
        }
        return this.crossContinentNeighbours;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String a) {
        this.name = a;
    }

    public int getArmies() {
        return this.armies;
    }

    public Continent getContinent() {
        return this.continent;
    }

    public void setContinent(Continent a) {
        this.continent = a;
    }

    public void addNeighbour(Country t) {
        this.crossContinentNeighbours = null;
        this.neighbours.add(t);
        t.getIncomingNeighbours().add(this);
    }

    public List<Country> getIncomingNeighbours() {
        return this.incomingNeighbours;
    }

    public void setOwner(Player p) {
        this.owner = p;
    }

    public Player getOwner() {
        return this.owner;
    }

    public void addArmy() {
        ++this.armies;
    }

    public void addArmies(int n) {
        this.armies += n;
    }

    public void removeArmies(int lessArmies) {
        this.armies -= lessArmies;
    }

    public void looseArmy() {
        --this.armies;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int a) {
        this.color = a;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int a) {
        this.x = a;
    }

    public void setY(int a) {
        this.y = a;
    }

    public int getDistanceTo(int px, int py) {
        return (int)Math.sqrt((px -= this.getX()) * px + (py -= this.getY()) * py);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (out instanceof RiskObjectOutputStream) {
            ObjectOutputStream.PutField putField = out.putFields();
            putField.put("owner", this.owner);
            putField.put("armies", this.armies);
            out.writeFields();
        } else {
            out.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.incomingNeighbours = new ArrayList<Country>(2);
        this.neighbours = new Vector();
    }
}

