/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.core;

import java.io.Serializable;
import java.util.Vector;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;

public class Continent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String idString;
    private String name;
    private int color;
    private int armyValue;
    private Vector territoriesContained = new Vector();
    private transient Vector borderCountries;

    public Continent(String id, String n, int noa, int c) {
        this.idString = id;
        this.name = n;
        this.color = c;
        this.armyValue = noa;
    }

    public String toString() {
        if (this.armyValue != 0) {
            return this.idString + " [" + this.armyValue + "]";
        }
        return this.idString;
    }

    public String getIdString() {
        return this.idString;
    }

    public void setIdString(String a) {
        this.idString = a;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String a) {
        this.name = a;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int a) {
        this.color = a;
    }

    public int getArmyValue() {
        return this.armyValue;
    }

    public void setArmyValue(int a) {
        this.armyValue = a;
    }

    public boolean isOwned(Player p) {
        for (int c = 0; c < this.territoriesContained.size(); ++c) {
            if (((Country)this.territoriesContained.elementAt(c)).getOwner() == p) continue;
            return false;
        }
        return true;
    }

    public int getNumberOwned(Player p) {
        int ownedByPlayer = 0;
        for (int c = 0; c < this.territoriesContained.size(); ++c) {
            if (((Country)this.territoriesContained.elementAt(c)).getOwner() != p) continue;
            ++ownedByPlayer;
        }
        return ownedByPlayer;
    }

    public Player getOwner() {
        Player owner = ((Country)this.territoriesContained.elementAt(0)).getOwner();
        for (int c = 1; c < this.territoriesContained.size() && owner != null; ++c) {
            if (((Country)this.territoriesContained.elementAt(c)).getOwner() == owner) continue;
            owner = null;
        }
        return owner;
    }

    public Vector getBorderCountries() {
        if (this.borderCountries == null) {
            Vector<Country> b = new Vector<Country>(2);
            block0: for (int i = 0; i < this.territoriesContained.size(); ++i) {
                Country country = (Country)this.territoriesContained.get(i);
                Vector w = country.getNeighbours();
                for (int k = 0; k < w.size(); ++k) {
                    if (((Country)w.elementAt(k)).getContinent() == this) continue;
                    b.add(country);
                    continue block0;
                }
            }
            this.borderCountries = b;
        }
        return this.borderCountries;
    }

    public Vector getTerritoriesContained() {
        return this.territoriesContained;
    }

    public void addTerritoriesContained(Country t) {
        this.borderCountries = null;
        this.territoriesContained.add(t);
    }

    public boolean equals(Object o) {
        return o != null && o instanceof Continent && ((Continent)o).name.equals(this.name) && ((Continent)o).idString.equals(this.idString) && ((Continent)o).armyValue == this.armyValue;
    }
}

