/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.ai;

import java.util.List;
import java.util.Random;
import java.util.Vector;
import net.yura.domination.engine.ai.AI;
import net.yura.domination.engine.core.Card;
import net.yura.domination.engine.core.Country;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.RiskGame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AISubmissive
implements AI {
    protected Random r = new Random();
    protected RiskGame game;
    protected Player player;

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public String getCommand() {
        return "crap";
    }

    @Override
    public void setGame(RiskGame game) {
        this.game = game;
        this.player = game.getCurrentPlayer();
    }

    @Override
    public String getBattleWon() {
        return "move all";
    }

    @Override
    public String getTacMove() {
        return "nomove";
    }

    @Override
    public String getTrade() {
        Vector cards = this.player.getCards();
        if (cards.size() < 3) {
            return "endtrade";
        }
        Card[] result = new Card[3];
        if (this.game.getBestTrade(cards, result) > 0) {
            return this.getTrade(result);
        }
        return "endtrade";
    }

    protected String getTrade(Card[] result) {
        String output = "trade ";
        output = this.getCardName(result[0], output);
        output = output + " ";
        output = this.getCardName(result[1], output);
        output = output + " ";
        output = this.getCardName(result[2], output);
        return output;
    }

    private String getCardName(Card card1, String output) {
        output = card1.getName().equals("wildcard") ? output + card1.getName() : output + card1.getCountry().getColor();
        return output;
    }

    @Override
    public String getPlaceArmies() {
        if (!this.game.NoEmptyCountries()) {
            return "autoplace";
        }
        return this.getPlaceCommand(this.randomCountry(this.player.getTerritoriesOwned()), this.player.getExtraArmies() / 3 + this.player.getExtraArmies() % 3);
    }

    @Override
    public String getAttack() {
        return "endattack";
    }

    @Override
    public String getRoll() {
        return "retreat";
    }

    @Override
    public String getCapital() {
        return "capital " + this.randomCountry(this.player.getTerritoriesOwned()).getColor();
    }

    public Country randomCountry(List<Country> countries) {
        if (countries.isEmpty()) {
            return null;
        }
        return countries.get(this.r.nextInt(countries.size()));
    }

    @Override
    public String getAutoDefendString() {
        int n = this.game.getDefender().getArmies();
        return "roll " + Math.min(this.game.getMaxDefendDice(), n);
    }

    protected String getPlaceCommand(Country country, int armies) {
        return "placearmies " + country.getColor() + " " + (!this.game.getSetupDone() ? 1 : Math.max(1, Math.min(this.player.getExtraArmies(), armies)));
    }
}

