/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.util.Vector;
import net.yura.mobile.logging.Logger;

public class StringUtil {
    private static final char TOKEN_PREFIX = '{';
    private static final char TOKEN_SUFFIX = '}';

    public static String[] split(String value, String separator) {
        int len = value.length();
        if (len == 0) {
            return new String[0];
        }
        int start = 0;
        Vector<String> parts = new Vector<String>();
        int end = value.indexOf(separator);
        while (start < end) {
            parts.addElement(value.substring(start, end));
            start = end + 1;
            end = value.indexOf(separator, start);
        }
        parts.addElement(value.substring(start, len));
        Object[] array = new String[parts.size()];
        parts.copyInto(array);
        return array;
    }

    public static String[] split(String value, char delimiter) {
        int len = value.length();
        if (len == 0) {
            return new String[0];
        }
        int start = 0;
        Vector<String> parts = new Vector<String>();
        int end = value.indexOf(delimiter);
        while (start < end) {
            parts.addElement(value.substring(start, end));
            start = end + 1;
            end = value.indexOf(delimiter, start);
        }
        parts.addElement(value.substring(start, len));
        Object[] array = new String[parts.size()];
        parts.copyInto(array);
        return array;
    }

    public static String replaceAll(String text, String searchString, String replacementString) {
        StringBuffer sBuffer = new StringBuffer();
        int pos = 0;
        while ((pos = text.indexOf(searchString)) != -1) {
            sBuffer.append(text.substring(0, pos) + replacementString);
            text = text.substring(pos + searchString.length());
        }
        sBuffer.append(text);
        return sBuffer.toString();
    }

    public static String replace(String str, String replace, String replacement) {
        StringBuffer buffer = new StringBuffer(str);
        int i = str.indexOf(replace);
        if (i >= 0) {
            buffer.delete(i, i + replace.length());
            buffer.insert(i, replacement);
        } else {
            Logger.info("can not replace " + replace + " with " + replacement + " in string " + str);
        }
        return buffer.toString();
    }

    public static String replaceToken(String str, int tokenIndex, String replacement) {
        char[] chars = str.toCharArray();
        char tokenIndexChar = (char)(tokenIndex + 48);
        for (int i = 0; i < chars.length - 2; ++i) {
            if (chars[i] != '{' || chars[i + 1] != tokenIndexChar || chars[i + 2] != '}') continue;
            String before = str.substring(0, i);
            String after = str.substring(i + 3, str.length());
            return before + replacement + after;
        }
        return str;
    }
}

