/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.plaf;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.border.EmptyBorder;
import net.yura.mobile.gui.border.MatteBorder;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.Style;
import net.yura.mobile.io.kxml2.KXmlParser;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.StringUtil;

public class SynthLookAndFeel
extends LookAndFeel {
    protected Icon getIcon(String path, int x, int y, int w, int h) {
        Image in = this.createImage(path);
        if (in != null) {
            if (w != 0 && h != 0) {
                in = Image.createImage((Image)in, (int)x, (int)y, (int)w, (int)h, (int)0);
            }
            return new Icon(in);
        }
        return null;
    }

    protected Border getBorder(String path) {
        Image in = this.createImage(path);
        if (in != null) {
            return MatteBorder.load9png(in);
        }
        return null;
    }

    protected Image createImage(String path) {
        Image in = Midlet.createImage(path);
        if (in == null) {
            Logger.warn("can not load image: " + path);
        }
        return in;
    }

    protected InputStream getResourceAsStream(String path) {
        InputStream in = Midlet.getResourceAsStream(path);
        if (in == null) {
            Logger.warn("can not load resource: " + path);
        }
        return in;
    }

    public void load(InputStream input) throws Exception {
        Hashtable fonts = new Hashtable();
        KXmlParser parser = new KXmlParser();
        parser.setInput(input, null);
        parser.nextTag();
        Hashtable<String, Style> styleList = new Hashtable<String, Style>();
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if ("style".equals(name)) {
                String id = parser.getAttributeValue(null, "id");
                Style newStyle = this.readStyle(parser, fonts);
                if (styleList.get(id) != null) {
                    throw new Exception("ID " + id + " is already defined");
                }
                styleList.put(id, newStyle);
                continue;
            }
            if ("bind".equals(name)) {
                Style theStyle;
                String style = parser.getAttributeValue(null, "style");
                String key = parser.getAttributeValue(null, "key");
                Style newStyle = (Style)styleList.get(style);
                Style oldStyle = this.getStyle(key);
                Style defaultStyle = this.getStyle("");
                if (oldStyle == null && defaultStyle == null) {
                    theStyle = newStyle;
                } else {
                    theStyle = new Style(oldStyle != null ? oldStyle : defaultStyle);
                    theStyle.putAll(newStyle);
                }
                if (".*".equals(key)) {
                    key = "";
                }
                this.setStyleFor(key, theStyle);
            } else {
                Logger.warn("unknown found: " + name);
            }
            parser.skipSubTree();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Style readStyle(KXmlParser parser, Hashtable fonts) throws Exception {
        Hashtable<String, Object> params = new Hashtable<String, Object>();
        Style newStyle = new Style();
        EmptyBorder insets = null;
        boolean opaque = true;
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if ("state".equals(name)) {
                int st = this.workOutState(parser.getAttributeValue(null, "value"));
                int borderfill = 0;
                MatteBorder border = null;
                while (parser.nextTag() != 3) {
                    String name2 = parser.getName();
                    if ("font".equals(name2)) {
                        newStyle.addFont(this.loadFont(parser, fonts), st);
                        continue;
                    }
                    if ("imagePainter".equals(name2)) {
                        String path = parser.getAttributeValue(null, "path");
                        String sourceInsets = parser.getAttributeValue(null, "sourceInsets");
                        String paintCenter = parser.getAttributeValue(null, "paintCenter");
                        if (sourceInsets != null) {
                            Icon activeimage = this.getIcon(path, 0, 0, 0, 0);
                            if (activeimage != null) {
                                String[] stringArray = StringUtil.split(sourceInsets, ' ');
                                border = new MatteBorder(activeimage, insets == null ? 0 : insets.getTop(), insets == null ? 0 : insets.getLeft(), insets == null ? 0 : insets.getBottom(), insets == null ? 0 : insets.getRight(), Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]), Integer.parseInt(stringArray[3]), "true".equals(paintCenter) || "Y".equals(paintCenter), borderfill);
                                border.opaque = opaque;
                                newStyle.addBorder(border, st);
                            }
                        } else if (path.indexOf(".9.") > 0) {
                            Border border2 = this.getBorder(path);
                            if (border2 != null) {
                                newStyle.addBorder(border2, st);
                            }
                        } else {
                            try {
                                border = MatteBorder.load(path);
                                newStyle.addBorder(border, st);
                            }
                            catch (Exception ex) {
                                Logger.warn("failed to load: " + path, ex);
                            }
                        }
                    } else if ("property".equals(name2)) {
                        String type = parser.getAttributeValue(null, "type");
                        String key = parser.getAttributeValue(null, "key");
                        String value = parser.getAttributeValue(null, "value");
                        if ("integer".equals(type)) {
                            int i = Graphics2D.parseColor(value, 10);
                            newStyle.addProperty(new Integer(i), key, st);
                        } else if ("string".equals(type)) {
                            newStyle.addProperty(value, key, st);
                        } else {
                            if (type != null && !"idref".equals(type)) throw new Exception("unknown property type " + type);
                            Object obj = params.get(value);
                            if (obj != null) {
                                newStyle.addProperty(obj, key, st);
                            } else {
                                Logger.warn("object with idref " + value + " not found");
                            }
                        }
                    } else if ("color".equals(name2)) {
                        String cvalue = parser.getAttributeValue(null, "value");
                        String type = parser.getAttributeValue(null, "type");
                        String id = parser.getAttributeValue(null, "id");
                        int color = 0;
                        if (cvalue != null) {
                            color = Graphics2D.parseColor(cvalue, 16);
                        }
                        if (type != null) {
                            if ("BACKGROUND".equals(type)) {
                                newStyle.addBackground(color, st);
                            } else if ("FOREGROUND".equals(type)) {
                                newStyle.addForeground(color, st);
                            } else if ("BORDERFILL".equals(type)) {
                                if (border != null) {
                                    border.setColor(color);
                                } else {
                                    borderfill = color;
                                }
                            }
                        }
                        if (id != null) {
                            params.put(id, new Integer(color));
                        }
                    } else {
                        Logger.warn("unknown found: " + name2);
                    }
                    parser.skipSubTree();
                }
                continue;
            }
            if ("font".equals(name)) {
                this.loadFont(parser, fonts);
                continue;
            }
            if ("insets".equals(name)) {
                String top = parser.getAttributeValue(null, "top");
                String left = parser.getAttributeValue(null, "left");
                String bottom = parser.getAttributeValue(null, "bottom");
                String right = parser.getAttributeValue(null, "right");
                insets = new EmptyBorder(Integer.parseInt(top), Integer.parseInt(left), Integer.parseInt(bottom), Integer.parseInt(right));
                newStyle.addBorder(insets, 0);
            } else if ("imageIcon".equals(name)) {
                void var16_33;
                String path = parser.getAttributeValue(null, "path");
                String x = parser.getAttributeValue(null, "x");
                String y = parser.getAttributeValue(null, "y");
                String width = parser.getAttributeValue(null, "width");
                String height = parser.getAttributeValue(null, "height");
                String id = parser.getAttributeValue(null, "id");
                String frameWidth = parser.getAttributeValue(null, "frameWidth");
                String frameHeight = parser.getAttributeValue(null, "frameHeight");
                Object var16_29 = null;
                if (frameWidth != null || frameHeight != null) {
                    Image img = this.createImage(path);
                    if (img != null) {
                        Sprite sprite = new Sprite(img, frameWidth == null ? img.getWidth() : Integer.parseInt(frameWidth), frameHeight == null ? img.getHeight() : Integer.parseInt(frameHeight));
                    }
                } else {
                    Icon icon = this.getIcon(path, x == null ? 0 : Integer.parseInt(x), y == null ? 0 : Integer.parseInt(y), width == null ? 0 : Integer.parseInt(width), height == null ? 0 : Integer.parseInt(height));
                }
                if (var16_33 != null) {
                    params.put(id, var16_33);
                }
            } else if ("opaque".equals(name)) {
                String value = parser.getAttributeValue(null, "value");
                boolean bl = opaque = !"false".equals(value);
                if (!opaque) {
                    newStyle.addBackground(0, 0);
                }
            } else {
                Logger.warn("unknown found: " + name);
            }
            parser.skipSubTree();
        }
        return newStyle;
    }

    private int workOutState(String value) {
        int result = 0;
        if (value == null) {
            return result;
        }
        if (value.indexOf("DISABLED") != -1) {
            result |= 2;
        }
        if (value.indexOf("FOCUSED") != -1) {
            result |= 4;
        }
        if (value.indexOf("SELECTED") != -1) {
            result |= 8;
        }
        return result;
    }

    private Font loadFont(KXmlParser parser, Hashtable params) throws Exception {
        InputStream in;
        Font font = null;
        String fontIdRef = parser.getAttributeValue(null, "idref");
        if (fontIdRef != null && (font = (Font)params.get(fontIdRef)) != null) {
            parser.skipSubTree();
            return font;
        }
        String fontName = parser.getAttributeValue(null, "name");
        String fontSize = parser.getAttributeValue(null, "size");
        String fontStyle = parser.getAttributeValue(null, "style");
        String fontId = parser.getAttributeValue(null, "id");
        String path = parser.getAttributeValue(null, "path");
        Logger.info("Loading font: name: " + fontName + ", size: " + fontSize + ", style: " + fontStyle + ", id: " + fontId);
        int fname = SynthLookAndFeel.getFontName(fontName);
        int fsize = SynthLookAndFeel.getFontSize(fontSize);
        int fstyle = 0;
        if (fontStyle != null) {
            if (fontStyle.indexOf("BOLD") != -1) {
                fstyle |= 1;
            }
            if (fontStyle.indexOf("ITALIC") != -1) {
                fstyle |= 2;
            }
            if (fontStyle.indexOf("UNDERLINED") != -1) {
                fstyle |= 4;
            }
        }
        Vector<Integer> colors = new Vector<Integer>();
        Vector<Image> images = new Vector<Image>();
        while (parser.nextTag() != 3) {
            String name = parser.getName();
            if ("fontImage".equals(name)) {
                String imagePath = parser.getAttributeValue(null, "path");
                String imageColor = parser.getAttributeValue(null, "color");
                Image img = this.createImage(imagePath);
                if (img != null) {
                    int color = 0;
                    if (imageColor != null) {
                        color = Graphics2D.parseColor(imageColor, 16);
                    }
                    colors.addElement(new Integer(color));
                    images.addElement(img);
                }
            }
            Logger.debug("oooo: " + name);
            parser.skipSubTree();
        }
        if (path != null && (in = this.getResourceAsStream(path)) != null && !images.isEmpty()) {
            int[] colorsArray = new int[colors.size()];
            for (int c = 0; c < colorsArray.length; ++c) {
                colorsArray[c] = (Integer)colors.elementAt(c);
            }
            Object[] imagesArray = new Image[images.size()];
            images.copyInto(imagesArray);
            font = Font.getFont(in, (Image[])imagesArray, colorsArray);
        }
        if (font == null) {
            try {
                font = new Font(fname, fstyle, fsize);
            }
            catch (Exception ex) {
                Logger.warn("failed to load font: " + fname + " " + fstyle + " " + fsize, ex);
                font = Font.getDefaultSystemFont();
            }
        }
        if (fontId != null) {
            params.put(fontId, font);
        }
        return font;
    }

    public static int getFontName(String fontName) {
        int fname = 64;
        if ("PROPORTIONAL".equals(fontName)) {
            fname = 64;
        } else if ("MONOSPACE".equals(fontName)) {
            fname = 32;
        } else if ("SYSTEM".equals(fontName)) {
            fname = 0;
        }
        return fname;
    }

    public static int getFontSize(String fontSize) {
        int fsize = 0;
        if (fontSize != null) {
            if ("SMALL".equals(fontSize)) {
                fsize = 8;
            } else if ("MEDIUM".equals(fontSize)) {
                fsize = 0;
            } else if ("LARGE".equals(fontSize)) {
                fsize = 16;
            } else {
                try {
                    fsize = -Integer.parseInt(fontSize);
                }
                catch (Exception ex) {
                    Logger.warn("error with " + fontSize, ex);
                }
            }
        }
        return fsize;
    }
}

