/*
 * Decompiled with CFR 0.152.
 */
package net.yura.swing;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class TreeCombo
extends JComboBox {
    static final int OFFSET = 16;
    static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public TreeCombo() {
        this.setRenderer(new ListEntryRenderer());
    }

    public TreeCombo(TreeModel aTreeModel) {
        this();
        this.setModel(aTreeModel);
    }

    public void setModel(TreeModel aTreeModel) {
        super.setModel(new TreeToListModel(aTreeModel));
    }

    class ListEntryRenderer
    extends JLabel
    implements ListCellRenderer {
        Icon leafIcon = (Icon)UIManager.get("Tree.expandedIcon");
        Icon nodeIcon = (Icon)UIManager.get("Tree.collapsedIcon");

        public ListEntryRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            DefaultMutableTreeNode treeEntry = (DefaultMutableTreeNode)value;
            if (treeEntry != null) {
                this.setText(treeEntry.toString());
                this.setIcon(treeEntry.isLeaf() ? this.leafIcon : this.nodeIcon);
                Border border = index != -1 ? new EmptyBorder(0, 16 * treeEntry.getLevel(), 0, 0) : emptyBorder;
                if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                    if (index == -1) {
                        this.setOpaque(false);
                    } else {
                        this.setOpaque(true);
                    }
                } else {
                    this.setOpaque(true);
                }
                this.setBorder(border);
                if (isSelected) {
                    this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                } else {
                    this.setBackground(UIManager.getColor("ComboBox.background"));
                    this.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }

    class TreeToListModel
    extends AbstractListModel
    implements ComboBoxModel,
    TreeModelListener {
        TreeModel source;
        boolean invalid = true;
        Object currentValue;
        Vector cache = new Vector();

        public TreeToListModel(TreeModel aTreeModel) {
            this.source = aTreeModel;
            aTreeModel.addTreeModelListener(this);
            TreeCombo.this.setRenderer(new ListEntryRenderer());
        }

        public void setSelectedItem(Object anObject) {
            if (this.currentValue != null && !this.currentValue.equals(anObject) || this.currentValue == null && anObject != null) {
                this.currentValue = anObject;
                Enumeration enum1 = this.cache.elements();
                while (enum1.hasMoreElements()) {
                    Object le = enum1.nextElement();
                    if (!le.equals(anObject)) continue;
                    this.currentValue = le;
                    break;
                }
            }
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }

        public int getSize() {
            this.validate();
            return this.cache.size();
        }

        public Object getElementAt(int index) {
            return this.cache.elementAt(index);
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.invalid = true;
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.invalid = true;
        }

        void validate() {
            if (this.invalid) {
                this.cache = new Vector();
                this.cacheTree(this.source.getRoot());
                if (this.cache.size() > 0) {
                    this.currentValue = this.cache.elementAt(0);
                }
                this.invalid = false;
                this.fireContentsChanged(this, 0, 0);
            }
        }

        void cacheTree(Object anObject) {
            if (this.source.isLeaf(anObject)) {
                this.cache.addElement(anObject);
            } else {
                int c = this.source.getChildCount(anObject);
                this.cache.addElement(anObject);
                for (int i = 0; i < c; ++i) {
                    Object child = this.source.getChild(anObject, i);
                    this.cacheTree(child);
                }
            }
        }
    }
}

