/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.impl.lcdui;

import java.awt.image.RGBImageFilter;

public class DrawImageFilter
extends RGBImageFilter {
    int[] data;
    int x;
    int y;
    int w;
    int h;

    public DrawImageFilter(int[] data, int x, int y, int w, int h) {
        this.data = data;
        if (data.length < w * h) {
            throw new IllegalArgumentException("data.length " + data.length + " < " + w + " * " + h);
        }
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }

    public int filterRGB(int fx, int fy, int argb) {
        if ((fx -= this.x) < 0 || (fy -= this.y) < 0 || fx >= this.w || fy >= this.h) {
            return argb;
        }
        int d = this.data[fx + this.w * fy];
        return d < 0 ? d : argb;
    }
}

